package com.ejianc.business.finance.api;

import com.ejianc.business.finance.hystrix.PayContractHystrix;
import com.ejianc.business.finance.pub.vo.PubContractSubQueryVO;
import com.ejianc.business.finance.pub.vo.PubWarnQueryVO;
import com.ejianc.business.finance.vo.FinanceWarnV0;
import com.ejianc.business.finance.vo.PayMnyWarnVO;
import com.ejianc.business.finance.vo.ProjectReimburseVO;
import com.ejianc.business.finance.vo.SumPayMnyVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 获取合同参照工厂类方法
 *
 * @author yqls
 *
 */
@FeignClient(name= "ejc-finance-web", url="${common.env.feign-client-url}", path="ejc-finance-web", fallback = PayContractHystrix.class)
//@FeignClient(name= "ejc-finance-web", url="${common.env.feign-client-url}", path="ejc-finance-web", configuration = {KeepErrMsgConfiguration.class})
public interface IPayContractApi{

	/**
	 * 根据合同contractId和组织orgId（不必输）查询累计付款与累计预付款
	 * @param contractId
	 * @param orgId
	 * @return
	 */
	@GetMapping(value = "/api/finance/getSumPayMny")
	public CommonResponse<SumPayMnyVO> getSumPayMny(@RequestParam(value = "contractId", required = true) Long contractId, @RequestParam("orgId") Long orgId);

	/**
	 * 根据合同contractId和组织orgId（本下，不必输） 查询累计付款与付款详情
	 * @param contractId
	 * @param orgId
	 * @return
	 */
	@GetMapping(value = "/api/finance/getSumPayMnyVOList")
	public CommonResponse<SumPayMnyVO> getSumPayMnyVOList(@RequestParam(value = "contractId", required = true) Long contractId, @RequestParam("orgId") Long orgId);

	/**
	 * 根据合同contractId和组织orgId（本下，不必输） 查询累计付款与付款详情
	 * @param pubContractSubQueryVO
	 * @return
	 */
	@PostMapping(value = "/api/finance/getSubSettlePay")
	public CommonResponse<Map<String, BigDecimal>> getSubSettlePay(@RequestBody PubContractSubQueryVO pubContractSubQueryVO);


	/**
	 * 根据租户id集合查询付款信息
	 * @param pubWarnQueryVO
	 * @return
	 */
	@PostMapping(value = "/api/finance/getPayMnyByTenantIds")
	public CommonResponse<Map<String, PayMnyWarnVO>> getPayMnyByTenantIds(@RequestBody PubWarnQueryVO pubWarnQueryVO);
	/**
	 * 根据租户id集合查询付款信息
	 * @param pubWarnQueryVO
	 * @return
	 */
	@PostMapping(value = "/api/finance/warnPayMny")
	public CommonResponse<Map<String, PayMnyWarnVO>> warnPayMny(@RequestBody PubWarnQueryVO pubWarnQueryVO);
	/**
	 * 根据租户id集合查询付款信息
	 * @param pubWarnQueryVO
	 * @return
	 */
	@PostMapping(value = "/api/finance/warnMaterialPayMny")
	public CommonResponse<Map<String, PayMnyWarnVO>> warnMaterialPayMny(@RequestBody PubWarnQueryVO pubWarnQueryVO);
	/**
	 * 根据租户id集合查询付款信息
	 * @param pubWarnQueryVO
	 * @return
	 */
	@PostMapping(value = "/api/finance/warnMaterialPrePayMny")
	public CommonResponse<Map<String, PayMnyWarnVO>> warnMaterialPrePayMny(@RequestBody PubWarnQueryVO pubWarnQueryVO);


	/**
	 * 项目维度报销和备用金报销
	 * @return
	 */
	@PostMapping(value = "/api/finance/getProjectReimburse")
	public CommonResponse<List<ProjectReimburseVO>> getProjectReimburse(@RequestParam("projectIds") List<Long> projectIds);

	/**
	 * 项目维度累计付款金额
	 * @return
	 */
	@PostMapping(value = "/api/finance/getProjectPayMny")
	public CommonResponse<List<FinanceWarnV0>> getProjectPayMny();
}
