package com.ejianc.business.finance.util;

import java.util.HashMap;
import java.util.Map;

/**
 * @author songlx
 * @version 1.0
 * @description: 微信公众号消息类型
 * @date 2021/10/20
 */
public enum NoticeEnum {

    /**
     * 支出管理
     * 确认支付 批量支付
     * 单据创建人
     */
    PAY_SUCCESS("支付成功通知", "付款申请支付成功通知", "请及时查看");

    private String desc;

    private String subject;

    private String key1;


    private static Map<NoticeEnum, String> mobileContentMap = new HashMap<>();

    private static Map<NoticeEnum, String> mobileUrlMap = new HashMap<>();

    private static Map<NoticeEnum, String> pcContentMap = new HashMap<>();


    static {
        mobileContentMap.put(PAY_SUCCESS, "您有一条新的支付成功单据【费用类型： #FEETYPE# 单据编号： #BILLCODE# - #THISPAYMNY# 】");
        mobileUrlMap.put(PAY_SUCCESS, "#BASEHOST#");
        pcContentMap.put(PAY_SUCCESS, "您有一条新的支付成功单据【费用类型： #FEETYPE# 单据编号： #BILLCODE# 支付金额： #THISPAYMNY# 】，<a href=" + '"' + "#BASEHOST#" + '"' + ">点击查看详情</a>");
    }

    NoticeEnum(String desc, String subject, String key1) {
        this.desc = desc;
        this.subject = subject;
        this.key1 = key1;
    }

    public static String getMobileUrl(NoticeEnum notice, Map<String, String> map) {

        String url = mobileUrlMap.get(notice);

        for (Map.Entry<String, String> entry : map.entrySet()) {
            url = url.replace(entry.getKey(), entry.getValue());
        }
        return url.contains("?") ? url + "&" : url + "?";
    }

    public static String getMobileContent(NoticeEnum notice, HashMap<String, String> map) {
        String url = mobileContentMap.get(notice);

        for (Map.Entry<String, String> entry : map.entrySet()) {
            url = url.replace(entry.getKey(), entry.getValue());
        }
        return url;
    }


    public static String getPcContent(NoticeEnum notice, HashMap<String, String> map) {
        String url = pcContentMap.get(notice);

        for (Map.Entry<String, String> entry : map.entrySet()) {
            url = url.replace(entry.getKey(), entry.getValue());
        }
        return url;
    }


    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getSubject() {
        return subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }


    public String getKey1() {
        return key1;
    }

    public void setKey1(String key1) {
        this.key1 = key1;
    }


}
