/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.api;

import com.ejianc.business.finance.hystrix.PayContractHystrix;
import com.ejianc.business.finance.pub.vo.PubContractSubQueryVO;
import com.ejianc.business.finance.pub.vo.PubWarnQueryVO;
import com.ejianc.business.finance.vo.FinanceWarnV0;
import com.ejianc.business.finance.vo.PayMnyWarnVO;
import com.ejianc.business.finance.vo.ProjectReimburseVO;
import com.ejianc.business.finance.vo.SumPayMnyVO;
import com.ejianc.framework.core.response.CommonResponse;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(name="ejc-finance-web", url="${common.env.feign-client-url}", path="ejc-finance-web", fallback=PayContractHystrix.class)
public interface IPayContractApi {
    @GetMapping(value={"/api/finance/getSumPayMny"})
    public CommonResponse<SumPayMnyVO> getSumPayMny(@RequestParam(value="contractId", required=true) Long var1, @RequestParam(value="orgId") Long var2);

    @GetMapping(value={"/api/finance/getSumPayMnyVOList"})
    public CommonResponse<SumPayMnyVO> getSumPayMnyVOList(@RequestParam(value="contractId", required=true) Long var1, @RequestParam(value="orgId") Long var2);

    @PostMapping(value={"/api/finance/getSubSettlePay"})
    public CommonResponse<Map<String, BigDecimal>> getSubSettlePay(@RequestBody PubContractSubQueryVO var1);

    @PostMapping(value={"/api/finance/getPayMnyByTenantIds"})
    public CommonResponse<Map<String, PayMnyWarnVO>> getPayMnyByTenantIds(@RequestBody PubWarnQueryVO var1);

    @PostMapping(value={"/api/finance/warnPayMny"})
    public CommonResponse<Map<String, PayMnyWarnVO>> warnPayMny(@RequestBody PubWarnQueryVO var1);

    @PostMapping(value={"/api/finance/warnMaterialPayMny"})
    public CommonResponse<Map<String, PayMnyWarnVO>> warnMaterialPayMny(@RequestBody PubWarnQueryVO var1);

    @PostMapping(value={"/api/finance/warnMaterialPrePayMny"})
    public CommonResponse<Map<String, PayMnyWarnVO>> warnMaterialPrePayMny(@RequestBody PubWarnQueryVO var1);

    @PostMapping(value={"/api/finance/getProjectReimburse"})
    public CommonResponse<List<ProjectReimburseVO>> getProjectReimburse(@RequestParam(value="projectIds") List<Long> var1);

    @PostMapping(value={"/api/finance/getProjectPayMny"})
    public CommonResponse<List<FinanceWarnV0>> getProjectPayMny();
}

