package com.ejianc.business.finance.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;


/**
 * 集中付款申请明细实体
 * 
 * @author generator
 * 
 */
public class PayFocusDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long focusId; // 集中付款单ID
    private Long projectId; // 项目
    private String projectName; // 项目名称
    private String projectType; // 项目类型：1-自营，2-联营
    private String projectTypeName; // 项目类型名称
    private Long settleId; // 来源结算单主键
    private String settleCode; // 结算单编号
    private BigDecimal settleMny; // 本期结算金额
    private BigDecimal bodyApplyMny; // 本期申请金额
    private BigDecimal sumApplyMny; // 已申请金额
    private BigDecimal payScale; // 合同支付比例
    private BigDecimal surplusApplyMny; // 剩余可申请金额
    private BigDecimal contractPayMny; // 约定支付金额
    private String memo; // 备注
    private Long parentOrgId; // 项目部上级组织Id
    private String parentOrgName; // 项目部上级组织名称
    private String parentOrgCode; // 项目部上级组织编码
    private Long orgId; // 组织
    private String orgCode; // 组织编码
    private String orgName; // 组织名称
    private BigDecimal proSurplusMny; // 项目可用资金
    private BigDecimal proSurplusApplyMny; //剩余可申请金额

    /**
     * 结算单版本号
     */
    private Integer settleVersion;
    /**
     * 结算单类型：1-过程结算，2-完工结算
     */
    private Integer settleType;
    

    public Long getFocusId() {
        return focusId;
    }

    public void setFocusId(Long focusId) {
        this.focusId = focusId;
    }
    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectType() {
        return projectType;
    }

    public void setProjectType(String projectType) {
        this.projectType = projectType;
    }
    public String getProjectTypeName() {
        return projectTypeName;
    }

    public void setProjectTypeName(String projectTypeName) {
        this.projectTypeName = projectTypeName;
    }
    public Long getSettleId() {
        return settleId;
    }

    public void setSettleId(Long settleId) {
        this.settleId = settleId;
    }
    public String getSettleCode() {
        return settleCode;
    }

    public void setSettleCode(String settleCode) {
        this.settleCode = settleCode;
    }
    public BigDecimal getSettleMny() {
        return settleMny;
    }

    public void setSettleMny(BigDecimal settleMny) {
        this.settleMny = settleMny;
    }
    public BigDecimal getBodyApplyMny() {
        return bodyApplyMny;
    }

    public void setBodyApplyMny(BigDecimal bodyApplyMny) {
        this.bodyApplyMny = bodyApplyMny;
    }
    public BigDecimal getSumApplyMny() {
        return sumApplyMny;
    }

    public void setSumApplyMny(BigDecimal sumApplyMny) {
        this.sumApplyMny = sumApplyMny;
    }
    public BigDecimal getPayScale() {
        return payScale;
    }

    public void setPayScale(BigDecimal payScale) {
        this.payScale = payScale;
    }
    public BigDecimal getSurplusApplyMny() {
        return surplusApplyMny;
    }

    public void setSurplusApplyMny(BigDecimal surplusApplyMny) {
        this.surplusApplyMny = surplusApplyMny;
    }
    public BigDecimal getContractPayMny() {
        return contractPayMny;
    }

    public void setContractPayMny(BigDecimal contractPayMny) {
        this.contractPayMny = contractPayMny;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public BigDecimal getProSurplusMny() {
        return proSurplusMny;
    }

    public void setProSurplusMny(BigDecimal proSurplusMny) {
        this.proSurplusMny = proSurplusMny;
    }

    public BigDecimal getProSurplusApplyMny() {
        return proSurplusApplyMny;
    }

    public void setProSurplusApplyMny(BigDecimal proSurplusApplyMny) {
        this.proSurplusApplyMny = proSurplusApplyMny;
    }

    public Integer getSettleVersion() {
        return settleVersion;
    }

    public void setSettleVersion(Integer settleVersion) {
        this.settleVersion = settleVersion;
    }

    public Integer getSettleType() {
        return settleType;
    }

    public void setSettleType(Integer settleType) {
        this.settleType = settleType;
    }
}
