package com.ejianc.business.finance.api;

import com.ejianc.business.finance.hystrix.RecoveriesHystrix;
import com.ejianc.business.finance.vo.ReceiveQuteDetailVO;
import com.ejianc.business.finance.vo.ReceiveVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient(name= "ejc-finance-web", url="${common.env.feign-client-url}", path="ejc-finance-web", fallback = RecoveriesHystrix.class)
public interface IRecoveriesApi {
    /**
     * 根据项目id，查询项目收款金额
     * @param projectIds
     * @return
     */
    @GetMapping({"/api/receive/queryProjectReceiveMny"})
    CommonResponse<List<ReceiveVO>> queryProjectReceiveMny(@RequestParam("projectIds") List<Long> projectIds);

    /**
     * 根据甲方报量id，查询收款登记信息
     * @param quoteId
     * @return
     */
    @GetMapping({"/api/receive/queryInfoQuoteId"})
    CommonResponse<List<ReceiveVO>> queryInfoQuoteId(@RequestParam("quoteId") Long quoteId,@RequestParam("contractId") Long contractId);
}
