package com.ejianc.business.finance.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 付款申请记录实体
 * 
 * @author generator
 * 
 */
public class PayRecordVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long payapplyId; // 付款申请主键
    private String applyType; // 付款申请类型：合同付款，零星采购，报销，押金
    private Long contractId; // 合同主键
    private String contractName; // 合同名称
    private Long contractType;// 合同类型：1-分包,2-设备采购,3-设备租赁,4-物资采购,5-物资租赁
    private Long feeType; // 支付类型：1-预付款，2-过程款，3-其他
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private java.util.Date confirmTime; // 经办时间
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private java.util.Date approveTime; // 审批时间
    private BigDecimal thisPayMny; // 本期支付金额
    private String memo; // 备注
    private String billCode; // 单据编号
    private Long projectId; // 项目
    private String projectName; // 项目名称
    private Long orgId; // 组织
    private String orgName; // 组织名称
    private Long applyUserId; // 申请人
    private String applyUserName; // 申请人名称
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private java.util.Date applyTime; // 申请时间
    private BigDecimal applyMny; // 申请金额
    private Long receiveUnitId; // 收款单位
    private String receiveUnitName; // 收款单位名称
    private Long payWay; // 付款方式
    private String payWayName; // 付款方式名称
    private Long receiveNotesId; // 应收票据
    private String receiveNotesName; // 应收票据
    private Long payNotesId; // 应付票据
    private String payNotesName; // 应付票据
    private Long billingRoomId; // 抵账房
    private String billingRoomName; // 抵账房
    private Long carModelId; // 车辆型号
    private String carModelName; // 车辆型号
    private String materialInfo; // 物品信息
    private List<PayRecordSettleVO> settleList = new ArrayList<>(); // 付款申请记录结算实体
    private java.math.BigDecimal notCreditedMny; // 不入账金额
    private Long mergeConfirmId; // 合并支付Id
    private String accountName; // 账户名称
    private String accountNum; // 银行账号
    private String accountBank; // 开户行

    private BigDecimal msgPayMny; //发送消息时用到的累计支付金额
    private Long msgId;//发送消息时用到的ID
    private String msgBillCode;//发送消息时用到的billCode
    private Long accountId; // 付款账户名
    private Boolean closed; //是否关闭
    /**
     * 推送凭证标识
     */
    private Integer voucherFlag;

    /**
     * 凭证信息json
     */
    private String voucherInfo;

    public Integer getVoucherFlag() {
        return voucherFlag;
    }

    public void setVoucherFlag(Integer voucherFlag) {
        this.voucherFlag = voucherFlag;
    }

    public String getVoucherInfo() {
        return voucherInfo;
    }

    public void setVoucherInfo(String voucherInfo) {
        this.voucherInfo = voucherInfo;
    }

    public Boolean getClosed() {
        return closed;
    }

    public void setClosed(Boolean closed) {
        this.closed = closed;
    }

    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public String getAccountNum() {
        return accountNum;
    }

    public void setAccountNum(String accountNum) {
        this.accountNum = accountNum;
    }

    public Long getMergeConfirmId() {
        return mergeConfirmId;
    }

    public void setMergeConfirmId(Long mergeConfirmId) {
        this.mergeConfirmId = mergeConfirmId;
    }

    public String getAccountBank() {
        return accountBank;
    }

    public void setAccountBank(String accountBank) {
        this.accountBank = accountBank;
    }

    public BigDecimal getMsgPayMny() {
        return msgPayMny;
    }

    public void setMsgPayMny(BigDecimal msgPayMny) {
        this.msgPayMny = msgPayMny;
    }

    public Long getMsgId() {
        return msgId;
    }

    public void setMsgId(Long msgId) {
        this.msgId = msgId;
    }

    public String getMsgBillCode() {
        return msgBillCode;
    }

    public void setMsgBillCode(String msgBillCode) {
        this.msgBillCode = msgBillCode;
    }

    /**
     * 付款申请主键
     */
    public Long getPayapplyId() {
        return payapplyId;
    }

    public BigDecimal getNotCreditedMny() {
        return notCreditedMny;
    }

    public void setNotCreditedMny(BigDecimal notCreditedMny) {
        this.notCreditedMny = notCreditedMny;
    }

    /**
     * 付款申请主键
     */
    public void setPayapplyId(Long payapplyId) {
        this.payapplyId = payapplyId;
    }
    /**
     * 付款申请类型：合同付款，零星采购，报销，押金
     */
    public String getApplyType() {
        return applyType;
    }

    /**
     * 付款申请类型：合同付款，零星采购，报销，押金
     */
    public void setApplyType(String applyType) {
        this.applyType = applyType;
    }
    /**
     * 合同主键
     */
    public Long getContractId() {
        return contractId;
    }

    /**
     * 合同主键
     */
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 合同名称
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 合同类型：1-分包,2-设备采购,3-设备租赁,4-物资采购,5-物资租赁
     */
    public Long getContractType() {
        return contractType;
    }

    /**
     * 合同类型：1-分包,2-设备采购,3-设备租赁,4-物资采购,5-物资租赁
     */
    public void setContractType(Long contractType) {
        this.contractType = contractType;
    }
    /**
     * 支付类型：1-预付款，2-过程款，3-其他
     */
    public Long getFeeType() {
        return feeType;
    }

    /**
     * 支付类型：1-预付款，2-过程款，3-其他
     */
    public void setFeeType(Long feeType) {
        this.feeType = feeType;
    }
    /**
     * 经办人
     */
    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 经办时间
     */
    public java.util.Date getConfirmTime() {
        return confirmTime;
    }

    /**
     * 经办时间
     */
    public void setConfirmTime(java.util.Date confirmTime) {
        this.confirmTime = confirmTime;
    }
    /**
     * 审批时间
     */
    public java.util.Date getApproveTime() {
        return approveTime;
    }

    /**
     * 审批时间
     */
    public void setApproveTime(java.util.Date approveTime) {
        this.approveTime = approveTime;
    }
    /**
     * 本期支付金额
     */
    public BigDecimal getThisPayMny() {
        return thisPayMny;
    }

    /**
     * 本期支付金额
     */
    public void setThisPayMny(BigDecimal thisPayMny) {
        this.thisPayMny = thisPayMny;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 项目
     */
    @ReferSerialTransfer(referCode = "market-project")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 组织
     */
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 申请人
     */
    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getApplyUserId() {
        return applyUserId;
    }

    /**
     * 申请人
     */
    @ReferDeserialTransfer
    public void setApplyUserId(Long applyUserId) {
        this.applyUserId = applyUserId;
    }
    /**
     * 申请人名称
     */
    public String getApplyUserName() {
        return applyUserName;
    }

    /**
     * 申请人名称
     */
    public void setApplyUserName(String applyUserName) {
        this.applyUserName = applyUserName;
    }
    /**
     * 申请时间
     */
    public java.util.Date getApplyTime() {
        return applyTime;
    }

    /**
     * 申请时间
     */
    public void setApplyTime(java.util.Date applyTime) {
        this.applyTime = applyTime;
    }
    /**
     * 申请金额
     */
    public BigDecimal getApplyMny() {
        return applyMny;
    }

    /**
     * 申请金额
     */
    public void setApplyMny(BigDecimal applyMny) {
        this.applyMny = applyMny;
    }
    /**
     * 收款单位
     */
    @ReferSerialTransfer(referCode="support-supplier")
    public Long getReceiveUnitId() {
        return receiveUnitId;
    }

    /**
     * 收款单位
     */
    @ReferDeserialTransfer
    public void setReceiveUnitId(Long receiveUnitId) {
        this.receiveUnitId = receiveUnitId;
    }
    /**
     * 收款单位名称
     */
    public String getReceiveUnitName() {
        return receiveUnitName;
    }

    /**
     * 收款单位名称
     */
    public void setReceiveUnitName(String receiveUnitName) {
        this.receiveUnitName = receiveUnitName;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getPayWay() {
        return payWay;
    }
    @ReferDeserialTransfer
    public void setPayWay(Long payWay) {
        this.payWay = payWay;
    }
    @ReferSerialTransfer(referCode = "bank-account")
    public Long getAccountId() {
        return accountId;
    }
    @ReferDeserialTransfer
    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getReceiveNotesId() {
        return receiveNotesId;
    }
    @ReferDeserialTransfer
    public void setReceiveNotesId(Long receiveNotesId) {
        this.receiveNotesId = receiveNotesId;
    }

    public String getReceiveNotesName() {
        return receiveNotesName;
    }

    public void setReceiveNotesName(String receiveNotesName) {
        this.receiveNotesName = receiveNotesName;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getPayNotesId() {
        return payNotesId;
    }
    @ReferDeserialTransfer
    public void setPayNotesId(Long payNotesId) {
        this.payNotesId = payNotesId;
    }

    public String getPayNotesName() {
        return payNotesName;
    }

    public void setPayNotesName(String payNotesName) {
        this.payNotesName = payNotesName;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getBillingRoomId() {
        return billingRoomId;
    }
    @ReferDeserialTransfer
    public void setBillingRoomId(Long billingRoomId) {
        this.billingRoomId = billingRoomId;
    }

    public String getBillingRoomName() {
        return billingRoomName;
    }

    public void setBillingRoomName(String billingRoomName) {
        this.billingRoomName = billingRoomName;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getCarModelId() {
        return carModelId;
    }
    @ReferDeserialTransfer
    public void setCarModelId(Long carModelId) {
        this.carModelId = carModelId;
    }

    public String getCarModelName() {
        return carModelName;
    }

    public void setCarModelName(String carModelName) {
        this.carModelName = carModelName;
    }

    public String getMaterialInfo() {
        return materialInfo;
    }

    public void setMaterialInfo(String materialInfo) {
        this.materialInfo = materialInfo;
    }

    public String getPayWayName() {
        return payWayName;
    }

    public void setPayWayName(String payWayName) {
        this.payWayName = payWayName;
    }

    /**
      * 付款申请记录结算实体
      */
     public List<PayRecordSettleVO> getSettleList() {
        return settleList;
     }

     /**
      * 付款申请记录结算实体
      */
     public void setSettleList(List<PayRecordSettleVO> settleList) {
        this.settleList = settleList;
     }
}
