package com.ejianc.business.finance.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 投标保证金申请
 * 
 * @author generator
 * 
 */
public class BidBondVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String billCode; // 申请编码
    private String bondStatus; // 保证金状态:0-待处理，1-有效
    private BigDecimal applyMny; // 申请金额
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date beginDate; // 预计使用时间
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endDate; // 预计退还时间
    private String memo; // 申请说明
    private Long opportunityId; // 商机
    private String opportunityName; // 商机名称
    private Long orgId; // 组织
    private String orgName; // 组织名称
    private Long applyEmployeeId; // 申请人
    private String applyEmployeeName; // 申请人名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date applyTime; // 申请时间
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private Long customerId; // 收款单位
    private String customerName; // 收款单位名称
    private BigDecimal bondScale; // 保证金比例
    private String accountName; // 账户名
    private String bankAccount; // 银行账号
    private String bankName; // 开户行
    private BigDecimal payMny; // 已支付金额
    private BigDecimal backMny; // 已退还金额
    private BigDecimal surplusMny; //剩余金额
    private Integer billState; // 单据状态（审批必须字段）
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date dealTime; // 办理时间

    private String dealStatus;
    private String billStateName;

    private List<BidBondDealVO> bidBondDealList = new ArrayList<>(); // 投标保证金申请子表
    private List<BidBondBackVO> bidBondBackList = new ArrayList<>(); // 投标保证金申请子表

    public BigDecimal getSurplusMny() {
        return surplusMny;
    }

    public void setSurplusMny(BigDecimal surplusMny) {
        this.surplusMny = surplusMny;
    }

    public List<BidBondBackVO> getBidBondBackList() {
        return bidBondBackList;
    }

    public void setBidBondBackList(List<BidBondBackVO> bidBondBackList) {
        this.bidBondBackList = bidBondBackList;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public String getBondStatus() {
        return bondStatus;
    }

    public void setBondStatus(String bondStatus) {
        this.bondStatus = bondStatus;
    }

    public BigDecimal getApplyMny() {
        return applyMny;
    }

    public void setApplyMny(BigDecimal applyMny) {
        this.applyMny = applyMny;
    }

    public Date getBeginDate() {
        return beginDate;
    }

    public void setBeginDate(Date beginDate) {
        this.beginDate = beginDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    @ReferSerialTransfer(referCode="business-opportunity-register")
    public Long getOpportunityId() {
        return opportunityId;
    }
    @ReferDeserialTransfer
    public void setOpportunityId(Long opportunityId) {
        this.opportunityId = opportunityId;
    }

    public String getOpportunityName() {
        return opportunityName;
    }

    public void setOpportunityName(String opportunityName) {
        this.opportunityName = opportunityName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getApplyEmployeeId() {
        return applyEmployeeId;
    }
    @ReferDeserialTransfer
    public void setApplyEmployeeId(Long applyEmployeeId) {
        this.applyEmployeeId = applyEmployeeId;
    }

    public String getApplyEmployeeName() {
        return applyEmployeeName;
    }

    public void setApplyEmployeeName(String applyEmployeeName) {
        this.applyEmployeeName = applyEmployeeName;
    }

    public Date getApplyTime() {
        return applyTime;
    }

    public void setApplyTime(Date applyTime) {
        this.applyTime = applyTime;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    @ReferSerialTransfer(referCode="support-customer")
    public Long getCustomerId() {
        return customerId;
    }
    @ReferDeserialTransfer
    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    public BigDecimal getBondScale() {
        return bondScale;
    }

    public void setBondScale(BigDecimal bondScale) {
        this.bondScale = bondScale;
    }

    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public String getBankAccount() {
        return bankAccount;
    }

    public void setBankAccount(String bankAccount) {
        this.bankAccount = bankAccount;
    }

    public String getBankName() {
        return bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    public BigDecimal getPayMny() {
        return payMny;
    }

    public void setPayMny(BigDecimal payMny) {
        this.payMny = payMny;
    }

    public BigDecimal getBackMny() {
        return backMny;
    }

    public void setBackMny(BigDecimal backMny) {
        this.backMny = backMny;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public Date getDealTime() {
        return dealTime;
    }

    public void setDealTime(Date dealTime) {
        this.dealTime = dealTime;
    }

    public String getDealStatus() {
        return dealStatus;
    }

    public void setDealStatus(String dealStatus) {
        this.dealStatus = dealStatus;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public List<BidBondDealVO> getBidBondDealList() {
        return bidBondDealList;
    }

    public void setBidBondDealList(List<BidBondDealVO> bidBondDealList) {
        this.bidBondDealList = bidBondDealList;
    }
}
