package com.ejianc.business.finance.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author yqls
 * @since 2020-06-04
 */
public class ReceiveVO extends BaseVO {

    private static final long serialVersionUID = 1L;

    /**
     * 单据编号
     */
    private String billCode;

    /**
     * 单据状态：0-自由态，1-已提交，2-审批中，3-审批通过，4-审批不通过
     */
    private Integer billState;

    /**
     * 备注
     */
    private String memo;

    /**
     * 收入类型
     */
    private Long receiveType;

    /**
     * 合同主键
     */
    private Long contractId;

    /**
     * 合同编码
     */
    private String contractCode;

    /**
     * 合同名称
     */
    private String contractName;
    /**
     * 推送凭证标识
     */
    private Integer voucherFlag;

    /**
     * 凭证信息json
     */
    private String voucherInfo;

    /**
     * 项目
     */
    private Long projectId;

    /**
     * 项目名称
     */
    private String projectName;

    /**
     * 项目类型：1-自营，2-联营
     */
    private String projectType;

    /**
     * 组织
     */
    private Long orgId;

    /**
     * 组织名称
     */
    private String orgName;

    /**
     * 收款方式
     */
    private Long receiveWay;

    /**
     * 收款金额
     */
    private BigDecimal receiveMny;

    /**
     * 收款单位
     */
    private Long receiveUnitId;

    /**
     * 收款单位名称
     */
    private String receiveUnitName;

    /**
     * 收款说明
     */
    private String receiveExplain;

    /**
     * 经办人
     */
    private Long employeeId;
    private Long receiveNotesId; // 应收票据
    private String receiveNotesName; // 应收票据
    private Long billingRoomId; // 抵账房
    private String billingRoomName; // 抵账房
    private Long carModelId; // 车辆型号
    private String carModelName; // 车辆型号
    private String materialInfo; // 物品信息
    /**
     * 经办人名称
     */
    private String employeeName;

    /**
     * 经办时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date confirmTime;

    /**
     * 合同金额
     */
    private BigDecimal contractMny;

    /**
     * 累计产值
     */
    private BigDecimal sumProductionMny;

    /**
     * 累计批量
     */
    private BigDecimal sumQuoteMny;

    /**
     * 已收金额
     */
    private BigDecimal sumCollectMny;

    /**
     * 累计开票金额
     */
    private BigDecimal sumInvoicingMny;

    /**
     * 开票金额
     */
    private BigDecimal invoiceMny;

    /**
     * 发票子表
     */
    private List<ReceiveInvoiceVO> invoiceVOList;
    /**
     * 甲方报量子表
     */
    private List<ReceiveQuteDetailVO> receiveQuteDetailList;

    /**
     * 收款类型：1-组织收款 2-项目收款
     */
    private Integer payType;

    /**
     * 单据状态名称
     */
    private String billStateName;
    private String accountName; // 账户名
    private String accountNum; // 银行账号
    private String accountBank; // 开户行
    private Long accountId; // 开户行
    /**
     * 收入类型名称
     */
    private String receiveTypeName;

    private BigDecimal totalContractReceiveMny;
    private BigDecimal totalReceiveTaxMny;
    private Long quoteId;
    /**
     * 合同版本号
     */
    private Integer contractVersion;

    /**
     * 收款方式名称 查询列表、导出使用
     */
    private String receiveWayName;

    public Integer getContractVersion() {
        return contractVersion;
    }

    public void setContractVersion(Integer contractVersion) {
        this.contractVersion = contractVersion;
    }

    public String getReceiveTypeName() {
        return receiveTypeName;
    }

    public Integer getVoucherFlag() {
        return voucherFlag;
    }

    public void setVoucherFlag(Integer voucherFlag) {
        this.voucherFlag = voucherFlag;
    }

    public String getVoucherInfo() {
        return voucherInfo;
    }

    public void setVoucherInfo(String voucherInfo) {
        this.voucherInfo = voucherInfo;
    }

    public void setReceiveTypeName(String receiveTypeName) {
        this.receiveTypeName = receiveTypeName;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public Integer getPayType() {
        return payType;
    }

    public void setPayType(Integer payType) {
        this.payType = payType;
    }

    public List<ReceiveInvoiceVO> getInvoiceVOList() {
        return invoiceVOList;
    }

    public void setInvoiceVOList(List<ReceiveInvoiceVO> invoiceVOList) {
        this.invoiceVOList = invoiceVOList;
    }

    public List<ReceiveQuteDetailVO> getReceiveQuteDetailList() {
        return receiveQuteDetailList;
    }

    public void setReceiveQuteDetailList(List<ReceiveQuteDetailVO> receiveQuteDetailList) {
        this.receiveQuteDetailList = receiveQuteDetailList;
    }

    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public String getAccountNum() {
        return accountNum;
    }

    public void setAccountNum(String accountNum) {
        this.accountNum = accountNum;
    }

    public String getAccountBank() {
        return accountBank;
    }

    public void setAccountBank(String accountBank) {
        this.accountBank = accountBank;
    }
    @ReferSerialTransfer(referCode = "bank-account")
    public Long getAccountId() {
        return accountId;
    }
    @ReferDeserialTransfer
    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Long getReceiveType() {
        return receiveType;
    }

    public void setReceiveType(Long receiveType) {
        this.receiveType = receiveType;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    @ReferSerialTransfer(referCode = "market-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectType() {
        return projectType;
    }

    public void setProjectType(String projectType) {
        this.projectType = projectType;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getReceiveWay() {
        return receiveWay;
    }

    @ReferDeserialTransfer
    public void setReceiveWay(Long receiveWay) {
        this.receiveWay = receiveWay;
    }

    public BigDecimal getReceiveMny() {
        return receiveMny;
    }

    public void setReceiveMny(BigDecimal receiveMny) {
        this.receiveMny = receiveMny;
    }

    @ReferSerialTransfer(referCode="support-customer")
    public Long getReceiveUnitId() {
        return receiveUnitId;
    }

    @ReferDeserialTransfer
    public void setReceiveUnitId(Long receiveUnitId) {
        this.receiveUnitId = receiveUnitId;
    }

    public String getReceiveUnitName() {
        return receiveUnitName;
    }

    public void setReceiveUnitName(String receiveUnitName) {
        this.receiveUnitName = receiveUnitName;
    }

    public String getReceiveExplain() {
        return receiveExplain;
    }

    public void setReceiveExplain(String receiveExplain) {
        this.receiveExplain = receiveExplain;
    }

    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public Date getConfirmTime() {
        return confirmTime;
    }

    public void setConfirmTime(Date confirmTime) {
        this.confirmTime = confirmTime;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public BigDecimal getSumProductionMny() {
        return sumProductionMny;
    }

    public void setSumProductionMny(BigDecimal sumProductionMny) {
        this.sumProductionMny = sumProductionMny;
    }

    public BigDecimal getSumQuoteMny() {
        return sumQuoteMny;
    }

    public void setSumQuoteMny(BigDecimal sumQuoteMny) {
        this.sumQuoteMny = sumQuoteMny;
    }

    public BigDecimal getSumCollectMny() {
        return sumCollectMny;
    }

    public void setSumCollectMny(BigDecimal sumCollectMny) {
        this.sumCollectMny = sumCollectMny;
    }

    public BigDecimal getSumInvoicingMny() {
        return sumInvoicingMny;
    }

    public void setSumInvoicingMny(BigDecimal sumInvoicingMny) {
        this.sumInvoicingMny = sumInvoicingMny;
    }

    public BigDecimal getInvoiceMny() {
        return invoiceMny;
    }

    public void setInvoiceMny(BigDecimal invoiceMny) {
        this.invoiceMny = invoiceMny;
    }

    public BigDecimal getTotalContractReceiveMny() {
        return totalContractReceiveMny;
    }

    public void setTotalContractReceiveMny(BigDecimal totalContractReceiveMny) {
        this.totalContractReceiveMny = totalContractReceiveMny;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getReceiveNotesId() {
        return receiveNotesId;
    }
    @ReferDeserialTransfer
    public void setReceiveNotesId(Long receiveNotesId) {
        this.receiveNotesId = receiveNotesId;
    }

    public String getReceiveNotesName() {
        return receiveNotesName;
    }

    public void setReceiveNotesName(String receiveNotesName) {
        this.receiveNotesName = receiveNotesName;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getBillingRoomId() {
        return billingRoomId;
    }
    @ReferDeserialTransfer
    public void setBillingRoomId(Long billingRoomId) {
        this.billingRoomId = billingRoomId;
    }

    public String getBillingRoomName() {
        return billingRoomName;
    }

    public void setBillingRoomName(String billingRoomName) {
        this.billingRoomName = billingRoomName;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getCarModelId() {
        return carModelId;
    }
    @ReferDeserialTransfer
    public void setCarModelId(Long carModelId) {
        this.carModelId = carModelId;
    }

    public String getCarModelName() {
        return carModelName;
    }

    public void setCarModelName(String carModelName) {
        this.carModelName = carModelName;
    }

    public String getMaterialInfo() {
        return materialInfo;
    }

    public void setMaterialInfo(String materialInfo) {
        this.materialInfo = materialInfo;
    }
    public BigDecimal getTotalReceiveTaxMny() {
        return totalReceiveTaxMny;
    }

    public void setTotalReceiveTaxMny(BigDecimal totalReceiveTaxMny) {
        this.totalReceiveTaxMny = totalReceiveTaxMny;
    }

    public Long getQuoteId() {
        return quoteId;
    }

    public void setQuoteId(Long quoteId) {
        this.quoteId = quoteId;
    }

    public String getReceiveWayName() {
        return receiveWayName;
    }

    public void setReceiveWayName(String receiveWayName) {
        this.receiveWayName = receiveWayName;
    }
}
