package com.ejianc.business.finance.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.finance.vo.ReimburseShareDetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 报销费用分摊
 * 
 * @author generator
 * 
 */
public class ReimburseShareVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Integer billState; // 单据状态：0-自由态，1-已提交，2-审批中，3-审批通过，4-审批不通过
    private Long reimburseId; // 费用报销主表id
    private String reimburseCode; // 费用报销编码
    private Long orgId; // 组织
    private String orgCode; // 组织编码
    private String orgName; // 组织名称
    private Long feeType; // 费用类别
    private String feeTypeName; // 费用类别名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date reimburseDate; // 报销日期
    private String reimburseReason; // 报销事由
    private BigDecimal reimburseMny; // 报销金额
    private String reimburseMnyCn; // 报销金额大写
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date bliDate; // 单据日期
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private BigDecimal lastShareMny; // 已分摊金额(不含本次)
    private BigDecimal totalShareMny; // 已分摊金额(含本次)
    private BigDecimal surplusShareMny; // 本次可分摊金额
    private BigDecimal sumShareMny; // 本次分摊金额合计
    private BigDecimal shareRatio; // 本次分摊比例
    private String memo; // 备注
    private String billStateName; // 单据状态名称

    private List<ReimburseShareDetailVO> reimburseShareDetailList = new ArrayList<>(); // 报销费用分摊子表

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    @ReferSerialTransfer(referCode = "pay_reimburse")
    public Long getReimburseId() {
        return reimburseId;
    }
    @ReferDeserialTransfer
    public void setReimburseId(Long reimburseId) {
        this.reimburseId = reimburseId;
    }
    public String getReimburseCode() {
        return reimburseCode;
    }

    public void setReimburseCode(String reimburseCode) {
        this.reimburseCode = reimburseCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getFeeType() {
        return feeType;
    }

    public void setFeeType(Long feeType) {
        this.feeType = feeType;
    }
    public String getFeeTypeName() {
        return feeTypeName;
    }

    public void setFeeTypeName(String feeTypeName) {
        this.feeTypeName = feeTypeName;
    }
    public Date getReimburseDate() {
        return reimburseDate;
    }

    public void setReimburseDate(Date reimburseDate) {
        this.reimburseDate = reimburseDate;
    }
    public String getReimburseReason() {
        return reimburseReason;
    }

    public void setReimburseReason(String reimburseReason) {
        this.reimburseReason = reimburseReason;
    }
    public BigDecimal getReimburseMny() {
        return reimburseMny;
    }

    public void setReimburseMny(BigDecimal reimburseMny) {
        this.reimburseMny = reimburseMny;
    }
    public String getReimburseMnyCn() {
        return reimburseMnyCn;
    }

    public void setReimburseMnyCn(String reimburseMnyCn) {
        this.reimburseMnyCn = reimburseMnyCn;
    }
    public Date getBliDate() {
        return bliDate;
    }

    public void setBliDate(Date bliDate) {
        this.bliDate = bliDate;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public BigDecimal getLastShareMny() {
        return lastShareMny;
    }

    public void setLastShareMny(BigDecimal lastShareMny) {
        this.lastShareMny = lastShareMny;
    }
    public BigDecimal getTotalShareMny() {
        return totalShareMny;
    }

    public void setTotalShareMny(BigDecimal totalShareMny) {
        this.totalShareMny = totalShareMny;
    }
    public BigDecimal getSurplusShareMny() {
        return surplusShareMny;
    }

    public void setSurplusShareMny(BigDecimal surplusShareMny) {
        this.surplusShareMny = surplusShareMny;
    }
    public BigDecimal getSumShareMny() {
        return sumShareMny;
    }

    public void setSumShareMny(BigDecimal sumShareMny) {
        this.sumShareMny = sumShareMny;
    }
    public BigDecimal getShareRatio() {
        return shareRatio;
    }

    public void setShareRatio(BigDecimal shareRatio) {
        this.shareRatio = shareRatio;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    
     public List<ReimburseShareDetailVO> getReimburseShareDetailList() {
        return reimburseShareDetailList;
     }

     public void setReimburseShareDetailList(List<ReimburseShareDetailVO> reimburseShareDetailList) {
        this.reimburseShareDetailList = reimburseShareDetailList;
     }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }
}
