package com.ejianc.business.finance.api;

import com.ejianc.business.finance.hystrix.ReceiveManageHystrix;
import com.ejianc.business.finance.vo.ReceiveVO;
import com.ejianc.business.finance.vo.SumReceiveVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

/**
 * 获取合同参照工厂类方法
 *
 * @author yqls
 */
@FeignClient(name = "ejc-finance-web", url = "${common.env.feign-client-url}", path = "ejc-finance-web", fallback = ReceiveManageHystrix.class)
//@FeignClient(name= "ejc-finance-web", url="${common.env.feign-client-url}", path="ejc-finance-web", configuration = {KeepErrMsgConfiguration.class})
public interface IReceiveManageApi {

    /**
     * 根据合同contractId 查询累计收款与收款详情
     *
     * @param contractId
     * @return
     */
    @GetMapping(value = "/api/receive/getSumReceiveVOList")
    public CommonResponse<SumReceiveVO> getSumReceiveVOList(@RequestParam(value = "contractId", required = true) Long contractId);

    /**
     * 统计已生效的有合同收款登记金额（含税）
     *
     * @param param tenantId 租户Id
     *              projectIds 项目Id列表
     * @return
     */
    @PostMapping(value = "/api/receive/countByProperties")
    public CommonResponse<BigDecimal> countByProperties(@RequestBody Map<String, Object> param);

    /**
     * @param projectId
     * @description: 根据项目id查询收款
     * @return: com.ejianc.framework.core.response.CommonResponse<com.ejianc.business.finance.vo.SumReceiveVO>
     * @author songlx
     * @date: 2021/7/26
     */
    @GetMapping(value = "/api/receive/queryList")
    public CommonResponse<List<ReceiveVO>> queryList(@RequestParam(value = "projectId", required = true) Long projectId);


    /**
     * @description: 获取合同已收质保金（收款登记收入属性为质保金）
     *
     * @param contractId
     * @return {@link CommonResponse< SumReceiveVO>}
     * @author songlx
     * @date: 2023/8/25
     */
    @GetMapping(value = "/api/receive/getSumZhiBaoJinReceiveMny")
    CommonResponse<SumReceiveVO> getSumZhiBaoJinReceiveMny(@RequestParam(value = "contractId") Long contractId);


}
