package com.ejianc.business.finance.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author yqls
 * @since 2020-06-04
 */
public class PayApplyPubVO extends BaseVO {

    private static final long serialVersionUID = 1L;

    /**
     * 单据编号
     */
    private String billCode;

    /**
     * 单据状态：0-自由态，1-已提交，2-审批中，3-审批通过，4-审批不通过
     */
    private Integer billState;

    /**
     * 付款类型：1-组织付款 2-项目付款
     */
    private Integer payType;

    /**
     * 支付状态：1-未支付 2-已支付
     */
    private Integer payStatus;
    private Long contractId;
    private Long contractType;
    /**
     * 合同名称
     */
    private String contractName;

    /**
     * 项目
     */
    private Long projectId;

    /**
     * 组织
     */
    private Long orgId;

    /**
     * 组织名称
     */
    private String orgName;

    /**
     * 申请类型
     */
    private String applyType;

    /**
     * 申请类型 + 费用类型
     */
    private String feeType;

    /**
     * 收款单位名称
     */
    private String receiveUnitName;

    /**
     * 收款单位名称
     */
    private String accountName;

    /**
     * 申请人
     */
    private Long applyUserId;

    /**
     * 申请人名称
     */
    private String applyUserName;

    /**
     * 申请时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date applyTime;

    /**
     * 申请金额
     */
    private BigDecimal applyMny;

    /**
     * 审批时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date approveTime;

    /**
     * 经办人
     */
    private Long employeeId;

    /**
     * 经办人名称
     */
    private String employeeName;
    private Long receiveNotesId; // 应收票据
    private String receiveNotesName; // 应收票据
    private Long payNotesId; // 应付票据
    private String payNotesName; // 应付票据
    private Long billingRoomId; // 抵账房
    private String billingRoomName; // 抵账房
    private Long carModelId; // 车辆型号
    private String carModelName; // 车辆型号
    private String materialInfo; // 物品信息
    private java.math.BigDecimal notCreditedMny; // 不入账金额
    private Long accountId; // 付款账户名
    /**
     * 经办时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date confirmTime;

    /**
     * 支付金额
     */
    private BigDecimal payMny;

    /**
     * 本期支付金额
     */
    private BigDecimal thisPayMny;

    /**
     * 发票金额
     */
    private BigDecimal invoiceMny;

    /**
     * 付款事由
     */
    private String payReason;
    /**
     * 备注
     */
    private String memo;

    private String accountNum;

    private String  accountBank;

    private Long payWay; // 付款方式
    private String payWayName; // 付款方式名称

    private java.math.BigDecimal unpaidMny; // 未付金额

    private String payUnitName;//付款单位名称

    private Long feeTypeId;

    public Long getFeeTypeId() {
        return feeTypeId;
    }

    public void setFeeTypeId(Long feeTypeId) {
        this.feeTypeId = feeTypeId;
    }

    public BigDecimal getUnpaidMny() {
        return unpaidMny;
    }

    public Long getContractType() {
        return contractType;
    }

    public void setContractType(Long contractType) {
        this.contractType = contractType;
    }

    public void setUnpaidMny(BigDecimal unpaidMny) {
        this.unpaidMny = unpaidMny;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public String getPayReason() {
        return payReason;
    }

    public void setPayReason(String payReason) {
        this.payReason = payReason;
    }

    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public BigDecimal getInvoiceMny() {
        return invoiceMny;
    }

    public void setInvoiceMny(BigDecimal invoiceMny) {
        this.invoiceMny = invoiceMny;
    }

    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public BigDecimal getThisPayMny() {
        return thisPayMny;
    }

    public void setThisPayMny(BigDecimal thisPayMny) {
        this.thisPayMny = thisPayMny;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }



    public Date getConfirmTime() {
        return confirmTime;
    }

    public void setConfirmTime(Date confirmTime) {
        this.confirmTime = confirmTime;
    }

    public BigDecimal getPayMny() {
        return payMny;
    }

    public void setPayMny(BigDecimal payMny) {
        this.payMny = payMny;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public Integer getPayType() {
        return payType;
    }

    public void setPayType(Integer payType) {
        this.payType = payType;
    }

    public Integer getPayStatus() {
        return payStatus;
    }

    public void setPayStatus(Integer payStatus) {
        this.payStatus = payStatus;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getApplyUserName() {
        return applyUserName;
    }

    public void setApplyUserName(String applyUserName) {
        this.applyUserName = applyUserName;
    }

    public Date getApplyTime() {
        return applyTime;
    }

    public void setApplyTime(Date applyTime) {
        this.applyTime = applyTime;
    }

    public String getFeeType() {
        return feeType;
    }

    public void setFeeType(String feeType) {
        this.feeType = feeType;
    }

    public String getApplyType() {
        return applyType;
    }

    public void setApplyType(String applyType) {
        this.applyType = applyType;
    }

    public BigDecimal getApplyMny() {
        return applyMny;
    }

    public void setApplyMny(BigDecimal applyMny) {
        this.applyMny = applyMny;
    }

    public Date getApproveTime() {
        return approveTime;
    }

    public void setApproveTime(Date approveTime) {
        this.approveTime = approveTime;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    @ReferSerialTransfer(referCode = "market-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getReceiveUnitName() {
        return receiveUnitName;
    }

    public void setReceiveUnitName(String receiveUnitName) {
        this.receiveUnitName = receiveUnitName;
    }

    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getApplyUserId() {
        return applyUserId;
    }

    @ReferDeserialTransfer
    public void setApplyUserId(Long applyUserId) {
        this.applyUserId = applyUserId;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getAccountNum() {
        return accountNum;
    }

    public void setAccountNum(String accountNum) {
        this.accountNum = accountNum;
    }

    public String getAccountBank() {
        return accountBank;
    }

    public void setAccountBank(String accountBank) {
        this.accountBank = accountBank;
    }

    public Long getPayWay() {
        return payWay;
    }

    public void setPayWay(Long payWay) {
        this.payWay = payWay;
    }

    public String getPayWayName() {
        return payWayName;
    }
    @ReferSerialTransfer(referCode = "bank-account")
    public Long getAccountId() {
        return accountId;
    }
    @ReferDeserialTransfer
    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getReceiveNotesId() {
        return receiveNotesId;
    }
    @ReferDeserialTransfer
    public void setReceiveNotesId(Long receiveNotesId) {
        this.receiveNotesId = receiveNotesId;
    }

    public String getReceiveNotesName() {
        return receiveNotesName;
    }

    public void setReceiveNotesName(String receiveNotesName) {
        this.receiveNotesName = receiveNotesName;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getPayNotesId() {
        return payNotesId;
    }
    @ReferDeserialTransfer
    public void setPayNotesId(Long payNotesId) {
        this.payNotesId = payNotesId;
    }

    public String getPayNotesName() {
        return payNotesName;
    }

    public void setPayNotesName(String payNotesName) {
        this.payNotesName = payNotesName;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getBillingRoomId() {
        return billingRoomId;
    }
    @ReferDeserialTransfer
    public void setBillingRoomId(Long billingRoomId) {
        this.billingRoomId = billingRoomId;
    }

    public String getBillingRoomName() {
        return billingRoomName;
    }

    public void setBillingRoomName(String billingRoomName) {
        this.billingRoomName = billingRoomName;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getCarModelId() {
        return carModelId;
    }
    @ReferDeserialTransfer
    public void setCarModelId(Long carModelId) {
        this.carModelId = carModelId;
    }

    public String getCarModelName() {
        return carModelName;
    }

    public void setCarModelName(String carModelName) {
        this.carModelName = carModelName;
    }

    public String getMaterialInfo() {
        return materialInfo;
    }

    public void setMaterialInfo(String materialInfo) {
        this.materialInfo = materialInfo;
    }

    public BigDecimal getNotCreditedMny() {
        return notCreditedMny;
    }

    public void setNotCreditedMny(BigDecimal notCreditedMny) {
        this.notCreditedMny = notCreditedMny;
    }

    public void setPayWayName(String payWayName) {
        this.payWayName = payWayName;
    }

    public String getPayUnitName() {
        return payUnitName;
    }

    public void setPayUnitName(String payUnitName) {
        this.payUnitName = payUnitName;
    }
}
