/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.finance.service.IPayContractService;
import com.ejianc.business.finance.service.IPaySporadicService;
import com.ejianc.business.finance.utils.ParamSearchUtil;
import com.ejianc.business.finance.vo.ParamsCheckVO;
import com.ejianc.business.finance.vo.PayContractVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/laborSalaryApply"})
public class LaborSalaryApplyController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPayContractService contractService;
    @Autowired
    private IPaySporadicService paySporadicService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        param.getOrderMap().put("createTime", "desc");
        JSONObject page = this.contractService.queryLaborSalaryApplyPageJson(param, false);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PayContractVO> vos) {
        List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        List<Long> payContractIds = vos.stream().filter(vo -> "1".equals(vo.getContractFlag())).map(BaseVO::getId).collect(Collectors.toList());
        List<Long> paySporadicIds = vos.stream().filter(vo -> "0".equals(vo.getContractFlag())).map(BaseVO::getId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(payContractIds)) {
            String string = this.contractService.delete(payContractIds);
        }
        if (CollectionUtils.isNotEmpty(paySporadicIds)) {
            this.paySporadicService.delete(paySporadicIds);
        }
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        ParamSearchUtil.handleQueryParam(queryParam);
        List<PayContractVO> supplierVos = this.contractService.queryLaborSalaryApplyExportList(queryParam);
        HashMap<String, List<PayContractVO>> beans = new HashMap<String, List<PayContractVO>>();
        beans.put("records", supplierVos);
        ExcelExport.getInstance().export("contract-laborSalaryApply-export.xlsx", beans, response);
    }

    @PostMapping(value={"/checkParams"})
    @ResponseBody
    public CommonResponse<ParamsCheckVO> checkParams(@RequestBody PayContractVO vo) {
        ParamsCheckVO paramsCheckVO = this.contractService.checkParamsToLabor(vo);
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)paramsCheckVO);
    }
}

