/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.finance.bean.LoadReimburseEntity;
import com.ejianc.business.finance.service.ILoadReimburseService;
import com.ejianc.business.finance.service.IloadInvoiceService;
import com.ejianc.business.finance.vo.LoadReimburseVO;
import com.ejianc.business.finance.vo.ParamsCheckSpreadVO;
import com.ejianc.business.finance.vo.PayInfoVO;
import com.ejianc.business.tax.api.IInvoiceApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"loadReimburse"})
public class LoadReimburseController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ILoadReimburseService service;
    @Autowired
    private IloadInvoiceService loadInvoiceService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IInvoiceApi invoiceApi;
    @Autowired
    private IDefdocApi defdocApi;
    private static String COST_TYPE_DEFDOC_CODE = "load-reimburse-costType";

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<LoadReimburseVO> saveOrUpdate(@RequestBody LoadReimburseVO saveorUpdateVO) {
        LoadReimburseVO vo = this.service.insertOrUpdate(saveorUpdateVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<LoadReimburseVO> queryDetail(Long id) {
        LoadReimburseEntity entity = (LoadReimburseEntity)((Object)this.service.selectById(id));
        LoadReimburseVO vo = (LoadReimburseVO)BeanMapper.map((Object)((Object)entity), LoadReimburseVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<LoadReimburseVO> vos) {
        if (CollectionUtils.isNotEmpty(vos)) {
            List<Long> ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
            this.loadInvoiceService.updateInvoiceUsedMnyByDel(ids);
            this.service.removeByIds(ids, true);
        }
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("applyEmployeeName");
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        ComplexParam c2 = new ComplexParam();
        c2.setLogic("or");
        c2.getParams().put("applyEmployeeId", new Parameter("eq", (Object)InvocationInfoProxy.getEmployeeId()));
        c1.getComplexParams().add(c2);
        ComplexParam c3 = new ComplexParam();
        c3.setLogic("or");
        c3.getParams().put("employeeId", new Parameter("eq", (Object)InvocationInfoProxy.getEmployeeId()));
        c1.getComplexParams().add(c3);
        param.getComplexParams().add(c1);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage pageData = this.service.queryPage(param, false);
        JSONObject res = new JSONObject();
        res.put("records", (Object)BeanMapper.mapList((Iterable)pageData.getRecords(), LoadReimburseVO.class));
        res.put("total", (Object)pageData.getTotal());
        res.put("current", (Object)pageData.getCurrent());
        res.put("size", (Object)pageData.getSize());
        res.put("pages", (Object)pageData.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)res);
    }

    @RequestMapping(value={"/queryReportList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryReportList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("applyEmployeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        ArrayList commonOrgIds = new ArrayList();
        ArrayList<Integer> billstate = new ArrayList<Integer>();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse orgListResp = this.orgApi.findChildrenByParentId(orgId);
        if (!orgListResp.isSuccess()) {
            return CommonResponse.success((String)"\u5217\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        commonOrgIds.addAll(((List)orgListResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        }
        billstate.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billstate.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        param.getParams().put("bill_state", new Parameter("in", billstate));
        IPage pageData = this.service.queryPage(param, false);
        JSONObject res = new JSONObject();
        res.put("records", (Object)BeanMapper.mapList((Iterable)pageData.getRecords(), LoadReimburseVO.class));
        res.put("total", (Object)pageData.getTotal());
        res.put("current", (Object)pageData.getCurrent());
        res.put("size", (Object)pageData.getSize());
        res.put("pages", (Object)pageData.getPages());
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)res);
    }

    @RequestMapping(value={"/queryPrint"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryPrint(Long id) {
        JSONObject json = new JSONObject();
        json.put("LoadReimburse", this.service.selectById(id));
        return CommonResponse.success((String)"\u67e5\u8be2\u6253\u5370\u6570\u636e\u6210\u529f\uff01", (Object)json);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List list = new ArrayList();
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("applyEmployeeId", new Parameter("eq", (Object)InvocationInfoProxy.getEmployeeId()));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage pageData = this.service.queryPage(param, false);
        if (CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            list = BeanMapper.mapList((Iterable)pageData.getRecords(), LoadReimburseVO.class);
        }
        Map<Object, Object> defDocMap = new HashMap();
        CommonResponse defDocByDefCode = this.defdocApi.getDefDocByDefCode(COST_TYPE_DEFDOC_CODE);
        if (defDocByDefCode.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)defDocByDefCode.getData()))) {
            List data = (List)defDocByDefCode.getData();
            defDocMap = data.stream().collect(Collectors.toMap(BaseVO::getId, DefdocDetailVO::getName, (key1, key2) -> key2));
        }
        for (LoadReimburseVO vo : list) {
            vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
            vo.setCostTypeName((String)defDocMap.get(vo.getCostType()));
        }
        HashMap beans = new HashMap();
        beans.put("records", list);
        ExcelExport.getInstance().export("loadReimburseExport.xlsx", beans, response);
    }

    @RequestMapping(value={"/excelExportReport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportReport(@RequestBody QueryParam param, HttpServletResponse response) {
        List list = new ArrayList();
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        ArrayList commonOrgIds = new ArrayList();
        ArrayList<Integer> billstate = new ArrayList<Integer>();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse orgListResp = this.orgApi.findChildrenByParentId(orgId);
        if (!orgListResp.isSuccess()) {
            throw new BusinessException("\u5217\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        commonOrgIds.addAll(((List)orgListResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        }
        billstate.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billstate.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        param.getParams().put("bill_state", new Parameter("in", billstate));
        IPage pageData = this.service.queryPage(param, false);
        if (CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            list = BeanMapper.mapList((Iterable)pageData.getRecords(), LoadReimburseVO.class);
        }
        Map<Object, Object> defDocMap = new HashMap();
        CommonResponse defDocByDefCode = this.defdocApi.getDefDocByDefCode(COST_TYPE_DEFDOC_CODE);
        if (defDocByDefCode.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)defDocByDefCode.getData()))) {
            List data = (List)defDocByDefCode.getData();
            defDocMap = data.stream().collect(Collectors.toMap(BaseVO::getId, DefdocDetailVO::getName, (key1, key2) -> key2));
        }
        for (LoadReimburseVO vo : list) {
            vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
            vo.setCostTypeName((String)defDocMap.get(vo.getCostType()));
        }
        HashMap beans = new HashMap();
        beans.put("records", list);
        ExcelExport.getInstance().export("loadReimburseExport.xlsx", beans, response);
    }

    @RequestMapping(value={"/pushCost"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<LoadReimburseVO> pushCost(@RequestBody LoadReimburseVO loadReimburseVO) {
        return this.service.pushCost(loadReimburseVO);
    }

    @PostMapping(value={"checkBudgetParams"})
    @ResponseBody
    public CommonResponse<ParamsCheckSpreadVO> checkBudgetParams(@RequestBody LoadReimburseVO vo) {
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)this.service.checkBudgetParams(vo));
    }

    @RequestMapping(value={"/updateInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<LoadReimburseVO> updateInfo(@RequestBody LoadReimburseVO vo) {
        if (vo.getId() != null && vo.getInvoiceFlag() != null) {
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)vo.getId());
            updateWrapper.set(LoadReimburseEntity::getInvoiceFlag, (Object)vo.getInvoiceFlag());
            this.service.update((Wrapper)updateWrapper);
        }
        return CommonResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"payReimburse-import.xlsx", (String)"\u5907\u7528\u91d1\u62a5\u9500\u8d39\u7528\u4fe1\u606f\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        ArrayList<PayInfoVO> successList = new ArrayList<PayInfoVO>();
        ArrayList<PayInfoVO> errorList = new ArrayList<PayInfoVO>();
        if (result != null && result.size() > 0) {
            if (((List)result.get(0)).size() != 4) {
                throw new BusinessException("\u8bf7\u6309\u7167\u5bfc\u5165\u6a21\u677f\u5bfc\u5165\u6570\u636e");
            }
            Map<Object, Object> collect = new HashMap();
            CommonResponse defDocByDefId = this.defdocApi.getDefDocByDefId(Long.valueOf(324875125018329093L));
            if (!defDocByDefId.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u67e5\u8be2\u81ea\u5b9a\u4e49\u6863\u6848\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            List ddd = (List)defDocByDefId.getData();
            collect = ddd.stream().collect(Collectors.toMap(DefdocDetailVO::getName, BaseVO::getId));
            for (int i = 0; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                PayInfoVO purchaseOrderDetailVO = new PayInfoVO();
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(0)))) {
                    purchaseOrderDetailVO.setErrorMessage("\u8d39\u7528\u540d\u79f0\u4e3a\u5fc5\u586b\u9879");
                } else if (collect.containsKey(((String)datas.get(0)).trim())) {
                    purchaseOrderDetailVO.setFeeTypeName(((String)datas.get(0)).trim());
                    purchaseOrderDetailVO.setFeeType((Long)collect.get(((String)datas.get(0)).trim()));
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(1)))) {
                    purchaseOrderDetailVO.setErrorMessage("\u8d39\u7528\u91d1\u989d\u4e3a\u5fc5\u586b\u9879");
                } else if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(1)))) {
                    try {
                        purchaseOrderDetailVO.setFeeTaxMny(new BigDecimal((String)datas.get(1)));
                    }
                    catch (Exception e) {
                        purchaseOrderDetailVO.setErrorMessage("\u8d39\u7528\u91d1\u989d\u5fc5\u987b\u4e3a\u6570\u5b57");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(2)))) {
                    try {
                        SimpleDateFormat ft = new SimpleDateFormat("yyyy-MM-dd");
                        String time = (String)datas.get(2);
                        Date date = ft.parse(time);
                        purchaseOrderDetailVO.setFeeHappenDate(date);
                    }
                    catch (Exception e) {
                        purchaseOrderDetailVO.setErrorMessage("\u8d39\u7528\u53d1\u751f\u65e5\u671f\u683c\u5f0f\u9519\u8bef\uff0c\u4f8b\u59822022-01-01");
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(3))) && ((String)datas.get(3)).length() > 50) {
                    purchaseOrderDetailVO.setErrorMessage("\u5907\u6ce8\u586b\u5199\u957f\u5ea6\u4e3a0~50\u5b57");
                } else {
                    purchaseOrderDetailVO.setFeeMemo((String)datas.get(3));
                }
                if (StringUtils.isNotEmpty((CharSequence)purchaseOrderDetailVO.getErrorMessage())) {
                    errorList.add(purchaseOrderDetailVO);
                    continue;
                }
                successList.add(purchaseOrderDetailVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success((Object)json);
    }
}

