/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.finance.service.IPayReimburseService;
import com.ejianc.business.finance.vo.PayReimburseStatisticsVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/payReimburseStatistics"})
public class StatisticsController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPayReimburseService service;
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private IOrgApi orgApi;

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<PayReimburseStatisticsVO>> queryList(@RequestBody QueryParam param) {
        ArrayList<Integer> billstate = new ArrayList<Integer>();
        String dependOnProject = "0";
        if (param.getParams().containsKey("dependOnProject")) {
            dependOnProject = String.valueOf(((Parameter)param.getParams().get("dependOnProject")).getValue());
            param.getParams().remove("dependOnProject");
        }
        billstate.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billstate.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        param.getParams().put("t.billState", new Parameter("in", billstate));
        param.getParams().put("t.dr", new Parameter("eq", (Object)0));
        param.getParams().put("t1.dr", new Parameter("eq", (Object)0));
        param.getParams().put("t.org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        String feeTypeName = param.getParams().get("feeTypeName") != null ? ((Parameter)param.getParams().get("feeTypeName")).getValue().toString() : null;
        HashMap<Long, String> feeTypeMap = new HashMap<Long, String>();
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        CommonResponse resp = this.defdocApi.getDefDocByDefId(Long.valueOf(324875125018329093L));
        if (resp.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)resp.getData()))) {
            List list = ((List)resp.getData()).stream().filter(s -> s.getEnabled() != 0).collect(Collectors.toList());
            if ("1".equals(dependOnProject)) {
                DefdocDetailVO defdocDetailVO = new DefdocDetailVO();
                defdocDetailVO.setId(null);
                defdocDetailVO.setName("\u5206\u644a\u8d39\u7528");
                list.add(defdocDetailVO);
            }
            for (DefdocDetailVO defdoc : list) {
                String defdocName;
                if (!StringUtils.isNotBlank((String)feeTypeName) || !(defdocName = defdoc.getName()).contains(feeTypeName)) continue;
                feeTypeMap.put(defdoc.getId(), defdoc.getName());
            }
            ArrayList feeType = new ArrayList(feeTypeMap.keySet());
            param.getParams().remove("feeTypeName");
            if (CollectionUtils.isNotEmpty(feeType)) {
                // empty if block
            }
            QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
            wrapper.eq((Object)"t.depend_on_project", (Object)dependOnProject);
            if (CollectionUtils.isNotEmpty(feeType) && feeType.contains(null)) {
                ((QueryWrapper)((QueryWrapper)wrapper.in((Object)"t1.fee_type", feeType)).or()).isNull((Object)"t1.fee_type");
            }
            IPage<PayReimburseStatisticsVO> listPage = this.service.payReimburseStatisticsList((Page<PayReimburseStatisticsVO>)page, wrapper, dependOnProject);
            List records = listPage.getRecords();
            for (DefdocDetailVO defdoc : list) {
                for (PayReimburseStatisticsVO record : records) {
                    ArrayList<PayReimburseStatisticsVO> children = record.getChildren();
                    if (CollectionUtils.isEmpty((Collection)children)) {
                        children = new ArrayList<PayReimburseStatisticsVO>();
                    }
                    if (!feeTypeMap.isEmpty() && !feeTypeMap.containsKey(defdoc.getId())) continue;
                    PayReimburseStatisticsVO newVO = new PayReimburseStatisticsVO();
                    newVO.setId(Long.valueOf(IdWorker.getId()));
                    newVO.setProjectId(record.getProjectId());
                    newVO.setOrgId(record.getOrgId());
                    newVO.setFeeType(defdoc.getId());
                    newVO.setFeeTypeName(defdoc.getName());
                    children.add(newVO);
                    newVO.setThisMonthApplyMny(BigDecimal.ZERO);
                    newVO.setThisMonthInvoiceMny(BigDecimal.ZERO);
                    newVO.setThisMonthPayMny(BigDecimal.ZERO);
                    newVO.setThisMonthShareMny(BigDecimal.ZERO);
                    newVO.setThisMonthOrgShareMny(BigDecimal.ZERO);
                    newVO.setThisYearApplyMny(BigDecimal.ZERO);
                    newVO.setThisYearInvoiceMny(BigDecimal.ZERO);
                    newVO.setThisYearPayMny(BigDecimal.ZERO);
                    newVO.setThisYearShareMny(BigDecimal.ZERO);
                    newVO.setThisYearOrgShareMny(BigDecimal.ZERO);
                    newVO.setSumApplyMny(BigDecimal.ZERO);
                    newVO.setSumInvoiceMny(BigDecimal.ZERO);
                    newVO.setSumPayMny(BigDecimal.ZERO);
                    newVO.setSumShareMny(BigDecimal.ZERO);
                    newVO.setSumOrgShareMny(BigDecimal.ZERO);
                    record.setChildren(children);
                }
            }
            for (PayReimburseStatisticsVO record : records) {
                ArrayList children = record.getChildren();
                List<PayReimburseStatisticsVO> detailList = this.service.payReimburseStatisticsDetailList(record.getProjectId(), record.getOrgId(), wrapper);
                if (CollectionUtils.isEmpty((Collection)children)) {
                    children = new ArrayList();
                }
                for (PayReimburseStatisticsVO detail : children) {
                    for (PayReimburseStatisticsVO detailData : detailList) {
                        Long detailDataId;
                        Long detailId = detail.getProjectId() != null ? detail.getProjectId() : detail.getOrgId();
                        if (!detailId.equals(detailDataId = detailData.getProjectId() != null ? detailData.getProjectId() : detailData.getOrgId()) || (detail.getFeeType() != null || detailData.getFeeType() != null) && (detail.getFeeType() == null || !detail.getFeeType().equals(detailData.getFeeType()))) continue;
                        detail.setThisMonthApplyMny(detailData.getThisMonthApplyMny());
                        detail.setThisMonthInvoiceMny(detailData.getThisMonthInvoiceMny());
                        detail.setThisMonthPayMny(detailData.getThisMonthPayMny());
                        detail.setThisMonthShareMny(detailData.getThisMonthShareMny());
                        detail.setThisMonthOrgShareMny(detailData.getThisMonthOrgShareMny());
                        detail.setThisYearApplyMny(detailData.getThisYearApplyMny());
                        detail.setThisYearInvoiceMny(detailData.getThisYearInvoiceMny());
                        detail.setThisYearPayMny(detailData.getThisYearPayMny());
                        detail.setThisYearShareMny(detailData.getThisYearShareMny());
                        detail.setThisYearOrgShareMny(detailData.getThisYearOrgShareMny());
                        detail.setSumApplyMny(detailData.getSumApplyMny());
                        detail.setSumInvoiceMny(detailData.getSumInvoiceMny());
                        detail.setSumPayMny(detailData.getSumPayMny());
                        detail.setSumShareMny(detailData.getSumShareMny());
                        detail.setSumOrgShareMny(detailData.getSumOrgShareMny());
                    }
                }
            }
            return CommonResponse.success((String)"\u5217\u8868\u67e5\u8be2\u6210\u529f", listPage);
        }
        return CommonResponse.error((String)"\u5217\u8868\u67e5\u8be2\u5931\u8d25");
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        ArrayList<Integer> billstate = new ArrayList<Integer>();
        String dependOnProject = "0";
        param.setPageIndex(1);
        param.setPageSize(-1);
        if (param.getParams().containsKey("dependOnProject")) {
            dependOnProject = String.valueOf(((Parameter)param.getParams().get("dependOnProject")).getValue());
            param.getParams().remove("dependOnProject");
        }
        billstate.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billstate.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        param.getParams().put("t.billState", new Parameter("in", billstate));
        param.getParams().put("t.dr", new Parameter("eq", (Object)0));
        param.getParams().put("t.org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        String feeTypeName = param.getParams().get("feeTypeName") != null ? ((Parameter)param.getParams().get("feeTypeName")).getValue().toString() : null;
        HashMap<Long, String> feeTypeMap = new HashMap<Long, String>();
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        IPage<PayReimburseStatisticsVO> listPage = new IPage<PayReimburseStatisticsVO>();
        CommonResponse resp = this.defdocApi.getDefDocByDefId(Long.valueOf(324875125018329093L));
        if (resp.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)resp.getData()))) {
            List list = ((List)resp.getData()).stream().filter(s -> s.getEnabled() != 0).collect(Collectors.toList());
            if ("1".equals(dependOnProject)) {
                DefdocDetailVO defdocDetailVO = new DefdocDetailVO();
                defdocDetailVO.setId(null);
                defdocDetailVO.setName("\u5206\u644a\u8d39\u7528");
                list.add(defdocDetailVO);
            }
            for (DefdocDetailVO defdoc : list) {
                String defdocName;
                if (!StringUtils.isNotBlank((String)feeTypeName) || !(defdocName = defdoc.getName()).contains(feeTypeName)) continue;
                feeTypeMap.put(defdoc.getId(), defdoc.getName());
            }
            ArrayList feeType = new ArrayList(feeTypeMap.keySet());
            param.getParams().remove("feeTypeName");
            if (CollectionUtils.isNotEmpty(feeType)) {
                // empty if block
            }
            QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)param);
            wrapper.eq((Object)"t.depend_on_project", (Object)dependOnProject);
            if (CollectionUtils.isNotEmpty(feeType) && feeType.contains(null)) {
                ((QueryWrapper)((QueryWrapper)wrapper.in((Object)"t1.fee_type", feeType)).or()).isNull((Object)"t1.fee_type");
            }
            listPage = this.service.payReimburseStatisticsList((Page<PayReimburseStatisticsVO>)page, wrapper, dependOnProject);
            List records = listPage.getRecords();
            for (DefdocDetailVO defdoc : list) {
                for (PayReimburseStatisticsVO record : records) {
                    ArrayList<PayReimburseStatisticsVO> children = record.getChildren();
                    if (CollectionUtils.isEmpty((Collection)children)) {
                        children = new ArrayList<PayReimburseStatisticsVO>();
                    }
                    if (!feeTypeMap.isEmpty() && !feeTypeMap.containsKey(defdoc.getId())) continue;
                    PayReimburseStatisticsVO newVO = new PayReimburseStatisticsVO();
                    newVO.setId(Long.valueOf(IdWorker.getId()));
                    newVO.setProjectId(record.getProjectId());
                    newVO.setOrgId(record.getOrgId());
                    newVO.setFeeType(defdoc.getId());
                    newVO.setFeeTypeName(defdoc.getName());
                    newVO.setThisMonthApplyMny(BigDecimal.ZERO);
                    newVO.setThisMonthInvoiceMny(BigDecimal.ZERO);
                    newVO.setThisMonthPayMny(BigDecimal.ZERO);
                    newVO.setThisMonthShareMny(BigDecimal.ZERO);
                    newVO.setThisYearApplyMny(BigDecimal.ZERO);
                    newVO.setThisYearInvoiceMny(BigDecimal.ZERO);
                    newVO.setThisYearPayMny(BigDecimal.ZERO);
                    newVO.setThisYearShareMny(BigDecimal.ZERO);
                    newVO.setSumApplyMny(BigDecimal.ZERO);
                    newVO.setSumInvoiceMny(BigDecimal.ZERO);
                    newVO.setSumPayMny(BigDecimal.ZERO);
                    newVO.setSumShareMny(BigDecimal.ZERO);
                    children.add(newVO);
                    record.setChildren(children);
                }
            }
            for (PayReimburseStatisticsVO record : records) {
                List children = record.getChildren();
                List<PayReimburseStatisticsVO> detailList = this.service.payReimburseStatisticsDetailList(record.getProjectId(), record.getOrgId(), wrapper);
                for (PayReimburseStatisticsVO detail : children) {
                    for (PayReimburseStatisticsVO detailData : detailList) {
                        Long detailDataId;
                        Long detailId = detail.getProjectId() != null ? detail.getProjectId() : detail.getOrgId();
                        if (!detailId.equals(detailDataId = detailData.getProjectId() != null ? detailData.getProjectId() : detailData.getOrgId()) || (detail.getFeeType() != null || detailData.getFeeType() != null) && (detail.getFeeType() == null || !detail.getFeeType().equals(detailData.getFeeType()))) continue;
                        detail.setThisMonthApplyMny(detailData.getThisMonthApplyMny());
                        detail.setThisMonthInvoiceMny(detailData.getThisMonthInvoiceMny());
                        detail.setThisMonthPayMny(detailData.getThisMonthPayMny());
                        detail.setThisMonthShareMny(detailData.getThisMonthShareMny());
                        detail.setThisYearApplyMny(detailData.getThisYearApplyMny());
                        detail.setThisYearInvoiceMny(detailData.getThisYearInvoiceMny());
                        detail.setThisYearPayMny(detailData.getThisYearPayMny());
                        detail.setThisYearShareMny(detailData.getThisYearShareMny());
                        detail.setSumApplyMny(detailData.getSumApplyMny());
                        detail.setSumInvoiceMny(detailData.getSumInvoiceMny());
                        detail.setSumPayMny(detailData.getSumPayMny());
                        detail.setSumShareMny(detailData.getSumShareMny());
                    }
                }
            }
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", listPage.getRecords());
        String exitsName = "org";
        if ("1".equals(dependOnProject)) {
            exitsName = "project";
        }
        ExcelExport.getInstance().export("ReimburseStatistics-" + exitsName + "-export.xlsx", beans, response);
    }
}

