/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bank.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.bank.bean.BankAcctEntity;
import com.ejianc.business.bank.bean.BankFlowEntity;
import com.ejianc.business.bank.consts.BankFlowSourceType;
import com.ejianc.business.bank.service.IBankAcctService;
import com.ejianc.business.bank.service.IBankFlowService;
import com.ejianc.business.bank.vo.BankAcctVO;
import com.ejianc.business.bank.vo.BankFlowVO;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"bankAcct"})
public class BankAcctController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IBankAcctService service;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IBankFlowService bankFlowService;

    @RequestMapping(value={"/init"}, method={RequestMethod.GET})
    @ResponseBody
    public void init() {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        List list = this.service.list((Wrapper)queryWrapper);
        for (BankAcctEntity entity : list) {
            BankFlowVO flowVO = BankFlowVO.instanceVOBySourceType((BankFlowSourceType)BankFlowSourceType.\u521d\u59cb\u4f59\u989d);
            flowVO.setBillDate(entity.getInitDate());
            flowVO.setSourceId(entity.getId());
            flowVO.setBillId(entity.getId());
            flowVO.setReceiveMoney(entity.getInitSurplusMny());
            flowVO.setAccountId(entity.getId());
            flowVO.setAccountName(entity.getAccountName());
            flowVO.setAccountBank(entity.getAccountBank());
            flowVO.setAccountNum(entity.getAccountNum());
            flowVO.setCreateTime(entity.getCreateTime());
            this.bankFlowService.saveFlowVO(flowVO);
        }
    }

    @RequestMapping(value={"/changeState"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<BankAcctVO> changeState(@RequestBody BankAcctVO bankAcctVO) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)bankAcctVO.getId());
        updateWrapper.set(BankAcctEntity::getState, (Object)bankAcctVO.getState());
        this.service.update((Wrapper)updateWrapper);
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<BankAcctVO> saveOrUpdate(@RequestBody BankAcctVO saveOrUpdateVO) {
        BankAcctEntity entity;
        boolean b;
        boolean updFlag;
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        queryWrapper.ne(saveOrUpdateVO.getId() != null, BaseEntity::getId, (Object)saveOrUpdateVO.getId());
        queryWrapper.eq(BankAcctEntity::getAccountNum, (Object)saveOrUpdateVO.getAccountNum());
        int count = this.service.count((Wrapper)queryWrapper);
        if (count > 0) {
            throw new BusinessException("\u8be5\u8d26\u53f7\u5df2\u5b58\u5728!");
        }
        boolean bl = updFlag = saveOrUpdateVO.getId() != null;
        if (updFlag) {
            BankAcctEntity bankAcctEntity = (BankAcctEntity)((Object)this.service.selectById(saveOrUpdateVO.getId()));
            CommonResponse resp = this.billTypeApi.checkQuote("BT202403000030", saveOrUpdateVO.getId());
            if (!(resp.isSuccess() || saveOrUpdateVO.getAccountBank().equals(bankAcctEntity.getAccountBank()) && saveOrUpdateVO.getAccountNum().equals(bankAcctEntity.getAccountNum()))) {
                throw new BusinessException("\u8be5\u8d26\u6237\u5df2\u4f7f\u7528\uff0c\u5f00\u6237\u884c\u4e0e\u8d26\u6237\u4fe1\u606f\u4e0d\u53ef\u66f4\u6539\uff01");
            }
            if (!ComputeUtil.equals((BigDecimal)saveOrUpdateVO.getInitSurplusMny(), (BigDecimal)bankAcctEntity.getInitSurplusMny())) {
                LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
                wrapper.eq(BankFlowEntity::getBillId, (Object)saveOrUpdateVO.getId());
                wrapper.eq(BankFlowEntity::getSourceFlag, (Object)BankFlowSourceType.\u521d\u59cb\u4f59\u989d.getCode());
                wrapper.set(BankFlowEntity::getReceiveMoney, (Object)saveOrUpdateVO.getInitSurplusMny());
                this.bankFlowService.update((Wrapper)wrapper);
            }
        }
        if ((b = this.service.saveOrUpdate((Object)(entity = (BankAcctEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, BankAcctEntity.class))), false)) && !updFlag) {
            BankFlowVO flowVO = BankFlowVO.instanceVOBySourceType((BankFlowSourceType)BankFlowSourceType.\u521d\u59cb\u4f59\u989d);
            flowVO.setBillDate(new Date());
            flowVO.setSourceId(entity.getId());
            flowVO.setBillId(entity.getId());
            flowVO.setReceiveMoney(entity.getInitSurplusMny());
            flowVO.setAccountId(entity.getId());
            flowVO.setAccountName(entity.getAccountName());
            flowVO.setAccountBank(entity.getAccountBank());
            flowVO.setAccountNum(entity.getAccountNum());
            this.bankFlowService.saveFlowVO(flowVO);
        }
        BankAcctVO vo = (BankAcctVO)BeanMapper.map((Object)((Object)entity), BankAcctVO.class);
        this.bankFlowService.getSurplusMny(Arrays.asList(vo));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BankAcctVO> queryDetail(Long id) {
        BankAcctEntity entity = (BankAcctEntity)((Object)this.service.selectById(id));
        BankAcctVO vo = (BankAcctVO)BeanMapper.map((Object)((Object)entity), BankAcctVO.class);
        this.bankFlowService.getSurplusMny(Arrays.asList(vo));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BankAcctVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
            for (BankAcctVO vo : vos) {
                CommonResponse resp = this.billTypeApi.checkQuote("BT202403000030", vo.getId());
                if (resp.isSuccess()) continue;
                return CommonResponse.error((String)resp.getMsg());
            }
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.in(BankFlowEntity::getBillId, ids);
            queryWrapper.ne(BankFlowEntity::getSourceFlag, (Object)BankFlowSourceType.\u521d\u59cb\u4f59\u989d.getCode());
            int count = this.bankFlowService.count((Wrapper)queryWrapper);
            if (count > 0) {
                return CommonResponse.error((String)"\u8be5\u8d26\u6237\u5df2\u4f7f\u7528\uff0c\u65e0\u6cd5\u5220\u9664\uff01");
            }
            boolean b = this.service.removeByIds(ids, true);
            if (b) {
                LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
                wrapper.in(BankFlowEntity::getBillId, ids);
                wrapper.eq(BankFlowEntity::getSourceFlag, (Object)BankFlowSourceType.\u521d\u59cb\u4f59\u989d.getCode());
                this.bankFlowService.remove((Wrapper)wrapper);
            }
        }
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<BankAcctVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("orgName", "accountName", "accountNum", "accountBank", "employeeName"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContext = this.sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (StringUtils.isNotEmpty((CharSequence)authOrgIds)) {
            CommonResponse authResponse = this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList()));
            param.getParams().put("orgId", new Parameter("in", ((List)authResponse.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List bankAcctVOS = BeanMapper.mapList((Iterable)page.getRecords(), BankAcctVO.class);
        this.bankFlowService.getSurplusMny(bankAcctVOS);
        pageData.setRecords(bankAcctVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/totalSurplusMny"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<BigDecimal> totalSurplusMny(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("orgName", "accountName", "accountNum", "accountBank", "employeeName"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        param.getParams().put("dr", new Parameter("eq", (Object)0));
        BigDecimal surplusMny = this.service.totalSurplusMny(param);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)surplusMny);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("orgName", "accountName", "accountNum", "accountBank", "employeeName"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        List bankAcctVOS = BeanMapper.mapList((Iterable)list, BankAcctVO.class);
        this.bankFlowService.getSurplusMny(bankAcctVOS);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", bankAcctVOS);
        ExcelExport.getInstance().export("BankAcct-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refBankAcctData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<BankAcctVO>> refBankAcctData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("orgName", "accountName", "accountNum", "accountBank", "employeeName"));
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("state", new Parameter("eq", (Object)1));
        Long orgId = InvocationInfoProxy.getOrgId();
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            if (_con.containsKey((Object)"orgId")) {
                orgId = _con.getLong("orgId");
            }
            if (_con.containsKey((Object)"state") && "all".equals(_con.getString("state"))) {
                param.getParams().remove("state");
            }
        }
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        LinkedHashMap orderMap = param.getOrderMap();
        if (MapUtils.isEmpty((Map)orderMap)) {
            orderMap.put("createTime", "desc");
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), BankAcctVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

