/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bank.service.impl;

import com.ejianc.business.bank.bean.BankAcctEntity;
import com.ejianc.business.bank.bean.BankAllocateEntity;
import com.ejianc.business.bank.consts.BankFlowSourceType;
import com.ejianc.business.bank.service.IBankAcctService;
import com.ejianc.business.bank.service.IBankAllocateService;
import com.ejianc.business.bank.service.IBankFlowService;
import com.ejianc.business.bank.vo.BankFlowVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="bankAllocate")
public class BankAllocateBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBankAllocateService service;
    @Autowired
    private IBankFlowService bankFlowService;
    @Autowired
    private IBankAcctService bankAcctService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String, Object> other) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u8fdb\u5165\u7ec8\u5ba1\u540e\u56de\u5199--- billId:" + billId + "  state:" + state);
        BankAllocateEntity entity = (BankAllocateEntity)((Object)this.service.selectById(billId));
        BankAcctEntity OutAccEntity = (BankAcctEntity)((Object)this.bankAcctService.selectById(entity.getAccountOutId()));
        BankAcctEntity InAccEntity = (BankAcctEntity)((Object)this.bankAcctService.selectById(entity.getAccountInId()));
        BankFlowVO flowVO = BankFlowVO.instanceVOBySourceType((BankFlowSourceType)BankFlowSourceType.\u8d26\u6237\u8c03\u5165);
        flowVO.setBillDate(entity.getAllocateDate());
        flowVO.setSourceId(entity.getId());
        flowVO.setBillId(entity.getId());
        flowVO.setReceiveMoney(entity.getAllocateMny());
        flowVO.setBillCode(entity.getBillCode());
        flowVO.setOrgId(entity.getOrgId());
        flowVO.setOrgName(entity.getOrgName());
        flowVO.setAccountId(entity.getAccountInId());
        flowVO.setAccountName(entity.getAccountInName());
        flowVO.setAccountBank(entity.getAccountInBank());
        flowVO.setAccountNum(entity.getAccountInNum());
        flowVO.setTradeOrgId(OutAccEntity.getOrgId());
        flowVO.setTradeOrgName(OutAccEntity.getOrgName());
        flowVO.setTradeAccountId(entity.getAccountOutId());
        flowVO.setTradeAccountName(entity.getAccountOutName());
        flowVO.setTradeAccountBank(entity.getAccountOutBank());
        flowVO.setTradeAccountNum(entity.getAccountOutNum());
        flowVO.setMemo(entity.getMemo());
        this.bankFlowService.saveFlowVO(flowVO);
        BankFlowVO flowOutVO = BankFlowVO.instanceVOBySourceType((BankFlowSourceType)BankFlowSourceType.\u8d26\u6237\u8c03\u51fa);
        flowOutVO.setBillDate(entity.getAllocateDate());
        flowOutVO.setSourceId(entity.getId());
        flowOutVO.setBillId(entity.getId());
        flowOutVO.setPayMoney(entity.getAllocateMny());
        flowOutVO.setBillCode(entity.getBillCode());
        flowOutVO.setOrgId(entity.getOrgId());
        flowOutVO.setOrgName(entity.getOrgName());
        flowOutVO.setAccountId(entity.getAccountOutId());
        flowOutVO.setAccountName(entity.getAccountOutName());
        flowOutVO.setAccountBank(entity.getAccountOutBank());
        flowOutVO.setAccountNum(entity.getAccountOutNum());
        flowOutVO.setTradeOrgId(InAccEntity.getOrgId());
        flowOutVO.setTradeOrgName(InAccEntity.getOrgName());
        flowOutVO.setTradeAccountId(entity.getAccountInId());
        flowOutVO.setTradeAccountName(entity.getAccountInName());
        flowOutVO.setTradeAccountBank(entity.getAccountInBank());
        flowOutVO.setTradeAccountNum(entity.getAccountInNum());
        flowOutVO.setMemo(entity.getMemo());
        this.bankFlowService.saveFlowVO(flowOutVO);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u8fdb\u5165\u5f03\u5ba1\u540e\u56de\u5199--- billId:" + billId + "  state:" + state);
        BankAllocateEntity entity = (BankAllocateEntity)((Object)this.service.selectById(billId));
        this.bankFlowService.delFlowBySource(entity.getId(), entity.getId());
        return CommonResponse.success();
    }
}

