/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bank.service.impl;

import com.ejianc.business.bank.bean.BankFinanceAdjustEntity;
import com.ejianc.business.bank.consts.BankFlowSourceType;
import com.ejianc.business.bank.service.IBankAcctService;
import com.ejianc.business.bank.service.IBankFinanceAdjustService;
import com.ejianc.business.bank.service.IBankFlowService;
import com.ejianc.business.bank.vo.BankFlowVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="bankFinanceAdjust")
public class BankFinanceAdjustBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBankFlowService bankFlowService;
    @Autowired
    private IBankAcctService bankAcctService;
    @Autowired
    private IBankFinanceAdjustService service;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String, Object> other) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u8fdb\u5165\u7ec8\u5ba1\u540e\u56de\u5199--- billId:" + billId + "  state:" + state);
        BankFinanceAdjustEntity entity = (BankFinanceAdjustEntity)((Object)this.service.selectById(billId));
        Integer adjustTrend = entity.getAdjustTrend();
        BankFlowVO flowVO = null;
        if (1 == adjustTrend) {
            flowVO = BankFlowVO.instanceVOBySourceType((BankFlowSourceType)BankFlowSourceType.\u4f59\u989d\u8c03\u589e);
            flowVO.setBillDate(entity.getAdjustDate());
            flowVO.setSourceId(entity.getId());
            flowVO.setBillId(entity.getId());
            flowVO.setReceiveMoney(entity.getAdjustMny());
            flowVO.setBillCode(entity.getBillCode());
            flowVO.setOrgId(entity.getOrgId());
            flowVO.setOrgName(entity.getOrgName());
            flowVO.setAccountId(entity.getAccountId());
            flowVO.setAccountName(entity.getAccountName());
            flowVO.setAccountBank(entity.getAccountBank());
            flowVO.setAccountNum(entity.getAccountNum());
            flowVO.setMemo(entity.getMemo());
        } else {
            flowVO = BankFlowVO.instanceVOBySourceType((BankFlowSourceType)BankFlowSourceType.\u4f59\u989d\u8c03\u51cf);
            flowVO.setBillDate(entity.getAdjustDate());
            flowVO.setSourceId(entity.getId());
            flowVO.setBillId(entity.getId());
            flowVO.setPayMoney(entity.getAdjustMny());
            flowVO.setBillCode(entity.getBillCode());
            flowVO.setOrgId(entity.getOrgId());
            flowVO.setOrgName(entity.getOrgName());
            flowVO.setAccountId(entity.getAccountId());
            flowVO.setAccountName(entity.getAccountName());
            flowVO.setAccountBank(entity.getAccountBank());
            flowVO.setAccountNum(entity.getAccountNum());
            flowVO.setMemo(entity.getMemo());
        }
        this.bankFlowService.saveFlowVO(flowVO);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u8fdb\u5165\u5f03\u5ba1\u540e\u56de\u5199--- billId:" + billId + "  state:" + state);
        BankFinanceAdjustEntity entity = (BankFinanceAdjustEntity)((Object)this.service.selectById(billId));
        this.bankFlowService.delFlowBySource(entity.getId(), entity.getId());
        return CommonResponse.success();
    }
}

