/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.finance.bean.BondDownBackEntity;
import com.ejianc.business.finance.service.IBondDownBackService;
import com.ejianc.business.finance.vo.BondDownBackVO;
import com.ejianc.business.finance.vo.BondDownDealRentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/bondDownBack"})
public class BondDownBackController {
    @Autowired
    private IBondDownBackService service;
    @Autowired
    private IOrgApi orgApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<BondDownBackVO> saveOrUpdate(@RequestBody BondDownBackVO bondDownBackVO) {
        BondDownBackVO backVO = this.service.insertOrUpdate(bondDownBackVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)backVO);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BondDownDealRentVO> queryDetail(Long id) {
        BondDownDealRentVO backVO = this.service.queryDetail(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)backVO);
    }

    @RequestMapping(value={"/queryDetailByNew"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BondDownBackVO> queryDetailByNew(Long id) {
        BondDownBackEntity entity = (BondDownBackEntity)((Object)this.service.selectById(id));
        BondDownBackVO map = (BondDownBackVO)BeanMapper.map((Object)((Object)entity), BondDownBackVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)map);
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<BondDownBackVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("bondCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        ArrayList commonOrgIds = new ArrayList();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse orgListResp = this.orgApi.findChildrenByParentId(orgId);
        if (!orgListResp.isSuccess()) {
            return CommonResponse.success((String)"\u5217\u8868\u67e5\u8be2\u5931\u8d25, \u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        commonOrgIds.addAll(((List)orgListResp.getData()).stream().map(BaseVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), BondDownBackVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BondDownBackVO> vos) {
        this.service.deleteNew(vos);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/totalAlreadyBackMny"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BigDecimal> totalAlreadyBackMny(Long bondId) {
        return this.service.totalAlreadyBackMny(bondId, null);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = new ArrayList();
        CommonResponse<IPage<BondDownBackVO>> iPageCommonResponse = this.queryList(param);
        if (iPageCommonResponse.isSuccess()) {
            list = ((IPage)iPageCommonResponse.getData()).getRecords();
        }
        HashMap beans = new HashMap();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        for (BondDownBackVO vo : list) {
            vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
            vo.setCreateTimeName(dateFormat.format(vo.getCreateTime()));
        }
        beans.put("records", list);
        ExcelExport.getInstance().export("bondDownBack-export.xlsx", beans, response);
    }
}

