/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.finance.bean.LoadApplyEntity;
import com.ejianc.business.finance.bean.PayContractEntity;
import com.ejianc.business.finance.bean.PayForegiftEntity;
import com.ejianc.business.finance.bean.PayReimburseEntity;
import com.ejianc.business.finance.bean.PaySporadicEntity;
import com.ejianc.business.finance.enums.ReceiveInvoiceFlagConst;
import com.ejianc.business.finance.service.ILoadApplyService;
import com.ejianc.business.finance.service.IPayContractService;
import com.ejianc.business.finance.service.IPayForegiftService;
import com.ejianc.business.finance.service.IPayReimburseService;
import com.ejianc.business.finance.service.IPaySporadicService;
import com.ejianc.business.finance.utils.ParamSearchUtil;
import com.ejianc.business.finance.vo.ParamsCheckSpreadVO;
import com.ejianc.business.finance.vo.PayInfoVO;
import com.ejianc.business.finance.vo.PayRecordVO;
import com.ejianc.business.finance.vo.PayReimburseStatisticsVO;
import com.ejianc.business.finance.vo.PayReimburseVO;
import com.ejianc.business.finance.vo.TotalColumnVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.permission.api.IRoleApi;
import com.ejianc.foundation.permission.vo.RoleVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"/payReimburse"})
public class PayReimburseController {
    private static final long serialVersionUID = 1L;
    private static final String PARAM_VIEW_CODE = "P-46055G32";
    @Autowired
    private IRoleApi roleApi;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IPayReimburseService payReimburseService;
    @Autowired
    private IPayContractService payContractService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private IPaySporadicService paySporadicService;
    @Autowired
    private IPayForegiftService payForegiftService;
    @Autowired
    private ILoadApplyService loadApplyService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PayReimburseVO> saveOrUpdate(@RequestBody PayReimburseVO payReimburseVO) {
        PayReimburseVO backVO = this.payReimburseService.insertOrUpdate(payReimburseVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)backVO);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PayReimburseVO> queryDetail(Long id) {
        PayReimburseVO backVO = this.payReimburseService.queryDetail(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)backVO);
    }

    @RequestMapping(value={"/queryPrint"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryPrint(Long id) {
        JSONObject json = new JSONObject();
        json.put("PayReimburse", (Object)this.payReimburseService.queryDetail(id));
        return CommonResponse.success((String)"\u67e5\u8be2\u6253\u5370\u6570\u636e\u6210\u529f\uff01", (Object)json);
    }

    public Boolean canViewAll() {
        Long userid;
        CommonResponse roleRes;
        ParamRegisterSetVO paramRegisterSetVO;
        String valueData;
        CommonResponse byCode = this.paramConfigApi.getByCode(PARAM_VIEW_CODE);
        if (byCode.isSuccess() && null != byCode.getData() && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)(valueData = (paramRegisterSetVO = (ParamRegisterSetVO)byCode.getData()).getValueData())) && (roleRes = this.roleApi.queryRoleByUserId(userid = InvocationInfoProxy.getUserid())).isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)roleRes.getData()))) {
            List<String> valList = Arrays.asList(valueData.split(",|\uff0c"));
            for (RoleVO roleVO : (List)roleRes.getData()) {
                if (!valList.contains(roleVO.getCode())) continue;
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        if (param.getOrderMap().size() == 0) {
            param.getOrderMap().put("createTime", "desc");
        }
        if (!this.canViewAll().booleanValue()) {
            param.getParams().put("createUserCode", new Parameter("eq", (Object)InvocationInfoProxy.getUsercode()));
        }
        JSONObject page = this.payReimburseService.queryPageJson(param, false);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/queryApproveList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryApproveList(@RequestBody QueryParam param) {
        ParamSearchUtil.handleQueryParam(param);
        param.getComplexParams().add(ComplexParam.getApprovedComplexParam((String)"and"));
        param.getOrderMap().put("approveTime", "desc");
        JSONObject page = this.payReimburseService.queryPageJson(param, false);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PayReimburseVO> vos) {
        List<Long> ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        String msg = this.payReimburseService.delete(ids);
        return CommonResponse.success((String)msg);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        if (!this.canViewAll().booleanValue()) {
            queryParam.getParams().put("createUserCode", new Parameter("eq", (Object)InvocationInfoProxy.getUsercode()));
        }
        List<PayReimburseVO> supplierVos = this.payReimburseService.queryExportList(queryParam);
        supplierVos.forEach(vo -> {
            if (null != vo.getApplyMny()) {
                vo.setUnpaidMny(vo.getApplyMny().subtract(vo.getPayMny() == null ? BigDecimal.ZERO : vo.getPayMny()));
                if (vo.getIsShareFlag() != null) {
                    vo.setIsShareFlagName(vo.getIsShareFlag() == 1 ? "\u662f" : "\u5426");
                }
            }
        });
        HashMap<String, List<PayReimburseVO>> beans = new HashMap<String, List<PayReimburseVO>>();
        beans.put("records", supplierVos);
        ExcelExport.getInstance().export("reim-payapply-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/excelExportApprove"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportApprove(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        ParamSearchUtil.handleQueryParam(queryParam);
        queryParam.getComplexParams().add(ComplexParam.getApprovedComplexParam((String)"and"));
        List<PayReimburseVO> supplierVos = this.payReimburseService.queryExportList(queryParam);
        HashMap<String, List<PayReimburseVO>> beans = new HashMap<String, List<PayReimburseVO>>();
        beans.put("records", supplierVos);
        ExcelExport.getInstance().export("reim-payapply-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/referData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<PayReimburseVO>> referData(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="condition", required=false) String condition, @RequestParam(value="searchObject", required=false) String searchObject, @RequestParam(value="searchText", required=false) String searchText) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setSearchObject(searchObject);
        queryParam.setSearchText(searchText);
        List fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("feeType");
        fuzzyFields.add("payReason");
        fuzzyFields.add("orgName");
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("payType", new Parameter("eq", (Object)1));
        queryParam.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        queryParam.getParams().put("payStatus", new Parameter("eq", (Object)2));
        UserContext userContext = this.sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (StringUtils.isNotEmpty((String)authOrgIds)) {
            CommonResponse authResponse = this.orgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList()));
            queryParam.getParams().put("orgId", new Parameter("in", ((List)authResponse.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        } else {
            queryParam.getParams().put("orgId", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        Page page = new Page((long)queryParam.getPageIndex(), (long)queryParam.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)queryParam);
        wrapper.eq((Object)"depend_on_project", (Object)"0");
        wrapper.and(wp -> (QueryWrapper)((QueryWrapper)((QueryWrapper)wp.isNull((Object)"quote_flag")).or()).eq((Object)"quote_flag", (Object)0));
        List<PayReimburseVO> list = this.payReimburseService.queryReferData((Page<PayReimburseVO>)page, wrapper);
        Page result = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        if (CollectionUtils.isNotEmpty(list)) {
            result.setRecords(list);
        }
        return CommonResponse.success((String)"\u53c2\u7167\u67e5\u8be2\u6210\u529f\uff01", (Object)result);
    }

    @RequestMapping(value={"/updateReceiveInvoiceFlag"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PayReimburseVO> updateReceiveInvoiceFlag(@RequestParam Long id, @RequestParam String applyType) {
        if (id != null) {
            if ("\u5408\u540c\u4ed8\u6b3e".equals(applyType) || "\u5de5\u4eba\u5de5\u8d44-\u6709\u5408\u540c".equals(applyType)) {
                LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                updateWrapper.eq(BaseEntity::getId, (Object)id);
                updateWrapper.set(PayContractEntity::getReceiveInvoiceFlag, (Object)ReceiveInvoiceFlagConst.YES);
                this.payContractService.update((Wrapper)updateWrapper);
            } else if ("\u96f6\u661f\u91c7\u8d2d".equals(applyType) || "\u5de5\u4eba\u5de5\u8d44-\u65e0\u5408\u540c".equals(applyType)) {
                LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                updateWrapper.eq(BaseEntity::getId, (Object)id);
                updateWrapper.set(PaySporadicEntity::getReceiveInvoiceFlag, (Object)ReceiveInvoiceFlagConst.YES);
                this.paySporadicService.update((Wrapper)updateWrapper);
            } else if ("\u62a5\u9500".equals(applyType)) {
                LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                updateWrapper.eq(BaseEntity::getId, (Object)id);
                updateWrapper.set(PayReimburseEntity::getReceiveInvoiceFlag, (Object)ReceiveInvoiceFlagConst.YES);
                this.payReimburseService.update((Wrapper)updateWrapper);
            } else if ("\u62bc\u91d1".equals(applyType)) {
                LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                updateWrapper.eq(BaseEntity::getId, (Object)id);
                updateWrapper.set(PayForegiftEntity::getReceiveInvoiceFlag, (Object)ReceiveInvoiceFlagConst.YES);
                this.payForegiftService.update((Wrapper)updateWrapper);
            } else if ("\u5907\u7528\u91d1".equals(applyType)) {
                LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                updateWrapper.eq(BaseEntity::getId, (Object)id);
                updateWrapper.set(LoadApplyEntity::getReceiveInvoiceFlag, (Object)ReceiveInvoiceFlagConst.YES);
                this.loadApplyService.update((Wrapper)updateWrapper);
            }
        }
        return CommonResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/refer"})
    @ResponseBody
    public JSONObject refer(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, String searchText) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setSearchText(searchText);
        List fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("address");
        fuzzyFields.add("area");
        fuzzyFields.add("engineeringName");
        fuzzyFields.add("engineeringCode");
        fuzzyFields.add("engineeringTypeName");
        fuzzyFields.add("infoSourceName");
        fuzzyFields.add("followPersonName");
        fuzzyFields.add("constructionUnitName");
        IPage pageData = this.payReimburseService.queryPage(queryParam, false);
        PageImpl page = new PageImpl(pageData.getRecords(), (Pageable)new PageRequest(pageNumber.intValue(), pageSize.intValue()), pageData.getTotal());
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", (Object)page);
        jsonObject.put("code", (Object)"success");
        jsonObject.put("msg", (Object)"\u67e5\u8be2\u6570\u8868\u53c2\u7167\u6210\u529f");
        return jsonObject;
    }

    @RequestMapping(value={"/queryReceiveInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PayReimburseVO> queryReceiveInfo(@RequestBody QueryParam queryParam) {
        queryParam.getParams().put("applyUserId", new Parameter("eq", (Object)InvocationInfoProxy.getEmployeeId()));
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getComplexParams().add(ComplexParam.getApprovedComplexParam((String)"and"));
        queryParam.getOrderMap().put("createTime", "desc");
        List entityList = this.payReimburseService.queryList(queryParam, false);
        PayReimburseVO backVO = !entityList.isEmpty() ? (PayReimburseVO)BeanMapper.map(entityList.get(0), PayReimburseVO.class) : new PayReimburseVO();
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)backVO);
    }

    @RequestMapping(value={"/pushCost"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PayReimburseVO> pushCost(@RequestBody PayReimburseVO paySporadicVO) {
        return this.payReimburseService.pushCost(paySporadicVO);
    }

    @RequestMapping(value={"getTotalColumnInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<TotalColumnVO> getTotalColumnInfo(@RequestBody QueryParam param) {
        param.getOrderMap().put("createTime", "desc");
        if (!this.canViewAll().booleanValue()) {
            param.getParams().put("createUserCode", new Parameter("eq", (Object)InvocationInfoProxy.getUsercode()));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)this.payReimburseService.getTotalColumnInfo(param, false));
    }

    @RequestMapping(value={"getApproveTotalColumnInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<TotalColumnVO> getApproveTotalColumnInfo(@RequestBody QueryParam param) {
        ParamSearchUtil.handleQueryParam(param);
        param.getComplexParams().add(ComplexParam.getApprovedComplexParam((String)"and"));
        param.getOrderMap().put("approveTime", "desc");
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)this.payReimburseService.getApproveTotalColumnInfo(param, false));
    }

    @RequestMapping(value={"/updateInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PayReimburseVO> updateInfo(@RequestBody PayReimburseVO vo) {
        PayReimburseEntity entity = (PayReimburseEntity)((Object)BeanMapper.map((Object)vo, PayReimburseEntity.class));
        if (vo.getId() != null && vo.getInvoiceFlag() != null) {
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)entity.getId());
            updateWrapper.set(PayReimburseEntity::getInvoiceFlag, (Object)entity.getInvoiceFlag());
            this.payReimburseService.update((Wrapper)updateWrapper);
        }
        return CommonResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/getPayReimburseInfo"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PayReimburseStatisticsVO> getPayReimburseInfo(Integer dependOnProject) {
        CommonResponse<PayReimburseStatisticsVO> response = this.payReimburseService.getPayReimburseInfo(dependOnProject);
        return response;
    }

    @RequestMapping(value={"/checkBudgetParams"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ParamsCheckSpreadVO> checkBudgetParams(@RequestBody PayReimburseVO vo) {
        ParamsCheckSpreadVO pc = new ParamsCheckSpreadVO();
        pc.setWarnType("none");
        pc.setDataSource(null);
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)pc);
    }

    @RequestMapping(value={"/closePayment"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Void> closePayment(@RequestParam(value="id") Long id) {
        this.payReimburseService.closePayment(id);
        return CommonResponse.success((String)"\u4ed8\u6b3e\u5173\u95ed\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/returnPayment"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PayRecordVO> returnPayment(@RequestBody PayRecordVO payRecordVO) {
        return CommonResponse.success((String)"\u4ed8\u6b3e\u9000\u56de\u6210\u529f\uff01", (Object)this.payReimburseService.returnPayment(payRecordVO));
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"payReimburse-import.xlsx", (String)"\u8d39\u7528\u62a5\u9500\u8d39\u7528\u4fe1\u606f\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        ArrayList<PayInfoVO> successList = new ArrayList<PayInfoVO>();
        ArrayList<PayInfoVO> errorList = new ArrayList<PayInfoVO>();
        if (result != null && result.size() > 0) {
            if (((List)result.get(0)).size() != 4) {
                throw new BusinessException("\u8bf7\u6309\u7167\u5bfc\u5165\u6a21\u677f\u5bfc\u5165\u6570\u636e");
            }
            Map<Object, Object> collect = new HashMap();
            CommonResponse defDocByDefId = this.defdocApi.getDefDocByDefId(Long.valueOf(860469051774742605L));
            if (!defDocByDefId.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u67e5\u8be2\u81ea\u5b9a\u4e49\u6863\u6848\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            List ddd = (List)defDocByDefId.getData();
            collect = ddd.stream().collect(Collectors.toMap(DefdocDetailVO::getName, BaseVO::getId));
            for (int i = 0; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                PayInfoVO purchaseOrderDetailVO = new PayInfoVO();
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)((CharSequence)datas.get(0)))) {
                    purchaseOrderDetailVO.setErrorMessage("\u8d39\u7528\u540d\u79f0\u4e3a\u5fc5\u586b\u9879");
                } else if (collect.containsKey(((String)datas.get(0)).trim())) {
                    purchaseOrderDetailVO.setFeeTypeName(((String)datas.get(0)).trim());
                    purchaseOrderDetailVO.setFeeType((Long)collect.get(((String)datas.get(0)).trim()));
                }
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)((CharSequence)datas.get(1)))) {
                    purchaseOrderDetailVO.setErrorMessage("\u8d39\u7528\u91d1\u989d\u4e3a\u5fc5\u586b\u9879");
                } else if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(1)))) {
                    try {
                        purchaseOrderDetailVO.setFeeTaxMny(new BigDecimal((String)datas.get(1)));
                    }
                    catch (Exception e) {
                        purchaseOrderDetailVO.setErrorMessage("\u8d39\u7528\u91d1\u989d\u5fc5\u987b\u4e3a\u6570\u5b57");
                    }
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(2)))) {
                    try {
                        SimpleDateFormat ft = new SimpleDateFormat("yyyy-MM-dd");
                        String time = (String)datas.get(2);
                        Date date = ft.parse(time);
                        purchaseOrderDetailVO.setFeeHappenDate(date);
                    }
                    catch (Exception e) {
                        purchaseOrderDetailVO.setErrorMessage("\u8d39\u7528\u53d1\u751f\u65e5\u671f\u683c\u5f0f\u9519\u8bef\uff0c\u4f8b\u59822022-01-01");
                    }
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(3))) && ((String)datas.get(3)).length() > 50) {
                    purchaseOrderDetailVO.setErrorMessage("\u5907\u6ce8\u586b\u5199\u957f\u5ea6\u4e3a0~50\u5b57");
                } else {
                    purchaseOrderDetailVO.setFeeMemo((String)datas.get(3));
                }
                if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)purchaseOrderDetailVO.getErrorMessage())) {
                    errorList.add(purchaseOrderDetailVO);
                    continue;
                }
                successList.add(purchaseOrderDetailVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success((Object)json);
    }
}

