/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.controller.api;

import com.ejianc.business.finance.service.ILoadReimburseService;
import com.ejianc.business.finance.service.IPayReimburseService;
import com.ejianc.business.finance.service.IPaySporadicService;
import com.ejianc.business.finance.vo.LoadReimburseVO;
import com.ejianc.business.finance.vo.PayReimburseVO;
import com.ejianc.business.finance.vo.PaySporadicVO;
import com.ejianc.framework.core.response.CommonResponse;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/budgetControl/"})
public class BudgetControlApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPayReimburseService payReimburseService;
    @Autowired
    private IPaySporadicService paySporadicService;
    @Autowired
    private ILoadReimburseService loadReimburseService;

    @GetMapping(value={"budgetControlTotal"})
    public CommonResponse<BigDecimal> budgetControlTotal(Long projectId) {
        BigDecimal applyMny = BigDecimal.ZERO;
        PayReimburseVO payReimburse = new PayReimburseVO();
        payReimburse.setProjectId(projectId);
        applyMny = applyMny.add(this.payReimburseService.totalBudgetMny(payReimburse));
        LoadReimburseVO loadReimburse = new LoadReimburseVO();
        loadReimburse.setProjectId(projectId);
        applyMny = applyMny.add(this.loadReimburseService.totalBudgetMny(loadReimburse));
        PaySporadicVO paySporadic = new PaySporadicVO();
        paySporadic.setProjectId(projectId);
        applyMny = applyMny.add(this.paySporadicService.totalBudgetMny(paySporadic));
        return CommonResponse.success((Object)applyMny);
    }
}

