/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.controller.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.cost.api.ICostDetailApi;
import com.ejianc.business.finance.bean.BondDownEntity;
import com.ejianc.business.finance.bean.BondUpEntity;
import com.ejianc.business.finance.bean.LoadApplyEntity;
import com.ejianc.business.finance.bean.LoadBackEntity;
import com.ejianc.business.finance.bean.LoadInvoiceEntity;
import com.ejianc.business.finance.bean.LoadReimburseEntity;
import com.ejianc.business.finance.bean.PayContractEntity;
import com.ejianc.business.finance.bean.PayForegiftEntity;
import com.ejianc.business.finance.bean.PayForegiftRecordEntity;
import com.ejianc.business.finance.bean.PayInvoiceEntity;
import com.ejianc.business.finance.bean.PayReimburseEntity;
import com.ejianc.business.finance.bean.PaySporadicEntity;
import com.ejianc.business.finance.bean.ReceiveEntity;
import com.ejianc.business.finance.bean.ReceiveInvoiceEntity;
import com.ejianc.business.finance.mapper.ProjectCapitalSetMapper;
import com.ejianc.business.finance.service.IBondDownService;
import com.ejianc.business.finance.service.IBondUpService;
import com.ejianc.business.finance.service.ILoadApplyService;
import com.ejianc.business.finance.service.ILoadBackService;
import com.ejianc.business.finance.service.ILoadReimburseService;
import com.ejianc.business.finance.service.IPayContractService;
import com.ejianc.business.finance.service.IPayForegiftRecordService;
import com.ejianc.business.finance.service.IPayForegiftService;
import com.ejianc.business.finance.service.IPayInvoiceService;
import com.ejianc.business.finance.service.IPayRecordService;
import com.ejianc.business.finance.service.IPayReimburseService;
import com.ejianc.business.finance.service.IPaySporadicService;
import com.ejianc.business.finance.service.IReceiveInvoiceService;
import com.ejianc.business.finance.service.IReceiveService;
import com.ejianc.business.finance.util.CountCallable;
import com.ejianc.business.finance.util.MathUtil;
import com.ejianc.business.finance.vo.ExpenditureVO;
import com.ejianc.business.finance.vo.IncomeVO;
import com.ejianc.business.finance.vo.ProjectCapitalSetVO;
import com.ejianc.business.finance.vo.ProjectFinancePayVO;
import com.ejianc.business.finance.vo.ProjectLedgerVO;
import com.ejianc.business.income.api.IIncomeContractApi;
import com.ejianc.business.prjfinance.api.IProjectDutyLetterApi;
import com.ejianc.business.prjfinance.vo.OperationCostVO;
import com.ejianc.business.tax.api.IInvoiceApi;
import com.ejianc.business.tax.vo.InvoiceReceiveVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.foundation.tenant.api.ITenantApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.Utils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.framework.skeleton.template.IBaseService;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.RequestContextHolder;

@RestController
@RequestMapping(value={"/api/project/"})
public class ProjectBoardApi {
    private static Logger logger = LoggerFactory.getLogger(ProjectBoardApi.class);
    private static Calendar calendar = Calendar.getInstance();
    @Value(value="${common.env.base-host}")
    private String BASE_HOST;
    @Autowired
    private ITenantApi tenantApi;
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private IInvoiceApi invoiceApi;
    @Autowired
    private IIncomeContractApi incomeApi;
    @Autowired
    private IPayContractService contractService;
    @Autowired
    private IPaySporadicService sporadicService;
    @Autowired
    private IPayReimburseService reimburseService;
    @Autowired
    private IPayForegiftService foregiftService;
    @Autowired
    private IPayForegiftRecordService foregiftRecordService;
    @Autowired
    private IReceiveInvoiceService receiveInvoiceService;
    @Autowired
    private IPayInvoiceService payInvoiceService;
    @Autowired
    private ILoadApplyService loadApplyService;
    @Autowired
    private ILoadReimburseService loadReimburseService;
    @Autowired
    private ILoadBackService loadBackService;
    @Autowired
    private IBondDownService bondDownService;
    @Autowired
    private IBondUpService bondUpService;
    @Autowired
    private IReceiveService receiveService;
    @Autowired
    private IPayRecordService payRecordService;
    @Autowired
    private ProjectCapitalSetMapper projectCapitalSetMapper;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private IProjectDutyLetterApi projectDutyLetterApi;
    private static String FEE_TYPE_DEFDOC_CODE = "finance-pay-reiburse-feetype";
    private static String COST_TYPE_DEFDOC_CODE = "load-reimburse-costType";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GetMapping(value={"queryPayAndReceiveByProjectId"})
    CommonResponse<JSONObject> queryPayAndReceiveByProjectId(@RequestParam(value="projectId") Long projectId, HttpServletRequest request) {
        long startTime = System.currentTimeMillis();
        String authority = request.getHeader("authority");
        ExecutorService threadPool = Executors.newFixedThreadPool(2);
        QueryParam queryParam = this.getNewQueryParam(projectId);
        Future<JSONObject> future1 = this.excute(threadPool, queryParam, this.receiveService);
        Future<JSONObject> future2 = this.excute(threadPool, authority, "ejc-income-web/contract/pageList", queryParam);
        BigDecimal payMoney = this.getPayMny(projectId);
        BigDecimal receiveMoney = null;
        BigDecimal contractMoney = null;
        try {
            receiveMoney = ProjectBoardApi.getSumMny(future1.get(), "receiveMny");
            contractMoney = ProjectBoardApi.getSumMny(future2.get(), "contractTaxMny");
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u9879\u76ee\u6536\u4ed8\u6b3e\u4ee5\u53ca\u5408\u540c\u91d1\u989d\u6570\u636e\u5f02\u5e38", (Throwable)e);
        }
        finally {
            threadPool.shutdown();
        }
        JSONObject resp = new JSONObject();
        resp.put("receiveMoney", (Object)ProjectBoardApi.roundTwoPre(receiveMoney));
        resp.put("payMoney", (Object)ProjectBoardApi.roundTwoPre(payMoney));
        resp.put("contractMoney", (Object)ProjectBoardApi.roundTwoPre(contractMoney));
        long endTime = System.currentTimeMillis();
        logger.info("queryPayAndReceiveByProjectId ---- \u8fd0\u884c\u65f6\u95f4\uff1a" + (endTime - startTime) + "ms");
        return CommonResponse.success((Object)resp);
    }

    @GetMapping(value={"queryReceiveInfoByProjectId"})
    CommonResponse<JSONObject> queryReceiveInfoByProjectId(@RequestParam(value="projectId") Long projectId, HttpServletRequest request) {
        long startTime = System.currentTimeMillis();
        String authority = request.getHeader("authority");
        JSONObject latestCollection = this.getLatestCollection(projectId);
        JSONObject paymentBalance = this.getPaymentBalance(projectId, authority);
        JSONObject monthlyIncomeAndExpenditure = this.getMonthlyIncomeAndExpenditure(projectId);
        JSONObject depositLoanMargin = this.getDepositLoanMargin(projectId);
        JSONObject underInvoice = this.getUnderInvoice(projectId);
        JSONObject resp = new JSONObject();
        resp.put("latestCollection", (Object)latestCollection);
        resp.put("paymentBalance", (Object)paymentBalance);
        resp.put("monthlyIncomeAndExpenditure", (Object)monthlyIncomeAndExpenditure);
        resp.put("depositLoanMargin", (Object)depositLoanMargin);
        resp.put("underInvoice", (Object)underInvoice);
        long endTime = System.currentTimeMillis();
        logger.info("queryReceiveInfoByProjectId ---- \u8fd0\u884c\u65f6\u95f4\uff1a" + (endTime - startTime) + "ms");
        return CommonResponse.success((Object)resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GetMapping(value={"queryCostByProjectId"})
    public CommonResponse<JSONObject> queryCostByProjectId(@RequestParam(value="projectId") Long projectId, HttpServletRequest request) {
        long startTime = System.currentTimeMillis();
        String authority = request.getHeader("authority");
        ExecutorService threadPool = Executors.newFixedThreadPool(10);
        QueryParam queryParam = this.getNewQueryParam(projectId);
        Future<JSONObject> future2 = this.excute(threadPool, authority, "ejc-income-web/quote/pageList", queryParam);
        QueryParam queryParam2 = this.getNewQueryParam(projectId);
        queryParam2.getParams().put("dependOnProject", new Parameter("eq", (Object)"1"));
        queryParam2.getParams().put("payStatus", new Parameter("eq", (Object)"2"));
        Future<JSONObject> future9 = this.excute(threadPool, queryParam2, this.sporadicService);
        Future<JSONObject> future10 = this.excute(threadPool, queryParam2, this.reimburseService);
        QueryParam queryParam3 = this.getNewQueryParam(projectId);
        queryParam3.getParams().put("dependOnProject", new Parameter("eq", (Object)"1"));
        Future<JSONObject> future11 = this.excute(threadPool, queryParam3, this.loadReimburseService);
        BigDecimal generalBudget = null;
        BigDecimal settlementToParta = null;
        BigDecimal subcontractingCost = null;
        BigDecimal materialCost = null;
        BigDecimal mechanicsCost = null;
        BigDecimal indirectExpense = null;
        Map monthMap = new LinkedHashMap();
        try {
            CommonResponse commonResponse = this.costDetailApi.getCostTypeAndBudgetMny(projectId);
            if (commonResponse.isSuccess()) {
                Map costBudgetmap = (Map)commonResponse.getData();
                generalBudget = costBudgetmap.containsKey(6) ? (BigDecimal)costBudgetmap.get(6) : null;
                BigDecimal laborCostMny = costBudgetmap.containsKey(1) ? (BigDecimal)costBudgetmap.get(1) : BigDecimal.ZERO;
                BigDecimal majorCostMny = costBudgetmap.containsKey(3) ? (BigDecimal)costBudgetmap.get(3) : BigDecimal.ZERO;
                subcontractingCost = ComputeUtil.safeAdd((BigDecimal)laborCostMny, (BigDecimal)majorCostMny);
                materialCost = costBudgetmap.containsKey(2) ? (BigDecimal)costBudgetmap.get(2) : BigDecimal.ZERO;
                mechanicsCost = costBudgetmap.containsKey(4) ? (BigDecimal)costBudgetmap.get(4) : BigDecimal.ZERO;
                indirectExpense = costBudgetmap.containsKey(5) ? (BigDecimal)costBudgetmap.get(5) : BigDecimal.ZERO;
            }
            settlementToParta = ProjectBoardApi.getSumMny(future2.get(), "quoteTaxMny");
            CommonResponse costMonth = this.costDetailApi.getCostMonth(projectId);
            if (costMonth.isSuccess()) {
                monthMap = (Map)costMonth.getData();
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5f02\u5e38", (Throwable)e);
        }
        finally {
            threadPool.shutdown();
        }
        BigDecimal totalCost = MathUtil.safeAdd((BigDecimal)MathUtil.safeAdd((BigDecimal)MathUtil.safeAdd(subcontractingCost, materialCost), mechanicsCost), indirectExpense);
        JSONObject data = new JSONObject();
        JSONObject target = new JSONObject();
        target.put("generalBudget", (Object)MathUtil.roundTwoPre((BigDecimal)generalBudget));
        target.put("settlementToParta", (Object)MathUtil.roundTwoPre((BigDecimal)settlementToParta));
        target.put("totalCost", (Object)MathUtil.roundTwoPre((BigDecimal)totalCost));
        JSONObject firstProcess = new JSONObject();
        firstProcess.put("process", (Object)MathUtil.roundTwoPre((BigDecimal)MathUtil.safeDiv((BigDecimal)totalCost, (BigDecimal)settlementToParta)));
        firstProcess.put("settlementBenefit", (Object)MathUtil.roundTwoPre((BigDecimal)MathUtil.safeSub((BigDecimal)settlementToParta, (BigDecimal)totalCost)));
        target.put("firstProcess", (Object)firstProcess);
        JSONObject secondProcess = new JSONObject();
        secondProcess.put("process", (Object)MathUtil.roundTwoPre((BigDecimal)MathUtil.safeDiv((BigDecimal)totalCost, (BigDecimal)generalBudget)));
        secondProcess.put("managementBenefit", (Object)MathUtil.roundTwoPre((BigDecimal)MathUtil.safeSub((BigDecimal)generalBudget, (BigDecimal)totalCost)));
        target.put("secondProcess", (Object)secondProcess);
        JSONObject costAnalysis = new JSONObject();
        costAnalysis.put("subcontractingCost", (Object)MathUtil.roundTwoPre((BigDecimal)subcontractingCost));
        costAnalysis.put("materialCost", (Object)MathUtil.roundTwoPre((BigDecimal)materialCost));
        costAnalysis.put("mechanicsCost", (Object)MathUtil.roundTwoPre((BigDecimal)mechanicsCost));
        costAnalysis.put("indirectExpense", (Object)MathUtil.roundTwoPre((BigDecimal)indirectExpense));
        target.put("costAnalysis", (Object)costAnalysis);
        JSONObject monthlyCost = new JSONObject();
        LinkedList<String> labelList = new LinkedList<String>();
        for (Object key : monthMap.keySet()) {
            labelList.add((String)key);
        }
        Collections.sort(labelList);
        LinkedList<BigDecimal> incomeList = new LinkedList<BigDecimal>();
        for (String key : labelList) {
            BigDecimal mny = (BigDecimal)monthMap.get(key);
            incomeList.add(mny != null ? ProjectBoardApi.roundTwoPre(mny) : new BigDecimal("0.00"));
        }
        monthlyCost.put("label", labelList);
        monthlyCost.put("income", incomeList);
        target.put("monthlyCost", (Object)monthlyCost);
        data.put("target", (Object)target);
        long endTime = System.currentTimeMillis();
        logger.info("queryCostByProjectId ---- \u8fd0\u884c\u65f6\u95f4\uff1a" + (endTime - startTime) + "ms");
        return CommonResponse.success((Object)data);
    }

    private QueryParam getNewQueryParam(@RequestParam(value="projectId") Long projectId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        queryParam.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        queryParam.setPageIndex(0);
        queryParam.setPageSize(-1);
        return queryParam;
    }

    @GetMapping(value={"queryIncoemAndExpendByProjectId"})
    CommonResponse<JSONObject> queryIncoemAndExpendByProjectId(@RequestParam(value="projectId") Long projectId, HttpServletRequest request) {
        JSONObject obj;
        long startTime = System.currentTimeMillis();
        QueryParam queryParam = this.getNewQueryParam(projectId);
        QueryParam queryParam2 = (QueryParam)Utils.deepCopy((Object)queryParam);
        queryParam2.getOrderMap().put("createTime", "desc");
        CommonResponse incomeResp = this.incomeApi.getListByQueryParam(queryParam2);
        JSONArray jsonArray = new JSONArray();
        if (!incomeResp.isSuccess() || incomeResp.getData() == null) {
            logger.error("\u83b7\u53d6\u6536\u5165\u5408\u540c\u5217\u8868\u5931\u8d25\uff1a{}", (Object)incomeResp.getMsg());
        } else {
            jsonArray = ((JSONObject)incomeResp.getData()).getJSONArray("records");
        }
        List receiveList = this.receiveService.queryList(queryParam);
        JSONArray receiveArray = JSONArray.parseArray((String)JSON.toJSONString((Object)receiveList));
        CommonResponse openResp = this.invoiceApi.getOpenListByQueryParam(queryParam);
        JSONArray openArray = new JSONArray();
        if (!openResp.isSuccess() || openResp.getData() == null) {
            logger.error("\u83b7\u53d6\u5f00\u7968\u5217\u8868\u5931\u8d25\uff1a{}", (Object)openResp.getMsg());
        } else {
            openArray = ((JSONObject)openResp.getData()).getJSONArray("records");
        }
        QueryParam queryParam3 = (QueryParam)Utils.deepCopy((Object)queryParam);
        queryParam3.getParams().put("dependOnProject", new Parameter("eq", (Object)"1"));
        CommonResponse invoiceResp = this.invoiceApi.getReceiveListByQueryParam(queryParam3);
        JSONArray invoiceArray = new JSONArray();
        if (!invoiceResp.isSuccess() || invoiceResp.getData() == null) {
            logger.error("\u83b7\u53d6\u6536\u7968\u5217\u8868\u5931\u8d25\uff1a{}", (Object)invoiceResp.getMsg());
        } else {
            invoiceArray = ((JSONObject)invoiceResp.getData()).getJSONArray("records");
        }
        BigDecimal payMoney = this.getPayMny(projectId);
        BigDecimal receiveMoney = null;
        BigDecimal incomeContractTaxMny = null;
        BigDecimal incomeContractMny = null;
        BigDecimal incomeTaxRate = null;
        BigDecimal financeEngineReceiveMny = null;
        BigDecimal financeOtherReceiveMny = null;
        BigDecimal openInvoiceTaxMny = null;
        BigDecimal openInvoiceMny = null;
        BigDecimal openTaxMny = null;
        BigDecimal receiveSpecialInvoiceTaxMny = null;
        BigDecimal receiveSpecialInvoiceMny = null;
        BigDecimal receiveSpecialTaxMny = null;
        BigDecimal receiveGeneralInvoiceTaxMny = null;
        BigDecimal receiveGeneralInvoiceMny = null;
        BigDecimal receiveGeneralTaxMny = null;
        incomeContractTaxMny = ProjectBoardApi.getSumMny(jsonArray, "contractTaxMny");
        incomeContractMny = ProjectBoardApi.getSumMny(jsonArray, "contractMny");
        if (CollectionUtils.isNotEmpty((Collection)jsonArray)) {
            JSONObject obj2 = jsonArray.getJSONObject(0);
            incomeTaxRate = obj2.getBigDecimal("taxRate");
        }
        receiveMoney = ProjectBoardApi.getSumMny(receiveArray, "receiveMny");
        if (CollectionUtils.isNotEmpty((Collection)receiveArray)) {
            for (int i = 0; i < receiveArray.size(); ++i) {
                obj = receiveArray.getJSONObject(i);
                if (Long.valueOf("1275321308270993409").equals(obj.getLong("receiveType"))) {
                    financeEngineReceiveMny = MathUtil.safeAdd(financeEngineReceiveMny, (BigDecimal)obj.getBigDecimal("receiveMny"));
                }
                if (!Long.valueOf("1275321354706132993").equals(obj.getLong("receiveType"))) continue;
                financeOtherReceiveMny = MathUtil.safeAdd(financeOtherReceiveMny, (BigDecimal)obj.getBigDecimal("receiveMny"));
            }
        }
        openInvoiceTaxMny = ProjectBoardApi.getSumMny(openArray, "invoiceTaxMny");
        openInvoiceMny = ProjectBoardApi.getSumMny(openArray, "invoiceMny");
        openTaxMny = ProjectBoardApi.getSumMny(openArray, "taxMny");
        if (CollectionUtils.isNotEmpty((Collection)invoiceArray)) {
            for (int i = 0; i < invoiceArray.size(); ++i) {
                obj = invoiceArray.getJSONObject(i);
                if (Long.valueOf("1277537516768632833").equals(obj.getLong("invoiceType"))) {
                    receiveSpecialInvoiceTaxMny = MathUtil.safeAdd(receiveSpecialInvoiceTaxMny, (BigDecimal)obj.getBigDecimal("invoiceTaxMny"));
                    receiveSpecialInvoiceMny = MathUtil.safeAdd(receiveSpecialInvoiceMny, (BigDecimal)obj.getBigDecimal("invoiceMny"));
                    receiveSpecialTaxMny = MathUtil.safeAdd(receiveSpecialTaxMny, (BigDecimal)obj.getBigDecimal("taxMny"));
                }
                if (!Long.valueOf("1277537563879055362").equals(obj.getLong("invoiceType"))) continue;
                receiveGeneralInvoiceTaxMny = MathUtil.safeAdd(receiveGeneralInvoiceTaxMny, (BigDecimal)obj.getBigDecimal("invoiceTaxMny"));
                receiveGeneralInvoiceMny = MathUtil.safeAdd(receiveGeneralInvoiceMny, (BigDecimal)obj.getBigDecimal("invoiceMny"));
                receiveGeneralTaxMny = MathUtil.safeAdd(receiveGeneralTaxMny, (BigDecimal)obj.getBigDecimal("taxMny"));
            }
        }
        JSONObject resp = new JSONObject();
        resp.put("receiveMoney", (Object)receiveMoney);
        resp.put("payMoney", (Object)payMoney);
        resp.put("incomeContractTaxMny", (Object)incomeContractTaxMny);
        resp.put("incomeContractMny", (Object)incomeContractMny);
        resp.put("incomeTaxRate", (Object)incomeTaxRate);
        resp.put("financeEngineReceiveMny", (Object)financeEngineReceiveMny);
        resp.put("financeOtherReceiveMny", (Object)financeOtherReceiveMny);
        resp.put("openInvoiceTaxMny", (Object)openInvoiceTaxMny);
        resp.put("openInvoiceMny", (Object)openInvoiceMny);
        resp.put("openTaxMny", (Object)openTaxMny);
        resp.put("receiveSpecialInvoiceTaxMny", (Object)receiveSpecialInvoiceTaxMny);
        resp.put("receiveSpecialInvoiceMny", (Object)receiveSpecialInvoiceMny);
        resp.put("receiveSpecialTaxMny", (Object)receiveSpecialTaxMny);
        resp.put("receiveGeneralInvoiceTaxMny", (Object)receiveGeneralInvoiceTaxMny);
        resp.put("receiveGeneralInvoiceMny", (Object)receiveGeneralInvoiceMny);
        resp.put("receiveGeneralTaxMny", (Object)receiveGeneralTaxMny);
        long endTime = System.currentTimeMillis();
        logger.info("queryIncoemAndExpendByProjectId ---- \u8fd0\u884c\u65f6\u95f4\uff1a" + (endTime - startTime) + "ms");
        return CommonResponse.success((Object)resp);
    }

    @PostMapping(value={"getProjectLedgerVO"})
    public CommonResponse<ProjectLedgerVO> getProjectLedgerVO(@RequestBody QueryParam param) throws ExecutionException, InterruptedException {
        ProjectLedgerVO projectLedgerVO = new ProjectLedgerVO();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(0);
        param.setPageSize(-1);
        Parameter startDay = (Parameter)param.getParams().get("startDay");
        Parameter endDay = (Parameter)param.getParams().get("endDay");
        String filterDate = ((Parameter)param.getParams().get("filterDate")).getValue().toString();
        param.getParams().remove("startDay");
        param.getParams().remove("endDay");
        param.getParams().remove("filterDate");
        Parameter dateParameter = null;
        if (startDay != null && endDay != null) {
            dateParameter = new Parameter("between", (Object)(startDay.getValue() + "," + endDay.getValue()));
        } else if (startDay != null) {
            dateParameter = new Parameter("ge", startDay.getValue());
        } else if (endDay != null) {
            dateParameter = new Parameter("ge", endDay.getValue());
        }
        List expenditureList = this.queryExpenditureList(param, filterDate, dateParameter).stream().filter(vo -> vo.getApplyTime() != null).collect(Collectors.toList());
        BigDecimal sumPayMny = expenditureList.stream().filter(vo -> vo.getThisPayMny() != null).map(ExpenditureVO::getThisPayMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        List<IncomeVO> incomeList = this.queryIncomeList(param, dateParameter);
        BigDecimal sumReceiveMny = incomeList.stream().filter(vo -> vo.getReceiveMny() != null).map(IncomeVO::getReceiveMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal bookFunds = sumReceiveMny.subtract(sumPayMny);
        Map<Object, Object> defDocMap = new HashMap();
        CommonResponse defDocByDefCode = this.defdocApi.getDefDocByDefCode(FEE_TYPE_DEFDOC_CODE);
        if (defDocByDefCode.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)defDocByDefCode.getData()))) {
            List data = (List)defDocByDefCode.getData();
            defDocMap = data.stream().collect(Collectors.toMap(BaseVO::getId, DefdocDetailVO::getName, (key1, key2) -> key2));
        }
        if (CollectionUtils.isNotEmpty(expenditureList)) {
            for (ExpenditureVO vo2 : expenditureList) {
                if (StringUtils.isNotEmpty((String)vo2.getApplyType())) {
                    if ("\u5408\u540c\u4ed8\u6b3e".equals(vo2.getApplyType())) {
                        vo2.setApplyTypeFilter(Integer.valueOf(1));
                    } else if ("\u62a5\u9500".equals(vo2.getApplyType())) {
                        vo2.setApplyTypeFilter(Integer.valueOf(2));
                    } else if ("\u96f6\u661f\u91c7\u8d2d".equals(vo2.getApplyType())) {
                        vo2.setApplyTypeFilter(Integer.valueOf(4));
                    }
                }
                if (vo2.getFeeType() == null) continue;
                if (1L == vo2.getFeeType()) {
                    vo2.setApplyType(vo2.getApplyType() + "-\u9884\u4ed8\u6b3e");
                    continue;
                }
                if (2L == vo2.getFeeType()) {
                    vo2.setApplyType(vo2.getApplyType() + "-\u8fc7\u7a0b\u6b3e");
                    continue;
                }
                if (3L == vo2.getFeeType()) {
                    vo2.setApplyType(vo2.getApplyType() + "-\u5176\u4ed6");
                    continue;
                }
                String name = (String)defDocMap.get(vo2.getFeeType());
                vo2.setApplyType("\u62a5\u9500-" + name);
            }
        }
        String projectId1 = ((Parameter)param.getParams().get("projectId")).getValue().toString();
        Long projectId = Long.valueOf(projectId1);
        ProjectFinancePayVO projectApplyPayInfo = this.contractService.getProjectApplyPayInfo(projectId);
        BigDecimal sumEffectiveApplyMny = BigDecimal.ZERO;
        BigDecimal sumFreeApplyMny = BigDecimal.ZERO;
        if (projectApplyPayInfo != null) {
            sumEffectiveApplyMny = projectApplyPayInfo.getSumEffectiveApplyMny();
            sumFreeApplyMny = ComputeUtil.safeSub((BigDecimal)projectApplyPayInfo.getSumApplyMny(), (BigDecimal)projectApplyPayInfo.getSumEffectiveApplyMny());
        }
        projectLedgerVO.setSumEffectiveApplyMny(sumEffectiveApplyMny);
        projectLedgerVO.setSumFreeApplyMny(sumFreeApplyMny);
        OperationCostVO operationCostVO = new OperationCostVO();
        operationCostVO.setProjectId(projectId);
        CommonResponse operationListRes = this.projectDutyLetterApi.getOperationList(operationCostVO);
        BigDecimal operationCostMny = BigDecimal.ZERO;
        BigDecimal xiangMuDianZiJieYuMny = BigDecimal.ZERO;
        List operationList = new ArrayList();
        if (operationListRes.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)operationListRes.getData()))) {
            operationList = (List)operationListRes.getData();
            operationCostMny = operationList.stream().map(aa -> aa.getCostMny()).reduce(BigDecimal.ZERO, ComputeUtil::safeAdd);
            xiangMuDianZiJieYuMny = operationList.stream().filter(t -> "\u9879\u76ee\u4ee3\u8f6c\u6b3e".equals(t.getBillName())).map(aa -> aa.getCostMny()).reduce(BigDecimal.ZERO, ComputeUtil::safeAdd);
        }
        projectLedgerVO.setOperationList(operationList);
        projectLedgerVO.setOperationCostMny(operationCostMny);
        projectLedgerVO.setXiangMuDianZiJieYuMny(xiangMuDianZiJieYuMny);
        projectLedgerVO.setProjectId(projectId);
        projectLedgerVO.setSumReceiveMny(sumReceiveMny);
        projectLedgerVO.setSumPayMny(sumPayMny);
        projectLedgerVO.setBookFunds(bookFunds);
        projectLedgerVO.setExpenditureList(expenditureList);
        projectLedgerVO.setIncomeList(incomeList);
        if (CollectionUtils.isNotEmpty(expenditureList) && CollectionUtils.isNotEmpty(incomeList)) {
            projectLedgerVO.setProjectName(((ExpenditureVO)expenditureList.get(0)).getProjectName());
        } else if (CollectionUtils.isNotEmpty(expenditureList)) {
            projectLedgerVO.setProjectName(((ExpenditureVO)expenditureList.get(0)).getProjectName());
        } else if (CollectionUtils.isNotEmpty(incomeList)) {
            projectLedgerVO.setProjectName(incomeList.get(0).getProjectName());
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)projectLedgerVO);
    }

    private List<ExpenditureVO> queryExpenditureList(QueryParam param, String filterDate, Parameter dateParameter) {
        QueryParam queryParam = (QueryParam)Utils.deepCopy((Object)param);
        queryParam.getParams().remove("incomeContractName");
        queryParam.getParams().remove("receiveTypeName");
        queryParam.getParams().remove("employeeName");
        String paramDate = null;
        if (StringUtils.equals((String)"1", (String)filterDate)) {
            paramDate = "confirmTime";
            queryParam.getOrderMap().put("confirmTime", "desc");
        } else {
            paramDate = "applyTime";
            queryParam.getOrderMap().put("applyTime", "desc");
        }
        if (dateParameter != null) {
            queryParam.getParams().put(paramDate, dateParameter);
        }
        List recordEntityList = this.payRecordService.queryList(queryParam);
        QueryParam expenditureQueryParam = new QueryParam();
        List expenditureVOS = new ArrayList();
        if (CollectionUtil.isNotEmpty((Collection)recordEntityList)) {
            recordEntityList = recordEntityList.stream().filter(list -> !list.getApplyType().equals("\u62bc\u91d1")).collect(Collectors.toList());
            expenditureVOS = BeanMapper.mapList(recordEntityList, ExpenditureVO.class);
            for (ExpenditureVO vo : expenditureVOS) {
                expenditureQueryParam.getParams().remove("payapplyId");
                expenditureQueryParam.getParams().put("payapplyId", new Parameter("eq", (Object)vo.getPayapplyId()));
                List payInvoiceEntities = this.payInvoiceService.queryList(expenditureQueryParam);
                vo.setExpenditureTaxMny(payInvoiceEntities.stream().filter(v -> v.getTaxMny() != null).map(PayInvoiceEntity::getTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add));
                vo.setExpenditureInvoiceTaxMny(payInvoiceEntities.stream().filter(v -> v.getInvoiceTaxMny() != null).map(PayInvoiceEntity::getInvoiceTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add));
                vo.setExpenditureZhuanTaxMny(payInvoiceEntities.stream().filter(v -> v.getTaxMny() != null && v.getInvoiceType() != null && Long.valueOf("1277537516768632833").equals(v.getInvoiceType())).map(PayInvoiceEntity::getTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add));
            }
        }
        queryParam.getOrderMap().remove("confirmTime");
        if (queryParam.getParams().get("confirmTime") != null) {
            Parameter parameter = (Parameter)queryParam.getParams().get("confirmTime");
            queryParam.getParams().remove("confirmTime");
            queryParam.getParams().put("applyTime", parameter);
        }
        QueryParam queryParam2 = (QueryParam)Utils.deepCopy((Object)queryParam);
        queryParam2.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        queryParam2.getParams().put("dependOnProject", new Parameter("eq", (Object)"1"));
        Map<Object, Object> defDocMap = new HashMap();
        CommonResponse defDocByDefCode = this.defdocApi.getDefDocByDefCode(COST_TYPE_DEFDOC_CODE);
        if (defDocByDefCode.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)defDocByDefCode.getData()))) {
            List data = (List)defDocByDefCode.getData();
            defDocMap = data.stream().collect(Collectors.toMap(BaseVO::getId, DefdocDetailVO::getName, (key1, key2) -> key2));
        }
        List reimburseEntityList = this.loadReimburseService.queryList(queryParam2);
        List reimburseVOList = BeanMapper.mapList((Iterable)reimburseEntityList, ExpenditureVO.class);
        CommonResponse taxReceive = this.invoiceApi.getTaxReceive(Long.valueOf(((Parameter)param.getParams().get("projectId")).getValue().toString()));
        Map<Object, Object> invoiceTypeMap = new HashMap();
        if (taxReceive.isSuccess()) {
            invoiceTypeMap = ((List)taxReceive.getData()).stream().collect(Collectors.toMap(BaseVO::getId, InvoiceReceiveVO::getInvoiceType));
        }
        for (LoadReimburseEntity entity : reimburseEntityList) {
            for (Object vo : reimburseVOList) {
                if (!entity.getBillCode().equals(vo.getBillCode())) continue;
                String s = (String)defDocMap.get(entity.getCostType());
                vo.setApplyType("\u501f\u6b3e\u62a5\u9500-" + s);
                vo.setApplyTypeFilter(Integer.valueOf(3));
                vo.setThisPayMny(entity.getReimburseMny());
                vo.setApplyUserName(entity.getApplyEmployeeName());
                vo.setExplanation(entity.getMemo());
                vo.setConfirmTime(entity.getApplyTime());
                List<LoadInvoiceEntity> invoiceVOList = entity.getInvoiceVOList();
                BigDecimal expenditureTaxMny = new BigDecimal(0);
                BigDecimal expenditureInvoiceTaxMny = new BigDecimal(0);
                BigDecimal expenditureZhuanTaxMny = new BigDecimal(0);
                for (LoadInvoiceEntity loadInvoiceEntity : invoiceVOList) {
                    expenditureTaxMny = ComputeUtil.safeAdd((BigDecimal)loadInvoiceEntity.getTaxMny(), (BigDecimal)expenditureTaxMny);
                    expenditureInvoiceTaxMny = ComputeUtil.safeAdd((BigDecimal)loadInvoiceEntity.getInvoiceTaxMny(), (BigDecimal)expenditureInvoiceTaxMny);
                    if (!((Long)invoiceTypeMap.get(loadInvoiceEntity.getInvoiceId())).equals(Long.valueOf("1277537516768632833"))) continue;
                    expenditureZhuanTaxMny = ComputeUtil.safeAdd((BigDecimal)loadInvoiceEntity.getTaxMny(), (BigDecimal)expenditureZhuanTaxMny);
                }
                vo.setExpenditureTaxMny(expenditureTaxMny);
                vo.setExpenditureInvoiceTaxMny(expenditureInvoiceTaxMny);
                vo.setExpenditureZhuanTaxMny(expenditureZhuanTaxMny);
            }
        }
        QueryParam queryParam3 = (QueryParam)Utils.deepCopy((Object)queryParam);
        queryParam3.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        queryParam3.getParams().put("isShareFlag", new Parameter("eq", (Object)"1"));
        List payReimburseEntities = this.reimburseService.queryList(queryParam3);
        List payReimburseVOList = BeanMapper.mapList((Iterable)payReimburseEntities, ExpenditureVO.class);
        for (PayReimburseEntity entity : payReimburseEntities) {
            for (ExpenditureVO vo : payReimburseVOList) {
                if (!entity.getBillCode().equals(vo.getBillCode())) continue;
                vo.setApplyType("\u62a5\u9500");
                vo.setApplyTypeFilter(Integer.valueOf(2));
                vo.setThisPayMny(entity.getPayMny());
                vo.setApplyUserName(entity.getApplyUserName());
                vo.setPayapplyId(entity.getId());
                vo.setExplanation(entity.getMemo());
                vo.setConfirmTime(entity.getApplyTime());
                BigDecimal expenditureTaxMny = new BigDecimal(0);
                BigDecimal expenditureInvoiceTaxMny = new BigDecimal(0);
                BigDecimal expenditureZhuanTaxMny = new BigDecimal(0);
                vo.setExpenditureTaxMny(expenditureTaxMny);
                vo.setExpenditureInvoiceTaxMny(expenditureInvoiceTaxMny);
                vo.setExpenditureZhuanTaxMny(expenditureZhuanTaxMny);
            }
        }
        ArrayList<ExpenditureVO> resultList = new ArrayList<ExpenditureVO>();
        resultList.addAll(expenditureVOS);
        resultList.addAll(reimburseVOList);
        resultList.addAll(payReimburseVOList);
        return resultList;
    }

    private List<IncomeVO> queryIncomeList(QueryParam param, Parameter dateParameter) {
        QueryParam queryParam = (QueryParam)Utils.deepCopy((Object)param);
        queryParam.getParams().remove("contractName");
        queryParam.getParams().remove("applyType");
        queryParam.getParams().remove("applyUserName");
        queryParam.getOrderMap().put("confirmTime", "desc");
        Parameter parameter = (Parameter)param.getParams().get("incomeContractName");
        if (parameter != null) {
            queryParam.getParams().put("contractName", parameter);
        }
        if (dateParameter != null) {
            queryParam.getParams().put("confirmTime", dateParameter);
        }
        List receiveEntityList = this.receiveService.queryList(queryParam, false);
        List voList = BeanMapper.mapList((Iterable)receiveEntityList, IncomeVO.class);
        QueryParam inVoiceParam = new QueryParam();
        voList.forEach(vo -> {
            receiveEntityList.forEach(entity -> {
                if (vo.getId().equals(entity.getId())) {
                    vo.setIncomeContractName(entity.getContractName());
                }
            });
            vo.setReceiveTypeName("\u6536\u6b3e\u767b\u8bb0");
            inVoiceParam.getParams().remove("receiveId");
            inVoiceParam.getParams().put("receiveId", new Parameter("eq", (Object)vo.getId()));
            List receiveInvoiceEntities = this.receiveInvoiceService.queryList(inVoiceParam);
            vo.setInComeTaxMny(receiveInvoiceEntities.stream().filter(v -> v.getTaxMny() != null).map(ReceiveInvoiceEntity::getTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add));
            vo.setInComeInvoiceTaxMny(receiveInvoiceEntities.stream().filter(v -> v.getInvoiceTaxMny() != null).map(ReceiveInvoiceEntity::getInvoiceTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add));
        });
        return voList;
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) throws ExecutionException, InterruptedException {
        CommonResponse<ProjectLedgerVO> commonResponse = this.getProjectLedgerVO(param);
        if (commonResponse.isSuccess() && commonResponse.getData() != null) {
            HashMap<String, List> beans = new HashMap<String, List>();
            ProjectLedgerVO data = (ProjectLedgerVO)commonResponse.getData();
            List expenditureList = data.getExpenditureList();
            List incomeList = data.getIncomeList();
            beans.put("expend", expenditureList);
            beans.put("income", incomeList);
            beans.put("operationList", data.getOperationList());
            ExcelExport.getInstance().export("expend-income-export.xlsx", beans, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BigDecimal getPayMny(Long projectId) {
        QueryParam queryParam = this.getNewQueryParam(projectId);
        queryParam.getParams().put("dependOnProject", new Parameter("eq", (Object)"1"));
        queryParam.getParams().put("payStatus", new Parameter("eq", (Object)"2"));
        QueryParam loadReimburseQueryParam = this.getNewQueryParam(projectId);
        loadReimburseQueryParam.getParams().put("dependOnProject", new Parameter("eq", (Object)"1"));
        ExecutorService threadPool = Executors.newFixedThreadPool(4);
        Future<JSONObject> future1 = this.excute(threadPool, queryParam, this.contractService);
        Future<JSONObject> future2 = this.excute(threadPool, queryParam, this.sporadicService);
        Future<JSONObject> future3 = this.excute(threadPool, queryParam, this.reimburseService);
        Future<JSONObject> future4 = this.excute(threadPool, loadReimburseQueryParam, this.loadReimburseService);
        BigDecimal payMoney = null;
        try {
            JSONObject c1 = future1.get();
            BigDecimal payContMny = ProjectBoardApi.getSumMny(c1, "payMny");
            JSONObject c2 = future2.get();
            BigDecimal sporadicMny = ProjectBoardApi.getSumMny(c2, "payMny");
            JSONObject c3 = future3.get();
            BigDecimal reimburseMny = ProjectBoardApi.getSumMny(c3, "payMny");
            JSONObject c4 = future4.get();
            BigDecimal loadReimburseMny = ProjectBoardApi.getSumMny(c4, "reimburseMny");
            payMoney = MathUtil.safeAdd((BigDecimal)MathUtil.safeAdd((BigDecimal)MathUtil.safeAdd((BigDecimal)payContMny, (BigDecimal)sporadicMny), (BigDecimal)reimburseMny), (BigDecimal)loadReimburseMny);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6570\u636e\u5f02\u5e38", (Throwable)e);
        }
        finally {
            threadPool.shutdown();
        }
        return payMoney;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONObject getPaymentBalance(Long projectId, String authority) {
        ExecutorService threadPool = Executors.newFixedThreadPool(3);
        QueryParam queryParam = this.getNewQueryParam(projectId);
        Future<JSONObject> future1 = this.excute(threadPool, queryParam, this.receiveService);
        Future<JSONObject> future2 = this.excute(threadPool, authority, "ejc-tax-web/invoiceOpen/pageList", queryParam);
        QueryParam queryParam2 = this.getNewQueryParam(projectId);
        queryParam2.getParams().put("dependOnProject", new Parameter("eq", (Object)"1"));
        Future<JSONObject> future3 = this.excute(threadPool, authority, "ejc-tax-web/invoiceReceive/pageList", queryParam2);
        BigDecimal salesInvoice = null;
        BigDecimal inputInvoice = null;
        BigDecimal receiveMoney = null;
        BigDecimal payMoney = this.getPayMny(projectId);
        BigDecimal balanceMny = null;
        try {
            receiveMoney = ProjectBoardApi.getSumMny(future1.get(), "receiveMny");
            balanceMny = MathUtil.safeSub((BigDecimal)receiveMoney, (BigDecimal)payMoney);
            salesInvoice = ProjectBoardApi.getSumMny(future2.get(), "invoiceTaxMny");
            inputInvoice = ProjectBoardApi.getSumMny(future3.get(), "invoiceTaxMny");
            logger.info("-----------\u9879\u76ee\u770b\u677f--\u8d44\u91d1\u7a0e\u52a1\u5206\u6790\u3010 \u6536\u6b3e\uff1a{}, \u4ed8\u6b3e\uff1a{}, \u5f00\u7968\uff1a{}, \u6536\u7968\uff1a{} \u3011----------------", new Object[]{receiveMoney, payMoney, salesInvoice, inputInvoice});
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6570\u636e\u5f02\u5e38", (Throwable)e);
        }
        finally {
            threadPool.shutdown();
        }
        JSONObject paymentBalance = new JSONObject();
        paymentBalance.put("paymentBalance", (Object)ProjectBoardApi.roundTwoPre(balanceMny));
        paymentBalance.put("projectCollection", (Object)ProjectBoardApi.roundTwoPre(receiveMoney));
        paymentBalance.put("projectExpenditure", (Object)ProjectBoardApi.roundTwoPre(payMoney));
        paymentBalance.put("salesInvoice", (Object)ProjectBoardApi.roundTwoPre(salesInvoice));
        paymentBalance.put("inputInvoice", (Object)ProjectBoardApi.roundTwoPre(inputInvoice));
        return paymentBalance;
    }

    private JSONObject getLatestCollection(Long projectId) {
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(ReceiveEntity::getProjectId, (Object)projectId);
        lambda.in(ReceiveEntity::getBillState, new Object[]{1, 3});
        lambda.orderByDesc(BaseEntity::getCreateTime);
        List list = this.receiveService.list((Wrapper)lambda);
        String collectionDate = null;
        String collectionType = null;
        BigDecimal money = null;
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            ReceiveEntity entity = (ReceiveEntity)((Object)list.get(0));
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            collectionDate = sdf.format(entity.getConfirmTime());
            CommonResponse defResp = this.defdocApi.getDefDocByDefId(Long.valueOf(330358772148207658L));
            if (!defResp.isSuccess()) {
                logger.error("\u83b7\u53d6\u81ea\u5b9a\u4e49\u6863\u6848\u5217\u8868\u5931\u8d25\uff1a{}", (Object)defResp.getMsg());
            }
            for (DefdocDetailVO vo : (List)defResp.getData()) {
                if (!vo.getId().equals(entity.getReceiveType())) continue;
                collectionType = vo.getName();
            }
            money = entity.getReceiveMny();
        }
        JSONObject latestCollection = new JSONObject();
        latestCollection.put("collectionDate", collectionDate);
        latestCollection.put("collectionType", collectionType);
        latestCollection.put("money", (Object)MathUtil.roundTwoPre(money));
        return latestCollection;
    }

    public JSONObject getMonthlyIncomeAndExpenditure(Long projectId) {
        QueryParam queryParam = this.getNewQueryParam(projectId);
        List receiveEntities = this.receiveService.queryList(queryParam, false);
        queryParam.getParams().put("dependOnProject", new Parameter("eq", (Object)"1"));
        queryParam.getParams().put("payStatus", new Parameter("eq", (Object)"2"));
        List contractEntities = this.contractService.queryList(queryParam, false);
        List paySporadicEntities = this.sporadicService.queryList(queryParam, false);
        List reimburseEntities = this.reimburseService.queryList(queryParam, false);
        queryParam.getParams().remove("payStatus");
        List loadReimburseEntities = this.loadReimburseService.queryList(queryParam, false);
        LinkedHashMap<String, Map<String, BigDecimal>> monthMap = new LinkedHashMap<String, Map<String, BigDecimal>>();
        if (ListUtil.isNotEmpty((List)receiveEntities)) {
            for (Object entity : receiveEntities) {
                this.calculateSumMny(monthMap, ((ReceiveEntity)((Object)entity)).getConfirmTime(), "income", ((ReceiveEntity)((Object)entity)).getReceiveMny());
            }
        }
        if (ListUtil.isNotEmpty((List)contractEntities)) {
            Iterator mnyMap = new HashMap();
            for (Object entity : contractEntities) {
                this.calculateSumMny(monthMap, ((PayContractEntity)((Object)entity)).getConfirmTime(), "expenditure", ((PayContractEntity)((Object)entity)).getPayMny());
            }
        }
        if (ListUtil.isNotEmpty((List)paySporadicEntities)) {
            for (Object entity : paySporadicEntities) {
                this.calculateSumMny(monthMap, ((PaySporadicEntity)((Object)entity)).getConfirmTime(), "expenditure", ((PaySporadicEntity)((Object)entity)).getPayMny());
            }
        }
        if (ListUtil.isNotEmpty((List)reimburseEntities)) {
            for (Object entity : reimburseEntities) {
                this.calculateSumMny(monthMap, ((PayReimburseEntity)((Object)entity)).getConfirmTime(), "expenditure", ((PayReimburseEntity)((Object)entity)).getPayMny());
            }
        }
        if (ListUtil.isNotEmpty((List)loadReimburseEntities)) {
            for (Object entity : loadReimburseEntities) {
                this.calculateSumMny(monthMap, ((LoadReimburseEntity)((Object)entity)).getApplyTime(), "expenditure", ((LoadReimburseEntity)((Object)entity)).getReimburseMny());
            }
        }
        JSONObject back = new JSONObject();
        LinkedList<String> labelList = new LinkedList<String>();
        for (String key : monthMap.keySet()) {
            labelList.add(key);
        }
        Collections.sort(labelList, new Comparator<String>(){

            @Override
            public int compare(String u1, String u2) {
                int diff = Integer.valueOf(u1.substring(0, u1.length() - 1)) - Integer.valueOf(u2.substring(0, u2.length() - 1));
                if (diff > 0) {
                    return 1;
                }
                if (diff < 0) {
                    return -1;
                }
                return 0;
            }
        });
        LinkedList<BigDecimal> incomeList = new LinkedList<BigDecimal>();
        LinkedList<BigDecimal> expenditureList = new LinkedList<BigDecimal>();
        for (String key : labelList) {
            Map map = (Map)monthMap.get(key);
            incomeList.add(map.get("income") != null ? ProjectBoardApi.roundTwoPre((BigDecimal)map.get("income")) : new BigDecimal("0.00"));
            expenditureList.add(map.get("expenditure") != null ? ProjectBoardApi.roundTwoPre((BigDecimal)map.get("expenditure")) : new BigDecimal("0.00"));
        }
        back.put("label", labelList);
        back.put("income", incomeList);
        back.put("expenditure", expenditureList);
        return back;
    }

    public JSONObject getDepositLoanMargin(Long projectId) {
        List foregiftRecordEntities;
        QueryParam queryParam = this.getNewQueryParam(projectId);
        List foregiftEntities = this.foregiftService.queryList(queryParam, false);
        BigDecimal sumPayMny = null;
        if (CollectionUtils.isNotEmpty((Collection)foregiftEntities)) {
            for (PayForegiftEntity vo : foregiftEntities) {
                sumPayMny = MathUtil.safeAdd(sumPayMny, (BigDecimal)vo.getPayMny());
            }
        }
        List foregiftIds = foregiftEntities.stream().map(BaseEntity::getId).collect(Collectors.toList());
        BigDecimal sumReturnMny = null;
        if (CollectionUtils.isNotEmpty(foregiftIds) && CollectionUtils.isNotEmpty((Collection)(foregiftRecordEntities = this.foregiftRecordService.list((Wrapper)new QueryWrapper().in((Object)"payapply_id", foregiftIds))))) {
            for (PayForegiftRecordEntity vo : foregiftRecordEntities) {
                sumReturnMny = MathUtil.safeAdd(sumReturnMny, (BigDecimal)vo.getReturnMny());
            }
        }
        BigDecimal uncollectedDeposit = MathUtil.safeSub((BigDecimal)sumPayMny, sumReturnMny);
        List loadApplyEntities = this.loadApplyService.queryList(queryParam, false);
        BigDecimal sumApplyMny = null;
        if (CollectionUtils.isNotEmpty((Collection)loadApplyEntities)) {
            for (LoadApplyEntity vo : loadApplyEntities) {
                sumApplyMny = MathUtil.safeAdd(sumApplyMny, (BigDecimal)vo.getApplyMny());
            }
        }
        List loadReimburseEntities = this.loadReimburseService.queryList(queryParam, false);
        BigDecimal sumReimburseMny = null;
        if (CollectionUtils.isNotEmpty((Collection)loadReimburseEntities)) {
            for (LoadReimburseEntity vo : loadReimburseEntities) {
                sumReimburseMny = MathUtil.safeAdd(sumReimburseMny, (BigDecimal)vo.getReimburseMny());
            }
        }
        List loadBackEntities = this.loadBackService.queryList(queryParam, false);
        BigDecimal sumBackMny = null;
        if (CollectionUtils.isNotEmpty((Collection)loadBackEntities)) {
            for (LoadBackEntity vo : loadBackEntities) {
                sumBackMny = MathUtil.safeAdd(sumBackMny, (BigDecimal)vo.getBackMny());
            }
        }
        BigDecimal uncollectedLoan = MathUtil.safeSub((BigDecimal)MathUtil.safeSub((BigDecimal)sumApplyMny, sumReimburseMny), sumBackMny);
        List bondDownEntities = this.bondDownService.queryList(queryParam, false);
        BigDecimal depositReturned = null;
        if (CollectionUtils.isNotEmpty((Collection)bondDownEntities)) {
            for (BondDownEntity vo : bondDownEntities) {
                depositReturned = MathUtil.safeAdd(depositReturned, (BigDecimal)MathUtil.safeSub((BigDecimal)vo.getPayMny(), (BigDecimal)vo.getBackMny()));
            }
        }
        List bondUpEntities = this.bondUpService.queryList(queryParam, false);
        BigDecimal uncollectedMargin = null;
        if (CollectionUtils.isNotEmpty((Collection)bondUpEntities)) {
            for (BondUpEntity vo : bondUpEntities) {
                uncollectedMargin = MathUtil.safeAdd(uncollectedMargin, (BigDecimal)MathUtil.safeSub((BigDecimal)vo.getPayMny(), (BigDecimal)vo.getBackMny()));
            }
        }
        JSONObject back = new JSONObject();
        back.put("uncollectedDeposit", (Object)ProjectBoardApi.roundTwoPre(uncollectedDeposit));
        back.put("uncollectedLoan", (Object)ProjectBoardApi.roundTwoPre(uncollectedLoan));
        back.put("depositReturned", (Object)ProjectBoardApi.roundTwoPre(depositReturned));
        back.put("uncollectedMargin", (Object)ProjectBoardApi.roundTwoPre(uncollectedMargin));
        return back;
    }

    public JSONObject getUnderInvoice(Long projectId) {
        QueryParam queryParam = this.getNewQueryParam(projectId);
        queryParam.getParams().put("dependOnProject", new Parameter("eq", (Object)"1"));
        queryParam.getParams().put("contractId", new Parameter("ne", null));
        CommonResponse resp = this.invoiceApi.getReceiveListByQueryParam(queryParam);
        JSONArray jsonArray = new JSONArray();
        if (!resp.isSuccess() || resp.getData() == null) {
            logger.error("\u83b7\u53d6\u5217\u8868\u5931\u8d25\uff1a{}", (Object)resp.getMsg());
        } else {
            jsonArray = ((JSONObject)resp.getData()).getJSONArray("records");
        }
        HashMap<Long, JSONObject> map = new HashMap<Long, JSONObject>();
        if (CollectionUtils.isNotEmpty((Collection)jsonArray)) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject vo = jsonArray.getJSONObject(i);
                BigDecimal invoiceTaxMny = vo.getBigDecimal("invoiceTaxMny");
                this.calculateSumMnyBySupplierId(map, vo.getLong("supplierId"), invoiceTaxMny, vo.getString("supplierName"), false);
            }
        }
        queryParam.getParams().put("payStatus", new Parameter("eq", (Object)"2"));
        List contractEntities = this.contractService.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)contractEntities)) {
            for (PayContractEntity vo : contractEntities) {
                this.calculateSumMnyBySupplierId(map, vo.getReceiveUnitId(), vo.getPayMny(), vo.getReceiveUnitName(), true);
            }
        }
        Iterator it = map.entrySet().iterator();
        BigDecimal accumulatedUnderInvoice = null;
        while (it.hasNext()) {
            BigDecimal amountOwed = ((JSONObject)it.next().getValue()).getBigDecimal("amountOwed");
            BigDecimal bigDecimal = amountOwed = amountOwed != null ? amountOwed : BigDecimal.ZERO;
            if (amountOwed.compareTo(BigDecimal.ZERO) <= 0) {
                it.remove();
                continue;
            }
            accumulatedUnderInvoice = MathUtil.safeAdd(accumulatedUnderInvoice, (BigDecimal)amountOwed);
        }
        ArrayList<JSONObject> dataList = new ArrayList<JSONObject>();
        for (Long key : map.keySet()) {
            JSONObject value = (JSONObject)map.get(key);
            BigDecimal amountOwed = value.getBigDecimal("amountOwed") != null ? value.getBigDecimal("amountOwed") : BigDecimal.ZERO;
            BigDecimal proportion = MathUtil.safeDiv((BigDecimal)amountOwed, (BigDecimal)accumulatedUnderInvoice);
            value.put("amountOwed", (Object)ProjectBoardApi.roundTwoPre(amountOwed));
            value.put("proportion", (Object)(proportion == null ? new BigDecimal("0.0000") : proportion.setScale(4, 6)));
            dataList.add(value);
        }
        Collections.sort(dataList, new Comparator<JSONObject>(){

            @Override
            public int compare(JSONObject o1, JSONObject o2) {
                BigDecimal mny1 = o1.getBigDecimal("amountOwed");
                BigDecimal mny2 = o2.getBigDecimal("amountOwed");
                return mny1.compareTo(mny2);
            }
        });
        Collections.reverse(dataList);
        dataList = dataList.size() > 5 ? dataList.subList(0, 5) : dataList;
        JSONArray array = JSONArray.parseArray((String)JSON.toJSONString(dataList));
        JSONObject back = new JSONObject();
        back.put("accumulatedUnderInvoice", (Object)ProjectBoardApi.roundTwoPre(accumulatedUnderInvoice != null ? accumulatedUnderInvoice : BigDecimal.ZERO));
        back.put("list", (Object)array);
        return back;
    }

    private static BigDecimal getSumMny(CommonResponse<JSONObject> resp, String records, String field) {
        JSONArray jsonArray = new JSONArray();
        if (!resp.isSuccess() || resp.getData() == null) {
            logger.error("\u83b7\u53d6\u5217\u8868\u5931\u8d25\uff1a{}", (Object)resp.getMsg());
        } else {
            logger.info("\u67e5\u8be2\u5217\u8868\u7ed3\u679c\uff1a{}", resp);
            jsonArray = ((JSONObject)resp.getData()).getJSONArray(records);
        }
        BigDecimal sumMny = null;
        if (CollectionUtils.isNotEmpty((Collection)jsonArray)) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject obj = jsonArray.getJSONObject(i);
                sumMny = MathUtil.safeAdd(sumMny, (BigDecimal)obj.getBigDecimal(field));
            }
        }
        return sumMny;
    }

    private static BigDecimal getSumMny(JSONObject json, String field) {
        JSONArray jsonArray = json.getJSONArray("records");
        if (CollectionUtils.isEmpty((Collection)jsonArray)) {
            return null;
        }
        BigDecimal sumMny = null;
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject obj = jsonArray.getJSONObject(i);
            sumMny = MathUtil.safeAdd(sumMny, (BigDecimal)obj.getBigDecimal(field));
        }
        return sumMny;
    }

    private static BigDecimal getSumMny(JSONArray jsonArray, String field) {
        if (CollectionUtils.isEmpty((Collection)jsonArray)) {
            return null;
        }
        BigDecimal sumMny = null;
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject obj = jsonArray.getJSONObject(i);
            sumMny = MathUtil.safeAdd(sumMny, (BigDecimal)obj.getBigDecimal(field));
        }
        return sumMny;
    }

    private void calculateCallableMny(Map<String, Map<String, BigDecimal>> monthMap, JSONObject json, String dateField, String mnyField) {
        JSONArray jsonArray = json.getJSONArray("records");
        if (CollectionUtils.isNotEmpty((Collection)jsonArray)) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                JSONObject obj = jsonArray.getJSONObject(i);
                this.calculateSumMny(monthMap, obj.getDate(dateField), "income", obj.getBigDecimal(mnyField));
            }
        }
    }

    private void calculateSumMny(Map<String, Map<String, BigDecimal>> monthMap, Date date, String key, BigDecimal value) {
        if (date != null) {
            calendar.setTime(date);
            String month = calendar.get(2) + 1 + "\u6708";
            Map<Object, Object> mnyMap = new HashMap();
            BigDecimal mny = null;
            if (monthMap.containsKey(month)) {
                mnyMap = monthMap.get(month);
                mny = MathUtil.safeAdd((BigDecimal)((BigDecimal)mnyMap.get(key)), (BigDecimal)value);
                mnyMap.put(key, mny);
            } else {
                mnyMap = new HashMap();
                mnyMap.put(key, value);
            }
            monthMap.put(month, mnyMap);
        }
    }

    private void calculateSumMnyBySupplierId(Map<Long, JSONObject> map, Long supplierId, BigDecimal mny, String supplierName, Boolean flag) {
        JSONObject data = new JSONObject();
        BigDecimal amountOwed = null;
        if (map.containsKey(supplierId)) {
            data = map.get(supplierId);
            amountOwed = flag.booleanValue() ? MathUtil.safeAdd((BigDecimal)data.getBigDecimal("amountOwed"), (BigDecimal)mny) : MathUtil.safeSub((BigDecimal)data.getBigDecimal("amountOwed"), (BigDecimal)mny);
        } else {
            amountOwed = flag != false ? MathUtil.safeAdd((BigDecimal)BigDecimal.ZERO, (BigDecimal)mny) : MathUtil.safeSub((BigDecimal)BigDecimal.ZERO, (BigDecimal)mny);
        }
        data.put("amountOwed", (Object)amountOwed);
        data.put("supplierName", (Object)supplierName);
        map.put(supplierId, data);
    }

    private Future<JSONObject> excute(ExecutorService threadPool, String authority, String url, QueryParam queryParam) {
        CountCallable callable = new CountCallable(RequestContextHolder.getRequestAttributes(), authority, this.BASE_HOST + url, queryParam, null);
        Future<JSONObject> future = threadPool.submit(callable);
        return future;
    }

    private Future<JSONObject> excute(ExecutorService threadPool, QueryParam queryParam, IBaseService service) {
        CountCallable callable = new CountCallable(RequestContextHolder.getRequestAttributes(), null, null, queryParam, service);
        Future<JSONObject> future = threadPool.submit(callable);
        return future;
    }

    public static BigDecimal roundTwoPre(BigDecimal src) {
        return src == null ? new BigDecimal("0.00") : src.setScale(2, 6);
    }

    @PostMapping(value={"queryIncoemAndExpendByProjectIds"})
    public CommonResponse<Map<Long, JSONObject>> queryIncoemAndExpendByProjectIds(@RequestBody List<Long> projectIds) {
        BigDecimal sumMny;
        Long projectId2;
        Object obj;
        int i;
        long startTime = System.currentTimeMillis();
        HashMap<Long, BigDecimal> payMoneyMap = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> incomeContractTaxMnyMap = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> incomeContractMnyMap = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> incomeTaxRateMap = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> receiveMoneyMap = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> financeEngineReceiveMnyMap = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> financeOtherReceiveMnyMap = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> openInvoiceTaxMnyMap = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> openInvoiceMnyMap = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> openTaxMnyMap = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> receiveSpecialInvoiceTaxMnyMap = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> receiveSpecialInvoiceMnyMap = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> receiveSpecialTaxMnyMap = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> receiveGeneralInvoiceTaxMnyMap = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> receiveGeneralInvoiceMnyMap = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> receiveGeneralTaxMnyMap = new HashMap<Long, BigDecimal>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantId", InvocationInfoProxy.getTenantid());
        map.put("projectIds", projectIds);
        List<ProjectCapitalSetVO> payMoneyList = this.projectCapitalSetMapper.getProjectPayMny(map);
        if (payMoneyList != null && payMoneyList.size() > 0) {
            for (ProjectCapitalSetVO vo : payMoneyList) {
                payMoneyMap.put(vo.getProjectId(), vo.getProjectIncome());
            }
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        queryParam.getParams().put("projectId", new Parameter("in", projectIds));
        queryParam.setPageIndex(0);
        queryParam.setPageSize(-1);
        QueryParam queryParam2 = (QueryParam)Utils.deepCopy((Object)queryParam);
        queryParam2.getOrderMap().put("createTime", "desc");
        CommonResponse incomeResp = this.incomeApi.getListByQueryParam(queryParam2);
        JSONArray jsonArray = new JSONArray();
        if (!incomeResp.isSuccess() || incomeResp.getData() == null) {
            logger.error("\u83b7\u53d6\u6536\u5165\u5408\u540c\u5217\u8868\u5931\u8d25\uff1a{}", (Object)incomeResp.getMsg());
        } else {
            jsonArray = ((JSONObject)incomeResp.getData()).getJSONArray("records");
        }
        List receiveList = this.receiveService.queryList(queryParam);
        JSONArray receiveArray = JSONArray.parseArray((String)JSON.toJSONString((Object)receiveList));
        CommonResponse openResp = this.invoiceApi.getOpenListByQueryParam(queryParam);
        JSONArray openArray = new JSONArray();
        if (!openResp.isSuccess() || openResp.getData() == null) {
            logger.error("\u83b7\u53d6\u5f00\u7968\u5217\u8868\u5931\u8d25\uff1a{}", (Object)openResp.getMsg());
        } else {
            openArray = ((JSONObject)openResp.getData()).getJSONArray("records");
        }
        QueryParam queryParam3 = (QueryParam)Utils.deepCopy((Object)queryParam);
        queryParam3.getParams().put("dependOnProject", new Parameter("eq", (Object)"1"));
        CommonResponse invoiceResp = this.invoiceApi.getReceiveListByQueryParam(queryParam3);
        JSONArray invoiceArray = new JSONArray();
        if (!invoiceResp.isSuccess() || invoiceResp.getData() == null) {
            logger.error("\u83b7\u53d6\u6536\u7968\u5217\u8868\u5931\u8d25\uff1a{}", (Object)invoiceResp.getMsg());
        } else {
            invoiceArray = ((JSONObject)invoiceResp.getData()).getJSONArray("records");
        }
        long endTime2 = System.currentTimeMillis();
        logger.info("query2 ---- \u8fd0\u884c\u65f6\u95f4\uff1a" + (endTime2 - startTime) + "ms");
        if (CollectionUtils.isNotEmpty((Collection)jsonArray)) {
            for (i = 0; i < jsonArray.size(); ++i) {
                obj = jsonArray.getJSONObject(i);
                projectId2 = this.getProjectId((JSONObject)obj);
                if (incomeContractTaxMnyMap.get(projectId2) != null) {
                    sumMny = MathUtil.safeAdd((BigDecimal)((BigDecimal)incomeContractTaxMnyMap.get(projectId2)), (BigDecimal)obj.getBigDecimal("contractTaxMny"));
                    incomeContractTaxMnyMap.put(projectId2, sumMny);
                } else {
                    incomeContractTaxMnyMap.put(projectId2, obj.getBigDecimal("contractTaxMny"));
                }
                if (incomeContractMnyMap.get(projectId2) != null) {
                    sumMny = MathUtil.safeAdd((BigDecimal)((BigDecimal)incomeContractMnyMap.get(projectId2)), (BigDecimal)obj.getBigDecimal("contractMny"));
                    incomeContractMnyMap.put(projectId2, sumMny);
                } else {
                    incomeContractMnyMap.put(projectId2, obj.getBigDecimal("contractMny"));
                }
                if (incomeTaxRateMap.get(projectId2) != null) continue;
                incomeTaxRateMap.put(projectId2, obj.getBigDecimal("taxRate"));
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)receiveArray)) {
            for (i = 0; i < receiveArray.size(); ++i) {
                obj = receiveArray.getJSONObject(i);
                projectId2 = this.getProjectId((JSONObject)obj);
                if (receiveMoneyMap.get(projectId2) != null) {
                    sumMny = MathUtil.safeAdd((BigDecimal)((BigDecimal)receiveMoneyMap.get(projectId2)), (BigDecimal)obj.getBigDecimal("receiveMny"));
                    receiveMoneyMap.put(projectId2, sumMny);
                } else {
                    receiveMoneyMap.put(projectId2, obj.getBigDecimal("receiveMny"));
                }
                if (Long.valueOf("1275321308270993409").equals(obj.getLong("receiveType"))) {
                    if (financeEngineReceiveMnyMap.get(projectId2) != null) {
                        sumMny = MathUtil.safeAdd((BigDecimal)((BigDecimal)financeEngineReceiveMnyMap.get(projectId2)), (BigDecimal)obj.getBigDecimal("receiveMny"));
                        financeEngineReceiveMnyMap.put(projectId2, sumMny);
                    } else {
                        financeEngineReceiveMnyMap.put(projectId2, obj.getBigDecimal("receiveMny"));
                    }
                }
                if (!Long.valueOf("1275321354706132993").equals(obj.getLong("receiveType"))) continue;
                if (financeOtherReceiveMnyMap.get(projectId2) != null) {
                    sumMny = MathUtil.safeAdd((BigDecimal)((BigDecimal)financeOtherReceiveMnyMap.get(projectId2)), (BigDecimal)obj.getBigDecimal("receiveMny"));
                    financeOtherReceiveMnyMap.put(projectId2, sumMny);
                    continue;
                }
                financeOtherReceiveMnyMap.put(projectId2, obj.getBigDecimal("receiveMny"));
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)openArray)) {
            for (i = 0; i < openArray.size(); ++i) {
                obj = openArray.getJSONObject(i);
                projectId2 = this.getProjectId((JSONObject)obj);
                if (openInvoiceTaxMnyMap.get(projectId2) != null) {
                    sumMny = MathUtil.safeAdd((BigDecimal)((BigDecimal)openInvoiceTaxMnyMap.get(projectId2)), (BigDecimal)obj.getBigDecimal("invoiceTaxMny"));
                    openInvoiceTaxMnyMap.put(projectId2, sumMny);
                } else {
                    openInvoiceTaxMnyMap.put(projectId2, obj.getBigDecimal("invoiceTaxMny"));
                }
                if (openInvoiceMnyMap.get(projectId2) != null) {
                    sumMny = MathUtil.safeAdd((BigDecimal)((BigDecimal)openInvoiceMnyMap.get(projectId2)), (BigDecimal)obj.getBigDecimal("invoiceMny"));
                    openInvoiceMnyMap.put(projectId2, sumMny);
                } else {
                    openInvoiceMnyMap.put(projectId2, obj.getBigDecimal("invoiceMny"));
                }
                if (openTaxMnyMap.get(projectId2) != null) {
                    sumMny = MathUtil.safeAdd((BigDecimal)((BigDecimal)openTaxMnyMap.get(projectId2)), (BigDecimal)obj.getBigDecimal("taxMny"));
                    openTaxMnyMap.put(projectId2, sumMny);
                    continue;
                }
                openTaxMnyMap.put(projectId2, obj.getBigDecimal("taxMny"));
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)invoiceArray)) {
            for (i = 0; i < invoiceArray.size(); ++i) {
                obj = invoiceArray.getJSONObject(i);
                projectId2 = this.getProjectId((JSONObject)obj);
                if (Long.valueOf("1277537516768632833").equals(obj.getLong("invoiceType"))) {
                    if (receiveSpecialInvoiceTaxMnyMap.get(projectId2) != null) {
                        sumMny = MathUtil.safeAdd((BigDecimal)((BigDecimal)receiveSpecialInvoiceTaxMnyMap.get(projectId2)), (BigDecimal)obj.getBigDecimal("invoiceTaxMny"));
                        receiveSpecialInvoiceTaxMnyMap.put(projectId2, sumMny);
                    } else {
                        receiveSpecialInvoiceTaxMnyMap.put(projectId2, obj.getBigDecimal("invoiceTaxMny"));
                    }
                    if (receiveSpecialInvoiceMnyMap.get(projectId2) != null) {
                        sumMny = MathUtil.safeAdd((BigDecimal)((BigDecimal)receiveSpecialInvoiceMnyMap.get(projectId2)), (BigDecimal)obj.getBigDecimal("invoiceMny"));
                        receiveSpecialInvoiceMnyMap.put(projectId2, sumMny);
                    } else {
                        receiveSpecialInvoiceMnyMap.put(projectId2, obj.getBigDecimal("invoiceMny"));
                    }
                    if (receiveSpecialTaxMnyMap.get(projectId2) != null) {
                        sumMny = MathUtil.safeAdd((BigDecimal)((BigDecimal)receiveSpecialTaxMnyMap.get(projectId2)), (BigDecimal)obj.getBigDecimal("taxMny"));
                        receiveSpecialTaxMnyMap.put(projectId2, sumMny);
                    } else {
                        receiveSpecialTaxMnyMap.put(projectId2, obj.getBigDecimal("taxMny"));
                    }
                }
                if (!Long.valueOf("1277537563879055362").equals(obj.getLong("invoiceType"))) continue;
                if (receiveGeneralInvoiceTaxMnyMap.get(projectId2) != null) {
                    sumMny = MathUtil.safeAdd((BigDecimal)((BigDecimal)receiveGeneralInvoiceTaxMnyMap.get(projectId2)), (BigDecimal)obj.getBigDecimal("invoiceTaxMny"));
                    receiveGeneralInvoiceTaxMnyMap.put(projectId2, sumMny);
                } else {
                    receiveGeneralInvoiceTaxMnyMap.put(projectId2, obj.getBigDecimal("invoiceTaxMny"));
                }
                if (receiveGeneralInvoiceMnyMap.get(projectId2) != null) {
                    sumMny = MathUtil.safeAdd((BigDecimal)((BigDecimal)receiveGeneralInvoiceMnyMap.get(projectId2)), (BigDecimal)obj.getBigDecimal("invoiceMny"));
                    receiveGeneralInvoiceMnyMap.put(projectId2, sumMny);
                } else {
                    receiveGeneralInvoiceMnyMap.put(projectId2, obj.getBigDecimal("invoiceMny"));
                }
                if (receiveGeneralTaxMnyMap.get(projectId2) != null) {
                    sumMny = MathUtil.safeAdd((BigDecimal)((BigDecimal)receiveGeneralTaxMnyMap.get(projectId2)), (BigDecimal)obj.getBigDecimal("taxMny"));
                    receiveGeneralTaxMnyMap.put(projectId2, sumMny);
                    continue;
                }
                receiveGeneralTaxMnyMap.put(projectId2, obj.getBigDecimal("taxMny"));
            }
        }
        HashMap<Long, JSONObject> result = new HashMap<Long, JSONObject>();
        for (Long projectId2 : projectIds) {
            JSONObject resp = new JSONObject();
            resp.put("receiveMoney", receiveMoneyMap.get(projectId2));
            resp.put("payMoney", payMoneyMap.get(projectId2));
            resp.put("incomeContractTaxMny", incomeContractTaxMnyMap.get(projectId2));
            resp.put("incomeContractMny", incomeContractMnyMap.get(projectId2));
            resp.put("incomeTaxRate", incomeTaxRateMap.get(projectId2));
            resp.put("financeEngineReceiveMny", financeEngineReceiveMnyMap.get(projectId2));
            resp.put("financeOtherReceiveMny", financeOtherReceiveMnyMap.get(projectId2));
            resp.put("openInvoiceTaxMny", openInvoiceTaxMnyMap.get(projectId2));
            resp.put("openInvoiceMny", openInvoiceMnyMap.get(projectId2));
            resp.put("openTaxMny", openTaxMnyMap.get(projectId2));
            resp.put("receiveSpecialInvoiceTaxMny", receiveSpecialInvoiceTaxMnyMap.get(projectId2));
            resp.put("receiveSpecialInvoiceMny", receiveSpecialInvoiceMnyMap.get(projectId2));
            resp.put("receiveSpecialTaxMny", receiveSpecialTaxMnyMap.get(projectId2));
            resp.put("receiveGeneralInvoiceTaxMny", receiveGeneralInvoiceTaxMnyMap.get(projectId2));
            resp.put("receiveGeneralInvoiceMny", receiveGeneralInvoiceMnyMap.get(projectId2));
            resp.put("receiveGeneralTaxMny", receiveGeneralTaxMnyMap.get(projectId2));
            result.put(projectId2, resp);
        }
        long endTime = System.currentTimeMillis();
        logger.info("queryIncoemAndExpendByProjectIds ---- \u8fd0\u884c\u65f6\u95f4\uff1a" + (endTime - endTime2) + "ms");
        return CommonResponse.success(result);
    }

    private Long getProjectId(JSONObject obj) {
        Long projectId = null;
        projectId = obj.getString("projectId").length() > 20 ? obj.getJSONObject("projectId").getLong("id") : obj.getLong("projectId");
        return projectId;
    }
}

