/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.service;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.finance.util.NoticeEnum;
import com.ejianc.business.finance.vo.PayRecordVO;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class PayRecordMessageService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Value(value="${weixin_template.check_id}")
    private String weixinCheckTemplateId;
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private IDefdocApi defdocApi;

    public CommonResponse<String> sendMsg(PayRecordVO payRecordVO, String[] receivers, NoticeEnum notice) {
        if (payRecordVO != null) {
            String url = "";
            String feeTypeName = "";
            String mobileUrl = "ejc-finance-mobile/#/newPayContract/card?id=";
            String supplierText = "";
            if ("\u5de5\u4eba\u5de5\u8d44-\u6709\u5408\u540c".equals(payRecordVO.getApplyType())) {
                url = "ejc-finance-frontend/#/paymentList/contractCard?id=" + payRecordVO.getPayapplyId();
                feeTypeName = payRecordVO.getSalaryApplyTypeName();
                notice.setSubject("\u5de5\u4eba\u5de5\u8d44\u4ed8\u6b3e\u7533\u8bf7(\u6709\u5408\u540c)");
            } else if ("\u5de5\u4eba\u5de5\u8d44-\u65e0\u5408\u540c".equals(payRecordVO.getApplyType())) {
                url = "ejc-finance-frontend/#/paymentList/sporadicCard?id=" + payRecordVO.getPayapplyId();
                feeTypeName = payRecordVO.getSalaryApplyTypeName();
                mobileUrl = "ejc-finance-mobile/#/paySporadic/card?id=";
                notice.setSubject("\u5de5\u4eba\u5de5\u8d44\u4ed8\u6b3e\u7533\u8bf7(\u65e0\u5408\u540c)");
            } else if ("\u5408\u540c\u4ed8\u6b3e".equals(payRecordVO.getApplyType())) {
                url = "ejc-finance-frontend/#/paymentList/contractCard?id=" + payRecordVO.getPayapplyId();
                feeTypeName = payRecordVO.getFeeType() == 1L ? "-\u9884\u4ed8\u6b3e" : (payRecordVO.getFeeType() == 2L ? "-\u8fc7\u7a0b\u6b3e" : "-\u5176\u4ed6");
                supplierText = "\u4f9b\u5e94\u5546\uff1a" + payRecordVO.getReceiveUnitName() + "\uff1b";
                notice.setSubject("\u5408\u540c\u4ed8\u6b3e\u7533\u8bf7");
            } else if ("\u96f6\u661f\u91c7\u8d2d".equals(payRecordVO.getApplyType())) {
                url = "ejc-finance-frontend/#/paymentList/sporadicCard?id=" + payRecordVO.getPayapplyId();
                mobileUrl = "ejc-finance-mobile/#/paySporadic/card?id=";
                supplierText = "\u4f9b\u5e94\u5546\uff1a" + payRecordVO.getReceiveUnitName() + "\uff1b";
                notice.setSubject("\u96f6\u661f\u91c7\u8d2d\u4ed8\u6b3e\u7533\u8bf7");
            } else if ("\u62a5\u9500".equals(payRecordVO.getApplyType())) {
                url = "ejc-finance-frontend/#/paymentList/reimburseProCard?id=" + payRecordVO.getPayapplyId();
                mobileUrl = "ejc-finance-mobile/#/reimbursePro/projectDetails?id=";
                notice.setSubject("\u62a5\u9500\u4ed8\u6b3e\u7533\u8bf7");
            } else if ("\u62bc\u91d1".equals(payRecordVO.getApplyType())) {
                url = "ejc-finance-frontend/#/paymentList/foregiftCard?id=" + payRecordVO.getPayapplyId();
                mobileUrl = "ejc-finance-mobile/#/payForegift/card?id=";
                notice.setSubject("\u62bc\u91d1\u4ed8\u6b3e\u7533\u8bf7");
            } else if ("\u5907\u7528\u91d1".equals(payRecordVO.getApplyType())) {
                url = "ejc-finance-frontend/#/loadList/loadApplyCard?id=" + payRecordVO.getPayapplyId();
                mobileUrl = "ejc-finance-mobile/#/loadApply/loadApplyCard?id=";
                notice.setSubject("\u5907\u7528\u91d1\u4ed8\u6b3e\u7533\u8bf7");
            }
            this.logger.info("\u53d1\u9001\u6d88\u606f\u5f00\u59cb========= msgId = " + payRecordVO.getMsgId() + "\uff0cmsgBillCode = " + payRecordVO.getMsgBillCode());
            PushMsgParameter parameter = new PushMsgParameter();
            ArrayList<String> channel = new ArrayList<String>();
            channel.add("weixin");
            channel.add("sys");
            HashMap<String, String> keyMap = new HashMap<String, String>();
            keyMap.put("#FEETYPE#", payRecordVO.getApplyType() + feeTypeName);
            keyMap.put("#BILLCODE#", payRecordVO.getMsgBillCode());
            keyMap.put("#THISPAYMNY#", String.valueOf(ComputeUtil.scaleTwo((BigDecimal)payRecordVO.getThisPayMny())));
            keyMap.put("#ID#", String.valueOf(payRecordVO.getMsgId()));
            keyMap.put("#BASEHOST#", this.baseHost + url);
            this.logger.info("\u53d1\u9001\u6d88\u606f\u5f00\u59cb========= url = " + this.baseHost + url);
            if (StringUtils.isNotBlank((CharSequence)this.weixinCheckTemplateId)) {
                String remark = "\u8d39\u7528\u7c7b\u578b\uff1a" + payRecordVO.getApplyType() + feeTypeName + "\uff1b" + supplierText + "\u4ed8\u6b3e\u7533\u8bf7\u91d1\u989d\uff1a" + ComputeUtil.scaleTwo((BigDecimal)payRecordVO.getApplyMny()) + "\u5143\uff1b\u542b\u672c\u671f\u7d2f\u8ba1\u652f\u4ed8\u91d1\u989d\uff1a" + ComputeUtil.scaleTwo((BigDecimal)payRecordVO.getMsgPayMny()) + "\u5143\uff1b";
                JSONObject weixinParams = new JSONObject();
                weixinParams.put("template_id", (Object)this.weixinCheckTemplateId);
                JSONObject wxparams = new JSONObject();
                wxparams.put("amount2", (Object)String.valueOf(ComputeUtil.scaleTwo((BigDecimal)payRecordVO.getThisPayMny())));
                wxparams.put("character_string3", (Object)payRecordVO.getMsgBillCode());
                weixinParams.put("data", (Object)wxparams);
                this.logger.info("==============================\u5fae\u4fe1\u516c\u4f17\u53f7===================================================");
                mobileUrl = mobileUrl + payRecordVO.getPayapplyId() + "&openid={openid}";
                this.logger.info("mobileUrl = " + mobileUrl);
                weixinParams.put("url", (Object)(this.baseHost + mobileUrl));
                parameter.setWeixinParams(weixinParams);
            } else {
                this.logger.info("\u672a\u914d\u7f6e\u5fae\u4fe1\u516c\u4f17\u53f7\u6a21\u677f\uff0c\u6545\u4e0d\u53d1\u5fae\u4fe1\u516c\u4f17\u53f7\u6d88\u606f");
            }
            parameter.setReceivers(receivers);
            parameter.setChannel(channel.toArray(new String[channel.size()]));
            parameter.setMsgType("notice");
            parameter.setSubject(notice.getSubject() + "\u3010\u5355\u636e\u7f16\u53f7:" + payRecordVO.getMsgBillCode() + "\u3011\u652f\u4ed8\u6210\u529f\u901a\u77e5\uff1a\u672c\u6b21\u652f\u4ed8\u91d1\u989d " + ComputeUtil.scaleTwo((BigDecimal)payRecordVO.getThisPayMny()) + " \u5143\uff01");
            this.logger.info("==============================\u7cfb\u7edf\u6d88\u606f===================================================");
            String sysContent = NoticeEnum.getPcContent((NoticeEnum)notice, keyMap);
            this.logger.info("sysContent = " + sysContent);
            parameter.setContent(sysContent);
            parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
            parameter.setSendUserId(InvocationInfoProxy.getUserid());
            try {
                CommonResponse result = this.pushMessageApi.pushMessage(parameter);
                if (result.isSuccess()) {
                    this.logger.error("\u6d88\u606f\u53d1\u9001\u6210\u529f---------------->" + result.getMsg());
                } else {
                    this.logger.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25---------------->" + result.getMsg());
                }
            }
            catch (Exception e) {
                this.logger.error("\u8c03\u7528\u6d88\u606f\u4e2d\u5fc3RPC\u670d\u52a1\u5f02\u5e38--------------" + e);
            }
        }
        return CommonResponse.success();
    }
}

