/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.finance.bean.BidBondEntity;
import com.ejianc.business.finance.mapper.BidBondMapper;
import com.ejianc.business.finance.service.IBidBondService;
import com.ejianc.business.finance.vo.BidBondReportVO;
import com.ejianc.business.finance.vo.BidBondVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service(value="bidBondService")
public class BidBondServiceImpl
extends BaseServiceImpl<BidBondMapper, BidBondEntity>
implements IBidBondService {
    @Override
    public List<BidBondVO> queryDealList(Page<BidBondVO> pages, QueryWrapper queryWrapper) {
        List<BidBondVO> listres = ((BidBondMapper)this.baseMapper).pageList(pages, queryWrapper);
        return listres;
    }

    @Override
    public IPage<BidBondEntity> selectPage(Page<BidBondEntity> page, QueryWrapper wrapper) {
        return ((BidBondMapper)this.baseMapper).selectPage((IPage)page, (Wrapper)wrapper);
    }

    @Override
    public BidBondVO queryByCode(String billCode) {
        BidBondVO resp = null;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"bill_code", (Object)billCode);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        query.eq((Object)"tenant_id", (Object)InvocationInfoProxy.getTenantid());
        BidBondEntity entity = (BidBondEntity)((Object)((BidBondMapper)this.baseMapper).selectOne((Wrapper)query));
        if (null != entity) {
            resp = (BidBondVO)BeanMapper.map((Object)((Object)entity), BidBondVO.class);
        }
        return resp;
    }

    @Override
    public BidBondReportVO queryBondReport(QueryWrapper queryWrapper) {
        BidBondReportVO reportVO = new BidBondReportVO();
        List<BidBondReportVO> list = ((BidBondMapper)this.baseMapper).queryBondReport(queryWrapper);
        if (CollectionUtils.isNotEmpty(list)) {
            list.forEach(vo -> {
                BigDecimal upPayMny = vo.getUpPayMny() == null ? BigDecimal.ZERO : vo.getUpPayMny();
                BigDecimal upBackMny = vo.getUpBackMny() == null ? BigDecimal.ZERO : vo.getUpBackMny();
                reportVO.setUpApplyMny(reportVO.getUpApplyMny().add(vo.getUpApplyMny()));
                reportVO.setUpBackMny(reportVO.getUpBackMny().add(upBackMny));
                reportVO.setUpPayMny(reportVO.getUpPayMny().add(upPayMny));
                if (null != vo.getEndDate() && new Date().after(vo.getEndDate())) {
                    reportVO.setUpUnPayMny(reportVO.getUpUnPayMny().add(upPayMny.subtract(upBackMny)));
                }
            });
        }
        return reportVO;
    }
}

