/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.ejianc.business.finance.bean.BondDownBackEntity;
import com.ejianc.business.finance.bean.BondDownEntity;
import com.ejianc.business.finance.mapper.BondDownBackMapper;
import com.ejianc.business.finance.service.IBondDownBackService;
import com.ejianc.business.finance.service.IBondDownService;
import com.ejianc.business.finance.vo.BondDownBackVO;
import com.ejianc.business.finance.vo.BondDownDealRentVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BondDownBackServiceImpl
extends BaseServiceImpl<BondDownBackMapper, BondDownBackEntity>
implements IBondDownBackService {
    private static final String BONGDOWN_BACK = "BONGDOWN_BACK";
    @Autowired
    private IBondDownService bondDownService;
    @Autowired
    private IBillCodeApi billCodeApi;

    @Override
    public BondDownBackVO insertOrUpdate(BondDownBackVO bondDownBackVO) {
        BigDecimal applyMny;
        LambdaQueryWrapper lambda;
        Long tenantId = InvocationInfoProxy.getTenantid();
        List entities = null;
        if (StringUtils.isEmpty((CharSequence)bondDownBackVO.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BONGDOWN_BACK, tenantId);
            if (billCode.isSuccess()) {
                bondDownBackVO.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        BondDownBackEntity entity = (BondDownBackEntity)((Object)BeanMapper.map((Object)bondDownBackVO, BondDownBackEntity.class));
        if (null != bondDownBackVO.getId() && bondDownBackVO.getId() > 0L) {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(BondDownBackEntity::getBillCode, (Object)bondDownBackVO.getBillCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.ne(BaseEntity::getId, (Object)bondDownBackVO.getId());
            entities = super.list((Wrapper)lambda);
        } else {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.eq(BondDownBackEntity::getBillCode, (Object)bondDownBackVO.getBillCode());
            entities = super.list((Wrapper)lambda);
        }
        if (entities != null && entities.size() > 0) {
            throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        if (null == entity.getBackTime()) {
            entity.setBackTime(new Date());
        }
        super.saveOrUpdate((Object)entity, false);
        BondDownEntity upentity = (BondDownEntity)((Object)this.bondDownService.selectById(bondDownBackVO.getBondId()));
        BigDecimal sumBackMny = (BigDecimal)this.totalAlreadyBackMny(entity.getBondId(), entity.getId()).getData();
        BigDecimal bigDecimal = applyMny = upentity.getApplyMny() == null ? BigDecimal.ZERO : upentity.getApplyMny();
        if (applyMny.compareTo(sumBackMny.add(entity.getBackMny())) < 0) {
            throw new BusinessException("\u672c\u6b21\u9000\u8fd8\u91d1\u989d\u4e0d\u80fd\u8d85\u8fc7\u5269\u4f59\u91d1\u989d!");
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)entity.getBondId());
        updateWrapper.set(BondDownEntity::getBackMny, (Object)sumBackMny.add(entity.getBackMny()));
        this.bondDownService.update((Wrapper)updateWrapper);
        return (BondDownBackVO)BeanMapper.map((Object)((Object)entity), BondDownBackVO.class);
    }

    @Override
    public BondDownDealRentVO queryDetail(Long id) {
        BondDownDealRentVO vo = new BondDownDealRentVO();
        BondDownEntity upEntity = (BondDownEntity)((Object)this.bondDownService.selectById(id));
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(BondDownBackEntity::getBondId, (Object)id);
        lambda.in(BondDownBackEntity::getBillState, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        lambda.orderBy(true, false, (Object[])new SFunction[]{BondDownBackEntity::getBackTime});
        List list = super.list((Wrapper)lambda);
        vo.setId(id);
        vo.setBondStatus(upEntity.getBondStatus());
        vo.setContractId(upEntity.getContractId());
        vo.setContractName(upEntity.getContractName());
        vo.setApplyMny(upEntity.getApplyMny() == null ? BigDecimal.ZERO : upEntity.getApplyMny());
        vo.setContractTaxMny(upEntity.getContractTaxMny() == null ? BigDecimal.ZERO : upEntity.getContractTaxMny());
        vo.setBackMny(this.totalBackMny(id));
        vo.setSurplusMny(vo.getApplyMny().subtract(vo.getBackMny()));
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            vo.setBackRecord(BeanMapper.mapList((Iterable)list, BondDownBackVO.class));
        }
        return vo;
    }

    @Override
    public void deleteNew(List<BondDownBackVO> vos) {
        List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        for (Long id : ids) {
            BondDownBackEntity bondDownBackEntity = (BondDownBackEntity)((Object)super.selectById((Serializable)id));
            BondDownEntity upentity = (BondDownEntity)((Object)this.bondDownService.selectById(bondDownBackEntity.getBondId()));
            BigDecimal sumBackMny = upentity.getBackMny() == null ? BigDecimal.ZERO : upentity.getBackMny();
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)bondDownBackEntity.getBondId());
            updateWrapper.set(BondDownEntity::getBackMny, (Object)sumBackMny.add(bondDownBackEntity.getBackMny()));
            this.bondDownService.update((Wrapper)updateWrapper);
        }
        super.removeByIds(ids);
    }

    @Override
    public CommonResponse<BigDecimal> totalAlreadyBackMny(Long bondId, Long backId) {
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        lambda.eq(BondDownBackEntity::getBondId, (Object)bondId);
        if (null != backId) {
            lambda.ne(BaseEntity::getId, (Object)backId);
        }
        List list = super.list((Wrapper)lambda);
        BigDecimal alreadyBackMny = BigDecimal.ZERO;
        for (BondDownBackEntity entity : list) {
            if (null == entity.getBackMny()) continue;
            alreadyBackMny = alreadyBackMny.add(entity.getBackMny());
        }
        return CommonResponse.success((Object)alreadyBackMny);
    }

    public BigDecimal totalBackMny(Long bondId) {
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        lambda.eq(BondDownBackEntity::getBondId, (Object)bondId);
        lambda.in(BondDownBackEntity::getBillState, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        List list = super.list((Wrapper)lambda);
        BigDecimal alreadyBackMny = BigDecimal.ZERO;
        for (BondDownBackEntity entity : list) {
            if (null == entity.getBackMny()) continue;
            alreadyBackMny = alreadyBackMny.add(entity.getBackMny());
        }
        return alreadyBackMny;
    }
}

