/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.service.impl;

import com.ejianc.business.bank.bean.BankAcctEntity;
import com.ejianc.business.bank.consts.BankFlowSourceType;
import com.ejianc.business.bank.service.IBankAcctService;
import com.ejianc.business.bank.service.IBankFlowService;
import com.ejianc.business.bank.vo.BankFlowVO;
import com.ejianc.business.finance.bean.BondUpBackEntity;
import com.ejianc.business.finance.bean.BondUpEntity;
import com.ejianc.business.finance.service.IBondUpBackService;
import com.ejianc.business.finance.service.IBondUpService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="bondUpBack")
public class BondUpBackBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBondUpBackService service;
    @Autowired
    private IBondUpService bondUpService;
    @Autowired
    private IBankFlowService bankFlowService;
    @Autowired
    private IBankAcctService bankAcctService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u8fdb\u5165\u7ec8\u5ba1\u540e\u56de\u5199--- billId:" + billId + "  state:" + state);
        BondUpBackEntity entity = (BondUpBackEntity)((Object)this.service.selectById(billId));
        BondUpEntity bondUpEntity = (BondUpEntity)((Object)this.bondUpService.selectById(entity.getBondId()));
        BankAcctEntity bankAcctEntity = (BankAcctEntity)((Object)this.bankAcctService.selectById(entity.getAccountId()));
        BankFlowVO flowVO = BankFlowVO.instanceVOBySourceType((BankFlowSourceType)BankFlowSourceType.\u5bf9\u4e0a\u4fdd\u8bc1\u91d1\u9000\u8fd8);
        flowVO.setBillDate(entity.getBackTime());
        flowVO.setSourceId(entity.getId());
        flowVO.setBillId(entity.getId());
        flowVO.setReceiveMoney(entity.getBackMny());
        flowVO.setBillCode(entity.getBillCode());
        flowVO.setOrgId(bondUpEntity.getOrgId());
        flowVO.setOrgName(bondUpEntity.getOrgName());
        if (null != bankAcctEntity) {
            flowVO.setAccountOrgId(bankAcctEntity.getOrgId());
            flowVO.setAccountOrgName(bankAcctEntity.getOrgName());
        }
        flowVO.setAccountId(entity.getAccountId());
        flowVO.setAccountName(entity.getAccountName());
        flowVO.setAccountBank(entity.getAccountBank());
        flowVO.setAccountNum(entity.getAccountNum());
        flowVO.setTradeOrgId(entity.getCustomerId());
        flowVO.setTradeOrgName(entity.getCustomerName());
        flowVO.setMemo(entity.getMemo());
        this.bankFlowService.saveFlowVO(flowVO);
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u8fdb\u5165\u5f03\u5ba1\u540e\u56de\u5199--- billId:" + billId + "  state:" + state);
        BondUpBackEntity entity = (BondUpBackEntity)((Object)this.service.selectById(billId));
        this.bankFlowService.delFlowBySource(entity.getId(), entity.getId());
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    public CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
        BondUpBackEntity entity = (BondUpBackEntity)((Object)this.service.selectById(billId));
        if (entity == null) {
            return CommonResponse.error((String)"\u67e5\u8be2\u4e0d\u5230\u8be5\u5355\u636e\u4fe1\u606f\uff01");
        }
        QueryParam param = new QueryParam();
        param.getParams().put("bond_id", new Parameter("eq", (Object)entity.getBondId()));
        param.getOrderMap().put("create_time", "desc");
        List bondUpBackEntities = this.service.queryList(param);
        if (CollectionUtils.isNotEmpty((Collection)bondUpBackEntities) && null != bondUpBackEntities.get(0)) {
            BondUpBackEntity backEntity = (BondUpBackEntity)((Object)bondUpBackEntities.get(0));
            if (!entity.getId().equals(billId)) {
                return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5df2\u6709\u65b0\u7684\u5bf9\u4e0a\u4fdd\u8bc1\u91d1\u9000\u8fd8\uff0c\u4e0d\u80fd\u5f03\u5ba1/\u64a4\u56de\uff01");
            }
        }
        return CommonResponse.success((String)"\u5f03\u5ba1/\u64a4\u56de\u524d\u6821\u9a8c\u56de\u8c03\u6210\u529f\uff01");
    }
}

