/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.ejianc.business.finance.bean.BondUpBackEntity;
import com.ejianc.business.finance.bean.BondUpEntity;
import com.ejianc.business.finance.mapper.BondUpBackMapper;
import com.ejianc.business.finance.service.IBondUpBackService;
import com.ejianc.business.finance.service.IBondUpService;
import com.ejianc.business.finance.vo.BondUpBackVO;
import com.ejianc.business.finance.vo.BondUpDealRentVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BondUpBackServiceImpl
extends BaseServiceImpl<BondUpBackMapper, BondUpBackEntity>
implements IBondUpBackService {
    private static final String BONGUP_BACK = "BONGUP_BACK";
    @Autowired
    private IBondUpService bondUpService;
    @Autowired
    private IBillCodeApi billCodeApi;

    @Override
    public BondUpBackVO insertOrUpdate(BondUpBackVO bondUpBackVO) {
        LambdaQueryWrapper lambda;
        Long tenantId = InvocationInfoProxy.getTenantid();
        List entities = null;
        if (StringUtils.isEmpty((CharSequence)bondUpBackVO.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BONGUP_BACK, tenantId);
            if (billCode.isSuccess()) {
                bondUpBackVO.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        BondUpBackEntity entity = (BondUpBackEntity)((Object)BeanMapper.map((Object)bondUpBackVO, BondUpBackEntity.class));
        if (null != bondUpBackVO.getId() && bondUpBackVO.getId() > 0L) {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(BondUpBackEntity::getBillCode, (Object)bondUpBackVO.getBillCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.ne(BaseEntity::getId, (Object)bondUpBackVO.getId());
            entities = super.list((Wrapper)lambda);
        } else {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.eq(BondUpBackEntity::getBillCode, (Object)bondUpBackVO.getBillCode());
            entities = super.list((Wrapper)lambda);
        }
        if (entities != null && entities.size() > 0) {
            throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        if (null == entity.getBackTime()) {
            entity.setBackTime(new Date());
        }
        super.saveOrUpdate((Object)entity, false);
        BondUpEntity upentity = (BondUpEntity)((Object)this.bondUpService.selectById(bondUpBackVO.getBondId()));
        BigDecimal sumBackMny = (BigDecimal)this.totalAlreadyBackMny(entity.getBondId(), entity.getId()).getData();
        BigDecimal applyMny = upentity.getApplyMny() == null ? BigDecimal.ZERO : upentity.getApplyMny();
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)entity.getBondId());
        updateWrapper.set(BondUpEntity::getBackMny, (Object)sumBackMny.add(entity.getBackMny()));
        this.bondUpService.update((Wrapper)updateWrapper);
        return (BondUpBackVO)BeanMapper.map((Object)((Object)entity), BondUpBackVO.class);
    }

    @Override
    public BondUpDealRentVO queryDetail(Long id) {
        BondUpDealRentVO vo = new BondUpDealRentVO();
        BondUpEntity upEntity = (BondUpEntity)((Object)this.bondUpService.selectById(id));
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(BondUpBackEntity::getBondId, (Object)id);
        lambda.in(BondUpBackEntity::getBillState, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        lambda.orderBy(true, false, (Object[])new SFunction[]{BondUpBackEntity::getBackTime});
        List list = super.list((Wrapper)lambda);
        vo.setId(id);
        vo.setBondStatus(upEntity.getBondStatus());
        vo.setContractId(upEntity.getContractId());
        vo.setContractName(upEntity.getContractName());
        vo.setApplyMny(upEntity.getApplyMny() == null ? BigDecimal.ZERO : upEntity.getApplyMny());
        vo.setContractTaxMny(upEntity.getContractTaxMny() == null ? BigDecimal.ZERO : upEntity.getContractTaxMny());
        vo.setBackMny(this.totalBackMny(id));
        vo.setSurplusMny(vo.getApplyMny().subtract(vo.getBackMny()));
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            vo.setBackRecord(BeanMapper.mapList((Iterable)list, BondUpBackVO.class));
        }
        return vo;
    }

    @Override
    public void deleteNew(List<BondUpBackVO> vos) {
        List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        for (Long id : ids) {
            BondUpBackEntity entity = (BondUpBackEntity)((Object)super.selectById((Serializable)id));
            BondUpEntity upentity = (BondUpEntity)((Object)this.bondUpService.selectById(entity.getBondId()));
            BigDecimal sumBackMny = upentity.getBackMny() == null ? BigDecimal.ZERO : upentity.getBackMny();
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)entity.getBondId());
            updateWrapper.set(BondUpEntity::getBackMny, (Object)sumBackMny.subtract(entity.getBackMny()));
            this.bondUpService.update((Wrapper)updateWrapper);
        }
        super.removeByIds(ids);
    }

    @Override
    public CommonResponse<BigDecimal> totalAlreadyBackMny(Long bondId, Long backId) {
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        if (null != backId) {
            lambda.ne(BaseEntity::getId, (Object)backId);
        }
        lambda.eq(BondUpBackEntity::getBondId, (Object)bondId);
        List list = super.list((Wrapper)lambda);
        BigDecimal alreadyBackMny = BigDecimal.ZERO;
        for (BondUpBackEntity entity : list) {
            if (null == entity.getBackMny()) continue;
            alreadyBackMny = alreadyBackMny.add(entity.getBackMny());
        }
        return CommonResponse.success((Object)alreadyBackMny);
    }

    public BigDecimal totalBackMny(Long bondId) {
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        lambda.eq(BondUpBackEntity::getBondId, (Object)bondId);
        lambda.in(BondUpBackEntity::getBillState, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        List list = super.list((Wrapper)lambda);
        BigDecimal alreadyBackMny = BigDecimal.ZERO;
        for (BondUpBackEntity entity : list) {
            if (null == entity.getBackMny()) continue;
            alreadyBackMny = alreadyBackMny.add(entity.getBackMny());
        }
        return alreadyBackMny;
    }
}

