/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.finance.bean.BondUpEntity;
import com.ejianc.business.finance.mapper.BondUpMapper;
import com.ejianc.business.finance.service.IBondUpService;
import com.ejianc.business.finance.vo.BondReportVO;
import com.ejianc.business.finance.vo.BondUpVO;
import com.ejianc.business.finance.vo.BondVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.fields.service.ICommenQueryFieldsService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service
public class BondUpServiceImpl
extends BaseServiceImpl<BondUpMapper, BondUpEntity>
implements IBondUpService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BONDUP_BILL_CODE = "FINANCE_BONDUP";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private ICommenQueryFieldsService commenQueryFieldsService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommonResponse<BondUpVO> insertOrUpdate(BondUpVO bondUpVO) {
        block13: {
            Long tenantId = InvocationInfoProxy.getTenantid();
            if (null != bondUpVO && StringUtils.isEmpty((CharSequence)bondUpVO.getBillCode())) {
                CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BONDUP_BILL_CODE, tenantId);
                if (billCode.isSuccess()) {
                    bondUpVO.setBillCode((String)billCode.getData());
                } else {
                    throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
            }
            if (bondUpVO.getContractVersion() != null && bondUpVO.getContractVersion() != 0) {
                Jedis jedis = this.jedisPool.getResource();
                boolean locked = false;
                try {
                    locked = RedisTool.tryLock((Jedis)jedis, (String)String.valueOf(bondUpVO.getContractId()), (String)"saveOrUpdate", (int)1000);
                    this.logger.info("\u5224\u65ad\u5355\u636e\u5355\u636e\u9501\u7ed3\u679c------" + locked);
                    if (locked) {
                        Integer conVersion;
                        JSONObject contractEntity = this.commenQueryFieldsService.queryBillDetail(String.valueOf(bondUpVO.getContractId()), "BT200528000000002");
                        String objVersion = contractEntity.getJSONObject("data").get((Object)"version").toString();
                        Integer version = contractEntity.getJSONObject("data").get((Object)"version") == null ? 0 : Integer.parseInt(objVersion.substring(0, objVersion.indexOf(".")));
                        if (!version.equals(conVersion = bondUpVO.getContractVersion())) {
                            CommonResponse commonResponse = CommonResponse.error((String)"\u8be5\u5408\u540c\u5df2\u88ab\u66f4\u65b0\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u505a\uff01");
                            return commonResponse;
                        }
                        break block13;
                    }
                    CommonResponse contractEntity = CommonResponse.error((String)"\u51fa\u73b0\u5e76\u53d1\u64cd\u4f5c,\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
                    return contractEntity;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    if (locked) {
                        RedisTool.releaseLock((Jedis)jedis, (String)String.valueOf(bondUpVO.getContractId()), (String)"saveOrUpdate");
                    }
                    jedis.close();
                }
            }
        }
        bondUpVO.setBondStatus("0");
        BondUpEntity entity = (BondUpEntity)((Object)BeanMapper.map((Object)bondUpVO, BondUpEntity.class));
        super.saveOrUpdate((Object)entity, false);
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)entity), BondUpVO.class));
    }

    @Override
    public BondUpVO queryDetail(Long id) {
        BondUpEntity entity = (BondUpEntity)((Object)super.selectById((Serializable)id));
        BondUpVO bondUpVO = (BondUpVO)BeanMapper.map((Object)((Object)entity), BondUpVO.class);
        return bondUpVO;
    }

    @Override
    public List<BondVO> queryUnDealList(Page pages, QueryWrapper queryWrapper) {
        List<BondVO> listres = ((BondUpMapper)this.baseMapper).pageList(pages, queryWrapper);
        return listres;
    }

    @Override
    public BondReportVO queryBondReport(QueryWrapper queryWrapper) {
        List<BondReportVO> downList;
        BondReportVO reportVO = new BondReportVO();
        List<BondReportVO> list = ((BondUpMapper)this.baseMapper).queryBondUpReport(queryWrapper);
        if (CollectionUtils.isNotEmpty(list)) {
            list.forEach(vo -> {
                BigDecimal upPayMny = vo.getUpPayMny() == null ? BigDecimal.ZERO : vo.getUpPayMny();
                BigDecimal upBackMny = vo.getUpBackMny() == null ? BigDecimal.ZERO : vo.getUpBackMny();
                reportVO.setUpApplyMny(reportVO.getUpApplyMny().add(vo.getUpApplyMny()));
                reportVO.setUpBackMny(reportVO.getUpBackMny().add(upBackMny));
                reportVO.setUpPayMny(reportVO.getUpPayMny().add(upPayMny));
                if (new Date().after(vo.getEndDate())) {
                    reportVO.setUpUnPayMny(reportVO.getUpUnPayMny().add(upPayMny.subtract(upBackMny)));
                }
            });
        }
        if (CollectionUtils.isNotEmpty(downList = ((BondUpMapper)this.baseMapper).queryBondDownReport(queryWrapper))) {
            downList.forEach(vo -> {
                BigDecimal downPayMny = vo.getDownPayMny() == null ? BigDecimal.ZERO : vo.getDownPayMny();
                BigDecimal downBackMny = vo.getDownBackMny() == null ? BigDecimal.ZERO : vo.getDownBackMny();
                reportVO.setDownApplyMny(reportVO.getDownApplyMny().add(vo.getDownApplyMny()));
                reportVO.setDownBackMny(reportVO.getDownBackMny().add(downBackMny));
                reportVO.setDownPayMny(reportVO.getDownPayMny().add(downPayMny));
                if (new Date().after(vo.getEndDate())) {
                    reportVO.setDownUnPayMny(reportVO.getDownUnPayMny().add(downPayMny.subtract(downBackMny)));
                }
            });
        }
        return reportVO;
    }

    @Override
    public IPage<BondUpEntity> selectPage(Page pages, QueryWrapper queryWrapper) {
        return ((BondUpMapper)this.baseMapper).selectPage((IPage)pages, (Wrapper)queryWrapper);
    }
}

