/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.bank.service.IBankFlowService;
import com.ejianc.business.finance.bean.LoadApplyEntity;
import com.ejianc.business.finance.enums.ReceiveInvoiceFlagConst;
import com.ejianc.business.finance.service.IDeductionService;
import com.ejianc.business.finance.service.ILoadApplyService;
import com.ejianc.business.finance.service.IPayRecordService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="loadApply")
public class LoadApplyBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPayRecordService recordService;
    @Autowired
    private ILoadApplyService loadApplyService;
    @Autowired
    private IDeductionService ideductionService;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBankFlowService bankFlowService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)billId);
        updateWrapper.set(LoadApplyEntity::getApproveTime, (Object)new Date());
        this.loadApplyService.update((Wrapper)updateWrapper);
        return CommonResponse.success((String)"\u56de\u8c03\u5904\u7406\u6210\u529f\uff01");
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse stringCommonResponse = this.billTypeApi.checkQuote(billTypeCode, billId);
        boolean success = stringCommonResponse.isSuccess();
        if (!success) {
            return CommonResponse.error((String)"\u5df2\u7ecf\u88ab\u6263\u6b3e\u5355\u4f7f\u7528\u4e0d\u80fd\u5f03\u5ba1\u548c\u64a4\u56de");
        }
        LoadApplyEntity entity = (LoadApplyEntity)((Object)this.loadApplyService.selectById(billId));
        BigDecimal surplusMny = this.loadApplyService.querySurplusMny(null, null, entity.getOrgId(), 0, String.valueOf(entity.getApplyEmployeeId()));
        BigDecimal applyMny = entity.getApplyMny();
        if (applyMny.compareTo(surplusMny) > 0) {
            DecimalFormat df1 = new DecimalFormat("###,###.##");
            this.logger.info("\u8be5\u5355\u636e\u5f03\u5ba1\u540e\uff0c\u6b64\u5458\u5de5\u5df2\u62a5\u9500\u91d1\u989d\u5c06\u5927\u4e8e\u5907\u7528\u91d1\u7533\u8bf7\u91d1\u989d\uff0c\u4e0d\u80fd\u5f03\u5ba1! surplusMny:{}", (Object)df1.format(surplusMny));
            return CommonResponse.error((String)"\u8be5\u5355\u636e\u5f03\u5ba1\u540e\uff0c\u6b64\u5458\u5de5\u5df2\u62a5\u9500\u91d1\u989d\u5c06\u5927\u4e8e\u5907\u7528\u91d1\u7533\u8bf7\u91d1\u989d\uff0c\u4e0d\u80fd\u5f03\u5ba1!");
        }
        LambdaQueryWrapper lambdachange = Wrappers.lambdaQuery();
        lambdachange.eq(LoadApplyEntity::getApplyEmployeeId, (Object)InvocationInfoProxy.getEmployeeId());
        lambdachange.eq(LoadApplyEntity::getOrgId, (Object)entity.getOrgId());
        lambdachange.notIn(LoadApplyEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        int nums = this.loadApplyService.count((Wrapper)lambdachange);
        if (nums > 0) {
            return CommonResponse.error((String)"\u5ba1\u6279\u56de\u5199\u5f02\u5e38!\u8be5\u7ec4\u7ec7\u4e0b\u5df2\u5b58\u5728\u672a\u751f\u6548\u7684\u5355\u636e,\u4e0d\u5141\u8bb8\u64a4\u56de!");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        LoadApplyEntity entity = (LoadApplyEntity)((Object)this.loadApplyService.selectById(billId));
        entity.setPayMny(null);
        entity.setPayStatus(1);
        entity.setReceiveInvoiceFlag(ReceiveInvoiceFlagConst.NO);
        entity.setApproveTime(null);
        entity.setConfirmTime(null);
        this.loadApplyService.saveOrUpdate((Object)entity);
        this.logger.info("\u8fdb\u5165\u5ba1\u6279\u540e\u56de\u5199--- entity:" + (Object)((Object)entity));
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"payapply_id", (Object)billId);
        this.recordService.remove((Wrapper)wrapper, false);
        this.bankFlowService.delFlowBySource(null, billId);
        return CommonResponse.success();
    }
}

