/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.finance.bean.LoadApplyEntity;
import com.ejianc.business.finance.bean.LoadBackEntity;
import com.ejianc.business.finance.bean.LoadReimburseEntity;
import com.ejianc.business.finance.enums.ReceiveInvoiceFlagConst;
import com.ejianc.business.finance.mapper.LoadApplyMapper;
import com.ejianc.business.finance.service.ILoadApplyService;
import com.ejianc.business.finance.service.ILoadBackService;
import com.ejianc.business.finance.service.ILoadReimburseService;
import com.ejianc.business.finance.vo.LoadApplyVO;
import com.ejianc.business.finance.vo.ParamsCheckDsSpreadVO;
import com.ejianc.business.finance.vo.ParamsCheckSpreadVO;
import com.ejianc.business.finance.vo.ProjectFinanceVO;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LoadApplyServiceImpl
extends BaseServiceImpl<LoadApplyMapper, LoadApplyEntity>
implements ILoadApplyService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BONDUP_BILL_CODE = "LOAD_APPLY";
    private static final String CAN_USE_MNY_CHECK_CODE = "P-M478G960";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private ILoadReimburseService loadReimburseService;
    @Autowired
    private ILoadBackService loadBackService;
    @Autowired
    private IParamConfigApi paramConfigApi;

    @Override
    public LoadApplyVO insertOrUpdate(LoadApplyVO loadApplyVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (null != loadApplyVO && StringUtils.isEmpty((CharSequence)loadApplyVO.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BONDUP_BILL_CODE, tenantId);
            if (billCode.isSuccess()) {
                loadApplyVO.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        LoadApplyEntity entity = (LoadApplyEntity)((Object)BeanMapper.map((Object)loadApplyVO, LoadApplyEntity.class));
        BigDecimal surplusMny = this.querySurplusMny(null, null, entity.getOrgId(), 1, String.valueOf(loadApplyVO.getApplyEmployeeId()));
        entity.setSurplusMny(surplusMny);
        entity.setReceiveInvoiceFlag(ReceiveInvoiceFlagConst.NO);
        super.saveOrUpdate((Object)entity, false);
        LoadApplyVO applyVO = (LoadApplyVO)BeanMapper.map((Object)((Object)entity), LoadApplyVO.class);
        ProjectFinanceVO v = (ProjectFinanceVO)BeanMapper.map((Object)applyVO, ProjectFinanceVO.class);
        applyVO.setProjectFinanceVO(v);
        return applyVO;
    }

    @Override
    public BigDecimal querySurplusMny(Long rebid, Long backid, Long orgId, int type, String applyEmployeeId) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (StringUtils.isEmpty((CharSequence)applyEmployeeId)) {
            applyEmployeeId = InvocationInfoProxy.getEmployeeId();
        }
        List listApplys = new ArrayList();
        List listReimburse = new ArrayList();
        List listBack = new ArrayList();
        ArrayList<Integer> billstate = new ArrayList<Integer>();
        billstate.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billstate.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambda.eq(LoadApplyEntity::getOrgId, (Object)orgId);
        lambda.eq(LoadApplyEntity::getApplyEmployeeId, (Object)applyEmployeeId);
        lambda.in(LoadApplyEntity::getBillState, billstate);
        listApplys = super.list((Wrapper)lambda);
        BigDecimal sumApplyMny = listApplys.stream().map(LoadApplyEntity::getApplyMny).reduce(BigDecimal.ZERO, (a, b) -> a.add((BigDecimal)b));
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
        queryParam.getParams().put("org_id", new Parameter("eq", (Object)orgId));
        queryParam.getParams().put("apply_employee_id", new Parameter("eq", (Object)applyEmployeeId));
        if (null != rebid) {
            queryParam.getParams().put("id", new Parameter("ne", (Object)rebid));
        }
        if (1 == type) {
            queryParam.getParams().put("bill_state", new Parameter("in", billstate));
        }
        listReimburse = this.loadReimburseService.queryList(queryParam, false);
        BigDecimal sumReimburseMny = listReimburse.stream().map(LoadReimburseEntity::getReimburseMny).reduce(BigDecimal.ZERO, (a, b) -> a.add((BigDecimal)b));
        QueryParam queryParam2 = new QueryParam();
        queryParam2.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
        queryParam2.getParams().put("org_id", new Parameter("eq", (Object)orgId));
        queryParam2.getParams().put("apply_employee_id", new Parameter("eq", (Object)applyEmployeeId));
        if (null != backid) {
            queryParam2.getParams().put("id", new Parameter("ne", (Object)backid));
        }
        if (1 == type) {
            queryParam2.getParams().put("bill_state", new Parameter("in", billstate));
        }
        listBack = this.loadBackService.queryList(queryParam2, false);
        BigDecimal sumBackMny = listBack.stream().map(LoadBackEntity::getBackMny).reduce(BigDecimal.ZERO, (a, b) -> a.add((BigDecimal)b));
        BigDecimal ApplyMny = sumApplyMny == null ? BigDecimal.ZERO : sumApplyMny;
        BigDecimal ReimburseMny = sumReimburseMny == null ? BigDecimal.ZERO : sumReimburseMny;
        BigDecimal BackMny = sumBackMny == null ? BigDecimal.ZERO : sumBackMny;
        return ApplyMny.subtract(ReimburseMny).subtract(BackMny);
    }

    @Override
    public List<LoadApplyVO> queryUserReport() {
        Long tenantId = InvocationInfoProxy.getTenantid();
        String userId = InvocationInfoProxy.getEmployeeId();
        List<LoadApplyVO> list = ((LoadApplyMapper)this.baseMapper).getUserReport(tenantId, userId);
        return list;
    }

    @Override
    public List<LoadApplyVO> queryAllReport(Page pages, QueryWrapper queryWrapper) {
        List<LoadApplyVO> listres = ((LoadApplyMapper)this.baseMapper).getReports(pages, queryWrapper);
        return listres;
    }

    @Override
    public ParamsCheckSpreadVO checkParams(LoadApplyVO vo) {
        Long curOrgId = Optional.ofNullable(vo.getOrgId()).orElse(InvocationInfoProxy.getOrgId());
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        HashMap<String, List<ParamsCheckDsSpreadVO>> paramsCheckVOMap = new HashMap<String, List<ParamsCheckDsSpreadVO>>();
        paramsCheckVOMap.put("alert", new ArrayList());
        paramsCheckVOMap.put("warn", new ArrayList());
        ParamsCheckSpreadVO paramsCheckVO = new ParamsCheckSpreadVO();
        CommonResponse response1 = this.paramConfigApi.getBillParamByCodeAndOrgId(CAN_USE_MNY_CHECK_CODE, curOrgId);
        if (!response1.isSuccess()) {
            this.logger.info(response1.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        BigDecimal applyMny = vo.getApplyMny();
        List billParamVOS1 = (List)response1.getData();
        if (CollectionUtils.isNotEmpty((Collection)billParamVOS1)) {
            for (BillParamVO billParamVO : billParamVOS1) {
                BigDecimal roleValue = billParamVO.getRoleValue();
                BigDecimal surplusApplyMny = ComputeUtil.safeMultiply((BigDecimal)roleValue.divide(BigDecimal.valueOf(100L)), (BigDecimal)vo.getProSurplusApplyMny());
                if (!ComputeUtil.isGreaterThan((BigDecimal)applyMny, (BigDecimal)surplusApplyMny)) continue;
                ParamsCheckDsSpreadVO paramsCheckDsVO = new ParamsCheckDsSpreadVO();
                paramsCheckDsVO.setWarnItem("\u5907\u7528\u91d1\u7533\u8bf7\u989d\u8d85\u9879\u76ee\u53ef\u7528\u8d44\u91d1");
                paramsCheckDsVO.setWarnName("\u672c\u671f\u7533\u8bf7\u91d1\u989d\u5927\u4e8e\u5269\u4f59\u53ef\u7533\u8bf7\u91d1\u989d");
                paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("\u672c\u6b21\u7533\u8bf7\u91d1\u989d\uff1a").append(ComputeUtil.scaleTwo((BigDecimal)applyMny)).append("\u5143\uff0c\u5269\u4f59\u53ef\u7533\u8bf7\u91d1\u989d*").append(roleValue.setScale(2, 4)).append("%:").append(surplusApplyMny.setScale(2, 4)).append("\u5143\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(ComputeUtil.scaleTwo((BigDecimal)ComputeUtil.safeSub((BigDecimal)applyMny, (BigDecimal)surplusApplyMny))).append("\u5143");
                paramsCheckDsVO.setContent(stringBuffer.toString());
                LoadApplyServiceImpl.updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)((Collection)paramsCheckVOMap.get("alert")))) {
            paramsCheckVO.setWarnType("alert");
            paramsCheckVO.getDataSource().addAll((Collection)paramsCheckVOMap.get("alert"));
        } else if (CollectionUtils.isNotEmpty((Collection)((Collection)paramsCheckVOMap.get("warn")))) {
            paramsCheckVO.setWarnType("warn");
            paramsCheckVO.getDataSource().addAll((Collection)paramsCheckVOMap.get("warn"));
        }
        return paramsCheckVO;
    }

    public static void updateParamsCheckVOMap(String[] paramsArray, Map<String, List<ParamsCheckDsSpreadVO>> paramsCheckVOMap, BillParamVO billParamVO, ParamsCheckDsSpreadVO paramsCheckDsVO) {
        if ("alert".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsSpreadVO> alert = paramsCheckVOMap.get("alert");
            alert.add(paramsCheckDsVO);
        }
        if ("warn".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsSpreadVO> warn = paramsCheckVOMap.get("warn");
            warn.add(paramsCheckDsVO);
        }
    }
}

