/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.service.impl;

import com.ejianc.business.finance.bean.PayInvoiceEntity;
import com.ejianc.business.finance.mapper.PayInvoiceMapper;
import com.ejianc.business.finance.service.IPayInvoiceService;
import com.ejianc.business.finance.utils.BigDecimalUtil;
import com.ejianc.business.finance.vo.PayInvoiceUseVO;
import com.ejianc.business.finance.vo.PayInvoiceVO;
import com.ejianc.business.tax.api.IInvoiceApi;
import com.ejianc.business.tax.vo.InvoiceReceiveFlagVO;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PayInvoiceServiceImpl
extends BaseServiceImpl<PayInvoiceMapper, PayInvoiceEntity>
implements IPayInvoiceService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IInvoiceApi invoiceApi;

    @Override
    public CommonResponse<String> updateInvoiceUsedMnyBySave(List<PayInvoiceVO> voList, Long id) {
        CommonResponse res = CommonResponse.success();
        QueryParam param = new QueryParam();
        param.getParams().put("payapplyId", new Parameter("eq", (Object)id));
        List oldInvoiceList = id != null ? this.queryList(param, false) : null;
        HashMap invoiceUpdateMap = new HashMap();
        if (CollectionUtils.isNotEmpty(voList)) {
            HashMap oldInvoiceMap = CollectionUtils.isNotEmpty((Collection)oldInvoiceList) ? oldInvoiceList.stream().collect(Collectors.toMap(PayInvoiceEntity::getInvoiceId, PayInvoiceEntity::getUsedInvoiceTaxMny)) : new HashMap();
            voList.forEach(t -> {
                Long invoiceId = t.getInvoiceId();
                BigDecimal nowUesdInvoiceTaxMny = (BigDecimal)invoiceUpdateMap.get(invoiceId);
                nowUesdInvoiceTaxMny = "del".equals(t.getRowState()) && t.getId() != null ? ComputeUtil.safeAdd((BigDecimal)nowUesdInvoiceTaxMny, (BigDecimal)BigDecimalUtil.convertToMinusNumber((BigDecimal)oldInvoiceMap.get(invoiceId))) : ComputeUtil.safeAdd((BigDecimal)nowUesdInvoiceTaxMny, (BigDecimal)BigDecimalUtil.safeSub(t.getUsedInvoiceTaxMny(), (BigDecimal)oldInvoiceMap.get(invoiceId)));
                invoiceUpdateMap.put(invoiceId, nowUesdInvoiceTaxMny);
                oldInvoiceMap.remove(invoiceId);
            });
            if (oldInvoiceMap != null && oldInvoiceMap.size() > 0) {
                for (Map.Entry t2 : oldInvoiceMap.entrySet()) {
                    invoiceUpdateMap.put(t2.getKey(), BigDecimalUtil.convertToMinusNumber((BigDecimal)t2.getValue()));
                }
            }
        } else if (CollectionUtils.isNotEmpty((Collection)oldInvoiceList)) {
            oldInvoiceList.forEach(t -> invoiceUpdateMap.put(t.getInvoiceId(), BigDecimalUtil.convertToMinusNumber(t.getUsedInvoiceTaxMny())));
        }
        if (!invoiceUpdateMap.isEmpty()) {
            ArrayList<InvoiceReceiveFlagVO> invoiceReceiveFlagVOS = new ArrayList<InvoiceReceiveFlagVO>();
            for (Map.Entry t2 : invoiceUpdateMap.entrySet()) {
                InvoiceReceiveFlagVO v = new InvoiceReceiveFlagVO();
                v.setId((Long)t2.getKey());
                v.setNowUesdInvoiceTaxMny((BigDecimal)t2.getValue());
                invoiceReceiveFlagVOS.add(v);
            }
            res = this.invoiceApi.updateUsedInvoiceMny(invoiceReceiveFlagVOS);
            if (!res.isSuccess()) {
                this.logger.error("\u56de\u5199\u6536\u7968\u5df2\u4f7f\u7528\u91d1\u989d\u5931\u8d25\uff1a" + res.getMsg());
            }
        }
        return res;
    }

    @Override
    public CommonResponse<String> updateInvoiceUsedMnyByDel(List<Long> ids) {
        QueryParam param = new QueryParam();
        param.getParams().put("payapplyId", new Parameter("in", ids));
        List invoiceEntityList = this.queryList(param, false);
        if (CollectionUtils.isNotEmpty((Collection)invoiceEntityList)) {
            ArrayList updates = new ArrayList();
            invoiceEntityList.forEach(t -> {
                InvoiceReceiveFlagVO v = new InvoiceReceiveFlagVO();
                v.setId(t.getInvoiceId());
                v.setNowUesdInvoiceTaxMny(BigDecimalUtil.convertToMinusNumber(t.getUsedInvoiceTaxMny()));
                updates.add(v);
            });
            CommonResponse res = this.invoiceApi.updateUsedInvoiceMny(updates);
            if (!res.isSuccess()) {
                this.logger.error("\u4ed8\u6b3e\u7533\u8bf7\u5220\u9664\u9006\u56de\u5199\u6536\u7968\u5df2\u4f7f\u7528\u91d1\u989d\u62a5\u9519\uff1a" + res.getMsg());
            }
        }
        return CommonResponse.success();
    }

    @Override
    public List<PayInvoiceUseVO> queryUseList(Long invoiceId) {
        return ((PayInvoiceMapper)this.baseMapper).queryUseList(invoiceId);
    }

    @Override
    public List<PayInvoiceUseVO> countUseNum(List<Long> invoiceIds) {
        return ((PayInvoiceMapper)this.baseMapper).countUseNum(invoiceIds);
    }

    @Override
    public List<PayInvoiceUseVO> countOpenUseNum(List<Long> invoiceIds) {
        return ((PayInvoiceMapper)this.baseMapper).countOpenUseNum(invoiceIds);
    }

    @Override
    public List<PayInvoiceUseVO> queryOpenUseList(Long invoiceId) {
        return ((PayInvoiceMapper)this.baseMapper).queryOpenUseList(invoiceId);
    }
}

