/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.service.impl;

import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.bank.consts.BankFlowSourceType;
import com.ejianc.business.bank.service.IBankFlowService;
import com.ejianc.business.bank.vo.BankFlowVO;
import com.ejianc.business.budget.api.IBudgetProjectProApi;
import com.ejianc.business.budget.vo.BudgetProjectProParamControlVO;
import com.ejianc.business.budget.vo.BudgetProjectProQuantityAndMnyVO;
import com.ejianc.business.budget.vo.cons.CostTypeEnum;
import com.ejianc.business.cost.api.ICostDetailApi;
import com.ejianc.business.cost.vo.CostDetailVO;
import com.ejianc.business.equipment.api.IEquipmentContractApi;
import com.ejianc.business.equipment.api.ISettlementApi;
import com.ejianc.business.finance.bean.PayInfoEntity;
import com.ejianc.business.finance.bean.PayInvoiceEntity;
import com.ejianc.business.finance.bean.PayRecordEntity;
import com.ejianc.business.finance.bean.PayReimburseEntity;
import com.ejianc.business.finance.bean.ReimburseShareCostDetailEntity;
import com.ejianc.business.finance.bean.ReimburseShareEntity;
import com.ejianc.business.finance.controller.api.PayContractApi;
import com.ejianc.business.finance.enums.ReceiveInvoiceFlagConst;
import com.ejianc.business.finance.mapper.LoadReimburseMapper;
import com.ejianc.business.finance.mapper.PayReimburseMapper;
import com.ejianc.business.finance.mapper.PaySporadicMapper;
import com.ejianc.business.finance.service.ILoadReimburseService;
import com.ejianc.business.finance.service.IPayInfoService;
import com.ejianc.business.finance.service.IPayInvoiceService;
import com.ejianc.business.finance.service.IPayRecordService;
import com.ejianc.business.finance.service.IPayReimburseService;
import com.ejianc.business.finance.service.IPaySporadicService;
import com.ejianc.business.finance.service.IReimburseShareService;
import com.ejianc.business.finance.util.BillTypeCodeEnum;
import com.ejianc.business.finance.util.MathUtil;
import com.ejianc.business.finance.util.ValidateUtil;
import com.ejianc.business.finance.utils.DateUtil;
import com.ejianc.business.finance.utils.FeignUtil;
import com.ejianc.business.finance.utils.NumberToCN;
import com.ejianc.business.finance.vo.LoadReimburseVO;
import com.ejianc.business.finance.vo.ParamsCheckDsSpreadVO;
import com.ejianc.business.finance.vo.ParamsCheckSpreadVO;
import com.ejianc.business.finance.vo.PayInfoVO;
import com.ejianc.business.finance.vo.PayInvoiceVO;
import com.ejianc.business.finance.vo.PayRecordVO;
import com.ejianc.business.finance.vo.PayReimburseStatisticsVO;
import com.ejianc.business.finance.vo.PayReimburseVO;
import com.ejianc.business.finance.vo.PaySporadicVO;
import com.ejianc.business.finance.vo.ProjectFinanceVO;
import com.ejianc.business.finance.vo.ProjectReimburseVO;
import com.ejianc.business.finance.vo.TotalColumnVO;
import com.ejianc.business.income.api.IIncomeContractApi;
import com.ejianc.business.income.consts.EJCDateUtil;
import com.ejianc.business.material.api.IMaterialContractApi;
import com.ejianc.business.other.api.IOtherContractApi;
import com.ejianc.business.rmat.api.IRmatContractApi;
import com.ejianc.business.sub.api.ISubContractApi;
import com.ejianc.business.tax.api.IInvoiceApi;
import com.ejianc.business.tax.vo.InvoiceReceiveFlagVO;
import com.ejianc.foundation.metadata.vo.CustomBusinessDataVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.extdata.service.ICustomBusinessDataService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PayReimburseServiceImpl
extends BaseServiceImpl<PayReimburseMapper, PayReimburseEntity>
implements IPayReimburseService {
    private static final String REIM_PAYAPPLY_BILL_CODE = "REIM_PAYAPPLY";
    private static final String CAN_USE_MNY_CHECK_CODE = "P-M478G960";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IPayInvoiceService invoiceService;
    @Autowired
    private IOtherContractApi otherContractApi;
    @Autowired
    private IPayRecordService payRecordService;
    @Autowired
    private IInvoiceApi invoiceApi;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private FeignUtil feignUtil;
    @Autowired
    private PayContractApi payContractApi;
    @Autowired
    private ISettlementApi iSettlementApi;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IBudgetProjectProApi budgetProjectProApi;
    @Autowired
    private IPaySporadicService paySporadicService;
    @Autowired
    private ILoadReimburseService loadReimburseService;
    private static final String PARAM_TOTAL_MNY = "P-6zD11147";
    private static final String SGHTZJE_K_SJZCJE = "P-nkX4Sk61";
    @Autowired
    private IIncomeContractApi incomeContractApi;
    @Autowired
    private ISubContractApi subContractApi;
    @Autowired
    private IMaterialContractApi materialContractApi;
    @Autowired
    private IRmatContractApi rmatContractApi;
    @Autowired
    private IEquipmentContractApi equipmentContractApi;
    @Autowired
    private PaySporadicMapper paySporadicMapper;
    @Autowired
    private LoadReimburseMapper loadReimburseMapper;
    @Autowired
    private IReimburseShareService reimburseShareService;
    @Autowired
    private IBankFlowService bankFlowService;
    @Autowired
    private ICustomBusinessDataService customBusinessDataService;
    @Value(value="${extend.field.mode:false}")
    private Boolean extFieldsMode;
    @Autowired
    private IPayInfoService payInfoService;

    @Override
    public PayReimburseVO insertOrUpdate(PayReimburseVO vo) {
        CommonResponse<String> usedMnyRes;
        List payInfoList = vo.getPayInfoList();
        if (CollectionUtils.isNotEmpty((Collection)payInfoList)) {
            String feeTypeNames = payInfoList.stream().filter(s -> !"del".equals(s.getRowState())).map(PayInfoVO::getFeeTypeName).distinct().collect(Collectors.joining(","));
            String feeTypeIds = payInfoList.stream().filter(s -> !"del".equals(s.getRowState())).map(e -> e.getFeeType().toString()).distinct().collect(Collectors.joining(","));
            vo.setSubFeeTypeNames(StringUtils.isBlank((String)feeTypeNames) ? null : feeTypeNames);
            vo.setSubFeeTypeIds(feeTypeIds);
        } else {
            vo.setSubFeeTypeNames(null);
        }
        PayReimburseEntity entity = (PayReimburseEntity)((Object)BeanMapper.map((Object)vo, PayReimburseEntity.class));
        this.autoSetBillCode(entity);
        entity.setProportionFlag("0");
        entity.setRelationFlag("0");
        entity.setQuoteFlag(0);
        List voList = vo.getInvoiceVOList();
        if (CollectionUtils.isNotEmpty((Collection)voList)) {
            for (PayInvoiceVO invoiceVO : voList) {
                if (ValidateUtil.validateUpstreamVersion((String)String.valueOf(invoiceVO.getInvoiceId()), (String)BillTypeCodeEnum.\u7a0e\u52a1\u6536\u7968.getBillTypeCode(), (Integer)invoiceVO.getInvoiceVersion()).booleanValue()) continue;
                throw new BusinessException("\u53d1\u7968\u5df2\u88ab\u66f4\u65b0\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u505a\uff01");
            }
        }
        if (!(usedMnyRes = this.invoiceService.updateInvoiceUsedMnyBySave(voList, entity.getId())).isSuccess()) {
            throw new BusinessException(usedMnyRes.getMsg());
        }
        entity.setReceiveInvoiceFlag(ReceiveInvoiceFlagConst.NO);
        super.saveOrUpdateNoES((Object)entity);
        Long id = entity.getId();
        List invoiceVOList = this.updateInvoiceVOS(vo, id);
        PayReimburseEntity byId = (PayReimburseEntity)((Object)super.selectById((Serializable)id));
        PayReimburseVO backVO = (PayReimburseVO)BeanMapper.map((Object)((Object)byId), PayReimburseVO.class);
        if (entity.getId() != null) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"payapply_id", (Object)entity.getId());
            invoiceVOList = this.invoiceService.list((Wrapper)wrapper);
        }
        backVO.setInvoiceVOList(BeanMapper.mapList(invoiceVOList, PayInvoiceVO.class));
        ProjectFinanceVO v = (ProjectFinanceVO)BeanMapper.map((Object)((Object)byId), ProjectFinanceVO.class);
        backVO.setProjectFinanceVO(v);
        return backVO;
    }

    private List<PayInvoiceVO> updateInvoiceVOS(PayReimburseVO vo, Long id) {
        List delIds;
        List voList = vo.getInvoiceVOList();
        ArrayList<InvoiceReceiveFlagVO> flagVOS = new ArrayList<InvoiceReceiveFlagVO>();
        ArrayList<Long> receiveIds = new ArrayList<Long>();
        if (voList != null && !voList.isEmpty()) {
            for (PayInvoiceVO invoiceVO : voList) {
                InvoiceReceiveFlagVO flagVO = new InvoiceReceiveFlagVO();
                flagVO.setId(invoiceVO.getInvoiceId());
                flagVO.setFlag(Integer.valueOf(1));
                flagVOS.add(flagVO);
                receiveIds.add(invoiceVO.getInvoiceId());
                invoiceVO.setPayapplyId(id);
            }
            List entityList = BeanMapper.mapList((Iterable)voList, PayInvoiceEntity.class);
            this.invoiceService.saveOrUpdateBatch(entityList, entityList.size(), false);
            voList = BeanMapper.mapList((Iterable)entityList, PayInvoiceVO.class);
        }
        List dataList = this.invoiceService.list((Wrapper)new QueryWrapper().eq((Object)"payapply_id", (Object)id));
        List dataIds = dataList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty((Collection)voList)) {
            List voIds = voList.stream().map(BaseVO::getId).collect(Collectors.toList());
            dataIds.removeAll(voIds);
        }
        if (!(delIds = dataIds).isEmpty()) {
            this.invoiceService.remove((Wrapper)new QueryWrapper().in((Object)"id", delIds), false);
        }
        return voList;
    }

    @Override
    public PayReimburseVO queryDetail(Long id) {
        PayReimburseEntity entity = (PayReimburseEntity)((Object)this.selectById(id));
        PayReimburseVO vo = (PayReimburseVO)BeanMapper.map((Object)((Object)entity), PayReimburseVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("payapplyId", new Parameter("eq", (Object)vo.getId()));
        queryParam.getOrderMap().put("createTime", "desc");
        List invoiceEntityList = this.invoiceService.queryList(queryParam, false);
        vo.setInvoiceVOList(BeanMapper.mapList((Iterable)invoiceEntityList, PayInvoiceVO.class));
        List recordList = this.payRecordService.queryList(queryParam);
        vo.setRecordList(BeanMapper.mapList((Iterable)recordList, PayRecordVO.class));
        vo.setProjectFinanceVO((ProjectFinanceVO)BeanMapper.map((Object)vo, ProjectFinanceVO.class));
        if (null != vo.getPayMny()) {
            vo.setPayMnyCn(NumberToCN.number2CN(vo.getPayMny()));
        }
        return vo;
    }

    @Override
    public List<PayReimburseVO> queryExportList(QueryParam param) {
        param.setPageIndex(0);
        param.setPageSize(-1);
        List resVos = (List)this.querySubExcelList(param, false).get((Object)"records");
        if (!resVos.isEmpty()) {
            for (int i = 0; i < resVos.size(); ++i) {
                PayReimburseVO vo = (PayReimburseVO)resVos.get(i);
                vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
                vo.setIsShareFlagName(vo.getIsShareFlag() != null && vo.getIsShareFlag() == 1 ? "\u662f" : "\u5426");
            }
        }
        return resVos;
    }

    @Override
    public String delete(List<Long> ids) {
        CommonResponse<String> res;
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("id", new Parameter("in", ids));
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List entityList = super.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)entityList) && (res = this.invoiceService.updateInvoiceUsedMnyByDel(ids)).isSuccess()) {
            super.removeByIds(ids, false);
            QueryWrapper wrapper = (QueryWrapper)new QueryWrapper().in((Object)"payapply_id", ids);
            List invoiceList = this.invoiceService.list((Wrapper)wrapper);
            this.invoiceService.remove((Wrapper)wrapper, false);
        }
        return "\u5220\u9664\u6210\u529f\uff01";
    }

    @Override
    public JSONObject queryPageJson(QueryParam param, boolean isEs) {
        CommonResponse customBusinessDataResponse;
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("applyUserName");
        fuzzyFields.add("accountName");
        fuzzyFields.add("payReason");
        fuzzyFields.add("bearDept");
        fuzzyFields.add("payUnitName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("payReason");
        fuzzyFields.add("applyMny");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (!param.getParams().containsKey("orgId")) {
            UserContext userContext = this.sessionManager.getUserContext();
            String authOrgIds = userContext.getAuthOrgIds();
            this.logger.info(">>>>>>>>>>>>>>>>>>>>>>1authOrgIds:{}", (Object)authOrgIds);
            if (StringUtils.isNotEmpty((String)authOrgIds)) {
                CommonResponse authResponse = this.orgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList()));
                this.logger.info(">>>>>>>>>>>>>>>>>>>>>>2authOrgIds:{}, authResponse.getData():{}", (Object)authOrgIds, authResponse.getData() == null ? null : Integer.valueOf(((List)authResponse.getData()).size()));
                param.getParams().put("orgId", new Parameter("in", ((List)authResponse.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            } else {
                param.getParams().put("orgId", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            }
        }
        Parameter parameterFlag = (Parameter)param.getParams().get("relationInvoiceFlag");
        param.getParams().remove("relationInvoiceFlag");
        String flag = parameterFlag == null ? null : parameterFlag.getValue().toString();
        Page pages = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        String feeType = null;
        if (param.getParams().containsKey("feeType")) {
            feeType = ((Parameter)param.getParams().get("feeType")).getValue().toString();
            param.getParams().remove("feeType");
            param.getParams().put("sub_fee_type_ids", new Parameter("like", (Object)feeType));
        }
        QueryWrapper wrapper = PayReimburseServiceImpl.changeToQueryWrapper((QueryParam)param);
        wrapper.groupBy(new Object[]{"a.id"});
        List<PayReimburseVO> list = ((PayReimburseMapper)this.baseMapper).queryPageList(pages, wrapper, flag);
        ArrayList businessIdList = new ArrayList();
        list.forEach(vo -> {
            if (null != vo.getApplyMny()) {
                vo.setUnpaidMny(vo.getApplyMny().subtract(vo.getPayMny() == null ? BigDecimal.ZERO : vo.getPayMny()));
            }
            businessIdList.add(vo.getId());
        });
        if (this.extFieldsMode.booleanValue() && ListUtil.isNotEmpty(businessIdList) && (customBusinessDataResponse = this.customBusinessDataService.queryCustomBusinessData(businessIdList)).isSuccess()) {
            Map customBusinessDataMap = (Map)customBusinessDataResponse.getData();
            for (PayReimburseVO payReimburseVO : list) {
                CustomBusinessDataVO subCustomBusinessDataVo = (CustomBusinessDataVO)customBusinessDataMap.get(payReimburseVO.getId());
                if (subCustomBusinessDataVo == null) continue;
                JSONObject subCustomField = JSONObject.parseObject((String)subCustomBusinessDataVo.getBusinessData());
                payReimburseVO.setCustomField((Map)subCustomField);
            }
        }
        JSONObject page = new JSONObject();
        page.put("records", list);
        page.put("total", (Object)pages.getTotal());
        page.put("current", (Object)pages.getCurrent());
        page.put("size", (Object)pages.getSize());
        page.put("pages", (Object)pages.getPages());
        return page;
    }

    @Override
    public JSONObject querySubExcelList(QueryParam param, boolean isEs) {
        boolean feeTypeIsNull;
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("applyUserName");
        fuzzyFields.add("accountName");
        fuzzyFields.add("payReason");
        fuzzyFields.add("bearDept");
        fuzzyFields.add("payUnitName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("payReason");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (!param.getParams().containsKey("orgId")) {
            UserContext userContext = this.sessionManager.getUserContext();
            String authOrgIds = userContext.getAuthOrgIds();
            this.logger.info(">>>>>>>>>>>>>>>>>>>>>>1authOrgIds:{}", (Object)authOrgIds);
            if (StringUtils.isNotEmpty((String)authOrgIds)) {
                CommonResponse authResponse = this.orgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList()));
                this.logger.info(">>>>>>>>>>>>>>>>>>>>>>2authOrgIds:{}, authResponse.getData():{}", (Object)authOrgIds, authResponse.getData() == null ? null : Integer.valueOf(((List)authResponse.getData()).size()));
                param.getParams().put("orgId", new Parameter("in", ((List)authResponse.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            } else {
                param.getParams().put("orgId", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            }
        }
        Parameter parameterFlag = (Parameter)param.getParams().get("relationInvoiceFlag");
        param.getParams().remove("relationInvoiceFlag");
        String flag = parameterFlag == null ? null : parameterFlag.getValue().toString();
        Page pages = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        String feeType = null;
        if (param.getParams().containsKey("feeType")) {
            feeType = ((Parameter)param.getParams().get("feeType")).getValue().toString();
            param.getParams().remove("feeType");
            param.getParams().put("sub_fee_type_ids", new Parameter("like", (Object)feeType));
        }
        if (feeTypeIsNull = param.getParams().containsKey("feeTypeIsNull")) {
            param.getParams().remove("feeTypeIsNull");
        }
        QueryWrapper wrapper = PayReimburseServiceImpl.changeToQueryWrapper((QueryParam)param);
        wrapper.eq(StringUtils.isNotBlank((String)feeType), (Object)"a.pft", (Object)feeType);
        wrapper.isNull(feeTypeIsNull, (Object)"a.pft");
        List<PayReimburseVO> list = ((PayReimburseMapper)this.baseMapper).querySubExcelList(pages, wrapper, flag);
        list.forEach(vo -> {
            if (null != vo.getApplyMny()) {
                vo.setUnpaidMny(vo.getApplyMny().subtract(vo.getPayMny() == null ? BigDecimal.ZERO : vo.getPayMny()));
            }
        });
        JSONObject page = new JSONObject();
        page.put("records", list);
        page.put("total", (Object)pages.getTotal());
        page.put("current", (Object)pages.getCurrent());
        page.put("size", (Object)pages.getSize());
        page.put("pages", (Object)pages.getPages());
        return page;
    }

    @Override
    public Map<String, Object> countAmt(Long tenantId, List<Long> projectIds) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select(new String[]{"ifnull(sum(pay_mny),0) as amt"});
        queryWrapper.eq((Object)"tenant_id", (Object)tenantId);
        queryWrapper.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        queryWrapper.eq((Object)"pay_type", (Object)2);
        queryWrapper.eq((Object)"pay_status", (Object)2);
        if (CollectionUtils.isNotEmpty(projectIds)) {
            queryWrapper.in((Object)"project_id", projectIds);
        }
        queryWrapper.in((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        List<Object> orgIds = new ArrayList();
        UserContext userContext = this.sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (StringUtils.isNotEmpty((String)authOrgIds)) {
            CommonResponse authResponse = this.orgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList()));
            orgIds = ((List)authResponse.getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        } else {
            orgIds = ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        }
        if (ListUtil.isNotEmpty(orgIds)) {
            queryWrapper.in((Object)"org_id", orgIds);
        }
        return super.getMap((Wrapper)queryWrapper);
    }

    @Override
    public CommonResponse<PayReimburseVO> pushCost(PayReimburseVO payReimburseVO) {
        PayReimburseEntity payReimburseEntity = (PayReimburseEntity)((Object)((PayReimburseMapper)this.baseMapper).selectById(payReimburseVO.getId()));
        payReimburseEntity.setPayInfoList(BeanMapper.mapList((Iterable)payReimburseVO.getPayInfoList(), PayInfoEntity.class));
        super.saveOrUpdate((Object)payReimburseEntity, false);
        this.costPush(payReimburseEntity);
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)payReimburseEntity), PayReimburseVO.class));
    }

    @Override
    public void costPush(PayReimburseEntity payReimburseEntity) {
        this.logger.info("\u63a8\u9001\u5f00\u59cb:{}", (Object)JSONObject.toJSONString((Object)payReimburseEntity.getId()));
        if ("0".equals(payReimburseEntity.getDependOnProject())) {
            return;
        }
        boolean newRelationFlag = true;
        List<PayInfoEntity> payInfoList = payReimburseEntity.getPayInfoList();
        this.costDetailApi.deleteSubject(payReimburseEntity.getId());
        if (CollectionUtils.isNotEmpty(payInfoList)) {
            for (PayInfoEntity payInfoEntity : payInfoList) {
                if (payInfoEntity.getSubjectId() != null) continue;
                newRelationFlag = false;
                break;
            }
        }
        this.saveCost(payReimburseEntity);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)payReimburseEntity.getId());
        updateWrapper.set(PayReimburseEntity::getRelationFlag, (Object)(newRelationFlag ? "1" : "0"));
        super.update((Wrapper)updateWrapper);
    }

    private void saveCost(PayReimburseEntity entity) {
        this.logger.info("\u63a8\u9001\u8f6c\u6362:{}", (Object)JSON.toJSONString((Object)entity.getId()));
        ArrayList<CostDetailVO> costDetailVOList = new ArrayList<CostDetailVO>();
        List<PayInfoEntity> payInfoList = entity.getPayInfoList();
        if (CollectionUtils.isNotEmpty(payInfoList)) {
            BigDecimal payMny = entity.getPayMny();
            BigDecimal applyMny = entity.getApplyMny();
            BigDecimal payedMny = BigDecimal.ZERO;
            boolean partPayFlag = com.ejianc.business.utils.ComputeUtil.isLessThan((BigDecimal)payMny, (BigDecimal)applyMny);
            int i = 0;
            for (PayInfoEntity payInfoEntity : payInfoList) {
                CostDetailVO costDetailVO = new CostDetailVO();
                costDetailVO.setSubjectId(payInfoEntity.getSubjectId());
                costDetailVO.setSourceId(entity.getId());
                costDetailVO.setSourceDetailId(payInfoEntity.getId());
                ++i;
                if (partPayFlag) {
                    if (i == payInfoList.size()) {
                        BigDecimal surPayMny = com.ejianc.business.utils.ComputeUtil.safeSub((BigDecimal)payMny, (BigDecimal)payedMny);
                        costDetailVO.setHappenTaxMny(surPayMny);
                        costDetailVO.setHappenMny(surPayMny);
                    } else {
                        BigDecimal feeTaxMny = payInfoEntity.getFeeTaxMny();
                        BigDecimal ratio = com.ejianc.business.utils.ComputeUtil.safeDiv((BigDecimal)feeTaxMny, (BigDecimal)applyMny);
                        BigDecimal happenTaxMny = com.ejianc.business.utils.ComputeUtil.scaleTwo((BigDecimal)com.ejianc.business.utils.ComputeUtil.safeMultiply((BigDecimal)ratio, (BigDecimal)payMny));
                        costDetailVO.setHappenTaxMny(happenTaxMny);
                        costDetailVO.setHappenMny(happenTaxMny);
                        payedMny = com.ejianc.business.utils.ComputeUtil.safeAdd((BigDecimal)payedMny, (BigDecimal)happenTaxMny);
                    }
                } else {
                    costDetailVO.setHappenTaxMny(payInfoEntity.getFeeTaxMny());
                    costDetailVO.setHappenMny(payInfoEntity.getFeeTaxMny());
                }
                costDetailVO.setHappenDate(payInfoEntity.getFeeHappenDate());
                costDetailVO.setCreateUserName(this.sessionManager.getUserContext().getUserName());
                costDetailVO.setSourceType(REIM_PAYAPPLY_BILL_CODE);
                costDetailVO.setSourceTabType(REIM_PAYAPPLY_BILL_CODE);
                costDetailVO.setProjectId(entity.getProjectId());
                DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM");
                LocalDate settlementDate = LocalDate.now();
                settlementDate = ObjectUtil.isNotNull((Object)entity.getApplyTime()) ? entity.getApplyTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDate() : entity.getCreateTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                costDetailVO.setCostType(CostTypeEnum.INDIRECTION_COST_TYPE.getType());
                costDetailVO.setCostTypeName(CostTypeEnum.INDIRECTION_COST_TYPE.getName());
                costDetailVO.setPeriod(settlementDate.format(df));
                costDetailVO.setShareFlag(Integer.valueOf(0));
                costDetailVO.setSourceBillCode(entity.getBillCode());
                costDetailVO.setSourceBillName("\u8d39\u7528\u62a5\u9500");
                costDetailVO.setSourceBillUrl("/ejc-finance-frontend/#/reimbursePro/reimburseProCard?id=" + entity.getId());
                costDetailVOList.add(costDetailVO);
            }
        }
        if (CollectionUtils.isNotEmpty(costDetailVOList)) {
            CommonResponse stringCommonResponse = this.costDetailApi.saveSubject(costDetailVOList);
            this.logger.info("\u63a8\u9001\u8fd4\u56de\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)stringCommonResponse));
            if (!stringCommonResponse.isSuccess()) {
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        }
    }

    private void autoSetBillCode(PayReimburseEntity entity) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (StringUtils.isEmpty((String)entity.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(REIM_PAYAPPLY_BILL_CODE, tenantId);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(PayReimburseEntity::getBillCode, (Object)entity.getBillCode());
        lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambda.ne(entity.getId() != null && entity.getId() > 0L, BaseEntity::getId, (Object)entity.getId());
        List entityList = super.list((Wrapper)lambda);
        if (entityList != null && entityList.size() > 0) {
            throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
    }

    @Override
    public void pullCost(Long id) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(BaseEntity::getId, new Object[]{id});
        updateWrapper.set(PayReimburseEntity::getRelationFlag, (Object)"0");
        super.update((Wrapper)updateWrapper);
        this.costDetailApi.deleteSubject(id);
    }

    @Override
    public TotalColumnVO getTotalColumnInfo(QueryParam param, boolean isEs) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("applyUserName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (!param.getParams().containsKey("orgId")) {
            param.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().remove("createUserCode");
        }
        if (param.getParams().containsKey("projectId")) {
            param.getParams().remove("createUserCode");
        }
        Parameter parameterFlag = (Parameter)param.getParams().get("relationInvoiceFlag");
        param.getParams().remove("relationInvoiceFlag");
        String flag = parameterFlag == null ? null : parameterFlag.getValue().toString();
        QueryWrapper wrapper = PayReimburseServiceImpl.changeToQueryWrapper((QueryParam)param);
        wrapper.groupBy(new Object[]{"a.id"});
        List<PayReimburseVO> list = ((PayReimburseMapper)this.baseMapper).queryPageList(null, wrapper, flag);
        BigDecimal sumApplyMny = list.stream().filter(entity -> entity.getApplyMny() != null).map(PayReimburseVO::getApplyMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal sumPayMny = list.stream().filter(entity -> entity.getPayMny() != null).map(PayReimburseVO::getPayMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        TotalColumnVO vo = new TotalColumnVO();
        vo.setSumApplyMny(sumApplyMny);
        vo.setSumPayMny(sumPayMny);
        return vo;
    }

    @Override
    public TotalColumnVO getApproveTotalColumnInfo(QueryParam param, boolean isEs) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("applyUserName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        Parameter parameterFlag = (Parameter)param.getParams().get("relationInvoiceFlag");
        param.getParams().remove("relationInvoiceFlag");
        String flag = parameterFlag == null ? null : parameterFlag.getValue().toString();
        QueryWrapper wrapper = PayReimburseServiceImpl.changeToQueryWrapper((QueryParam)param);
        wrapper.groupBy(new Object[]{"a.id"});
        List<PayReimburseVO> list = ((PayReimburseMapper)this.baseMapper).queryPageList(null, wrapper, flag);
        BigDecimal sumApplyMny = list.stream().filter(entity -> entity.getApplyMny() != null).map(PayReimburseVO::getApplyMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal sumPayMny = list.stream().filter(entity -> entity.getPayMny() != null).map(PayReimburseVO::getPayMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        TotalColumnVO vo = new TotalColumnVO();
        vo.setSumApplyMny(sumApplyMny);
        vo.setSumPayMny(sumPayMny);
        return vo;
    }

    @Override
    public List<PayReimburseVO> queryReferData(Page<PayReimburseVO> page, QueryWrapper wrapper) {
        return ((PayReimburseMapper)this.baseMapper).queryReferData(page, wrapper);
    }

    @Override
    public CommonResponse<PayReimburseStatisticsVO> getPayReimburseInfo(Integer dependOnProject) {
        String lastMonthLastDayOfPreviousYear = EJCDateUtil.format((Date)new Date(), (String)"yyyy") + "-12-31";
        String firstDayOfCurrentYear = EJCDateUtil.getFirstDayOfCurrentYear((String)"yyyy-MM-dd");
        List<Object> orgIds = new ArrayList();
        UserContext userContext = this.sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (StringUtils.isNotEmpty((String)authOrgIds)) {
            CommonResponse authResponse = this.orgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList()));
            orgIds = ((List)authResponse.getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        } else {
            orgIds = ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select(new String[]{"IFNULL(SUM(IF((is_share_flag = 0),apply_mny,0)),0)AS applyMny,IFNULL(SUM(IF((is_share_flag = 0),pay_mny,0)),0) AS payMny,IFNULL(SUM(IF((is_share_flag = 0),count_share_mny,0)),0) AS countShareMny,IFNULL(SUM(IF((is_share_flag = 0),invoice_mny,0)),0) AS invoiceMny"});
        queryWrapper.eq((Object)"depend_on_project", (Object)dependOnProject);
        queryWrapper.in((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        queryWrapper.in(CollectionUtils.isNotEmpty(orgIds), (Object)"org_id", orgIds);
        queryWrapper.between((Object)"apply_time", (Object)firstDayOfCurrentYear, (Object)lastMonthLastDayOfPreviousYear);
        PayReimburseEntity one = (PayReimburseEntity)((Object)((PayReimburseMapper)this.baseMapper).selectOne((Wrapper)queryWrapper));
        PayReimburseStatisticsVO payReimburseStatisticsVO = new PayReimburseStatisticsVO();
        payReimburseStatisticsVO.setThisYearApplyMny(one.getApplyMny());
        payReimburseStatisticsVO.setThisYearPayMny(one.getPayMny());
        payReimburseStatisticsVO.setThisYearOrgShareMny(one.getCountShareMny());
        payReimburseStatisticsVO.setThisYearInvoiceMny(one.getInvoiceMny());
        String month = EJCDateUtil.getCurrentDay((String)"yyyy-MM");
        String startMonth = month + "-01";
        String endMonth = month + "-31";
        QueryWrapper thisMonthQueryWrapper = new QueryWrapper();
        thisMonthQueryWrapper.select(new String[]{"IFNULL(SUM(IF((is_share_flag = 0),apply_mny,0)),0)AS applyMny,IFNULL(SUM(IF((is_share_flag = 0),pay_mny,0)),0) AS payMny,IFNULL(SUM(IF((is_share_flag = 0),count_share_mny,0)),0) AS countShareMny,IFNULL(SUM(IF((is_share_flag = 0),invoice_mny,0)),0) AS invoiceMny"});
        thisMonthQueryWrapper.eq((Object)"depend_on_project", (Object)dependOnProject);
        thisMonthQueryWrapper.in((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        thisMonthQueryWrapper.in(CollectionUtils.isNotEmpty(orgIds), (Object)"org_id", orgIds);
        thisMonthQueryWrapper.between((Object)"apply_time", (Object)startMonth, (Object)endMonth);
        PayReimburseEntity thisMonthInfo = (PayReimburseEntity)((Object)((PayReimburseMapper)this.baseMapper).selectOne((Wrapper)thisMonthQueryWrapper));
        payReimburseStatisticsVO.setThisMonthApplyMny(thisMonthInfo.getApplyMny());
        payReimburseStatisticsVO.setThisMonthPayMny(thisMonthInfo.getPayMny());
        payReimburseStatisticsVO.setThisMonthOrgShareMny(thisMonthInfo.getCountShareMny());
        payReimburseStatisticsVO.setThisMonthInvoiceMny(thisMonthInfo.getInvoiceMny());
        return CommonResponse.success((String)"\u83b7\u53d6\u62a5\u9500\u4fe1\u606f\u6210\u529f\uff01", (Object)payReimburseStatisticsVO);
    }

    @Override
    public IPage<PayReimburseStatisticsVO> payReimburseStatisticsList(Page<PayReimburseStatisticsVO> page, QueryWrapper wrapper, String dependOnProject) {
        return ((PayReimburseMapper)this.baseMapper).payReimburseStatisticsList(page, wrapper, dependOnProject);
    }

    @Override
    public List<PayReimburseStatisticsVO> payReimburseStatisticsDetailList(Long projectId, Long orgId, QueryWrapper wrapper) {
        return ((PayReimburseMapper)this.baseMapper).payReimburseStatisticsDetailList(projectId, orgId, wrapper);
    }

    @Override
    public BigDecimal totalBudgetMny(PayReimburseVO vo) {
        BigDecimal applyMny = BigDecimal.ZERO;
        QueryWrapper reimburseQuery = new QueryWrapper();
        reimburseQuery.eq((Object)"project_Id", (Object)vo.getProjectId());
        reimburseQuery.eq((Object)"depend_on_project", (Object)1);
        if (vo.getId() != null) {
            reimburseQuery.ne((Object)"id", (Object)vo.getId());
        }
        if (vo.getApplyMny() != null) {
            applyMny = applyMny.add(vo.getApplyMny());
        }
        reimburseQuery.select(new String[]{"sum(apply_mny) as applyMny"});
        PayReimburseEntity payReimburseEntity = (PayReimburseEntity)((Object)super.getOne((Wrapper)reimburseQuery));
        if (payReimburseEntity != null && null != payReimburseEntity.getApplyMny() && !"0".equals(payReimburseEntity.getApplyMny())) {
            applyMny = applyMny.add(payReimburseEntity.getApplyMny());
        }
        this.logger.info("applyMny:{}", (Object)applyMny);
        return applyMny;
    }

    @Override
    public ParamsCheckSpreadVO checkBudgetParams(PayReimburseVO vo) {
        List billParamVOS;
        Long curOrgId = Optional.ofNullable(vo.getOrgId()).orElse(InvocationInfoProxy.getOrgId());
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        HashMap<String, List<ParamsCheckDsSpreadVO>> paramsCheckVOMap = new HashMap<String, List<ParamsCheckDsSpreadVO>>();
        paramsCheckVOMap.put("alert", new ArrayList());
        paramsCheckVOMap.put("warn", new ArrayList());
        ParamsCheckSpreadVO paramsCheckVO = new ParamsCheckSpreadVO();
        if (vo.getCheckExceedFlag() == null) {
            CommonResponse response1;
            BudgetProjectProParamControlVO requestVo = new BudgetProjectProParamControlVO();
            requestVo.setProjectId(vo.getProjectId());
            requestVo.setCostType(CostTypeEnum.INDIRECTION_COST_TYPE.getType());
            CommonResponse res = this.budgetProjectProApi.fetchQuantityAndMny(requestVo);
            this.logger.info("\u9884\u7b97\u95f4\u63a5\u8d39\u603b\u91d1\u989d \u8fd4\u56de\u5185\u5bb9:{}", (Object)JSONObject.toJSONString((Object)res));
            if (!res.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u9519\u8bef" + res.getMsg());
            }
            if (null != res.getData()) {
                BudgetProjectProQuantityAndMnyVO data = (BudgetProjectProQuantityAndMnyVO)res.getData();
                BigDecimal budgetTaxMny = data.getIndirectionTaxMny() == null ? BigDecimal.ZERO : data.getIndirectionTaxMny();
                CommonResponse response = this.paramConfigApi.getBillParamByCodeAndOrgId(PARAM_TOTAL_MNY, curOrgId);
                if (!response.isSuccess()) {
                    throw new BusinessException(" \u3010\u9884\u7b97\u95f4\u63a5\u8d39\u603b\u91d1\u989d\u3011\u63a7 \u3010\u5b9e\u9645\u95f4\u63a5\u8d39\u603b\u91d1\u989d\u3011\uff0c\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response.getMsg());
                }
                List billParamVOS2 = (List)response.getData();
                if (CollectionUtils.isNotEmpty((Collection)billParamVOS2)) {
                    BigDecimal totalContractMny = this.totalBudgetMny(vo);
                    CommonResponse bigDecimalCommonResponse = this.otherContractApi.budgetControlTotal(vo.getProjectId());
                    this.logger.info("\u9884\u7b97\u95f4\u63a5\u8d39 \u5176\u4ed6\u5408\u540c\u603b\u91d1\u989d \u8fd4\u56de\u5185\u5bb9:{}", (Object)JSONObject.toJSONString((Object)bigDecimalCommonResponse));
                    if (!bigDecimalCommonResponse.isSuccess()) {
                        throw new BusinessException(bigDecimalCommonResponse.getMsg());
                    }
                    totalContractMny = totalContractMny.add((BigDecimal)bigDecimalCommonResponse.getData());
                    PaySporadicVO paySporadic = new PaySporadicVO();
                    paySporadic.setProjectId(vo.getProjectId());
                    totalContractMny = totalContractMny.add(this.paySporadicService.totalBudgetMny(paySporadic));
                    LoadReimburseVO loadReimburse = new LoadReimburseVO();
                    loadReimburse.setProjectId(vo.getProjectId());
                    totalContractMny = totalContractMny.add(this.loadReimburseService.totalBudgetMny(loadReimburse));
                    for (BillParamVO billParamVO : billParamVOS2) {
                        if (0 == billParamVO.getControlType()) continue;
                        BigDecimal roleValue = billParamVO.getRoleValue();
                        BigDecimal scale = roleValue.divide(new BigDecimal("100"));
                        BigDecimal budgetTaxMnyResult = budgetTaxMny.multiply(scale);
                        this.logger.info("\u5907\u7528\u91d1\u62a5\u9500\u603b\u91d1\u989d:{} \u95f4\u63a5\u8d39\u7528:{}", (Object)JSONObject.toJSONString((Object)totalContractMny), (Object)JSONObject.toJSONString((Object)budgetTaxMnyResult));
                        if (totalContractMny.compareTo(budgetTaxMnyResult) <= 0) continue;
                        BigDecimal over = totalContractMny.subtract(budgetTaxMnyResult);
                        ParamsCheckDsSpreadVO paramsCheckDsVO = new ParamsCheckDsSpreadVO();
                        paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                        paramsCheckDsVO.setWarnItem("\u5b9e\u9645\u95f4\u63a5\u8d39\u603b\u91d1\u989d\u8d85\u9884\u7b97\u95f4\u63a5\u8d39\u603b\u91d1\u989d");
                        paramsCheckDsVO.setWarnName("\u5b9e\u9645\u95f4\u63a5\u8d39\u603b\u91d1\u989d\u5927\u4e8e\u9884\u7b97\u95f4\u63a5\u8d39\u603b\u91d1\u989d * " + roleValue + "%");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("\u8be5\u9879\u76ee\u5b9e\u9645\u95f4\u63a5\u8d39\u603b\u91d1\u989d\uff1a").append(totalContractMny.setScale(2, RoundingMode.HALF_UP)).append("\u5143\uff0c \u9884\u7b97\u95f4\u63a5\u8d39\u603b\u91d1\u989d * ").append(roleValue).append("%\uff1a").append(budgetTaxMnyResult.setScale(2, RoundingMode.HALF_UP)).append("\u5143\uff0c\u8d85\u51fa\u91d1\u989d\uff1a").append(over.setScale(2, RoundingMode.HALF_UP)).append("\u5143\u3002");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        PayReimburseServiceImpl.updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                    }
                }
            }
            if (!(response1 = this.paramConfigApi.getBillParamByCodeAndOrgId(CAN_USE_MNY_CHECK_CODE, curOrgId)).isSuccess()) {
                this.logger.info(response1.getMsg());
                throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
            }
            List billParamVOS1 = (List)response1.getData();
            if (CollectionUtils.isNotEmpty((Collection)billParamVOS1)) {
                for (BillParamVO billParamVO : billParamVOS1) {
                    BigDecimal roleValue = billParamVO.getRoleValue();
                    BigDecimal surplusApplyMny = com.ejianc.business.utils.ComputeUtil.safeMultiply((BigDecimal)roleValue.divide(BigDecimal.valueOf(100L)), (BigDecimal)vo.getProSurplusApplyMny());
                    BigDecimal payMny = vo.getApplyMny();
                    if (!com.ejianc.business.utils.ComputeUtil.isGreaterThan((BigDecimal)payMny, (BigDecimal)surplusApplyMny)) continue;
                    ParamsCheckDsSpreadVO paramsCheckDsVO = new ParamsCheckDsSpreadVO();
                    paramsCheckDsVO.setWarnItem("\u4ed8\u6b3e\u7533\u8bf7\u989d\u8d85\u9879\u76ee\u53ef\u7528\u8d44\u91d1");
                    paramsCheckDsVO.setWarnName("\u672c\u671f\u7533\u8bf7\u91d1\u989d\u5927\u4e8e\u5269\u4f59\u53ef\u7533\u8bf7\u91d1\u989d");
                    paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("\u672c\u6b21\u7533\u8bf7\u91d1\u989d\uff1a").append(payMny.setScale(2, 4)).append("\u5143\uff0c\u5269\u4f59\u53ef\u7533\u8bf7\u91d1\u989d*").append(roleValue.setScale(2, 4)).append("%:").append(surplusApplyMny.setScale(2, 4)).append("\u5143\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(payMny.subtract(surplusApplyMny).setScale(2, 4)).append("\u5143");
                    paramsCheckDsVO.setContent(stringBuffer.toString());
                    PayReimburseServiceImpl.updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                }
            }
        }
        BigDecimal costbudgetMny = BigDecimal.ZERO;
        ArrayList<Long> projectIds = new ArrayList<Long>();
        projectIds.add(vo.getProjectId());
        BigDecimal payReimburseMny = BigDecimal.ZERO;
        BigDecimal loadReimburseMny = BigDecimal.ZERO;
        CommonResponse<List<ProjectReimburseVO>> projectReimburse = this.payContractApi.getProjectReimburse(projectIds);
        CommonResponse settleMny = this.iSettlementApi.getSettleMny(projectIds);
        BigDecimal reimburseMmy = com.ejianc.business.utils.ComputeUtil.safeAdd((BigDecimal)payReimburseMny, (BigDecimal[])new BigDecimal[]{loadReimburseMny, vo.getApplyMny()});
        BigDecimal manageMmy = costbudgetMny;
        paramsCheckVO.setManageMmy(manageMmy);
        paramsCheckVO.setReimburseMmy(reimburseMmy);
        CommonResponse sghtkzc = this.paramConfigApi.getBillParamByCodeAndOrgId(SGHTZJE_K_SJZCJE, curOrgId);
        if (sghtkzc.isSuccess() && null != sghtkzc.getData() && CollectionUtils.isNotEmpty((Collection)(billParamVOS = (List)sghtkzc.getData()))) {
            BigDecimal sjzcje = this.getSjzcje(vo.getId(), vo.getProjectId(), vo.getApplyMny());
            CommonResponse res996 = this.incomeContractApi.fetchSghtzje(vo.getProjectId());
            if (!res996.isSuccess()) {
                throw new BusinessException("\u83b7\u53d6\u65bd\u5de5\u5408\u540c\u5de5\u603b\u91d1\u989d\u5931\u8d25");
            }
            BigDecimal sght = (BigDecimal)res996.getData();
            for (BillParamVO billParamVO : billParamVOS) {
                BigDecimal roleValue;
                BigDecimal scale;
                BigDecimal sghtzje;
                if (0 == billParamVO.getControlType() || sjzcje.compareTo(sghtzje = NumberUtil.mul((Number)sght, (Number)(scale = NumberUtil.div((Number)(roleValue = billParamVO.getRoleValue()), (Number)new BigDecimal("100"), (int)8)))) <= 0) continue;
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("\u8be5\u9879\u76ee\u5b9e\u9645\u652f\u51fa\u603b\u91d1\u989d\uff1a").append(sjzcje.setScale(2, RoundingMode.HALF_UP)).append("\uff0c\u65bd\u5de5\u5408\u540c\u5de5\u603b\u91d1\u989d*").append(roleValue).append("%\uff1a").append(sghtzje.setScale(2, RoundingMode.HALF_UP)).append("\uff0c\u8d85\u51fa\u91d1\u989d\uff1a").append(ComputeUtil.safeSub((BigDecimal)sjzcje, (BigDecimal)sghtzje).setScale(2, RoundingMode.HALF_UP));
                ParamsCheckDsSpreadVO paramsCheckDsVO = new ParamsCheckDsSpreadVO();
                paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                paramsCheckDsVO.setWarnItem("\u5b9e\u9645\u652f\u51fa\u603b\u91d1\u989d\u8d85\u65bd\u5de5\u5408\u540c\u603b\u91d1\u989d");
                paramsCheckDsVO.setWarnName("\u5b9e\u9645\u652f\u51fa\u603b\u91d1\u989d\u5927\u4e8e\u65bd\u5de5\u5408\u540c\u603b\u91d1\u989d");
                paramsCheckDsVO.setContent(stringBuffer.toString());
                PayReimburseServiceImpl.updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)((Collection)paramsCheckVOMap.get("alert")))) {
            paramsCheckVO.setWarnType("alert");
            paramsCheckVO.getDataSource().addAll((Collection)paramsCheckVOMap.get("alert"));
        } else if (CollectionUtils.isNotEmpty((Collection)((Collection)paramsCheckVOMap.get("warn")))) {
            paramsCheckVO.setWarnType("warn");
            paramsCheckVO.getDataSource().addAll((Collection)paramsCheckVOMap.get("warn"));
        }
        return paramsCheckVO;
    }

    private BigDecimal getSjzcje(Long id, Long projectId, BigDecimal mny) {
        CommonResponse fbCommonResponse = this.subContractApi.fetchSjzcje(projectId);
        if (!fbCommonResponse.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u5206\u5305\u5b9e\u9645\u652f\u51fa\u91d1\u989d\u5931\u8d25");
        }
        BigDecimal fb = (BigDecimal)fbCommonResponse.getData();
        CommonResponse wzCommonResponse = this.materialContractApi.fetchSjzcje(projectId);
        if (!wzCommonResponse.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u7269\u8d44\u5b9e\u9645\u652f\u51fa\u91d1\u989d\u5931\u8d25");
        }
        BigDecimal wz = (BigDecimal)wzCommonResponse.getData();
        CommonResponse zzcCommonResponse = this.rmatContractApi.fetchSjzcje(projectId);
        if (!zzcCommonResponse.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u5468\u8f6c\u6750\u5b9e\u9645\u652f\u51fa\u91d1\u989d\u5931\u8d25");
        }
        BigDecimal zzc = (BigDecimal)zzcCommonResponse.getData();
        CommonResponse sbcgCommonResponse = this.equipmentContractApi.fetchSjzcjePurchase(projectId);
        if (!sbcgCommonResponse.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u8bbe\u5907\u91c7\u8d2d\u5b9e\u9645\u652f\u51fa\u91d1\u989d\u5931\u8d25");
        }
        BigDecimal sbcg = (BigDecimal)sbcgCommonResponse.getData();
        CommonResponse sbzlCommonResponse = this.equipmentContractApi.fetchSjzcjeRent(projectId);
        if (!sbzlCommonResponse.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u8bbe\u5907\u79df\u8d41\u5b9e\u9645\u652f\u51fa\u91d1\u989d\u5931\u8d25");
        }
        BigDecimal sbzl = (BigDecimal)sbzlCommonResponse.getData();
        CommonResponse qtCommonResponse = this.otherContractApi.fetchSjzcje(projectId);
        if (!qtCommonResponse.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u5176\u4ed6\u5b9e\u9645\u652f\u51fa\u91d1\u989d\u5931\u8d25");
        }
        BigDecimal qt = (BigDecimal)qtCommonResponse.getData();
        BigDecimal fybx = ((PayReimburseMapper)this.baseMapper).fetchSjzcje(projectId, id);
        BigDecimal lx = this.paySporadicMapper.fetchSjzcje(projectId, null);
        BigDecimal yj = this.loadReimburseMapper.fetchSjzcje(projectId, null);
        return NumberUtil.add((BigDecimal[])new BigDecimal[]{mny, fb, wz, zzc, sbcg, sbzl, qt, fybx, lx, yj});
    }

    public static void updateParamsCheckVOMap(String[] paramsArray, Map<String, List<ParamsCheckDsSpreadVO>> paramsCheckVOMap, BillParamVO billParamVO, ParamsCheckDsSpreadVO paramsCheckDsVO) {
        if ("alert".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsSpreadVO> alert = paramsCheckVOMap.get("alert");
            alert.add(paramsCheckDsVO);
        }
        if ("warn".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsSpreadVO> warn = paramsCheckVOMap.get("warn");
            warn.add(paramsCheckDsVO);
        }
    }

    @Override
    public void closePayment(Long payapplyId) {
        if (payapplyId != null) {
            PayReimburseEntity entity = (PayReimburseEntity)((Object)super.selectById((Serializable)payapplyId));
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)payapplyId);
            updateWrapper.set(PayReimburseEntity::getApplyMnyBeforeClose, (Object)entity.getApplyMny());
            updateWrapper.set(PayReimburseEntity::getApplyMny, (Object)entity.getPayMny());
            updateWrapper.set(PayReimburseEntity::getApplyMnyCn, (Object)NumberToCN.number2CN(entity.getPayMny()));
            updateWrapper.set(PayReimburseEntity::getCloseState, (Object)"\u5df2\u5173\u95ed");
            updateWrapper.set(PayReimburseEntity::getCloseFlag, (Object)Boolean.TRUE);
            updateWrapper.set(PayReimburseEntity::getCloseTime, (Object)DateUtil.getCurrentDay("yyyy-MM-dd HH:mm:ss"));
            updateWrapper.set(PayReimburseEntity::getCloseUser, (Object)this.sessionManager.getUserContext().getUserName());
            super.update((Wrapper)updateWrapper);
        }
    }

    @Override
    public PayRecordVO returnPayment(PayRecordVO vo) {
        Long payapplyId = vo.getPayapplyId();
        if (payapplyId != null) {
            PayRecordEntity entity = (PayRecordEntity)((Object)BeanMapper.map((Object)vo, PayRecordEntity.class));
            entity.setThisPayMny(com.ejianc.business.utils.ComputeUtil.convertToMinusNumber((BigDecimal)entity.getThisPayMny()));
            PayReimburseEntity reimburse = (PayReimburseEntity)((Object)this.selectById(payapplyId));
            entity.setBillCode(reimburse.getBillCode());
            entity.setProjectId(reimburse.getProjectId());
            entity.setProjectName(reimburse.getProjectName());
            entity.setOrgId(reimburse.getOrgId());
            entity.setOrgName(reimburse.getOrgName());
            entity.setApplyUserId(reimburse.getApplyUserId());
            entity.setApplyUserName(reimburse.getApplyUserName());
            entity.setApplyTime(reimburse.getApplyTime());
            entity.setApplyMny(reimburse.getApplyMny());
            entity.setFeeType(reimburse.getFeeType());
            entity.setExplanation(reimburse.getPayReason());
            this.payRecordService.saveOrUpdate((Object)entity);
            BigDecimal payMny = MathUtil.safeAdd((BigDecimal)reimburse.getPayMny(), (BigDecimal)entity.getThisPayMny());
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)payapplyId);
            updateWrapper.set(PayReimburseEntity::getPayMny, (Object)payMny);
            super.update((Wrapper)updateWrapper);
            if (vo.getClosed().booleanValue()) {
                this.closePayment(payapplyId);
            }
            reimburse.setPayMny(payMny);
            this.costPush(reimburse);
            BankFlowVO bankFlowVO = BankFlowVO.instanceVOBySourceType((BankFlowSourceType)BankFlowSourceType.\u4ed8\u6b3e\u9000\u8fd8, (String)"\u8d39\u7528\u62a5\u9500\u4ed8\u6b3e\u9000\u56de");
            bankFlowVO.setTradeOrgId(reimburse.getApplyUserId());
            bankFlowVO.setTradeOrgName(reimburse.getApplyUserName());
            bankFlowVO.setOrgId(entity.getOrgId());
            bankFlowVO.setOrgName(entity.getOrgName());
            bankFlowVO.setSourceId(entity.getId());
            bankFlowVO.setBillId(entity.getPayapplyId());
            bankFlowVO.setBillCode(entity.getBillCode());
            bankFlowVO.setBillDate(entity.getConfirmTime());
            bankFlowVO.setAccountId(entity.getAccountId());
            bankFlowVO.setAccountName(entity.getAccountName());
            bankFlowVO.setAccountNum(entity.getAccountNum());
            bankFlowVO.setAccountBank(entity.getAccountBank());
            bankFlowVO.setReceiveMoney(entity.getThisPayMny() != null ? entity.getThisPayMny().abs() : entity.getThisPayMny());
            bankFlowVO.setMemo(entity.getMemo());
            this.bankFlowService.saveFlowVO(bankFlowVO);
        }
        return vo;
    }

    @Override
    public BigDecimal fetchSjzcje(Long projectId) {
        Assert.notNull((Object)projectId, (String)"\u9879\u76eeid\u4e0d\u80fd\u4e3a\u7a7a");
        return ((PayReimburseMapper)this.baseMapper).fetchSjzcje(projectId, null);
    }

    @Override
    public void updateShareMoneyByShareId(Long shareId, boolean addFlag) {
        ReimburseShareEntity reimburseShareEntity = (ReimburseShareEntity)((Object)this.reimburseShareService.selectById(shareId));
        if (reimburseShareEntity != null) {
            List<ReimburseShareCostDetailEntity> reimburseShareCostDetailList = reimburseShareEntity.getReimburseShareCostDetailList();
            List<Long> orgReimburseIds = reimburseShareCostDetailList.stream().map(ReimburseShareCostDetailEntity::getReimburseId).collect(Collectors.toList());
            Map<Long, BigDecimal> sumOrgReimburseMnyMap = this.reimburseShareService.getSumOrgReimburseMny(shareId, orgReimburseIds);
            if (addFlag) {
                for (ReimburseShareCostDetailEntity reimburseShareCostDetailEntity : reimburseShareCostDetailList) {
                    Long reimburseId = reimburseShareCostDetailEntity.getReimburseId();
                    BigDecimal sumReimburseShareMny = sumOrgReimburseMnyMap.get(reimburseId);
                    BigDecimal bodyReimburseShareMny = reimburseShareCostDetailEntity.getBodyReimburseShareMny();
                    sumReimburseShareMny = com.ejianc.business.utils.ComputeUtil.safeAdd((BigDecimal)sumReimburseShareMny, (BigDecimal)bodyReimburseShareMny);
                    sumOrgReimburseMnyMap.put(reimburseId, sumReimburseShareMny);
                }
            }
            for (Long reimburseId : orgReimburseIds) {
                BigDecimal countShareMny = sumOrgReimburseMnyMap.get(reimburseId);
                LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
                wrapper.eq(BaseEntity::getId, (Object)reimburseId);
                wrapper.set(PayReimburseEntity::getCountShareMny, (Object)countShareMny);
                this.update((Wrapper)wrapper);
            }
        }
    }

    @Override
    public BigDecimal queryFeeMny(Long projectId, Long feeTypeId) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(PayReimburseEntity::getProjectId, (Object)projectId);
        queryWrapper.in(PayReimburseEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        List entities = this.list((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)entities)) {
            List idList = entities.stream().map(BaseEntity::getId).collect(Collectors.toList());
            LambdaQueryWrapper query = Wrappers.lambdaQuery();
            query.eq(PayInfoEntity::getFeeType, (Object)feeTypeId);
            query.in(PayInfoEntity::getPayapplyId, idList);
            List infoEntities = this.payInfoService.list((Wrapper)query);
            if (CollectionUtils.isNotEmpty((Collection)infoEntities)) {
                return infoEntities.stream().map(PayInfoEntity::getFeeTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            }
        }
        return BigDecimal.ZERO;
    }
}

