/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.service.impl;

import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.bank.consts.BankFlowSourceType;
import com.ejianc.business.bank.service.IBankFlowService;
import com.ejianc.business.bank.vo.BankFlowVO;
import com.ejianc.business.budget.api.IBudgetProjectProApi;
import com.ejianc.business.budget.vo.BudgetProjectProParamControlVO;
import com.ejianc.business.budget.vo.BudgetProjectProQuantityAndMnyVO;
import com.ejianc.business.budget.vo.cons.CostTypeEnum;
import com.ejianc.business.cost.api.ICostDetailApi;
import com.ejianc.business.cost.vo.CostDetailVO;
import com.ejianc.business.equipment.api.IEquipmentContractApi;
import com.ejianc.business.equipment.vo.RentUseRecordVO;
import com.ejianc.business.finance.bean.PayInvoiceEntity;
import com.ejianc.business.finance.bean.PayRecordEntity;
import com.ejianc.business.finance.bean.PaySporadicEntity;
import com.ejianc.business.finance.bean.PaySporadicEquipmentRecordEntity;
import com.ejianc.business.finance.bean.PaySporadicOddjobEntity;
import com.ejianc.business.finance.bean.PaySporadicSalaryEntity;
import com.ejianc.business.finance.bean.PaySporadicStockEntity;
import com.ejianc.business.finance.bean.PaySporadicSummaryEntity;
import com.ejianc.business.finance.enums.ReceiveInvoiceFlagConst;
import com.ejianc.business.finance.mapper.LoadReimburseMapper;
import com.ejianc.business.finance.mapper.PayReimburseMapper;
import com.ejianc.business.finance.mapper.PaySporadicMapper;
import com.ejianc.business.finance.service.ILoadReimburseService;
import com.ejianc.business.finance.service.IPayInvoiceService;
import com.ejianc.business.finance.service.IPayRecordService;
import com.ejianc.business.finance.service.IPayReimburseService;
import com.ejianc.business.finance.service.IPaySporadicEquipmentRecordService;
import com.ejianc.business.finance.service.IPaySporadicOddjobService;
import com.ejianc.business.finance.service.IPaySporadicOtherService;
import com.ejianc.business.finance.service.IPaySporadicSalaryService;
import com.ejianc.business.finance.service.IPaySporadicService;
import com.ejianc.business.finance.service.IPaySporadicStockService;
import com.ejianc.business.finance.service.IPaySporadicSummaryService;
import com.ejianc.business.finance.util.BillTypeCodeEnum;
import com.ejianc.business.finance.util.MathUtil;
import com.ejianc.business.finance.util.ValidateUtil;
import com.ejianc.business.finance.utils.NumberToCN;
import com.ejianc.business.finance.vo.LoadReimburseVO;
import com.ejianc.business.finance.vo.ParamsCheckDsSpreadVO;
import com.ejianc.business.finance.vo.ParamsCheckSpreadVO;
import com.ejianc.business.finance.vo.PayInvoiceVO;
import com.ejianc.business.finance.vo.PayRecordVO;
import com.ejianc.business.finance.vo.PayReimburseVO;
import com.ejianc.business.finance.vo.PaySporadicEquipmentRecordVO;
import com.ejianc.business.finance.vo.PaySporadicOddjobVO;
import com.ejianc.business.finance.vo.PaySporadicOtherVO;
import com.ejianc.business.finance.vo.PaySporadicSalaryVO;
import com.ejianc.business.finance.vo.PaySporadicStockVO;
import com.ejianc.business.finance.vo.PaySporadicSummaryVO;
import com.ejianc.business.finance.vo.PaySporadicVO;
import com.ejianc.business.finance.vo.ProjectFinanceVO;
import com.ejianc.business.finance.vo.TotalColumnVO;
import com.ejianc.business.income.api.IIncomeContractApi;
import com.ejianc.business.labor.api.IProjectTeamApi;
import com.ejianc.business.material.api.IInstoreApi;
import com.ejianc.business.material.api.IMaterialContractApi;
import com.ejianc.business.material.vo.InstoreVO;
import com.ejianc.business.other.api.IOtherContractApi;
import com.ejianc.business.rmat.api.IRmatContractApi;
import com.ejianc.business.sub.api.ISubContractApi;
import com.ejianc.business.sub.api.ISubOddjobApi;
import com.ejianc.business.sub.vo.OddjobVO;
import com.ejianc.foundation.metadata.vo.CustomBusinessDataVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.extdata.service.ICustomBusinessDataService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service
public class PaySporadicServiceImpl
extends BaseServiceImpl<PaySporadicMapper, PaySporadicEntity>
implements IPaySporadicService {
    private static final String PAY_SPORADIC_BILL_CODE = "PAY_SPORADIC";
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IInstoreApi instoreApi;
    @Autowired
    private ISubOddjobApi oddjobApi;
    @Autowired
    private IPayInvoiceService invoiceService;
    @Autowired
    private IOtherContractApi otherContractApi;
    @Autowired
    private IPaySporadicStockService stockService;
    @Autowired
    private IPayRecordService payRecordService;
    @Autowired
    private IPaySporadicOddjobService paySporadicOddjobService;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IPaySporadicOtherService paySporadicOtherService;
    @Autowired
    private IPaySporadicEquipmentRecordService equipmentRecordService;
    @Autowired
    private IEquipmentContractApi equipmentContractApi;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IBudgetProjectProApi budgetProjectProApi;
    @Autowired
    private IPayReimburseService payReimburseService;
    @Autowired
    private ILoadReimburseService loadReimburseService;
    @Autowired
    private IPaySporadicSalaryService paySporadicSalaryService;
    @Autowired
    private IPaySporadicSummaryService paySporadicSummaryService;
    @Autowired
    private IProjectTeamApi projectTeamApi;
    private static final String CAN_USE_MNY_CHECK_CODE = "P-M478G960";
    private static final String PARAM_TOTAL_MNY = "P-6zD11147";
    private static final String SGHTZJE_K_SJZCJE = "P-nkX4Sk61";
    @Autowired
    private IIncomeContractApi incomeContractApi;
    @Autowired
    private ISubContractApi subContractApi;
    @Autowired
    private IMaterialContractApi materialContractApi;
    @Autowired
    private IRmatContractApi rmatContractApi;
    @Autowired
    private PayReimburseMapper payReimburseMapper;
    @Autowired
    private LoadReimburseMapper loadReimburseMapper;
    @Autowired
    private IBankFlowService bankFlowService;
    private static final String PARAM_STOCK = "P-Ri945r72";
    @Autowired
    private ICustomBusinessDataService customBusinessDataService;
    @Value(value="${extend.field.mode:false}")
    private Boolean extFieldsMode;
    private static Map sporadicPaymentTypeNameMap = new HashMap();

    @Override
    public PaySporadicVO insertOrUpdate(PaySporadicVO vo) {
        CommonResponse<String> usedMnyRes;
        List payOtherVOList;
        CommonResponse byCode;
        PaySporadicEntity entity = (PaySporadicEntity)((Object)BeanMapper.map((Object)vo, PaySporadicEntity.class));
        if (null != entity.getSporadicPaymentType() && 1 == entity.getSporadicPaymentType() && (byCode = this.paramConfigApi.getByCode(PARAM_STOCK)).isSuccess() && null != byCode.getData()) {
            ParamRegisterSetVO paramRegisterSetVO = (ParamRegisterSetVO)byCode.getData();
            String valueData = paramRegisterSetVO.getValueData();
            List stockVOS = vo.getStockVOList();
            if (null != stockVOS) {
                List collect = stockVOS.stream().filter(d -> !"del".equals(d.getRowState())).collect(Collectors.toList());
                if ("2".equals(valueData) && collect.size() == 0) {
                    throw new BusinessException("\u8bf7\u9009\u62e9\u5165\u5e93\u5355!");
                }
            } else if ("2".equals(valueData)) {
                throw new BusinessException("\u8bf7\u9009\u62e9\u5165\u5e93\u5355!");
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(payOtherVOList = vo.getOtherVOList()))) {
            String otherTypeIds = payOtherVOList.stream().filter(s -> !"del".equals(s.getRowState()) && null != s.getCostTypeId()).map(e -> e.getCostTypeId().toString()).distinct().collect(Collectors.joining(","));
            String otherTypeNames = payOtherVOList.stream().filter(s -> !"del".equals(s.getRowState()) && StringUtils.isNotBlank((String)s.getCostType())).map(PaySporadicOtherVO::getCostType).distinct().collect(Collectors.joining(","));
            entity.setOtherCostTypeIds(otherTypeIds);
            entity.setOtherCostTypeNames(StringUtils.isBlank((String)otherTypeNames) ? null : otherTypeNames);
        } else {
            entity.setOtherCostTypeIds(null);
            entity.setOtherCostTypeNames(null);
        }
        this.autoSetBillCode(entity);
        List stockVO = vo.getStockVOList();
        if (ListUtil.isNotEmpty((List)stockVO)) {
            entity.setInputFlag("1");
        } else {
            entity.setInputFlag("0");
        }
        entity.setProportionFlag("0");
        entity.setRelationFlag("0");
        List voList = vo.getInvoiceVOList();
        if (CollectionUtils.isNotEmpty((Collection)voList)) {
            for (PayInvoiceVO invoiceVO : voList) {
                if (ValidateUtil.validateUpstreamVersion((String)String.valueOf(invoiceVO.getInvoiceId()), (String)BillTypeCodeEnum.\u7a0e\u52a1\u6536\u7968.getBillTypeCode(), (Integer)invoiceVO.getInvoiceVersion()).booleanValue()) continue;
                throw new BusinessException("\u53d1\u7968\u5df2\u88ab\u66f4\u65b0\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u505a\uff01");
            }
        }
        if (!(usedMnyRes = this.invoiceService.updateInvoiceUsedMnyBySave(voList, entity.getId())).isSuccess()) {
            throw new BusinessException(usedMnyRes.getMsg());
        }
        entity.setReceiveInvoiceFlag(ReceiveInvoiceFlagConst.NO);
        super.saveOrUpdate((Object)entity, false);
        Long id = entity.getId();
        List<PaySporadicOddjobVO> oddjovList = this.updateOddjovVOS(vo, id);
        List invoiceVOList = this.updateInvoiceVOS(vo, id);
        List<PaySporadicStockVO> stockVOList = this.updateStockVOS(vo, id);
        List<PaySporadicSalaryVO> sporadicSalaryVOList = this.updateSalaryVOS(vo, id);
        List<PaySporadicSummaryVO> sporadicSummaryVOList = this.updateSummaryVOS(vo, id);
        List<PaySporadicEquipmentRecordVO> equipmentRecordList = this.updateEquipmentRecordVOS(vo, id);
        List equipmentRecordVOS = vo.getEquipmentRecordList();
        if (CollectionUtils.isNotEmpty((Collection)equipmentRecordVOS)) {
            CommonResponse commonResponse;
            RentUseRecordVO rentUseRecordVO;
            List equipmentRecordDelList = equipmentRecordVOS.stream().filter(s -> "del".equals(s.getRowState())).collect(Collectors.toList());
            List equipmentRecordAddList = equipmentRecordVOS.stream().filter(s -> "add".equals(s.getRowState())).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(equipmentRecordDelList)) {
                ArrayList<RentUseRecordVO> delList = new ArrayList<RentUseRecordVO>();
                for (PaySporadicEquipmentRecordVO recordVO : equipmentRecordDelList) {
                    rentUseRecordVO = new RentUseRecordVO();
                    rentUseRecordVO.setId(recordVO.getSourceMainId());
                    rentUseRecordVO.setSporadicUseFlag(Integer.valueOf(0));
                    delList.add(rentUseRecordVO);
                }
                commonResponse = this.equipmentContractApi.updateRentUseRecordSporadicUseFlag(delList);
                if (commonResponse.isSuccess()) {
                    // empty if block
                }
            }
            if (CollectionUtils.isNotEmpty(equipmentRecordAddList)) {
                ArrayList<RentUseRecordVO> addList = new ArrayList<RentUseRecordVO>();
                for (PaySporadicEquipmentRecordVO recordVO : equipmentRecordAddList) {
                    rentUseRecordVO = new RentUseRecordVO();
                    rentUseRecordVO.setId(recordVO.getSourceMainId());
                    rentUseRecordVO.setSporadicUseFlag(Integer.valueOf(1));
                    addList.add(rentUseRecordVO);
                }
                commonResponse = this.equipmentContractApi.updateRentUseRecordSporadicUseFlag(addList);
                if (commonResponse.isSuccess()) {
                    // empty if block
                }
            }
        }
        PaySporadicEntity byId = (PaySporadicEntity)((Object)this.selectById(id));
        PaySporadicVO backVO = (PaySporadicVO)BeanMapper.map((Object)((Object)byId), PaySporadicVO.class);
        if (entity.getId() != null) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"payapply_id", (Object)entity.getId());
            invoiceVOList = this.invoiceService.list((Wrapper)wrapper);
        }
        backVO.setInvoiceVOList(BeanMapper.mapList(invoiceVOList, PayInvoiceVO.class));
        backVO.setStockVOList(stockVOList);
        backVO.setSporadicSalaryList(sporadicSalaryVOList);
        backVO.setSporadicSummaryList(sporadicSummaryVOList);
        backVO.setEquipmentRecordList(equipmentRecordList);
        backVO.setSporadicOddjobList(oddjovList);
        ProjectFinanceVO v = (ProjectFinanceVO)BeanMapper.map((Object)((Object)byId), ProjectFinanceVO.class);
        backVO.setProjectFinanceVO(v);
        return backVO;
    }

    private List<PaySporadicEquipmentRecordVO> updateEquipmentRecordVOS(PaySporadicVO vo, Long id) {
        QueryWrapper wrapper;
        List voList = vo.getEquipmentRecordList();
        if (voList != null && !voList.isEmpty()) {
            List ids = voList.stream().filter(s -> "del".equals(s.getRowState())).map(BaseVO::getId).collect(Collectors.toList());
            for (PaySporadicEquipmentRecordVO recordVO : voList) {
                recordVO.setPayapplyId(id);
            }
            List entityList = BeanMapper.mapList((Iterable)voList, PaySporadicEquipmentRecordEntity.class);
            this.equipmentRecordService.saveOrUpdateBatch(entityList);
            voList = BeanMapper.mapList((Iterable)entityList, PaySporadicEquipmentRecordVO.class);
            if (CollectionUtils.isNotEmpty(ids)) {
                this.equipmentRecordService.removeByIds(ids);
            }
        } else {
            wrapper = new QueryWrapper();
            wrapper.eq((Object)"payapply_id", (Object)id);
            this.equipmentRecordService.remove((Wrapper)wrapper, false);
        }
        wrapper = new QueryWrapper();
        wrapper.eq((Object)"payapply_id", (Object)id);
        List list = this.equipmentRecordService.list((Wrapper)wrapper);
        voList = BeanMapper.mapList((Iterable)list, PaySporadicEquipmentRecordVO.class);
        return voList;
    }

    private List<PaySporadicSalaryVO> updateSalaryVOS(PaySporadicVO vo, Long id) {
        List delSalList;
        List voList = vo.getSporadicSalaryList();
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"payapply_id", (Object)id);
        ArrayList<PaySporadicSalaryVO> updSalarys = new ArrayList<PaySporadicSalaryVO>();
        if (voList != null && !voList.isEmpty()) {
            for (PaySporadicSalaryVO salaryVO : voList) {
                salaryVO.setPayapplyId(id);
            }
            List entityList = BeanMapper.mapList((Iterable)voList, PaySporadicSalaryEntity.class);
            this.paySporadicSalaryService.saveOrUpdateBatch(entityList, entityList.size(), false);
            voList = BeanMapper.mapList((Iterable)entityList, PaySporadicSalaryVO.class);
            updSalarys.addAll(voList);
            List ids = voList.stream().map(BaseVO::getId).collect(Collectors.toList());
            wrapper.notIn(!ids.isEmpty(), (Object)"id", ids);
        }
        if (CollectionUtils.isNotEmpty((Collection)(delSalList = this.paySporadicSalaryService.list((Wrapper)wrapper)))) {
            List delSalVOList = BeanMapper.mapList((Iterable)delSalList, PaySporadicSalaryVO.class);
            updSalarys.addAll(delSalVOList);
        }
        this.paySporadicSalaryService.remove((Wrapper)wrapper, false);
        this.writeBackAlreadyApplyMny(updSalarys);
        return voList;
    }

    private List<PaySporadicSummaryVO> updateSummaryVOS(PaySporadicVO vo, Long id) {
        List voList = vo.getSporadicSummaryList();
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"payapply_id", (Object)id);
        if (voList != null && !voList.isEmpty()) {
            for (PaySporadicSummaryVO summaryVO : voList) {
                summaryVO.setPayapplyId(id);
            }
            List entityList = BeanMapper.mapList((Iterable)voList, PaySporadicSummaryEntity.class);
            this.paySporadicSummaryService.saveOrUpdateBatch(entityList, entityList.size(), false);
            voList = BeanMapper.mapList((Iterable)entityList, PaySporadicSummaryVO.class);
            List ids = voList.stream().map(BaseVO::getId).collect(Collectors.toList());
            wrapper.notIn(!ids.isEmpty(), (Object)"id", ids);
        }
        this.paySporadicSummaryService.remove((Wrapper)wrapper, false);
        return voList;
    }

    private List<PayInvoiceVO> updateInvoiceVOS(PaySporadicVO vo, Long id) {
        List voList = vo.getInvoiceVOList();
        if (voList != null && !voList.isEmpty()) {
            for (PayInvoiceVO invoiceVO : voList) {
                invoiceVO.setPayapplyId(id);
            }
            List entityList = BeanMapper.mapList((Iterable)voList, PayInvoiceEntity.class);
            this.invoiceService.saveOrUpdateBatch(entityList);
            voList = BeanMapper.mapList((Iterable)entityList, PayInvoiceVO.class);
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"payapply_id", (Object)id);
        if (voList != null && !voList.isEmpty()) {
            List ids = voList.stream().map(BaseVO::getId).collect(Collectors.toList());
            wrapper.notIn(!ids.isEmpty(), (Object)"id", ids);
        }
        this.invoiceService.remove((Wrapper)wrapper, false);
        return voList;
    }

    private List<PaySporadicOddjobVO> updateOddjovVOS(PaySporadicVO vo, Long id) {
        List voList = vo.getSporadicOddjobList();
        ArrayList<OddjobVO> oddjobVOList = new ArrayList<OddjobVO>();
        ArrayList<Long> oddjobIds = new ArrayList<Long>();
        if (voList != null && !voList.isEmpty()) {
            for (PaySporadicOddjobVO oddjobVO : voList) {
                oddjobVO.setPayapplyId(id);
                OddjobVO oddjobVOOne = new OddjobVO();
                oddjobVOOne.setId(oddjobVO.getOddjobId());
                oddjobIds.add(oddjobVO.getOddjobId());
                oddjobVOList.add(oddjobVOOne);
            }
            List entityList = BeanMapper.mapList((Iterable)voList, PaySporadicOddjobEntity.class);
            this.paySporadicOddjobService.saveOrUpdateBatch(entityList, entityList.size(), false);
            voList = BeanMapper.mapList((Iterable)entityList, PaySporadicOddjobVO.class);
        }
        List voIds = voList.stream().map(BaseVO::getId).collect(Collectors.toList());
        List dataList = this.paySporadicOddjobService.list((Wrapper)new QueryWrapper().eq((Object)"payapply_id", (Object)id));
        List dataIds = dataList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        dataIds.removeAll(voIds);
        List delIds = dataIds;
        if (!delIds.isEmpty()) {
            QueryWrapper wrapper = (QueryWrapper)new QueryWrapper().in((Object)"id", delIds);
            ArrayList<OddjobVO> delOddjobVOList = new ArrayList<OddjobVO>();
            List oddList = this.paySporadicOddjobService.list((Wrapper)wrapper);
            for (PaySporadicOddjobEntity paySporadicOddjobEntity : oddList) {
                OddjobVO oddjobVO = new OddjobVO();
                oddjobVO.setId(paySporadicOddjobEntity.getOddjobId());
                delOddjobVOList.add(oddjobVO);
            }
            if (!delOddjobVOList.isEmpty()) {
                this.oddjobApi.updateOddjobUse(delOddjobVOList, Boolean.FALSE);
            }
            this.paySporadicOddjobService.remove((Wrapper)wrapper, false);
        }
        if (!oddjobVOList.isEmpty()) {
            this.oddjobApi.updateOddjobUse(oddjobVOList, Boolean.TRUE);
        }
        return voList;
    }

    private List<PaySporadicStockVO> updateStockVOS(PaySporadicVO vo, Long id) {
        List voList = vo.getStockVOList();
        ArrayList<InstoreVO> instoreVOList = new ArrayList<InstoreVO>();
        ArrayList<Long> stockIds = new ArrayList<Long>();
        if (voList != null && !voList.isEmpty()) {
            for (PaySporadicStockVO stockVO : voList) {
                if (!ValidateUtil.validateUpstreamVersion((String)String.valueOf(stockVO.getStockId()), (String)BillTypeCodeEnum.\u7269\u8d44\u5165\u5e93.getBillTypeCode(), (Integer)stockVO.getStockVersion()).booleanValue()) {
                    throw new BusinessException("\u5165\u5e93\u5355\u5df2\u88ab\u66f4\u65b0\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u505a\uff01");
                }
                stockVO.setPayapplyId(id);
                InstoreVO instoreVO = new InstoreVO();
                instoreVO.setId(stockVO.getStockId());
                instoreVO.setPaymentFlag(Integer.valueOf(1));
                stockIds.add(stockVO.getStockId());
                instoreVOList.add(instoreVO);
            }
            List entityList = BeanMapper.mapList((Iterable)voList, PaySporadicStockEntity.class);
            this.stockService.saveOrUpdateBatch(entityList, entityList.size(), false);
            voList = BeanMapper.mapList((Iterable)entityList, PaySporadicStockVO.class);
        }
        if (voList != null && !voList.isEmpty()) {
            List voIds = voList.stream().map(BaseVO::getId).collect(Collectors.toList());
            List dataList = this.stockService.list((Wrapper)new QueryWrapper().eq((Object)"payapply_id", (Object)id));
            List dataIds = dataList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            dataIds.removeAll(voIds);
            List delIds = dataIds;
            if (!delIds.isEmpty()) {
                this.stockService.remove((Wrapper)new QueryWrapper().in((Object)"id", delIds), false);
            }
            for (PaySporadicStockEntity data : dataList) {
                if (!delIds.contains(data.getId()) || stockIds.contains(data.getStockId())) continue;
                InstoreVO instoreVO = new InstoreVO();
                instoreVO.setId(data.getStockId());
                instoreVO.setPaymentFlag(Integer.valueOf(0));
                instoreVOList.add(instoreVO);
            }
            if (!instoreVOList.isEmpty()) {
                this.instoreApi.updatePayment(instoreVOList);
            }
        }
        return voList;
    }

    public Boolean writeBackAlreadyApplyMny(List<PaySporadicSalaryVO> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            List<Long> salaryIds = list.stream().distinct().map(PaySporadicSalaryVO::getSalaryId).collect(Collectors.toList());
            List<PaySporadicSalaryVO> salarylist = this.paySporadicSalaryService.querySalaryAlreadyApplyMny(salaryIds);
            Map<Long, BigDecimal> map = salarylist.stream().collect(Collectors.toMap(PaySporadicSalaryVO::getSalaryId, a -> a.getApplyMny()));
            for (Long salaryId : salaryIds) {
                if (map.containsKey(salaryId)) continue;
                map.put(salaryId, BigDecimal.ZERO);
            }
            this.projectTeamApi.updateAlreadyApplyMny(map);
        }
        return true;
    }

    @Override
    public PaySporadicVO queryDetail(Long id) {
        PaySporadicEntity entity = (PaySporadicEntity)((Object)this.selectById(id));
        PaySporadicVO vo = (PaySporadicVO)BeanMapper.map((Object)((Object)entity), PaySporadicVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("payapplyId", new Parameter("eq", (Object)vo.getId()));
        queryParam.getOrderMap().put("createTime", "desc");
        List invoiceEntityList = this.invoiceService.queryList(queryParam, false);
        vo.setInvoiceVOList(BeanMapper.mapList((Iterable)invoiceEntityList, PayInvoiceVO.class));
        List oddjobEntityList = this.paySporadicOddjobService.queryList(queryParam, false);
        vo.setSporadicOddjobList(BeanMapper.mapList((Iterable)oddjobEntityList, PaySporadicOddjobVO.class));
        List stockEntityList = this.stockService.queryList(queryParam, false);
        vo.setStockVOList(BeanMapper.mapList((Iterable)stockEntityList, PaySporadicStockVO.class));
        List salaryEntityList = this.paySporadicSalaryService.queryList(queryParam, false);
        vo.setSporadicSalaryList(BeanMapper.mapList((Iterable)salaryEntityList, PaySporadicSalaryVO.class));
        List summaryEntityList = this.paySporadicSummaryService.queryList(queryParam, false);
        vo.setSporadicSummaryList(BeanMapper.mapList((Iterable)summaryEntityList, PaySporadicSummaryVO.class));
        List recordList = this.payRecordService.queryList(queryParam);
        vo.setRecordList(BeanMapper.mapList((Iterable)recordList, PayRecordVO.class));
        List equipmentRecordList = this.equipmentRecordService.queryList(queryParam);
        vo.setEquipmentRecordList(BeanMapper.mapList((Iterable)equipmentRecordList, PaySporadicEquipmentRecordVO.class));
        vo.setProjectFinanceVO((ProjectFinanceVO)BeanMapper.map((Object)vo, ProjectFinanceVO.class));
        if (null != vo.getPayMny()) {
            vo.setPayMnyCn(NumberToCN.number2CN(vo.getPayMny()));
        }
        return vo;
    }

    @Override
    public List<PaySporadicVO> queryExportList(QueryParam param) {
        param.setPageIndex(0);
        param.setPageSize(-1);
        List resVos = (List)this.queryPageJson(param, false).get((Object)"records");
        if (!resVos.isEmpty()) {
            for (int i = 0; i < resVos.size(); ++i) {
                PaySporadicVO vo = (PaySporadicVO)resVos.get(i);
                vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
            }
        }
        return resVos;
    }

    @Override
    public String delete(List<Long> ids) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("id", new Parameter("in", ids));
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List entityList = super.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)entityList)) {
            LambdaQueryWrapper removeWrapper = new LambdaQueryWrapper();
            removeWrapper.in(PaySporadicSalaryEntity::getPayapplyId, ids);
            List removeSalaryList = this.paySporadicSalaryService.list((Wrapper)removeWrapper);
            super.removeByIds(ids, false);
            this.paySporadicSalaryService.remove((Wrapper)new QueryWrapper().in((Object)"payapply_id", ids), false);
            this.paySporadicSummaryService.remove((Wrapper)new QueryWrapper().in((Object)"payapply_id", ids), false);
            QueryWrapper wrapperOdd = (QueryWrapper)new QueryWrapper().in((Object)"payapply_id", ids);
            List oddList = this.paySporadicOddjobService.list((Wrapper)wrapperOdd);
            this.paySporadicOddjobService.remove((Wrapper)wrapperOdd, false);
            ArrayList<OddjobVO> oddVOList = new ArrayList<OddjobVO>();
            for (PaySporadicOddjobEntity data : oddList) {
                OddjobVO oddVO = new OddjobVO();
                oddVO.setId(data.getOddjobId());
                oddVOList.add(oddVO);
            }
            if (!oddVOList.isEmpty()) {
                this.oddjobApi.updateOddjobUse(oddVOList, Boolean.FALSE);
            }
            QueryWrapper wrapper = (QueryWrapper)new QueryWrapper().in((Object)"payapply_id", ids);
            this.invoiceService.updateInvoiceUsedMnyByDel(ids);
            this.invoiceService.remove((Wrapper)wrapper, false);
            List stockList = this.stockService.list((Wrapper)wrapper);
            this.stockService.remove((Wrapper)wrapper, false);
            ArrayList<InstoreVO> instoreVOList = new ArrayList<InstoreVO>();
            for (PaySporadicStockEntity data : stockList) {
                InstoreVO instoreVO = new InstoreVO();
                instoreVO.setId(data.getStockId());
                instoreVO.setPaymentFlag(Integer.valueOf(0));
                instoreVOList.add(instoreVO);
            }
            if (!instoreVOList.isEmpty()) {
                this.instoreApi.updatePayment(instoreVOList);
            }
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.in((Object)"payapply_id", ids);
            List equipmentRecordEntities = this.equipmentRecordService.list((Wrapper)queryWrapper);
            ArrayList<RentUseRecordVO> delList = new ArrayList<RentUseRecordVO>();
            if (CollectionUtils.isNotEmpty((Collection)equipmentRecordEntities)) {
                for (PaySporadicEquipmentRecordEntity entity : equipmentRecordEntities) {
                    RentUseRecordVO rentUseRecordVO = new RentUseRecordVO();
                    rentUseRecordVO.setId(entity.getSourceMainId());
                    rentUseRecordVO.setSporadicUseFlag(Integer.valueOf(0));
                    delList.add(rentUseRecordVO);
                }
            }
            if (CollectionUtils.isNotEmpty(delList)) {
                CommonResponse commonResponse = this.equipmentContractApi.updateRentUseRecordSporadicUseFlag(delList);
            }
            QueryWrapper paySporadicEquipmentWrapper = (QueryWrapper)new QueryWrapper().in((Object)"payapply_id", ids);
            this.equipmentRecordService.remove((Wrapper)paySporadicEquipmentWrapper, false);
            this.writeBackAlreadyApplyMny(BeanMapper.mapList((Iterable)removeSalaryList, PaySporadicSalaryVO.class));
        }
        return "\u5220\u9664\u6210\u529f\uff01";
    }

    @Override
    public JSONObject queryPageJson(QueryParam param, boolean isEs) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("applyUserName");
        fuzzyFields.add("purchasePeople");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("payUnitName");
        fuzzyFields.add("payReason");
        fuzzyFields.add("applyMny");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContext = this.sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        this.logger.info(">>>>>>>>>>>>>>>>>>>>>>1authOrgIds:{}", (Object)authOrgIds);
        if (StringUtils.isNotEmpty((String)authOrgIds)) {
            CommonResponse authResponse = this.orgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList()));
            this.logger.info(">>>>>>>>>>>>>>>>>>>>>>2authOrgIds:{}, authResponse.getData():{}", (Object)authOrgIds, authResponse.getData() == null ? null : Integer.valueOf(((List)authResponse.getData()).size()));
            param.getParams().put("orgId", new Parameter("in", ((List)authResponse.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        if (StringUtils.isNotEmpty((String)param.getBillTypeId()) && this.viewSelf(param.getBillTypeId()).booleanValue() && param.getParams().get("createUserCode") == null && param.getParams().get("create_user_code") == null) {
            param.getParams().put("createUserCode", new Parameter("eq", (Object)InvocationInfoProxy.getUsercode()));
        }
        Parameter parameterFlag = (Parameter)param.getParams().get("relationInvoiceFlag");
        param.getParams().remove("relationInvoiceFlag");
        String flag = parameterFlag == null ? null : parameterFlag.getValue().toString();
        Page pages = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        String otherCostTypeIds = null;
        if (param.getParams().containsKey("otherCostTypeIds")) {
            otherCostTypeIds = ((Parameter)param.getParams().get("otherCostTypeIds")).getValue().toString();
            param.getParams().remove("otherCostTypeIds");
            param.getParams().put("other_cost_type_ids", new Parameter("like", (Object)otherCostTypeIds));
        }
        QueryWrapper wrapper = PaySporadicServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<PaySporadicVO> list = ((PaySporadicMapper)this.baseMapper).queryPageList(pages, wrapper, flag);
        ArrayList businessIdList = new ArrayList();
        list.forEach(vo -> {
            if (null != vo.getApplyMny()) {
                vo.setUnpaidMny(vo.getApplyMny().subtract(vo.getPayMny() == null ? BigDecimal.ZERO : vo.getPayMny()));
            }
            if (null != vo.getSporadicPaymentType()) {
                vo.setSporadicPaymentTypeName((String)sporadicPaymentTypeNameMap.get(String.valueOf(vo.getSporadicPaymentType())));
            }
            businessIdList.add(vo.getId());
        });
        CommonResponse customBusinessDataResponse = null;
        if (this.extFieldsMode.booleanValue() && ListUtil.isNotEmpty(businessIdList) && (customBusinessDataResponse = this.customBusinessDataService.queryCustomBusinessData(businessIdList)).isSuccess()) {
            Map customBusinessDataMap = (Map)customBusinessDataResponse.getData();
            for (PaySporadicVO vo2 : list) {
                CustomBusinessDataVO subCustomBusinessDataVo = (CustomBusinessDataVO)customBusinessDataMap.get(vo2.getId());
                if (subCustomBusinessDataVo == null) continue;
                JSONObject subCustomField = JSONObject.parseObject((String)subCustomBusinessDataVo.getBusinessData());
                vo2.setCustomField((Map)subCustomField);
            }
        }
        JSONObject page = new JSONObject();
        page.put("records", list);
        page.put("total", (Object)pages.getTotal());
        page.put("current", (Object)pages.getCurrent());
        page.put("size", (Object)pages.getSize());
        page.put("pages", (Object)pages.getPages());
        return page;
    }

    @Override
    public Map<String, Object> countAmt(Long tenantId, List<Long> projectIds) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select(new String[]{"ifnull(sum(pay_mny),0) as amt"});
        queryWrapper.eq((Object)"tenant_id", (Object)tenantId);
        queryWrapper.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        queryWrapper.eq((Object)"pay_type", (Object)2);
        queryWrapper.eq((Object)"pay_status", (Object)2);
        if (CollectionUtils.isNotEmpty(projectIds)) {
            queryWrapper.in((Object)"project_id", projectIds);
        }
        queryWrapper.in((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        List<Object> orgIds = new ArrayList();
        UserContext userContext = this.sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (StringUtils.isNotEmpty((String)authOrgIds)) {
            CommonResponse authResponse = this.orgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList()));
            orgIds = ((List)authResponse.getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        } else {
            orgIds = ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        }
        if (ListUtil.isNotEmpty(orgIds)) {
            queryWrapper.in((Object)"org_id", orgIds);
        }
        return super.getMap((Wrapper)queryWrapper);
    }

    @Override
    public CommonResponse<PaySporadicVO> pushCost(PaySporadicVO paySporadicVO) {
        PaySporadicEntity paySporadicEntity = (PaySporadicEntity)((Object)((PaySporadicMapper)this.baseMapper).selectById(paySporadicVO.getId()));
        paySporadicEntity.setSubjectId(paySporadicVO.getSubjectId());
        paySporadicEntity.setSubjectName(paySporadicVO.getSubjectName());
        super.saveOrUpdate((Object)paySporadicEntity, false);
        this.costPush(paySporadicEntity);
        return CommonResponse.success((Object)this.queryDetail(paySporadicEntity.getId()));
    }

    @Override
    public void costPush(PaySporadicEntity paySporadicEntity) {
        this.logger.info("\u63a8\u9001\u5f00\u59cb:{}", (Object)JSONObject.toJSONString((Object)paySporadicEntity.getId()));
        if (!"1".equals(paySporadicEntity.getDependOnProject())) {
            return;
        }
        Long subjectId = paySporadicEntity.getSubjectId();
        boolean newRelationFlag = true;
        if (null == subjectId) {
            newRelationFlag = false;
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(BaseEntity::getId, new Object[]{paySporadicEntity.getId()});
        updateWrapper.set(PaySporadicEntity::getRelationFlag, (Object)(newRelationFlag ? "1" : "0"));
        super.update((Wrapper)updateWrapper);
        this.costDetailApi.deleteSubject(paySporadicEntity.getId());
        this.saveCost(paySporadicEntity);
    }

    private void saveCost(PaySporadicEntity entity) {
        this.logger.info("\u63a8\u9001\u5b9e\u4f53\u8f6c\u6362:{}", (Object)JSONObject.toJSONString((Object)entity.getId()));
        ArrayList<CostDetailVO> costDetailVOList = new ArrayList<CostDetailVO>();
        CostDetailVO costDetailVO = new CostDetailVO();
        costDetailVO.setSubjectId(entity.getSubjectId());
        costDetailVO.setSourceId(entity.getId());
        costDetailVO.setSourceDetailId(entity.getId());
        costDetailVO.setHappenTaxMny(entity.getPayMny());
        costDetailVO.setHappenMny(entity.getPayMny());
        costDetailVO.setHappenDate(entity.getApplyTime());
        costDetailVO.setCreateUserName(this.sessionManager.getUserContext().getUserName());
        costDetailVO.setSourceType(PAY_SPORADIC_BILL_CODE);
        costDetailVO.setSourceTabType(PAY_SPORADIC_BILL_CODE);
        costDetailVO.setProjectId(entity.getProjectId());
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM");
        LocalDate settlementDate = entity.getApplyTime().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        if (entity.getSalaryFlag() != null && entity.getSalaryFlag() == 1 && entity.getSubjectId() == null) {
            costDetailVO.setCostType(CostTypeEnum.LABOR_COST_TYPE.getType());
            costDetailVO.setCostTypeName(CostTypeEnum.LABOR_COST_TYPE.getName());
        } else {
            costDetailVO.setCostType(CostTypeEnum.INDIRECTION_COST_TYPE.getType());
            costDetailVO.setCostTypeName(CostTypeEnum.INDIRECTION_COST_TYPE.getName());
        }
        if (entity.getSporadicPaymentType() != null) {
            if (entity.getSporadicPaymentType().equals(1)) {
                costDetailVO.setCostType(CostTypeEnum.MATERIAL_COST_TYPE.getType());
                costDetailVO.setCostTypeName(CostTypeEnum.MATERIAL_COST_TYPE.getName());
            } else if (entity.getSporadicPaymentType().equals(2)) {
                costDetailVO.setCostType(CostTypeEnum.MECHANICAL_COST_TYPE.getType());
                costDetailVO.setCostTypeName(CostTypeEnum.MECHANICAL_COST_TYPE.getName());
            } else if (entity.getSporadicPaymentType().equals(3)) {
                costDetailVO.setCostType(CostTypeEnum.INDIRECTION_COST_TYPE.getType());
                costDetailVO.setCostTypeName(CostTypeEnum.INDIRECTION_COST_TYPE.getName());
            } else if (entity.getSporadicPaymentType().equals(4)) {
                costDetailVO.setCostType(CostTypeEnum.LABOR_COST_TYPE.getType());
                costDetailVO.setCostTypeName(CostTypeEnum.LABOR_COST_TYPE.getName());
            }
        }
        costDetailVO.setPeriod(settlementDate.format(df));
        costDetailVO.setShareFlag(Integer.valueOf(0));
        costDetailVO.setSourceBillCode(entity.getBillCode());
        costDetailVO.setSourceBillName("\u96f6\u661f\u4ed8\u6b3e\u7533\u8bf7");
        costDetailVO.setSourceBillUrl("/ejc-finance-frontend/#/paymentList/sporadicCard?id=" + entity.getId());
        costDetailVOList.add(costDetailVO);
        if (ListUtil.isNotEmpty(costDetailVOList)) {
            ((Object)costDetailVOList).toString();
            CommonResponse stringCommonResponse = this.costDetailApi.saveSubject(costDetailVOList);
            this.logger.info("\u63a8\u9001\u8fd4\u56de\u7ed3\u679c:{}", (Object)JSONObject.toJSONString((Object)stringCommonResponse));
            if (!stringCommonResponse.isSuccess()) {
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        }
    }

    private void validateBeforeSave(PaySporadicEntity entity) {
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(PaySporadicEntity::getSupplierId, (Object)entity.getSupplierId());
        lambda.eq(PaySporadicEntity::getOrgId, (Object)entity.getOrgId());
        lambda.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        lambda.ne(entity.getId() != null && entity.getId() > 0L, BaseEntity::getId, (Object)entity.getId());
        lambda.notIn(PaySporadicEntity::getBillState, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        List entityList = super.list((Wrapper)lambda);
        if (entityList != null && entityList.size() > 0) {
            throw new BusinessException("\u8be5\u4f9b\u5e94\u5546\u5728\u5f53\u524d\u7ec4\u7ec7\u4e0b\u5b58\u5728\u672a\u5ba1\u6279\u901a\u8fc7\u7684\u7533\u8bf7\u5355[" + ((PaySporadicEntity)((Object)entityList.get(0))).getBillCode() + "]\uff0c\u65e0\u6cd5\u53d1\u8d77\u7533\u8bf7!");
        }
    }

    private void autoSetBillCode(PaySporadicEntity entity) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (StringUtils.isEmpty((String)entity.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(PAY_SPORADIC_BILL_CODE, tenantId);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(PaySporadicEntity::getBillCode, (Object)entity.getBillCode());
        lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambda.ne(entity.getId() != null && entity.getId() > 0L, BaseEntity::getId, (Object)entity.getId());
        List entityList = super.list((Wrapper)lambda);
        if (entityList != null && entityList.size() > 0) {
            throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
    }

    @Override
    public void pullCost(Long id) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(BaseEntity::getId, new Object[]{id});
        updateWrapper.set(PaySporadicEntity::getRelationFlag, (Object)"0");
        super.update((Wrapper)updateWrapper);
        this.costDetailApi.deleteSubject(id);
    }

    @Override
    public TotalColumnVO getTotalColumnInfo(QueryParam param, boolean isEs) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("applyUserName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        if (StringUtils.isNotEmpty((String)param.getBillTypeId()) && this.viewSelf(param.getBillTypeId()).booleanValue() && param.getParams().get("createUserCode") == null && param.getParams().get("create_user_code") == null) {
            param.getParams().put("createUserCode", new Parameter("eq", (Object)InvocationInfoProxy.getUsercode()));
        }
        Parameter parameterFlag = (Parameter)param.getParams().get("relationInvoiceFlag");
        param.getParams().remove("relationInvoiceFlag");
        String flag = parameterFlag == null ? null : parameterFlag.getValue().toString();
        QueryWrapper wrapper = PaySporadicServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<PaySporadicVO> list = ((PaySporadicMapper)this.baseMapper).queryPageList(null, wrapper, flag);
        BigDecimal sumApplyMny = list.stream().filter(entity -> entity.getApplyMny() != null).map(PaySporadicVO::getApplyMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal sumPayMny = list.stream().filter(entity -> entity.getPayMny() != null).map(PaySporadicVO::getPayMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        TotalColumnVO vo = new TotalColumnVO();
        vo.setSumApplyMny(sumApplyMny);
        vo.setSumPayMny(sumPayMny);
        return vo;
    }

    @Override
    public TotalColumnVO getApproveTotalColumnInfo(QueryParam param, boolean isEs) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("applyUserName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        Parameter parameterFlag = (Parameter)param.getParams().get("relationInvoiceFlag");
        param.getParams().remove("relationInvoiceFlag");
        String flag = parameterFlag == null ? null : parameterFlag.getValue().toString();
        QueryWrapper wrapper = PaySporadicServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<PaySporadicVO> list = ((PaySporadicMapper)this.baseMapper).queryPageList(null, wrapper, flag);
        BigDecimal sumApplyMny = list.stream().filter(entity -> entity.getApplyMny() != null).map(PaySporadicVO::getApplyMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal sumPayMny = list.stream().filter(entity -> entity.getPayMny() != null).map(PaySporadicVO::getPayMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        TotalColumnVO vo = new TotalColumnVO();
        vo.setSumApplyMny(sumApplyMny);
        vo.setSumPayMny(sumPayMny);
        return vo;
    }

    @Override
    public BigDecimal totalBudgetMny(PaySporadicVO vo) {
        BigDecimal applyMny = BigDecimal.ZERO;
        QueryWrapper sporadicQuery = new QueryWrapper();
        sporadicQuery.eq((Object)"project_Id", (Object)vo.getProjectId());
        sporadicQuery.eq((Object)"depend_on_project", (Object)1);
        sporadicQuery.eq((Object)"sporadic_payment_type", (Object)3);
        if (vo.getId() != null) {
            sporadicQuery.ne((Object)"id", (Object)vo.getId());
        }
        if (vo.getApplyMny() != null) {
            applyMny = applyMny.add(vo.getApplyMny());
        }
        sporadicQuery.select(new String[]{"sum(apply_mny) as applyMny"});
        PaySporadicEntity sporadicEntity = (PaySporadicEntity)((Object)super.getOne((Wrapper)sporadicQuery));
        if (sporadicEntity != null && null != sporadicEntity.getApplyMny() && !"0".equals(sporadicEntity.getApplyMny())) {
            applyMny = applyMny.add(sporadicEntity.getApplyMny());
        }
        return applyMny;
    }

    @Override
    public ParamsCheckSpreadVO checkBudgetParams(PaySporadicVO vo) {
        CommonResponse sghtkzc;
        CommonResponse response1;
        List billParamVOS;
        Long curOrgId = Optional.ofNullable(vo.getOrgId()).orElse(InvocationInfoProxy.getOrgId());
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        HashMap<String, List<ParamsCheckDsSpreadVO>> paramsCheckVOMap = new HashMap<String, List<ParamsCheckDsSpreadVO>>();
        paramsCheckVOMap.put("alert", new ArrayList());
        paramsCheckVOMap.put("warn", new ArrayList());
        BudgetProjectProParamControlVO requestVo = new BudgetProjectProParamControlVO();
        requestVo.setProjectId(vo.getProjectId());
        requestVo.setCostType(CostTypeEnum.INDIRECTION_COST_TYPE.getType());
        CommonResponse res = this.budgetProjectProApi.fetchQuantityAndMny(requestVo);
        this.logger.info("\u9884\u7b97\u95f4\u63a5\u8d39\u603b\u91d1\u989d \u8fd4\u56de\u5185\u5bb9:{}", (Object)JSONObject.toJSONString((Object)res));
        if (!res.isSuccess()) {
            throw new BusinessException("\u7f51\u7edc\u9519\u8bef" + res.getMsg());
        }
        if (null != res.getData() && 3 == vo.getSporadicPaymentType()) {
            BudgetProjectProQuantityAndMnyVO data = (BudgetProjectProQuantityAndMnyVO)res.getData();
            BigDecimal budgetTaxMny = data.getIndirectionTaxMny() == null ? BigDecimal.ZERO : data.getIndirectionTaxMny();
            CommonResponse response = this.paramConfigApi.getBillParamByCodeAndOrgId(PARAM_TOTAL_MNY, curOrgId);
            if (!response.isSuccess()) {
                throw new BusinessException(" \u3010\u9884\u7b97\u95f4\u63a5\u8d39\u603b\u91d1\u989d\u3011\u63a7 \u3010\u5b9e\u9645\u95f4\u63a5\u8d39\u603b\u91d1\u989d\u3011\uff0c\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response.getMsg());
            }
            billParamVOS = (List)response.getData();
            if (CollectionUtils.isNotEmpty((Collection)billParamVOS)) {
                BigDecimal totalContractMny = this.totalBudgetMny(vo);
                CommonResponse bigDecimalCommonResponse = this.otherContractApi.budgetControlTotal(vo.getProjectId());
                this.logger.info("\u9884\u7b97\u95f4\u63a5\u8d39 \u5176\u4ed6\u5408\u540c\u603b\u91d1\u989d \u8fd4\u56de\u5185\u5bb9:{}", (Object)JSONObject.toJSONString((Object)bigDecimalCommonResponse));
                if (!bigDecimalCommonResponse.isSuccess()) {
                    throw new BusinessException(bigDecimalCommonResponse.getMsg());
                }
                totalContractMny = totalContractMny.add((BigDecimal)bigDecimalCommonResponse.getData());
                PayReimburseVO payReimburse = new PayReimburseVO();
                payReimburse.setProjectId(vo.getProjectId());
                totalContractMny = totalContractMny.add(this.payReimburseService.totalBudgetMny(payReimburse));
                LoadReimburseVO loadReimburse = new LoadReimburseVO();
                loadReimburse.setProjectId(vo.getProjectId());
                totalContractMny = totalContractMny.add(this.loadReimburseService.totalBudgetMny(loadReimburse));
                for (BillParamVO billParamVO : billParamVOS) {
                    BigDecimal roleValue;
                    BigDecimal scale;
                    BigDecimal budgetTaxMnyResult;
                    if (0 == billParamVO.getControlType() || totalContractMny.compareTo(budgetTaxMnyResult = budgetTaxMny.multiply(scale = (roleValue = billParamVO.getRoleValue()).divide(new BigDecimal("100")))) <= 0) continue;
                    BigDecimal over = totalContractMny.subtract(budgetTaxMnyResult);
                    ParamsCheckDsSpreadVO paramsCheckDsVO = new ParamsCheckDsSpreadVO();
                    paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                    paramsCheckDsVO.setWarnItem("\u5b9e\u9645\u95f4\u63a5\u8d39\u603b\u91d1\u989d\u8d85\u9884\u7b97\u95f4\u63a5\u8d39\u603b\u91d1\u989d");
                    paramsCheckDsVO.setWarnName("\u5b9e\u9645\u95f4\u63a5\u8d39\u603b\u91d1\u989d\u5927\u4e8e\u9884\u7b97\u95f4\u63a5\u8d39\u603b\u91d1\u989d * " + roleValue + "%");
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("\u8be5\u9879\u76ee\u5b9e\u9645\u95f4\u63a5\u8d39\u603b\u91d1\u989d\uff1a").append(totalContractMny.setScale(2, RoundingMode.HALF_UP)).append("\u5143\uff0c \u9884\u7b97\u95f4\u63a5\u8d39\u603b\u91d1\u989d * ").append(roleValue).append("%\uff1a").append(budgetTaxMnyResult.setScale(2, RoundingMode.HALF_UP)).append("\u5143\uff0c\u8d85\u51fa\u91d1\u989d\uff1a").append(over.setScale(2, RoundingMode.HALF_UP)).append("\u5143\u3002");
                    paramsCheckDsVO.setContent(stringBuffer.toString());
                    PaySporadicServiceImpl.updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
                }
            }
        }
        if (!(response1 = this.paramConfigApi.getBillParamByCodeAndOrgId(CAN_USE_MNY_CHECK_CODE, curOrgId)).isSuccess()) {
            this.logger.info(response1.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        List billParamVOS1 = (List)response1.getData();
        if (CollectionUtils.isNotEmpty((Collection)billParamVOS1)) {
            for (BillParamVO billParamVO : billParamVOS1) {
                BigDecimal roleValue = billParamVO.getRoleValue();
                BigDecimal surplusApplyMny = ComputeUtil.safeMultiply((BigDecimal)roleValue.divide(BigDecimal.valueOf(100L)), (BigDecimal)vo.getProSurplusApplyMny());
                BigDecimal payMny = vo.getApplyMny();
                if (!ComputeUtil.isGreaterThan((BigDecimal)payMny, (BigDecimal)surplusApplyMny)) continue;
                ParamsCheckDsSpreadVO paramsCheckDsVO = new ParamsCheckDsSpreadVO();
                paramsCheckDsVO.setWarnItem("\u4ed8\u6b3e\u7533\u8bf7\u989d\u8d85\u9879\u76ee\u53ef\u7528\u8d44\u91d1");
                paramsCheckDsVO.setWarnName("\u672c\u671f\u7533\u8bf7\u91d1\u989d\u5927\u4e8e\u5269\u4f59\u53ef\u7533\u8bf7\u91d1\u989d");
                paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("\u672c\u6b21\u7533\u8bf7\u91d1\u989d\uff1a").append(payMny.setScale(2, 4)).append("\u5143\uff0c\u5269\u4f59\u53ef\u7533\u8bf7\u91d1\u989d*").append(roleValue.setScale(2, 4)).append("%:").append(surplusApplyMny.setScale(2, 4)).append("\u5143\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(payMny.subtract(surplusApplyMny.setScale(2, 4)).setScale(2, 4)).append("\u5143");
                paramsCheckDsVO.setContent(stringBuffer.toString());
                PaySporadicServiceImpl.updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
            }
        }
        if ((sghtkzc = this.paramConfigApi.getBillParamByCodeAndOrgId(SGHTZJE_K_SJZCJE, curOrgId)).isSuccess() && null != sghtkzc.getData() && CollectionUtils.isNotEmpty((Collection)(billParamVOS = (List)sghtkzc.getData()))) {
            BigDecimal sjzcje = this.getSjzcje(vo.getId(), vo.getProjectId(), vo.getApplyMny());
            CommonResponse res996 = this.incomeContractApi.fetchSghtzje(vo.getProjectId());
            if (!res996.isSuccess()) {
                throw new BusinessException("\u83b7\u53d6\u65bd\u5de5\u5408\u540c\u5de5\u603b\u91d1\u989d\u5931\u8d25");
            }
            BigDecimal sght = (BigDecimal)res996.getData();
            for (BillParamVO billParamVO : billParamVOS) {
                BigDecimal roleValue;
                BigDecimal scale;
                BigDecimal sghtzje;
                if (0 == billParamVO.getControlType() || sjzcje.compareTo(sghtzje = NumberUtil.mul((Number)sght, (Number)(scale = NumberUtil.div((Number)(roleValue = billParamVO.getRoleValue()), (Number)new BigDecimal("100"), (int)8)))) <= 0) continue;
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("\u8be5\u9879\u76ee\u5b9e\u9645\u652f\u51fa\u603b\u91d1\u989d\uff1a").append(sjzcje.setScale(2, RoundingMode.HALF_UP)).append("\uff0c\u65bd\u5de5\u5408\u540c\u5de5\u603b\u91d1\u989d*").append(roleValue).append("%\uff1a").append(sghtzje.setScale(2, RoundingMode.HALF_UP)).append("\uff0c\u8d85\u51fa\u91d1\u989d\uff1a").append(ComputeUtil.safeSub((BigDecimal)sjzcje, (BigDecimal)sghtzje).setScale(2, RoundingMode.HALF_UP));
                ParamsCheckDsSpreadVO paramsCheckDsVO = new ParamsCheckDsSpreadVO();
                paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                paramsCheckDsVO.setWarnItem("\u5b9e\u9645\u652f\u51fa\u603b\u91d1\u989d\u8d85\u65bd\u5de5\u5408\u540c\u603b\u91d1\u989d");
                paramsCheckDsVO.setWarnName("\u5b9e\u9645\u652f\u51fa\u603b\u91d1\u989d\u5927\u4e8e\u65bd\u5de5\u5408\u540c\u603b\u91d1\u989d");
                paramsCheckDsVO.setContent(stringBuffer.toString());
                PaySporadicServiceImpl.updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
            }
        }
        ParamsCheckSpreadVO paramsCheckVO = new ParamsCheckSpreadVO();
        if (CollectionUtils.isNotEmpty((Collection)((Collection)paramsCheckVOMap.get("alert")))) {
            paramsCheckVO.setWarnType("alert");
            paramsCheckVO.setDataSource((List)paramsCheckVOMap.get("alert"));
        } else if (CollectionUtils.isNotEmpty((Collection)((Collection)paramsCheckVOMap.get("warn")))) {
            paramsCheckVO.setWarnType("warn");
            paramsCheckVO.setDataSource((List)paramsCheckVOMap.get("warn"));
        } else {
            paramsCheckVO.setWarnType("none");
            paramsCheckVO.setDataSource(null);
        }
        return paramsCheckVO;
    }

    private BigDecimal getSjzcje(Long id, Long projectId, BigDecimal mny) {
        CommonResponse fbCommonResponse = this.subContractApi.fetchSjzcje(projectId);
        if (!fbCommonResponse.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u5206\u5305\u5b9e\u9645\u652f\u51fa\u91d1\u989d\u5931\u8d25");
        }
        BigDecimal fb = (BigDecimal)fbCommonResponse.getData();
        CommonResponse wzCommonResponse = this.materialContractApi.fetchSjzcje(projectId);
        if (!wzCommonResponse.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u7269\u8d44\u5b9e\u9645\u652f\u51fa\u91d1\u989d\u5931\u8d25");
        }
        BigDecimal wz = (BigDecimal)wzCommonResponse.getData();
        CommonResponse zzcCommonResponse = this.rmatContractApi.fetchSjzcje(projectId);
        if (!zzcCommonResponse.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u5468\u8f6c\u6750\u5b9e\u9645\u652f\u51fa\u91d1\u989d\u5931\u8d25");
        }
        BigDecimal zzc = (BigDecimal)zzcCommonResponse.getData();
        CommonResponse sbcgCommonResponse = this.equipmentContractApi.fetchSjzcjePurchase(projectId);
        if (!sbcgCommonResponse.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u8bbe\u5907\u91c7\u8d2d\u5b9e\u9645\u652f\u51fa\u91d1\u989d\u5931\u8d25");
        }
        BigDecimal sbcg = (BigDecimal)sbcgCommonResponse.getData();
        CommonResponse sbzlCommonResponse = this.equipmentContractApi.fetchSjzcjeRent(projectId);
        if (!sbzlCommonResponse.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u8bbe\u5907\u79df\u8d41\u5b9e\u9645\u652f\u51fa\u91d1\u989d\u5931\u8d25");
        }
        BigDecimal sbzl = (BigDecimal)sbzlCommonResponse.getData();
        CommonResponse qtCommonResponse = this.otherContractApi.fetchSjzcje(projectId);
        if (!qtCommonResponse.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u5176\u4ed6\u5b9e\u9645\u652f\u51fa\u91d1\u989d\u5931\u8d25");
        }
        BigDecimal qt = (BigDecimal)qtCommonResponse.getData();
        BigDecimal fybx = this.payReimburseMapper.fetchSjzcje(projectId, null);
        BigDecimal lx = ((PaySporadicMapper)this.baseMapper).fetchSjzcje(projectId, id);
        BigDecimal yj = this.loadReimburseMapper.fetchSjzcje(projectId, null);
        return NumberUtil.add((BigDecimal[])new BigDecimal[]{mny, fb, wz, zzc, sbcg, sbzl, qt, fybx, lx, yj});
    }

    private Integer totalMnyControl(PaySporadicVO vo, List<ParamsCheckDsSpreadVO> checkDsVOS, Integer controlType) {
        BudgetProjectProParamControlVO requestVo = new BudgetProjectProParamControlVO();
        requestVo.setProjectId(vo.getProjectId());
        requestVo.setCostType(CostTypeEnum.INDIRECTION_COST_TYPE.getType());
        CommonResponse res = this.budgetProjectProApi.fetchQuantityAndMny(requestVo);
        this.logger.info("\u9884\u7b97\u95f4\u63a5\u8d39\u603b\u91d1\u989d \u8fd4\u56de\u5185\u5bb9:{}", (Object)JSONObject.toJSONString((Object)res));
        if (!res.isSuccess()) {
            throw new BusinessException("\u7f51\u7edc\u9519\u8bef" + res.getMsg());
        }
        if (null != res.getData()) {
            BudgetProjectProQuantityAndMnyVO data = (BudgetProjectProQuantityAndMnyVO)res.getData();
            BigDecimal budgetTaxMny = data.getBudgetTaxMny() == null ? BigDecimal.ZERO : data.getBudgetTaxMny();
            CommonResponse response = this.paramConfigApi.getBillParamByCodeAndOrgId(PARAM_TOTAL_MNY, InvocationInfoProxy.getOrgId());
            if (!response.isSuccess()) {
                throw new BusinessException(" \u3010\u9884\u7b97\u95f4\u63a5\u8d39\u603b\u91d1\u989d\u3011\u63a7 \u3010\u5b9e\u9645\u95f4\u63a5\u8d39\u603b\u91d1\u989d\u3011\uff0c\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response.getMsg());
            }
            List billParamVOS = (List)response.getData();
            if (CollectionUtils.isNotEmpty((Collection)billParamVOS)) {
                BigDecimal totalContractMny = this.totalBudgetMny(vo);
                CommonResponse bigDecimalCommonResponse = this.otherContractApi.budgetControlTotal(vo.getProjectId());
                this.logger.info("\u9884\u7b97\u95f4\u63a5\u8d39 \u5176\u4ed6\u5408\u540c\u603b\u91d1\u989d \u8fd4\u56de\u5185\u5bb9:{}", (Object)JSONObject.toJSONString((Object)bigDecimalCommonResponse));
                if (!bigDecimalCommonResponse.isSuccess()) {
                    throw new BusinessException(bigDecimalCommonResponse.getMsg());
                }
                totalContractMny = totalContractMny.add((BigDecimal)bigDecimalCommonResponse.getData());
                PayReimburseVO payReimburse = new PayReimburseVO();
                payReimburse.setProjectId(vo.getProjectId());
                totalContractMny = totalContractMny.add(this.payReimburseService.totalBudgetMny(payReimburse));
                LoadReimburseVO loadReimburse = new LoadReimburseVO();
                loadReimburse.setProjectId(vo.getProjectId());
                totalContractMny = totalContractMny.add(this.loadReimburseService.totalBudgetMny(loadReimburse));
                for (BillParamVO billParamVO : billParamVOS) {
                    BigDecimal roleValue = billParamVO.getRoleValue();
                    BigDecimal scale = roleValue.divide(new BigDecimal("100"));
                    BigDecimal budgetTaxMnyResult = budgetTaxMny.multiply(scale);
                    if (totalContractMny.compareTo(budgetTaxMnyResult) <= 0) continue;
                    controlType = billParamVO.getControlType() > controlType ? billParamVO.getControlType() : controlType;
                    BigDecimal over = totalContractMny.subtract(budgetTaxMnyResult);
                    ParamsCheckDsSpreadVO paramsCheckDsVO = new ParamsCheckDsSpreadVO();
                    paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                    paramsCheckDsVO.setWarnItem("\u5b9e\u9645\u95f4\u63a5\u8d39\u603b\u91d1\u989d\u8d85\u9884\u7b97\u95f4\u63a5\u8d39\u603b\u91d1\u989d");
                    paramsCheckDsVO.setWarnName("\u5b9e\u9645\u95f4\u63a5\u8d39\u603b\u91d1\u989d\u5927\u4e8e\u9884\u7b97\u95f4\u63a5\u8d39\u603b\u91d1\u989d * " + roleValue + "%");
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("\u5b9e\u9645\u95f4\u63a5\u8d39\u603b\u91d1\u989d\uff1a").append(totalContractMny.setScale(2, RoundingMode.HALF_UP)).append("\u5143\uff0c \u9884\u7b97\u95f4\u63a5\u8d39\u603b\u91d1\u989d * ").append(roleValue).append("%\uff1a").append(budgetTaxMnyResult.setScale(2, RoundingMode.HALF_UP)).append("\u5143\uff0c\u8d85\u51fa\u91d1\u989d\uff1a").append(over.setScale(2, RoundingMode.HALF_UP)).append("\u5143\u3002");
                    paramsCheckDsVO.setContent(stringBuffer.toString());
                    checkDsVOS.add(paramsCheckDsVO);
                }
            }
        }
        return controlType;
    }

    public static void updateParamsCheckVOMap(String[] paramsArray, Map<String, List<ParamsCheckDsSpreadVO>> paramsCheckVOMap, BillParamVO billParamVO, ParamsCheckDsSpreadVO paramsCheckDsVO) {
        if ("alert".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsSpreadVO> alert = paramsCheckVOMap.get("alert");
            alert.add(paramsCheckDsVO);
        }
        if ("warn".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsSpreadVO> warn = paramsCheckVOMap.get("warn");
            warn.add(paramsCheckDsVO);
        }
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        ArrayList<PaySporadicOtherVO> successList = new ArrayList<PaySporadicOtherVO>();
        ArrayList<PaySporadicOtherVO> errorList = new ArrayList<PaySporadicOtherVO>();
        StringBuilder errMsg = new StringBuilder();
        if (result != null && result.size() > 0) {
            if (((List)result.get(0)).size() != 6) {
                throw new BusinessException("\u8bf7\u6309\u7167\u5bfc\u5165\u6a21\u677f\u5bfc\u5165\u6570\u636e");
            }
            for (int i = 1; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                PaySporadicOtherVO paySporadicOtherVO = new PaySporadicOtherVO();
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)((CharSequence)datas.get(0)))) {
                    errMsg.append("`\u8d39\u7528\u540d\u79f0\u5fc5\u586b\u9879`");
                } else {
                    paySporadicOtherVO.setName((String)datas.get(0));
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(1)))) {
                    try {
                        BigDecimal num = new BigDecimal((String)datas.get(1));
                        paySporadicOtherVO.setNum(num);
                    }
                    catch (Exception e) {
                        errMsg.append("`\u6570\u91cf\u4e3a\u5fc5\u987b\u4e3a\u6570\u5b57`");
                    }
                } else {
                    errMsg.append("`\u6570\u91cf\u4e3a\u5fc5\u586b\u9879`");
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(2)))) {
                    try {
                        paySporadicOtherVO.setTaxPrice(new BigDecimal((String)datas.get(2)));
                    }
                    catch (Exception e) {
                        errMsg.append("`\u5355\u4ef7\u5fc5\u987b\u4e3a\u6570\u5b57`");
                    }
                } else {
                    errMsg.append("`\u5355\u4ef7\u4e3a\u5fc5\u586b\u9879`");
                }
                if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(3)))) {
                    try {
                        paySporadicOtherVO.setTaxRate(new BigDecimal((String)datas.get(3)));
                    }
                    catch (Exception e) {
                        errMsg.append("`\u7a0e\u7387\u5fc5\u987b\u4e3a\u6570\u5b57`");
                    }
                }
                BigDecimal taxMoney = ComputeUtil.safeMultiply((BigDecimal)paySporadicOtherVO.getNum(), (BigDecimal)paySporadicOtherVO.getTaxPrice());
                paySporadicOtherVO.setTaxMoney(taxMoney);
                if (Objects.isNull(paySporadicOtherVO.getTaxRate())) {
                    paySporadicOtherVO.setMoney(taxMoney);
                    paySporadicOtherVO.setTax(BigDecimal.ZERO);
                } else {
                    BigDecimal taxPrice = paySporadicOtherVO.getTaxPrice();
                    BigDecimal rate = ComputeUtil.safeDiv((BigDecimal)paySporadicOtherVO.getTaxRate(), (BigDecimal)new BigDecimal(100));
                    BigDecimal price = ComputeUtil.safeDiv((BigDecimal)taxPrice, (BigDecimal)ComputeUtil.safeAdd((BigDecimal)BigDecimal.ONE, (BigDecimal)rate));
                    BigDecimal money = ComputeUtil.safeMultiply((BigDecimal)price, (BigDecimal)paySporadicOtherVO.getNum());
                    paySporadicOtherVO.setMoney(money);
                    paySporadicOtherVO.setPrice(price);
                    BigDecimal tax = ComputeUtil.safeSub((BigDecimal)paySporadicOtherVO.getTaxMoney(), (BigDecimal)paySporadicOtherVO.getMoney());
                    paySporadicOtherVO.setTax(tax);
                }
                paySporadicOtherVO.setMemo((String)datas.get(5));
                paySporadicOtherVO.setErrorMessage(errMsg.toString());
                if (StringUtils.isNotEmpty((String)paySporadicOtherVO.getErrorMessage())) {
                    errorList.add(paySporadicOtherVO);
                    continue;
                }
                successList.add(paySporadicOtherVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success((Object)json);
    }

    @Override
    public void closePayRecord(Long id) {
        PaySporadicEntity entity = (PaySporadicEntity)((Object)super.selectById((Serializable)id));
        entity.setApplyMnyBeforeClose(entity.getApplyMny());
        entity.setApplyMny(entity.getPayMny());
        entity.setApplyMnyCn(NumberToCN.number2CN(entity.getApplyMny()));
        entity.setCloseFlag(Boolean.TRUE);
        entity.setCloseState("\u5df2\u5173\u95ed");
        entity.setCloseTime(new Date());
        entity.setCloseUser(this.sessionManager.getUserContext().getUserName());
        super.updateById((Object)entity);
    }

    @Override
    public void returnPayRecord(PayRecordVO vo) {
        PayRecordEntity entity = (PayRecordEntity)((Object)BeanMapper.map((Object)vo, PayRecordEntity.class));
        entity.setId(null);
        entity.setThisPayMny(entity.getThisPayMny().negate());
        PaySporadicEntity sporadic = (PaySporadicEntity)((Object)super.selectById((Serializable)entity.getPayapplyId()));
        entity.setBillCode(sporadic.getBillCode());
        entity.setProjectId(sporadic.getProjectId());
        entity.setProjectName(sporadic.getProjectName());
        entity.setOrgId(sporadic.getOrgId());
        entity.setOrgName(sporadic.getOrgName());
        entity.setApplyUserId(sporadic.getApplyUserId());
        entity.setApplyUserName(sporadic.getApplyUserName());
        entity.setApplyTime(vo.getConfirmTime());
        entity.setApplyMny(sporadic.getApplyMny());
        entity.setExplanation(sporadic.getPayReason());
        entity.setFeeType(sporadic.getApplyType());
        sporadic.setPayStatus(2);
        sporadic.setConfirmTime(entity.getConfirmTime());
        sporadic.setEmployeeId(entity.getEmployeeId());
        sporadic.setEmployeeName(entity.getEmployeeName());
        sporadic.setPayMny(MathUtil.safeAdd((BigDecimal)sporadic.getPayMny(), (BigDecimal)entity.getThisPayMny()));
        super.saveOrUpdate((Object)sporadic);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("payapplyId", new Parameter("eq", (Object)entity.getPayapplyId()));
        queryParam.getOrderMap().put("createTime", "desc");
        QueryWrapper wrapper = PaySporadicServiceImpl.changeToQueryWrapper((QueryParam)queryParam);
        wrapper.last("limit 1");
        PayRecordEntity payRecordEntity = (PayRecordEntity)((Object)this.payRecordService.getOne((Wrapper)wrapper));
        if (payRecordEntity != null) {
            sporadic.setPayAccountName(payRecordEntity.getAccountName());
            sporadic.setPayAccountNum(payRecordEntity.getAccountNum());
            sporadic.setPayAccountBank(payRecordEntity.getAccountBank());
        }
        this.payRecordService.saveOrUpdate((Object)entity);
        if (vo.getClosed().booleanValue()) {
            this.closePayRecord(vo.getPayapplyId());
        }
        this.costPush(sporadic);
        BankFlowVO bankFlowVO = BankFlowVO.instanceVOBySourceType((BankFlowSourceType)BankFlowSourceType.\u4ed8\u6b3e\u9000\u8fd8, (String)"\u96f6\u661f\u4ed8\u6b3e\u9000\u56de");
        bankFlowVO.setTradeOrgId(sporadic.getSupplierId());
        bankFlowVO.setTradeOrgName(sporadic.getSupplierName());
        bankFlowVO.setOrgId(entity.getOrgId());
        bankFlowVO.setOrgName(entity.getOrgName());
        bankFlowVO.setSourceId(entity.getId());
        bankFlowVO.setBillId(entity.getPayapplyId());
        bankFlowVO.setBillCode(entity.getBillCode());
        bankFlowVO.setBillDate(entity.getConfirmTime());
        bankFlowVO.setAccountId(entity.getAccountId());
        bankFlowVO.setAccountName(entity.getAccountName());
        bankFlowVO.setAccountNum(entity.getAccountNum());
        bankFlowVO.setAccountBank(entity.getAccountBank());
        bankFlowVO.setReceiveMoney(entity.getThisPayMny() != null ? entity.getThisPayMny().abs() : entity.getThisPayMny());
        bankFlowVO.setMemo(entity.getMemo());
        this.bankFlowService.saveFlowVO(bankFlowVO);
    }

    @Override
    public BigDecimal fetchSjzcje(Long projectId) {
        Assert.notNull((Object)projectId, (String)"\u9879\u76eeid\u4e0d\u80fd\u4e3a\u7a7a");
        return ((PaySporadicMapper)this.baseMapper).fetchSjzcje(projectId, null);
    }

    static {
        sporadicPaymentTypeNameMap.put("1", "\u96f6\u661f\u6750\u6599");
        sporadicPaymentTypeNameMap.put("2", "\u96f6\u661f\u673a\u68b0");
        sporadicPaymentTypeNameMap.put("3", "\u5176\u4ed6");
        sporadicPaymentTypeNameMap.put("4", "\u96f6\u661f\u7528\u5de5");
    }
}

