/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.finance.bean.PayInvoiceEntity;
import com.ejianc.business.finance.service.IPayInvoiceService;
import com.ejianc.business.finance.vo.PayInvoiceUseVO;
import com.ejianc.business.tax.api.IInvoiceApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/payInvoice"})
public class PayInvoiceController {
    @Autowired
    private IPayInvoiceService invoiceService;
    @Autowired
    private IInvoiceApi invoiceApi;
    @Autowired
    private IOrgApi orgApi;

    @RequestMapping(value={"/refer"})
    @ResponseBody
    public CommonResponse<JSONObject> refer(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="condition", required=false) String condition, @RequestParam(value="searchText", required=false) String searchText) {
        List invoiceList;
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setSearchText(searchText);
        queryParam.getFuzzyFields().add("invoiceNumber");
        queryParam.getFuzzyFields().add("invoiceCode");
        queryParam.getComplexParams().add(ComplexParam.getApprovedComplexParam((String)"and"));
        if (StringUtils.isNotBlank((CharSequence)condition)) {
            JSONObject obj = JSONObject.parseObject((String)condition);
            if (condition.contains("orgId")) {
                queryParam.getParams().put("orgId", new Parameter("eq", (Object)obj.getLong("orgId")));
            }
            if (condition.contains("contractId")) {
                queryParam.getParams().put("contractId", new Parameter("eq", (Object)obj.getLong("contractId")));
            }
        }
        if (!(invoiceList = this.invoiceService.list((Wrapper)new QueryWrapper().eq((Object)"use_flag", (Object)2))).isEmpty()) {
            queryParam.getParams().put("id", new Parameter("not_in", invoiceList.stream().map(PayInvoiceEntity::getInvoiceId).collect(Collectors.toList())));
        }
        CommonResponse page = this.invoiceApi.invoiceReceiveRef(queryParam);
        return page;
    }

    @RequestMapping(value={"/queryUseList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<PayInvoiceUseVO>> queryUseList(@RequestBody PayInvoiceUseVO payInvoiceUseVO) {
        List<PayInvoiceUseVO> list = this.invoiceService.queryUseList(payInvoiceUseVO.getInvoiceId());
        return CommonResponse.success((String)"\u67e5\u8be2\u4f7f\u7528\u6b64\u53d1\u7968\u7684\u5408\u540c\u4ed8\u6b3e\u3001\u96f6\u661f\u4ed8\u6b3e\u3001\u8d39\u7528\u62a5\u9500\u5217\u8868\u6570\u636e\u6210\u529f\uff01", list);
    }

    @RequestMapping(value={"/queryOpenUseList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<PayInvoiceUseVO>> queryOpenUseList(@RequestBody PayInvoiceUseVO payInvoiceUseVO) {
        List<PayInvoiceUseVO> list = this.invoiceService.queryOpenUseList(payInvoiceUseVO.getInvoiceId());
        return CommonResponse.success((String)"\u67e5\u8be2\u4f7f\u7528\u6b64\u53d1\u7968\u7684\u6536\u6b3e\u767b\u8bb0\u5217\u8868\u6570\u636e\u6210\u529f\uff01", list);
    }
}

