package com.ejianc.business.bank.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.bank.bean.BankAcctEntity;
import com.ejianc.business.bank.bean.BankFlowEntity;
import com.ejianc.business.bank.mapper.BankFlowMapper;
import com.ejianc.business.bank.service.IBankAcctService;
import com.ejianc.business.bank.service.IBankFlowService;
import com.ejianc.business.bank.vo.BankAcctVO;
import com.ejianc.business.bank.vo.BankFlowVO;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 账户收支流水
 *
 * @author generator
 *
 */
@Service("bankFlowService")
public class BankFlowServiceImpl extends BaseServiceImpl<BankFlowMapper, BankFlowEntity> implements IBankFlowService {

    @Autowired
    private IBankAcctService bankAcctService;

    @Override
    public Boolean delFlowBySource(Long sourceId, Long billId) {
        Boolean b = Boolean.FALSE;
        if (sourceId != null || billId != null) {
            LambdaQueryWrapper<BankFlowEntity> bankFlowEntityLambdaQueryWrapper = new LambdaQueryWrapper<>();
            bankFlowEntityLambdaQueryWrapper.eq(sourceId != null, BankFlowEntity::getSourceId, sourceId);
            bankFlowEntityLambdaQueryWrapper.eq(billId != null, BankFlowEntity::getBillId, billId);
            b = this.remove(bankFlowEntityLambdaQueryWrapper);
        }
        return b;
    }

    @Override
    public BankFlowVO saveFlowVO(BankFlowVO bankFlowVO) {
        if (bankFlowVO != null) {
            bankFlowVO.setSourceExtName(Optional.ofNullable(bankFlowVO.getSourceExtName()).orElse(bankFlowVO.getSourceName()));
            bankFlowVO.setBillDate(Optional.ofNullable(bankFlowVO.getBillDate()).orElse(new Date()));
            Long accountId = bankFlowVO.getAccountId();
            if (accountId != null) {
                BankAcctEntity acctEntity = bankAcctService.getById(accountId);
                bankFlowVO.setAccountOrgId(acctEntity.getOrgId());
                bankFlowVO.setAccountOrgName(acctEntity.getOrgName());
            }
            BankFlowEntity entity = BeanMapper.map(bankFlowVO, BankFlowEntity.class);
            this.saveOrUpdateNoES(entity);
            return BeanMapper.map(entity, BankFlowVO.class);
        }
        return null;
    }

    @Override
    public void getSurplusMny(List<BankAcctVO> bankAcctVOS) {
        if(CollectionUtils.isNotEmpty(bankAcctVOS)){
            List<Long> accountIds = bankAcctVOS.stream().map(t -> t.getId()).collect(Collectors.toList());
            List<BankAcctVO> surplusList = baseMapper.querySurplusMnyByAccountIds(accountIds);
            Map<Long, BankAcctVO> map = new HashMap<>();
            if (CollectionUtils.isNotEmpty(surplusList)) {
                map = surplusList.stream().collect(Collectors.toMap(BankAcctVO::getId, e -> e));
            }
            for (BankAcctVO bankAcctVO : bankAcctVOS) {
                Long id = bankAcctVO.getId();
                BankAcctVO surBank = map.get(id);
                BigDecimal receMny = surBank != null ? surBank.getReceiveMoney() : BigDecimal.ZERO;
                bankAcctVO.setReceiveMoney(receMny);
                BigDecimal payMny = surBank != null ? surBank.getPayMoney() : BigDecimal.ZERO;
                bankAcctVO.setPayMoney(payMny);
                BigDecimal _surplus = ComputeUtil.safeSub(receMny, payMny);
                bankAcctVO.setSurplusMny(_surplus);
            }
        }
    }
}
