package com.ejianc.business.finance.service;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.finance.util.NoticeEnum;
import com.ejianc.business.finance.vo.PayRecordVO;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 * @author songlx
 * @version 1.0
 * @description: 微信公众号消息通知
 * @date 2021/10/20
 */
@Service
public class PayRecordMessageService {

    private final Logger logger = LoggerFactory.getLogger(getClass());


    @Value("${common.env.base-host}")
    private String baseHost;

    @Value("${weixin_template.check_id}")
    private String weixinCheckTemplateId;

    @Autowired
    private IPushMessageApi pushMessageApi;

    @Autowired
    private IDefdocApi defdocApi;


    public CommonResponse<String> sendMsg(PayRecordVO payRecordVO, String[] receivers, NoticeEnum notice) {
        if (payRecordVO != null) {
            String url = "";
            String feeTypeName = "";
            String mobileUrl = "ejc-finance-mobile/#/newPayContract/card?id=";
            String supplierText = "";
            if ("工人工资-有合同".equals(payRecordVO.getApplyType())) {
                url = "ejc-finance-frontend/#/paymentList/contractCard?id=" + payRecordVO.getPayapplyId();
                feeTypeName = payRecordVO.getSalaryApplyTypeName();
                notice.setSubject("工人工资付款申请(有合同)");
            } else if ("工人工资-无合同".equals(payRecordVO.getApplyType())) {
                url = "ejc-finance-frontend/#/paymentList/sporadicCard?id=" + payRecordVO.getPayapplyId();
                feeTypeName = payRecordVO.getSalaryApplyTypeName();
                mobileUrl = "ejc-finance-mobile/#/paySporadic/card?id=";
                notice.setSubject("工人工资付款申请(无合同)");
            } else if ("合同付款".equals(payRecordVO.getApplyType())) {
                url = "ejc-finance-frontend/#/paymentList/contractCard?id=" + payRecordVO.getPayapplyId();
                if (payRecordVO.getFeeType() == 1) {
                    feeTypeName = "-预付款";
                } else if (payRecordVO.getFeeType() == 2) {
                    feeTypeName = "-过程款";
                } else {
                    feeTypeName = "-其他";
                }
                supplierText = "供应商：" + payRecordVO.getReceiveUnitName() + "；";
                notice.setSubject("合同付款申请");
            } else if ("零星采购".equals(payRecordVO.getApplyType())) {
                url = "ejc-finance-frontend/#/paymentList/sporadicCard?id=" + payRecordVO.getPayapplyId();
                mobileUrl = "ejc-finance-mobile/#/paySporadic/card?id=";
                supplierText = "供应商：" + payRecordVO.getReceiveUnitName() + "；";
                notice.setSubject("零星采购付款申请");
            } else if ("报销".equals(payRecordVO.getApplyType())) {
                url = "ejc-finance-frontend/#/paymentList/reimburseProCard?id=" + payRecordVO.getPayapplyId();
                mobileUrl = "ejc-finance-mobile/#/reimbursePro/projectDetails?id=";
                notice.setSubject("报销付款申请");
            } else if ("押金".equals(payRecordVO.getApplyType())) {
                url = "ejc-finance-frontend/#/paymentList/foregiftCard?id=" + payRecordVO.getPayapplyId();
                mobileUrl = "ejc-finance-mobile/#/payForegift/card?id=";
                notice.setSubject("押金付款申请");
            } else if ("备用金".equals(payRecordVO.getApplyType())) {
                url = "ejc-finance-frontend/#/loadList/loadApplyCard?id=" + payRecordVO.getPayapplyId();
                mobileUrl = "ejc-finance-mobile/#/loadApply/loadApplyCard?id=";
                notice.setSubject("备用金付款申请");
            }
            logger.info("发送消息开始========= msgId = "+payRecordVO.getMsgId() + "，msgBillCode = "+payRecordVO.getMsgBillCode());

            PushMsgParameter parameter = new PushMsgParameter();
            List<String> channel = new ArrayList<>();
            channel.add(PushMsgParameter.CHANNEL_TYPE_WEIXIN);
            channel.add(PushMsgParameter.CHANNEL_TYPE_SYS);

            HashMap<String, String> keyMap = new HashMap<>();
            keyMap.put("#FEETYPE#", payRecordVO.getApplyType() + feeTypeName);
            keyMap.put("#BILLCODE#", payRecordVO.getMsgBillCode());
            keyMap.put("#THISPAYMNY#", String.valueOf(ComputeUtil.scaleTwo(payRecordVO.getThisPayMny())));
            keyMap.put("#ID#", String.valueOf(payRecordVO.getMsgId()));
            keyMap.put("#BASEHOST#", baseHost+url);
            logger.info("发送消息开始========= url = "+baseHost+url);
            if (StringUtils.isNotBlank(weixinCheckTemplateId)) {
                // 微信公众号消息
                String remark = "费用类型："+ payRecordVO.getApplyType() + feeTypeName + "；" + supplierText + "付款申请金额：" + ComputeUtil.scaleTwo(payRecordVO.getApplyMny()) + "元；含本期累计支付金额：" + ComputeUtil.scaleTwo(payRecordVO.getMsgPayMny()) + "元；";
                JSONObject weixinParams = new JSONObject();
                weixinParams.put("template_id", weixinCheckTemplateId);
                JSONObject wxparams = new JSONObject();
                wxparams.put("amount2", String.valueOf(ComputeUtil.scaleTwo(payRecordVO.getThisPayMny())));
                wxparams.put("character_string3", payRecordVO.getMsgBillCode());
                weixinParams.put("data", wxparams);
                logger.info("==============================微信公众号===================================================");
                mobileUrl += payRecordVO.getPayapplyId() + "&openid={openid}";
                logger.info("mobileUrl = "+ mobileUrl);
                weixinParams.put("url", baseHost + mobileUrl);
                parameter.setWeixinParams(weixinParams);
            } else {
                logger.info("未配置微信公众号模板，故不发微信公众号消息");
            }

            parameter.setReceivers(receivers);// 收信人
            parameter.setChannel(channel.toArray(new String[channel.size()]));// 消息类型
            parameter.setMsgType("notice");
            parameter.setSubject(notice.getSubject() + "【单据编号:" + payRecordVO.getMsgBillCode() + "】支付成功通知：本次支付金额 " + ComputeUtil.scaleTwo(payRecordVO.getThisPayMny()) + " 元！");// 标题
            logger.info("==============================系统消息===================================================");
            String sysContent = NoticeEnum.getPcContent(notice, keyMap);
            logger.info("sysContent = "+ sysContent);
            parameter.setContent(sysContent);// 内容
            parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
            parameter.setSendUserId(InvocationInfoProxy.getUserid());
            try {
                CommonResponse<String> result = pushMessageApi.pushMessage(parameter);
                if (result.isSuccess()) {
                    logger.error("消息发送成功---------------->" + result.getMsg());
                } else {
                    logger.error("消息发送失败---------------->" + result.getMsg());
                }
            } catch (Exception e) {
                logger.error("调用消息中心RPC服务异常--------------" + e);
            }
        }
        return CommonResponse.success();
    }

}
