package com.ejianc.business.finance.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.bank.bean.BankAcctEntity;
import com.ejianc.business.bank.bean.BankFlowEntity;
import com.ejianc.business.bank.consts.BankFlowSourceType;
import com.ejianc.business.bank.mapper.BankFlowMapper;
import com.ejianc.business.bank.service.IBankAcctService;
import com.ejianc.business.bank.service.IBankFlowService;
import com.ejianc.business.bank.vo.BankFlowVO;
import com.ejianc.business.finance.bean.BondUpDealEntity;
import com.ejianc.business.finance.bean.BondUpEntity;
import com.ejianc.business.finance.mapper.BondUpDealMapper;
import com.ejianc.business.finance.service.IBidBondService;
import com.ejianc.business.finance.service.IBondUpDealService;
import com.ejianc.business.finance.service.IBondUpService;
import com.ejianc.business.finance.vo.BondUpDealRentVO;
import com.ejianc.business.finance.vo.BondUpDealVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 保证金办理表 服务实现类
 * </p>
 *
 * @author sunyj
 * @since 2020-06-16
 */
@Service
public class BondUpDealServiceImpl extends BaseServiceImpl<BondUpDealMapper, BondUpDealEntity> implements IBondUpDealService {

    private static final String BONGUP_DEAL = "BONGUP_DEAL";

    @Autowired
    private IBondUpService bondUpService;

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IBankFlowService bankFlowService;

    @Autowired
    private IBankAcctService bankAcctService;
    @Override
    public BondUpDealVO insertOrUpdate(BondUpDealVO bondUpDealVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        List<BondUpDealEntity> entities = null;
        if(StringUtils.isEmpty(bondUpDealVO.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BONGUP_DEAL,tenantId);
            if(billCode.isSuccess()) {
                bondUpDealVO.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        BondUpDealEntity entity = BeanMapper.map(bondUpDealVO, BondUpDealEntity.class);
        if(null!=bondUpDealVO.getId()&&bondUpDealVO.getId()>0){
            //编辑
            LambdaQueryWrapper<BondUpDealEntity> lambda = Wrappers.<BondUpDealEntity>lambdaQuery();
            lambda.eq(BondUpDealEntity::getBillCode, bondUpDealVO.getBillCode());
            lambda.eq(BondUpDealEntity::getTenantId, tenantId);
            lambda.ne(BondUpDealEntity::getId, bondUpDealVO.getId());
            entities = super.list(lambda);
            //需要将本次数据新增，将之前数据改为作废
            LambdaUpdateWrapper<BondUpDealEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.eq(BondUpDealEntity::getId,entity.getId());
            updateWrapper.set(BondUpDealEntity::getDealStatus,"2");
            super.update(updateWrapper);
            //将作废的支出流水删除
            bankFlowService.delFlowBySource(entity.getId(),entity.getBondId());
            entity.setId(null);
        }else{
            //新增
            //校验合同编号是否重复
            LambdaQueryWrapper<BondUpDealEntity> lambda = Wrappers.<BondUpDealEntity>lambdaQuery();
            lambda.eq(BondUpDealEntity::getTenantId, tenantId);
            lambda.eq(BondUpDealEntity::getBillCode, bondUpDealVO.getBillCode());
            entities = super.list(lambda);
        }
        if(entities != null && entities.size() > 0 ) {
            throw new BusinessException("存在相同编码，不允许保存!");
        }
        entity.setDealStatus("1");
        entity.setDealTime(new Date());
        super.saveOrUpdate(entity,false);
        //==================推送收支流水
        BondUpEntity bondUpEntity = bondUpService.selectById(entity.getBondId());
        BankAcctEntity bankAcctEntity = bankAcctService.selectById(entity.getPayAccountId());
        BankFlowVO flowVO= BankFlowVO.instanceVOBySourceType(BankFlowSourceType.对上保证金支付);
        flowVO.setBillDate(new Date());
        flowVO.setSourceId(entity.getId());
        flowVO.setBillId(entity.getBondId());
        flowVO.setPayMoney(entity.getBondMny());
        flowVO.setBillCode(entity.getBillCode());
        flowVO.setOrgId(bondUpEntity.getOrgId());
        flowVO.setOrgName(bondUpEntity.getOrgName());
        if (null!=bankAcctEntity) {
            flowVO.setAccountOrgId(bankAcctEntity.getOrgId());
            flowVO.setAccountOrgName(bankAcctEntity.getOrgName());
        }
        flowVO.setAccountId(entity.getPayAccountId());
        flowVO.setAccountName(entity.getPayAccountName());
        flowVO.setAccountBank(entity.getPayAccountBank());
        flowVO.setAccountNum(entity.getPayAccountNum());

        flowVO.setTradeOrgId(bondUpEntity.getCustomerId());
        flowVO.setTradeOrgName(bondUpEntity.getCustomerName());
        flowVO.setTradeAccountName(bondUpEntity.getAccountName());
        flowVO.setTradeAccountBank(bondUpEntity.getBankName());
        flowVO.setTradeAccountNum(bondUpEntity.getBankAccount());
        flowVO.setMemo(entity.getMemo());
        bankFlowService.saveFlowVO(flowVO);
        //===============推送收支流水结束
        //回写申请单
        LambdaUpdateWrapper<BondUpEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(BondUpEntity::getId,entity.getBondId());
        updateWrapper.set(BondUpEntity::getBondStatus,"1");
        updateWrapper.set(BondUpEntity::getBeginDate,entity.getBeginDate());
        updateWrapper.set(BondUpEntity::getEndDate,entity.getEndDate());
        updateWrapper.set(BondUpEntity::getEmployeeId,entity.getEmployeeId());
        updateWrapper.set(BondUpEntity::getEmployeeName,entity.getEmployeeName());
        updateWrapper.set(BondUpEntity::getPayMny,entity.getBondMny());
        updateWrapper.set(BondUpEntity::getBondType,entity.getBondType());
        updateWrapper.set(BondUpEntity::getDealTime,entity.getDealTime());
        bondUpService.update(updateWrapper);
        return BeanMapper.map(entity, BondUpDealVO.class);
    }

    @Override
    public BondUpDealRentVO queryDetail(Long id) {
        BondUpDealRentVO vo = new BondUpDealRentVO();
        BondUpEntity upEntity = bondUpService.selectById(id);
        LambdaQueryWrapper<BondUpDealEntity> lambda = Wrappers.<BondUpDealEntity>lambdaQuery();
        lambda.eq(BondUpDealEntity::getBondId, id);
        lambda.orderBy(true,true,BondUpDealEntity::getDealStatus);
        List<BondUpDealEntity> list = super.list(lambda);
        vo = BeanMapper.map(upEntity,BondUpDealRentVO.class);
        if(CollectionUtils.isNotEmpty(list)){
            vo.setDealRecord(BeanMapper.mapList(list,BondUpDealVO.class));
        }
        return vo;
    }
}
