package com.ejianc.business.finance.service.impl;

import com.ejianc.business.finance.bean.PayInvoiceEntity;
import com.ejianc.business.finance.utils.BigDecimalUtil;
import com.ejianc.business.finance.vo.LoadInvoiceVO;
import com.ejianc.business.finance.vo.PayInvoiceVO;
import com.ejianc.business.tax.api.IInvoiceApi;
import com.ejianc.business.tax.vo.InvoiceReceiveFlagVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.finance.mapper.LoadInvoiceMapper;
import com.ejianc.business.finance.bean.LoadInvoiceEntity;
import com.ejianc.business.finance.service.IloadInvoiceService;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 借款报销发票信息
 * 
 * @author generator
 * 
 */
@Service("loadInvoiceService")
public class LoadInvoiceServiceImpl extends BaseServiceImpl<LoadInvoiceMapper, LoadInvoiceEntity> implements IloadInvoiceService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    private IInvoiceApi invoiceApi;


    /**
     * @param voList
     * @param id
     * @description: 保存编辑回写 收票占用金额
     * @return: com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     * @author songlx
     * @date: 2021/8/17
     */
    @Override
    public CommonResponse<String> updateInvoiceUsedMnyBySave(List<LoadInvoiceVO> voList, Long id) {
        CommonResponse<String> res = CommonResponse.success();
        QueryParam param = new QueryParam();
        param.getParams().put("reimburseId", new Parameter(QueryParam.EQ, id));
        // 查询关联发票
        List<LoadInvoiceEntity> oldInvoiceList = id != null ? this.queryList(param, false) : null;
        // 新增
        if (CollectionUtils.isNotEmpty(voList)) {
            Map<Long, LoadInvoiceEntity> invoiceEntityMap = CollectionUtils.isNotEmpty(oldInvoiceList) ? oldInvoiceList.stream().collect(Collectors.toMap(LoadInvoiceEntity::getId, Function.identity())) : null;
            //收票改为占用方式
            List<InvoiceReceiveFlagVO> updates = new ArrayList<>();
            voList.forEach(t -> {
                BigDecimal old = t.getId() != null && invoiceEntityMap != null && invoiceEntityMap.get(t.getId()) != null ? invoiceEntityMap.get(t.getId()).getUsedInvoiceTaxMny() : BigDecimal.ZERO;
                InvoiceReceiveFlagVO v = new InvoiceReceiveFlagVO();
                v.setId(t.getInvoiceId());
                if ("del".equals(t.getRowState()) && t.getId() != null) {
                    v.setNowUesdInvoiceTaxMny(BigDecimalUtil.convertToMinusNumber(old));
                } else {
                    v.setNowUesdInvoiceTaxMny(BigDecimalUtil.safeSub(t.getUsedInvoiceTaxMny(), old));
                }
                updates.add(v);
            });
            if (invoiceEntityMap != null && invoiceEntityMap.size() > 0) {
                List<Long> newInoviceIds = voList.stream().filter(s -> s.getId() != null).map(LoadInvoiceVO::getId).collect(Collectors.toList());
                for (Map.Entry<Long, LoadInvoiceEntity> m : invoiceEntityMap.entrySet()) {
                    if (!newInoviceIds.contains(m.getKey())) {
                        LoadInvoiceEntity t = m.getValue();
                        InvoiceReceiveFlagVO v = new InvoiceReceiveFlagVO();
                        v.setId(t.getInvoiceId());
                        v.setNowUesdInvoiceTaxMny(BigDecimalUtil.convertToMinusNumber(t.getUsedInvoiceTaxMny()));
                        updates.add(v);
                    }
                }
            }
            res = invoiceApi.updateUsedInvoiceMny(updates);
        } else {
            if (CollectionUtils.isNotEmpty(oldInvoiceList)) {
                List<InvoiceReceiveFlagVO> updates = new ArrayList<>();
                oldInvoiceList.forEach(t -> {
                    InvoiceReceiveFlagVO v = new InvoiceReceiveFlagVO();
                    v.setId(t.getInvoiceId());
                    v.setNowUesdInvoiceTaxMny(BigDecimalUtil.convertToMinusNumber(t.getUsedInvoiceTaxMny()));
                    updates.add(v);
                });
                res = invoiceApi.updateUsedInvoiceMny(updates);

            }
        }
        if (!res.isSuccess()) {
            logger.error("回写收票已使用金额失败：" + res.getMsg());
        }
        return res;
    }

    /**
     * @param ids
     * @description: 申请删除 回写 收票占用金额
     * @return: com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     * @author songlx
     * @date: 2021/8/17
     */
    @Override
    public CommonResponse<String> updateInvoiceUsedMnyByDel(List<Long> ids) {
        QueryParam param = new QueryParam();
        param.getParams().put("reimburseId", new Parameter(QueryParam.IN, ids));
        // 查询关联发票
        List<LoadInvoiceEntity> invoiceEntityList = this.queryList(param, false);
        if (CollectionUtils.isNotEmpty(invoiceEntityList)) {
            //收票改为占用方式
            List<InvoiceReceiveFlagVO> updates = new ArrayList<>();
            invoiceEntityList.forEach(t -> {
                InvoiceReceiveFlagVO v = new InvoiceReceiveFlagVO();
                v.setId(t.getInvoiceId());
                v.setNowUesdInvoiceTaxMny(BigDecimalUtil.convertToMinusNumber(t.getUsedInvoiceTaxMny()));
                updates.add(v);
            });
            CommonResponse<String> res = invoiceApi.updateUsedInvoiceMny(updates);
            if (!res.isSuccess()) {
                logger.error("付款申请删除逆回写收票已使用金额报错：" + res.getMsg());
            }
        }
        return CommonResponse.success();
    }
}
