package com.ejianc.business.finance.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.bank.bean.BankFlowEntity;
import com.ejianc.business.bank.service.IBankFlowService;
import com.ejianc.business.finance.bean.BondDownBackEntity;
import com.ejianc.business.finance.bean.BondDownDealEntity;
import com.ejianc.business.finance.bean.BondDownEntity;
import com.ejianc.business.finance.bean.BondUpBackEntity;
import com.ejianc.business.finance.service.IBondDownBackService;
import com.ejianc.business.finance.service.IBondDownDealService;
import com.ejianc.business.finance.service.IBondDownService;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 * 对下保证金申请审批事件
 * </p>
 *
 * @author sunyj
 * @since 2020-06-04
 */
@Service("bondDown")
public class BondDownBpmServiceImpl implements ICommonBusinessService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBondDownService bondDownService;

    @Autowired
    private IBondDownDealService bondDownDealService;

    @Autowired
    private IBondDownBackService bondDownBackService;

    @Autowired
    private IBankFlowService bankFlowService;
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state,String billTypeCode) {
        logger.info("进入弃审后回写--- billId:"+billId+"  state:"+state);
        BondDownEntity upEntity = bondDownService.selectById(billId);
        upEntity.setBondStatus("0");
        upEntity.setBackMny(BigDecimal.ZERO);
        upEntity.setPayMny(BigDecimal.ZERO);
        upEntity.setEmployeeId(null);
        upEntity.setEmployeeName(null);
        boolean res = bondDownService.saveOrUpdate(upEntity,false);
        //流水删除
        bankFlowService.delFlowBySource(null,upEntity.getId());
        QueryWrapper<BondDownDealEntity> dealWrapper = new QueryWrapper<>();
        dealWrapper.eq("bond_id", billId);
        bondDownDealService.remove(dealWrapper,false);

        QueryWrapper<BondDownBackEntity> backWrapper = new QueryWrapper<>();
        backWrapper.eq("bond_id", billId);
        //删除对下保证金退还记录======因保证金退还为单独单据因此特殊处理
        List<BondDownBackEntity> bondDownBackEntities = bondDownBackService.list(backWrapper);
        if (CollectionUtils.isNotEmpty(bondDownBackEntities)){
            List<Long> ids = bondDownBackEntities.stream().map(BondDownBackEntity::getId).collect(Collectors.toList());
            LambdaQueryWrapper<BankFlowEntity> bankFlowEntityLambdaQueryWrapper = new LambdaQueryWrapper<>();
            bankFlowEntityLambdaQueryWrapper.in( BankFlowEntity::getBillId, ids);
            bankFlowService.remove(bankFlowEntityLambdaQueryWrapper,false);
        }
        bondDownBackService.remove(backWrapper,false);
        if(res){
            return CommonResponse.success("回退成功!");
        }else{
            return CommonResponse.error("回退出现异常，请刷新后再试!");
        }
    }

}
