package com.ejianc.business.finance.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author yqls
 * @since 2020-06-04
 */
@TableName("ejc_finance_pay_contract")
public class PayContractEntity extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 单据编号
     */
    @TableField("bill_code")
    private String billCode;

    /**
     * 单据状态：0-自由态，1-已提交，2-审批中，3-审批通过，4-审批不通过
     */
    @TableField("bill_state")
    private Integer billState;

    /**
     * 经办人
     */
    @TableField("employee_id")
    private Long employeeId;

    /**
     * 经办人名称
     */
    @TableField("employee_name")
    private String employeeName;

    /**
     * 经办时间
     */
    @TableField("confirm_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date confirmTime;

    /**
     * 备注
     */
    @TableField("memo")
    private String memo;

    /**
     * 付款类型：1-组织付款 2-项目付款
     */
    @TableField("pay_type")
    private Integer payType;

    /**
     * 支付状态：1-未支付 2-已支付
     */
    @TableField("pay_status")
    private Integer payStatus;

    /**
     * 支付金额
     */
    @TableField("pay_mny")
    private BigDecimal payMny;

    /**
     * 合同主键
     */
    @TableField("contract_id")
    private Long contractId;

    /**
     * 合同类型：1-分包,2-设备采购,3-设备租赁,4-物资采购,5-物资租赁
     */
    @TableField("contract_type")
    private Long contractType;

    /**
     * 合同编码
     */
    @TableField("contract_code")
    private String contractCode;

    /**
     * 合同付款方式
     */
    @TableField("content")
    private String content;

    @TableField("oth_contract_type")
    private Long othContractType;


    @TableField("oth_contract_type_name")
    private String othContractTypeName;
    /**
     * 合同名称
     */
    @TableField("contract_name")
    private String contractName;

    /**
     * 项目
     */
    @TableField("project_id")
    private Long projectId;

    /**
     * 项目名称
     */
    @TableField("project_name")
    private String projectName;

    /**
     * 项目类型：1-自营，2-联营
     */
    @TableField("project_type")
    private String projectType;

    /**
     * 组织
     */
    @TableField("org_id")
    private Long orgId;

    /**
     * 组织名称
     */
    @TableField("org_name")
    private String orgName;

    /**
     * 支付属性：1-预付款，2-过程款，3-其他
     */
    @TableField("fee_type")
    private Long feeType;

    /**
     * 支付类型
     */
    @TableField("fee_kind")
    private Long feeKind;

    /**
     * 支付类型
     */
    @TableField("fee_kind_name")
    private String feeKindName;

    /**
     * 付款事由
     */
    @TableField("pay_reason")
    private String payReason;

    /**
     * 收款单位
     */
    @TableField("receive_unit_id")
    private Long receiveUnitId;

    /**
     * 收款单位名称
     */
    @TableField("receive_unit_name")
    private String receiveUnitName;


    /**
     * 付款单位
     */
    @TableField("pay_unit_id")
    private Long payUnitId;

    /**
     * 付款单位名称
     */
    @TableField("pay_unit_name")
    private String payUnitName;

    /**
     * 合同金额
     */
    @TableField("contract_mny")
    private BigDecimal contractMny;

    /**
     * 已结算金额
     */
    @TableField("sum_settle_mny")
    private BigDecimal sumSettleMny;

    /**
     * 累计已付
     */
    @TableField("sum_pay_mny")
    private BigDecimal sumPayMny;

    /**
     * 已收票金额
     */
    @TableField("sum_invoice_mny")
    private BigDecimal sumInvoiceMny;

    /**
     * 申请人
     */
    @TableField("apply_user_id")
    private Long applyUserId;

    /**
     * 申请人名称
     */
    @TableField("apply_user_name")
    private String applyUserName;

    /**
     * 申请时间
     */
    @TableField("apply_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date applyTime;

    /**
     * 申请金额
     */
    @TableField("apply_mny")
    private BigDecimal applyMny;

    /**
     * 账户名称
     */
    @TableField("account_name")
    private String accountName;

    /**
     * 银行账号
     */
    @TableField("account_num")
    private String accountNum;

    /**
     * 开户行
     */
    @TableField("account_bank")
    private String accountBank;

    /**
     * 发票金额
     */
    @TableField("invoice_mny")
    private BigDecimal invoiceMny;

    /**
     * 撤回原因
     */
    @TableField("back_reason")
    private String backReason;

    /**
     * 撤回时间
     */
    @TableField("back_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date backTime;

    /**
     * 合同支付比例
     */
    @TableField("pay_scale")
    private BigDecimal payScale;

    /**
     * 已支付比例
     */
    @TableField("be_pay_scale")
    private BigDecimal bePayScale;

    /**
     * 截止本期申请比例（按结算）
     */
    @TableField("endthis_pay_scale")
    private BigDecimal endthisPayScale;

    /**
     * 审批时间
     */
    @TableField("approve_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date approveTime;

    /**
     * 采购类型 1-自采，2-集采
     */
    @TableField("purchase_type")
    private String purchaseType;

    /**
     * 属于项目:1-是，0-否
     */
    @TableField("depend_on_project")
    private String dependOnProject;

    /**
     * 项目类型名称
     */
    @TableField("project_type_name")
    private String projectTypeName;

    /**
     * 是否需要发票：1 需要，2 不需要，3 不确定
     */
    private String invoiceFlag;


    /**
     * 截止本期申请比例（按合同）
     */
    @TableField("endthis_pay_scale_by_contract")
    private BigDecimal endthisPayScaleByContract;

    /**
     * 对甲回款比例
     */
    @TableField("collect_ratio")
    private BigDecimal collectRatio;

    /**
     * 项目收款总额
     */
    @TableField("sum_collect_mny")
    private BigDecimal sumCollectMny;

    /**
     * 累计完成产值
     */
    @TableField("sum_production_tax_mny")
    private BigDecimal sumProductionTaxMny;

    /**
     * 截止上期已申请
     */
    @TableField("sum_apply_mny")
    private BigDecimal sumApplyMny;

    /**
     * 申请金额大写
     */
    @TableField("apply_mny_cn")
    private String applyMnyCn;
    @TableField("wait_deduct_Mny")
    private BigDecimal waitDeductMny;//据主表选择项目+供应商，查询这个供应商+合项目下所有已生效未被引用过的累计扣款单金额

    /**
     *************start************************项目资金改造***************************start*******************************
     */

    @TableField(value="pro_contract_mny")
    private java.math.BigDecimal proContractMny; // 收入合同金额
    @TableField(value="pro_output_mny")
    private java.math.BigDecimal proOutputMny; // 完成产值
    @TableField(value="pro_date_progress")
    private java.math.BigDecimal proDateProgress; // 日期进度
    @TableField(value="pro_output_progress")
    private java.math.BigDecimal proOutputProgress; // 产值进度
    @TableField(value="pro_contract_receive_mny")
    private java.math.BigDecimal proContractReceiveMny; // 合同累计收款金额
    @TableField(value="pro_receive_mny")
    private java.math.BigDecimal proReceiveMny; // 累计收款
    @TableField(value="pro_pay_mny")
    private java.math.BigDecimal proPayMny; // 累计付款
    @TableField(value="pro_cost_list_surplus")
    private java.math.BigDecimal proCostListSurplus; // 费用清单结余
    @TableField(value="pro_transfer_surplus")
    private java.math.BigDecimal proTransferSurplus; // 项目代转款款结余
    @TableField(value="pro_risk_margin_surplus")
    private java.math.BigDecimal proRiskMarginSurplus; // 风险保证金结余
    @TableField(value="pro_loan_balance")
    private java.math.BigDecimal proLoanBalance; // 借款结余
    @TableField(value="pro_loan_interest")
    private java.math.BigDecimal proLoanInterest; // 借款利息
    @TableField(value="pro_other_fee_deduct")
    private java.math.BigDecimal proOtherFeeDeduct; // 其他费用扣除
    @TableField(value="pro_other_fee_back")
    private java.math.BigDecimal proOtherFeeBack; // 其他费用退还
    @TableField(value="pro_surplus_mny")
    private java.math.BigDecimal proSurplusMny; // 项目可用资金
    @TableField(value="pro_surplus_apply_mny")
    private java.math.BigDecimal proSurplusApplyMny; // 剩余可申请金额release
    @TableField(value="pro_petty_cash")
    private java.math.BigDecimal proPettyCash; // 备用金结余
    @TableField(value="pro_manage_scale")
    private java.math.BigDecimal proManageScale; // 管理费比例
    @TableField(value="pro_manage_fee")
    private java.math.BigDecimal proManageFee; // 管理费
    @TableField(value="pro_amerce")
    private java.math.BigDecimal proAmerce; // 罚款
    @TableField(value="pro_apply_unpay_mny")
    private java.math.BigDecimal proApplyUnpayMny; // 已申请未支付金额

    public BigDecimal getProApplyUnpayMny() {
        return proApplyUnpayMny;
    }

    public void setProApplyUnpayMny(BigDecimal proApplyUnpayMny) {
        this.proApplyUnpayMny = proApplyUnpayMny;
    }

    /**
     *************end************************项目资金改造***************************end*******************************
     */


    @TableField(value="contract_stage_id")
    private Long contractStageId; // 合同付款阶段id
    @TableField(value="contract_stage_scale")
    private BigDecimal contractStageScale; // 合同付款阶段比例
    @TableField(value="contract_stage_name")
    private String contractStageName; // 合同付款阶段名称
    @TableField(value="cur_penalty_money")
    private BigDecimal curPenaltyMoney; // 本期扣款金额合计
    @TableField(value="cur_settle_money")
    private BigDecimal curSettleMoney; // 本期结算金额合计
    @TableField(value="cur_contract_pay_money")
    private BigDecimal curContractPayMoney; // 本期合同应付金额合计

    /**
     * 世纪阳光字段 付款类型 1-保温，2-饰面，3-自有劳务********************************************************
     */
    @TableField("payment_type")
    private Integer paymentType;

    public Integer getPaymentType() {
        return paymentType;
    }

    public void setPaymentType(Integer paymentType) {
        this.paymentType = paymentType;
    }

    /**
     * 世纪阳光字段 付款类型 end*******************************************************************************
     */

    @TableField(value="income_code")
    private String incomeCode; // 施工合同编号

    /**
     * 剩余申请金额
     */
    @TableField("sum_surplus_apply_mny")
    private BigDecimal sumSurplusApplyMny;

    @TableField(value="project_short_name")
    private String projectShortName; // 项目简称



    @TableField(value="project_code")
    private String projectCode; // 项目编号

    @TableField(value="pay_way")
    private Long payWay; // 付款方式
    @TableField(value="pay_way_name")
    private String payWayName; // 付款方式名称

    /**
     * 确认收票标识：1-未确认收票，2-已确认
     */
    @TableField("receive_invoice_flag")
    private Integer receiveInvoiceFlag;

    @TableField(value = "psrm_returncode")
    private String psrmReturncode; // 数据中台状态

    @TableField(value = "psrm_code")
    private String psrmCode; // 数据中台编码

    @TableField(value = "psrm_returndata")
    private String psrmReturndata; // 数据中台返回数据

    //2025.8.5新增
    @TableField(value = "customer_name")
    private String customerName; // 甲方

    public String getPsrmReturncode() {
        return psrmReturncode;
    }

    public void setPsrmReturncode(String psrmReturncode) {
        this.psrmReturncode = psrmReturncode;
    }

    public String getPsrmCode() {
        return psrmCode;
    }

    public void setPsrmCode(String psrmCode) {
        this.psrmCode = psrmCode;
    }

    public String getPsrmReturndata() {
        return psrmReturndata;
    }

    public void setPsrmReturndata(String psrmReturndata) {
        this.psrmReturndata = psrmReturndata;
    }

    public Integer getReceiveInvoiceFlag() {
        return receiveInvoiceFlag;
    }

    public void setReceiveInvoiceFlag(Integer receiveInvoiceFlag) {
        this.receiveInvoiceFlag = receiveInvoiceFlag;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public Long getPayWay() {
        return payWay;
    }

    public void setPayWay(Long payWay) {
        this.payWay = payWay;
    }

    public String getPayWayName() {
        return payWayName;
    }

    public void setPayWayName(String payWayName) {
        this.payWayName = payWayName;
    }

    public String getProjectShortName() {
        return projectShortName;
    }

    public void setProjectShortName(String projectShortName) {
        this.projectShortName = projectShortName;
    }
    public BigDecimal getSumSurplusApplyMny() {
        return sumSurplusApplyMny;
    }

    public void setSumSurplusApplyMny(BigDecimal sumSurplusApplyMny) {
        this.sumSurplusApplyMny = sumSurplusApplyMny;
    }

    public Long getFeeKind() {
        return feeKind;
    }

    public void setFeeKind(Long feeKind) {
        this.feeKind = feeKind;
    }

    public String getFeeKindName() {
        return feeKindName;
    }

    public void setFeeKindName(String feeKindName) {
        this.feeKindName = feeKindName;
    }

    /**
     *  是否是工人工资：0-否，1-是
     */
    @TableField("salary_flag")
    private Integer salaryFlag;
    /**
     * 申请类型
     */
    @TableField("apply_type")
    private Long applyType;
    /**
     * 申请类型名称
     */
    @TableField("apply_type_name")
    private String applyTypeName;

    /**
     * 累计合同工资
     */
    @TableField("sum_contract_salary")
    private BigDecimal sumContractSalary;
    /**
     * 累计已申请金额
     */
    @TableField("total_apply_mny")
    private BigDecimal totalApplyMny;

    /**
     * 付款账户名
     */
    @TableField("pay_account_name")
    private String payAccountName;

    /**
     * 付款银行账号
     */
    @TableField("pay_account_num")
    private String payAccountNum;

    /**
     * 付款开户行
     */
    @TableField("pay_account_bank")
    private String payAccountBank;

    /**
     * 关闭前的本期申请金额
     */
    @TableField("apply_mny_before_close")
    private BigDecimal applyMnyBeforeClose;

    /**
     * 关闭状态
     */
    @TableField("close_state")
    private String closeState;

    /**
     * 关闭时间
     */
    @TableField("close_time")
    private Date closeTime;

    /**
     * 关闭人
     */
    @TableField("close_user")
    private String closeUser;

    /**
     * 是否关闭
     */
    @TableField("close_flag")
    private Boolean closeFlag;

    /**
     * 合同类型扩展：0-劳务分包,1-专业分包,2-设备采购,3-设备租赁,4-物资采购,5-周转材租赁,6-其他支出合同
     */
    @TableField("contract_type_extend")
    private Integer contractTypeExtend;

    public Integer getContractTypeExtend() {
        return contractTypeExtend;
    }

    public void setContractTypeExtend(Integer contractTypeExtend) {
        this.contractTypeExtend = contractTypeExtend;
    }

    public Boolean getCloseFlag() {
        return closeFlag;
    }

    public void setCloseFlag(Boolean closeFlag) {
        this.closeFlag = closeFlag;
    }

    public BigDecimal getApplyMnyBeforeClose() {
        return applyMnyBeforeClose;
    }

    public void setApplyMnyBeforeClose(BigDecimal applyMnyBeforeClose) {
        this.applyMnyBeforeClose = applyMnyBeforeClose;
    }

    public String getCloseState() {
        return closeState;
    }

    public void setCloseState(String closeState) {
        this.closeState = closeState;
    }

    public Date getCloseTime() {
        return closeTime;
    }

    public void setCloseTime(Date closeTime) {
        this.closeTime = closeTime;
    }

    public String getCloseUser() {
        return closeUser;
    }

    public void setCloseUser(String closeUser) {
        this.closeUser = closeUser;
    }

    public String getPayAccountName() {
        return payAccountName;
    }

    public void setPayAccountName(String payAccountName) {
        this.payAccountName = payAccountName;
    }

    public String getPayAccountNum() {
        return payAccountNum;
    }

    public void setPayAccountNum(String payAccountNum) {
        this.payAccountNum = payAccountNum;
    }

    public String getPayAccountBank() {
        return payAccountBank;
    }

    public void setPayAccountBank(String payAccountBank) {
        this.payAccountBank = payAccountBank;
    }

    /*@TableField(exist=false)
    @SubEntity(serviceName="payContractSummaryService",pidName = "payapplyId")
    private List<PayContractSummaryEntity> contractSummaryList = new ArrayList<>();

    @TableField(exist=false)
    @SubEntity(serviceName="payContractSalaryService",pidName = "payapplyId")
    private List<PayContractSalaryEntity> contractSalaryList = new ArrayList<>();*/

    public Integer getSalaryFlag() {
        return salaryFlag;
    }

    public void setSalaryFlag(Integer salaryFlag) {
        this.salaryFlag = salaryFlag;
    }

    public Long getApplyType() {
        return applyType;
    }

    public void setApplyType(Long applyType) {
        this.applyType = applyType;
    }

    public String getApplyTypeName() {
        return applyTypeName;
    }

    public void setApplyTypeName(String applyTypeName) {
        this.applyTypeName = applyTypeName;
    }

    public BigDecimal getSumContractSalary() {
        return sumContractSalary;
    }

    public void setSumContractSalary(BigDecimal sumContractSalary) {
        this.sumContractSalary = sumContractSalary;
    }

    /*public List<PayContractSummaryEntity> getContractSummaryList() {
        return contractSummaryList;
    }

    public void setContractSummaryList(List<PayContractSummaryEntity> contractSummaryList) {
        this.contractSummaryList = contractSummaryList;
    }

    public List<PayContractSalaryEntity> getContractSalaryList() {
        return contractSalaryList;
    }

    public void setContractSalaryList(List<PayContractSalaryEntity> contractSalaryList) {
        this.contractSalaryList = contractSalaryList;
    }*/

    public String getIncomeCode() {
        return incomeCode;
    }

    public void setIncomeCode(String incomeCode) {
        this.incomeCode = incomeCode;
    }

    public Long getPayUnitId() {
        return payUnitId;
    }

    public void setPayUnitId(Long payUnitId) {
        this.payUnitId = payUnitId;
    }

    public String getPayUnitName() {
        return payUnitName;
    }

    public void setPayUnitName(String payUnitName) {
        this.payUnitName = payUnitName;
    }

    public Long getContractStageId() {
        return contractStageId;
    }

    public void setContractStageId(Long contractStageId) {
        this.contractStageId = contractStageId;
    }

    public BigDecimal getContractStageScale() {
        return contractStageScale;
    }

    public void setContractStageScale(BigDecimal contractStageScale) {
        this.contractStageScale = contractStageScale;
    }

    public String getContractStageName() {
        return contractStageName;
    }

    public void setContractStageName(String contractStageName) {
        this.contractStageName = contractStageName;
    }

    public BigDecimal getCurPenaltyMoney() {
        return curPenaltyMoney;
    }

    public void setCurPenaltyMoney(BigDecimal curPenaltyMoney) {
        this.curPenaltyMoney = curPenaltyMoney;
    }

    public BigDecimal getCurSettleMoney() {
        return curSettleMoney;
    }

    public void setCurSettleMoney(BigDecimal curSettleMoney) {
        this.curSettleMoney = curSettleMoney;
    }

    public BigDecimal getCurContractPayMoney() {
        return curContractPayMoney;
    }

    public void setCurContractPayMoney(BigDecimal curContractPayMoney) {
        this.curContractPayMoney = curContractPayMoney;
    }

    @TableField(exist=false)
    private List<PayRecordEntity> recordList = new ArrayList<>(); // 付款申请记录实体

    public BigDecimal getProContractMny() {
        return proContractMny;
    }

    public void setProContractMny(BigDecimal proContractMny) {
        this.proContractMny = proContractMny;
    }

    public BigDecimal getProOutputMny() {
        return proOutputMny;
    }

    public void setProOutputMny(BigDecimal proOutputMny) {
        this.proOutputMny = proOutputMny;
    }

    public BigDecimal getProDateProgress() {
        return proDateProgress;
    }

    public void setProDateProgress(BigDecimal proDateProgress) {
        this.proDateProgress = proDateProgress;
    }

    public BigDecimal getProOutputProgress() {
        return proOutputProgress;
    }

    public void setProOutputProgress(BigDecimal proOutputProgress) {
        this.proOutputProgress = proOutputProgress;
    }

    public BigDecimal getProContractReceiveMny() {
        return proContractReceiveMny;
    }

    public void setProContractReceiveMny(BigDecimal proContractReceiveMny) {
        this.proContractReceiveMny = proContractReceiveMny;
    }

    public BigDecimal getProReceiveMny() {
        return proReceiveMny;
    }

    public void setProReceiveMny(BigDecimal proReceiveMny) {
        this.proReceiveMny = proReceiveMny;
    }

    public BigDecimal getProPayMny() {
        return proPayMny;
    }

    public void setProPayMny(BigDecimal proPayMny) {
        this.proPayMny = proPayMny;
    }

    public BigDecimal getProCostListSurplus() {
        return proCostListSurplus;
    }

    public void setProCostListSurplus(BigDecimal proCostListSurplus) {
        this.proCostListSurplus = proCostListSurplus;
    }

    public BigDecimal getProTransferSurplus() {
        return proTransferSurplus;
    }

    public void setProTransferSurplus(BigDecimal proTransferSurplus) {
        this.proTransferSurplus = proTransferSurplus;
    }

    public BigDecimal getProRiskMarginSurplus() {
        return proRiskMarginSurplus;
    }

    public void setProRiskMarginSurplus(BigDecimal proRiskMarginSurplus) {
        this.proRiskMarginSurplus = proRiskMarginSurplus;
    }

    public BigDecimal getProLoanBalance() {
        return proLoanBalance;
    }

    public void setProLoanBalance(BigDecimal proLoanBalance) {
        this.proLoanBalance = proLoanBalance;
    }

    public BigDecimal getProLoanInterest() {
        return proLoanInterest;
    }

    public void setProLoanInterest(BigDecimal proLoanInterest) {
        this.proLoanInterest = proLoanInterest;
    }

    public BigDecimal getProOtherFeeDeduct() {
        return proOtherFeeDeduct;
    }

    public void setProOtherFeeDeduct(BigDecimal proOtherFeeDeduct) {
        this.proOtherFeeDeduct = proOtherFeeDeduct;
    }

    public BigDecimal getProOtherFeeBack() {
        return proOtherFeeBack;
    }

    public void setProOtherFeeBack(BigDecimal proOtherFeeBack) {
        this.proOtherFeeBack = proOtherFeeBack;
    }

    public BigDecimal getProSurplusMny() {
        return proSurplusMny;
    }

    public void setProSurplusMny(BigDecimal proSurplusMny) {
        this.proSurplusMny = proSurplusMny;
    }

    public BigDecimal getProSurplusApplyMny() {
        return proSurplusApplyMny;
    }

    public void setProSurplusApplyMny(BigDecimal proSurplusApplyMny) {
        this.proSurplusApplyMny = proSurplusApplyMny;
    }

    public BigDecimal getProPettyCash() {
        return proPettyCash;
    }

    public void setProPettyCash(BigDecimal proPettyCash) {
        this.proPettyCash = proPettyCash;
    }

    public BigDecimal getProManageScale() {
        return proManageScale;
    }

    public void setProManageScale(BigDecimal proManageScale) {
        this.proManageScale = proManageScale;
    }

    public BigDecimal getProManageFee() {
        return proManageFee;
    }

    public void setProManageFee(BigDecimal proManageFee) {
        this.proManageFee = proManageFee;
    }

    public BigDecimal getProAmerce() {
        return proAmerce;
    }

    public void setProAmerce(BigDecimal proAmerce) {
        this.proAmerce = proAmerce;
    }

    public List<PayRecordEntity> getRecordList() {
        return recordList;
    }

    public BigDecimal getEndthisPayScaleByContract() {
        return endthisPayScaleByContract;
    }

    public void setEndthisPayScaleByContract(BigDecimal endthisPayScaleByContract) {
        this.endthisPayScaleByContract = endthisPayScaleByContract;
    }

    public BigDecimal getCollectRatio() {
        return collectRatio;
    }

    public void setCollectRatio(BigDecimal collectRatio) {
        this.collectRatio = collectRatio;
    }

    public BigDecimal getSumCollectMny() {
        return sumCollectMny;
    }

    public void setSumCollectMny(BigDecimal sumCollectMny) {
        this.sumCollectMny = sumCollectMny;
    }

    public BigDecimal getSumProductionTaxMny() {
        return sumProductionTaxMny;
    }

    public void setSumProductionTaxMny(BigDecimal sumProductionTaxMny) {
        this.sumProductionTaxMny = sumProductionTaxMny;
    }

    public BigDecimal getSumApplyMny() {
        return sumApplyMny;
    }

    public void setSumApplyMny(BigDecimal sumApplyMny) {
        this.sumApplyMny = sumApplyMny;
    }

    public String getApplyMnyCn() {
        return applyMnyCn;
    }

    public void setApplyMnyCn(String applyMnyCn) {
        this.applyMnyCn = applyMnyCn;
    }


    public BigDecimal getWaitDeductMny() {
        return waitDeductMny;
    }

    public void setWaitDeductMny(BigDecimal waitDeductMny) {
        this.waitDeductMny = waitDeductMny;
    }

    public void setRecordList(List<PayRecordEntity> recordList) {
        this.recordList = recordList;
    }

    public String getProjectTypeName() {
        return projectTypeName;
    }

    public void setProjectTypeName(String projectTypeName) {
        this.projectTypeName = projectTypeName;
    }

    public String getDependOnProject() {
        return dependOnProject;
    }

    public void setDependOnProject(String dependOnProject) {
        this.dependOnProject = dependOnProject;
    }

    public String getPurchaseType() {
        return purchaseType;
    }

    public void setPurchaseType(String purchaseType) {
        this.purchaseType = purchaseType;
    }

    public Date getApproveTime() {
        return approveTime;
    }

    public void setApproveTime(Date approveTime) {
        this.approveTime = approveTime;
    }

    public BigDecimal getPayScale() {
        return payScale;
    }

    public void setPayScale(BigDecimal payScale) {
        this.payScale = payScale;
    }

    public BigDecimal getBePayScale() {
        return bePayScale;
    }

    public void setBePayScale(BigDecimal bePayScale) {
        this.bePayScale = bePayScale;
    }

    public BigDecimal getEndthisPayScale() {
        return endthisPayScale;
    }

    public void setEndthisPayScale(BigDecimal endthisPayScale) {
        this.endthisPayScale = endthisPayScale;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public Date getConfirmTime() {
        return confirmTime;
    }

    public void setConfirmTime(Date confirmTime) {
        this.confirmTime = confirmTime;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Integer getPayType() {
        return payType;
    }

    public void setPayType(Integer payType) {
        this.payType = payType;
    }

    public Integer getPayStatus() {
        return payStatus;
    }

    public void setPayStatus(Integer payStatus) {
        this.payStatus = payStatus;
    }

    public BigDecimal getPayMny() {
        return payMny;
    }

    public void setPayMny(BigDecimal payMny) {
        this.payMny = payMny;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public Long getContractType() {
        return contractType;
    }

    public void setContractType(Long contractType) {
        this.contractType = contractType;
    }

    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }


    public String getProjectType() {
        return projectType;
    }

    public void setProjectType(String projectType) {
        this.projectType = projectType;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getFeeType() {
        return feeType;
    }

    public void setFeeType(Long feeType) {
        this.feeType = feeType;
    }

    public String getPayReason() {
        return payReason;
    }

    public void setPayReason(String payReason) {
        this.payReason = payReason;
    }

    public Long getReceiveUnitId() {
        return receiveUnitId;
    }

    public void setReceiveUnitId(Long receiveUnitId) {
        this.receiveUnitId = receiveUnitId;
    }

    public String getReceiveUnitName() {
        return receiveUnitName;
    }

    public void setReceiveUnitName(String receiveUnitName) {
        this.receiveUnitName = receiveUnitName;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public BigDecimal getSumSettleMny() {
        return sumSettleMny;
    }

    public void setSumSettleMny(BigDecimal sumSettleMny) {
        this.sumSettleMny = sumSettleMny;
    }

    public BigDecimal getSumPayMny() {
        return sumPayMny;
    }

    public void setSumPayMny(BigDecimal sumPayMny) {
        this.sumPayMny = sumPayMny;
    }

    public BigDecimal getSumInvoiceMny() {
        return sumInvoiceMny;
    }

    public void setSumInvoiceMny(BigDecimal sumInvoiceMny) {
        this.sumInvoiceMny = sumInvoiceMny;
    }

    public Long getApplyUserId() {
        return applyUserId;
    }

    public void setApplyUserId(Long applyUserId) {
        this.applyUserId = applyUserId;
    }

    public String getApplyUserName() {
        return applyUserName;
    }

    public void setApplyUserName(String applyUserName) {
        this.applyUserName = applyUserName;
    }

    public Date getApplyTime() {
        return applyTime;
    }

    public void setApplyTime(Date applyTime) {
        this.applyTime = applyTime;
    }

    public BigDecimal getApplyMny() {
        return applyMny;
    }

    public void setApplyMny(BigDecimal applyMny) {
        this.applyMny = applyMny;
    }

    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public String getAccountNum() {
        return accountNum;
    }

    public void setAccountNum(String accountNum) {
        this.accountNum = accountNum;
    }

    public String getAccountBank() {
        return accountBank;
    }

    public void setAccountBank(String accountBank) {
        this.accountBank = accountBank;
    }

    public BigDecimal getInvoiceMny() {
        return invoiceMny;
    }

    public void setInvoiceMny(BigDecimal invoiceMny) {
        this.invoiceMny = invoiceMny;
    }

    public String getBackReason() {
        return backReason;
    }

    public void setBackReason(String backReason) {
        this.backReason = backReason;
    }

    public Date getBackTime() {
        return backTime;
    }

    public Long getOthContractType() {
        return othContractType;
    }

    public void setOthContractType(Long othContractType) {
        this.othContractType = othContractType;
    }

    public String getOthContractTypeName() {
        return othContractTypeName;
    }

    public void setOthContractTypeName(String othContractTypeName) {
        this.othContractTypeName = othContractTypeName;
    }

    public void setBackTime(Date backTime) {
        this.backTime = backTime;
    }

    public String getInvoiceFlag() {
        return invoiceFlag;
    }

    public void setInvoiceFlag(String invoiceFlag) {
        this.invoiceFlag = invoiceFlag;
    }

    public BigDecimal getTotalApplyMny() {
        return totalApplyMny;
    }

    public void setTotalApplyMny(BigDecimal totalApplyMny) {
        this.totalApplyMny = totalApplyMny;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    // 劳务分包付款信息
    @TableField("applicant_id")
    private Long applicantId; //申请人id
    @TableField("applicant_name")
    private String applicantName; // 申请人名称
    @TableField("project_director")
    private Long projectDirector; // 项目总监Id
    @TableField("project_director_name")
    private String projectDirectorName; // 项目总监名称
    @TableField("deputy_boss_id")
    private Long deputyBossId; //分管副总id
    @TableField("deputy_boss_name")
    private String deputyBossName; // 分管副总名称
    @TableField("payment_adjust")
    private BigDecimal paymentAdjust; // 付款比例修正
    @TableField(value="sub_income_id")
    private Long subIncomeId; // 施工合同id-劳务
    @TableField(value="sub_income_code")
    private String subIncomeCode; // 施工合同编号-劳务
    @TableField(value="sub_income_name")
    private String subIncomeName;// 施工合同名称-劳务
    @TableField(value="sub_contract_ratio")
    private BigDecimal subContractRatio; // 合同约定付款比例-劳务
    @TableField(value="is_adjusted")
    private String isAdjusted; // 是否调整合同约定付款比例
    @TableField(value="paid_amount")
    private BigDecimal paidAmount; //累计已付金额
    @TableField(value="sub_invoiced_amount")
    private BigDecimal subInvoicedAmount; // 已收票金额-劳务
    @TableField(value="sub_apply_date_span")
    private String subApplyDateSpan ; // 申请请款日期区间
    @TableField(value="sub_to_deduct_amt")
    private BigDecimal subToDeductAmt; // 待扣款金额-劳务
    @TableField(value="sub_claim_amount")
    private BigDecimal subClaimAmount; // 本次申报金额-劳务
    @TableField(value="sub_settle_amount")
    private BigDecimal subSettleAmount; // 结算金额-劳务
    @TableField(value="sub_deduct_amount")
    private BigDecimal subDeductAmount; // 本次扣款金额-劳务
    @TableField(value="sub_project_approval_amt")
    private BigDecimal subProjectApprovalAmt; // 本次项目部批复金额-劳务
    @TableField(value="sub_visa_approved_amt")
    private BigDecimal subVisaApprovedAmt; // 已审核签证总金额-劳务
    @TableField(value="sub_worker_salary_amt")
    private BigDecimal subWorkerSalaryAmt; // 本次审批支付分包单位工人工资总金额
    @TableField(value="sub_boss_salary_amt")
    private BigDecimal subBossSalaryAmt; // 本次审批支付分包/老板金额
    @TableField(value="sub_progress_ratio")
    private BigDecimal subProgressRatio; // 本次请款该班组完成总进度比例
    @TableField(value="sub_progress_ratio_total")
    private BigDecimal subProgressRatioTotal;// 本次请款该班组累计完成总进度比例
    @TableField(value="sub_worker_salary_amt_sum")
    private BigDecimal subWorkerSalaryAmtSum; // 累计已支付分包单位工人工资总金额
    @TableField(value="sub_boss_salary_amt_sum")
    private BigDecimal subBossSalaryAmtSum; // 累计已支付分包/老板金额
    @TableField(value="sub_remain_amount")
    private BigDecimal subRemainAmount; // 截止本次请款合同剩余金额
    @TableField(value="sub_actual_amount")
    private BigDecimal subActualAmount; // 实发工资金额（特安部统计成本专用）


    // 工程中心批款
    @TableField(value="sub_approved_amount")
    private BigDecimal subApprovedAmount;// 本次批款金额（合同额*累计完成总进度比例-前期累计已批金额）
    @TableField(value="sub_approved_amount_adjust")
    private BigDecimal subApprovedAmountAdjust;// 批款金额修正
    @TableField(value="sub_hold_amount")
    private BigDecimal subHoldAmount; // 本次暂压金额
    @TableField(value="sub_hold_reason")
    private String subHoldReason; // 本次暂压原因备注

    // 工程中心排款
    @TableField(value="sub_use_salary_account")
    private String subUseSalaryAccount; // 本次是否使用工资户支付
    @TableField(value="sub_wage_account")
    private String subWageAccount; // 选择本次支付的工资户
    @TableField(value="sub_wage_account_amount")
    private BigDecimal subWageAccountAmount; // 本次工资户支付金额
    @TableField(value="sub_wage_pay_time")
    private Date subWagePayTime; // 工资支付排期
    @TableField(value="sub_joint_acct_amount")
    private BigDecimal subJointAcctAmount; //本次支付共管户金额
    @TableField(value="sub_pay_way")
    private String subPayWay; // 支付方式
    @TableField(value="sub_basic_acct_amount")
    private BigDecimal subBasicAcctAmount; // 本次支付基本户金额
    @TableField(value="sub_basic_acct_pay_way")
    private String subBasicAcctPayWay; // 支付方式
    @TableField(value="sub_wage_person_count")
    private Integer subWagePersonCount; // 本次支付工资人数
    @TableField(value="sub_wage_date_span")
    private String subWageDateSpan ; // 本次支付工资日期区间
    @TableField(value="sub_pay_bwhr_amount")
    private BigDecimal subPayBwhrAmount; // 本次支付班王/宏瑞金额
    @TableField(value="sub_basic_acct_pay_time")
    private Date subBasicAcctPayTime; // 基本户支付排期

    // 收款账号信息（小C）-分包
    @TableField("sub_account_name")
    private String subAccountName; // 账户名
    @TableField("sub_account_num")
    private String subAccountNum; // 基本户银行卡号
    @TableField("sub_account_bank")
    private String subAccountBank; // 开户行
    @TableField("sub_id_card")
    private String subIdCard; // 身份证号
    @TableField("sub_phone")
    private String subPhone; // 电话号码

    // 新增补充字段
    @TableField(value="joint_account_name")
    private String jointAccountName; // 共管账户名称
    @TableField(value="joint_account_num")
    private String jointAccountNum; // 共管账户银行账号
    @TableField(value="joint_account_bank")
    private String jointAccountBank; // 共管账户开户行
    @TableField(value="basic_account_name")
    private String basicAccountName; // 基本账户名称
    @TableField(value="basic_account_num")
    private String basicAccountNum; // 基本账户银行账号
    @TableField(value="basic_account_bank")
    private String basicAccountBank; // 基本账户开户行
    @TableField(value="sub_pay_bwhr_wage_amount")
    private BigDecimal subPayBwhrWageAmount; // 本次班王/宏瑞支付工资金额
    @TableField(value="sub_pay_bwhr_boss_amount")
    private BigDecimal subPayBwhrBossAmount; // 本次班王/宏瑞支付老板金额
    @TableField(value="sub_pay_boss_pay_time")
    private Date subPayBossPayTime;  // 支付小C老板金额排期
    @TableField(value="total_approved_amount")
    private BigDecimal totalApprovedAmount; // 累计批款金额

    // 关联项目责任分工表数据
    @TableField(value="project_manager_id")
    private Long projectManagerId; // 项目经理id
    @TableField(value="project_manager_name")
    private String projectManagerName; // 项目经理name
    @TableField(value="labor_supervisor_id")
    private Long laborSupervisorId; // 劳务区域主管id
    @TableField(value="labor_supervisor_name")
    private String laborSupervisorName; // 劳务区域主管name

    // 基本信息
    @TableField(value="sub_receive_unit_name")
    private String subReceiveUnitName; // 收款单位名称-分包

    // 收料入库信息
    @TableField(value="total_count")
    private BigDecimal totalCount; // 入库数量
    @TableField(value="total_amount")
    private BigDecimal totalAmount; // 入库金额含税

    // 2025-10-23 新增字段
    @TableField(value="safety_labor_platform")
    private String safetyLaborPlatform;           // 安全劳务专业中台
    @TableField(value="use_general_pay")
    private String useGeneralPay;            // 是否使用总包代付（1=是 0=否）
    @TableField(value="general_pay_amount")
    private BigDecimal generalPayAmount;      // 本次总包代付金额
    @TableField(value="use_new_disbursement")
    private String useNewDisbursement; // 是否使用新代发模式（1=是 0=否）


    public Long getApplicantId() {
        return applicantId;
    }

    public void setApplicantId(Long applicantId) {
        this.applicantId = applicantId;
    }

    public String getApplicantName() {
        return applicantName;
    }

    public void setApplicantName(String applicantName) {
        this.applicantName = applicantName;
    }

    public Long getProjectDirector() {
        return projectDirector;
    }

    public void setProjectDirector(Long projectDirector) {
        this.projectDirector = projectDirector;
    }

    public String getProjectDirectorName() {
        return projectDirectorName;
    }

    public void setProjectDirectorName(String projectDirectorName) {
        this.projectDirectorName = projectDirectorName;
    }

    public Long getDeputyBossId() {
        return deputyBossId;
    }

    public void setDeputyBossId(Long deputyBossId) {
        this.deputyBossId = deputyBossId;
    }

    public String getDeputyBossName() {
        return deputyBossName;
    }

    public void setDeputyBossName(String deputyBossName) {
        this.deputyBossName = deputyBossName;
    }

    public BigDecimal getPaymentAdjust() {
        return paymentAdjust;
    }

    public void setPaymentAdjust(BigDecimal paymentAdjust) {
        this.paymentAdjust = paymentAdjust;
    }

    public Long getSubIncomeId() {
        return subIncomeId;
    }

    public void setSubIncomeId(Long subIncomeId) {
        this.subIncomeId = subIncomeId;
    }

    public String getSubIncomeCode() {
        return subIncomeCode;
    }

    public void setSubIncomeCode(String subIncomeCode) {
        this.subIncomeCode = subIncomeCode;
    }

    public String getSubIncomeName() {
        return subIncomeName;
    }

    public void setSubIncomeName(String subIncomeName) {
        this.subIncomeName = subIncomeName;
    }

    public BigDecimal getSubContractRatio() {
        return subContractRatio;
    }

    public void setSubContractRatio(BigDecimal subContractRatio) {
        this.subContractRatio = subContractRatio;
    }

    public BigDecimal getSubInvoicedAmount() {
        return subInvoicedAmount;
    }

    public void setSubInvoicedAmount(BigDecimal subInvoicedAmount) {
        this.subInvoicedAmount = subInvoicedAmount;
    }

    public BigDecimal getSubToDeductAmt() {
        return subToDeductAmt;
    }

    public void setSubToDeductAmt(BigDecimal subToDeductAmt) {
        this.subToDeductAmt = subToDeductAmt;
    }

    public BigDecimal getSubClaimAmount() {
        return subClaimAmount;
    }

    public void setSubClaimAmount(BigDecimal subClaimAmount) {
        this.subClaimAmount = subClaimAmount;
    }

    public BigDecimal getSubSettleAmount() {
        return subSettleAmount;
    }

    public void setSubSettleAmount(BigDecimal subSettleAmount) {
        this.subSettleAmount = subSettleAmount;
    }

    public BigDecimal getSubDeductAmount() {
        return subDeductAmount;
    }

    public void setSubDeductAmount(BigDecimal subDeductAmount) {
        this.subDeductAmount = subDeductAmount;
    }

    public BigDecimal getSubProjectApprovalAmt() {
        return subProjectApprovalAmt;
    }

    public void setSubProjectApprovalAmt(BigDecimal subProjectApprovalAmt) {
        this.subProjectApprovalAmt = subProjectApprovalAmt;
    }

    public BigDecimal getSubVisaApprovedAmt() {
        return subVisaApprovedAmt;
    }

    public void setSubVisaApprovedAmt(BigDecimal subVisaApprovedAmt) {
        this.subVisaApprovedAmt = subVisaApprovedAmt;
    }

    public BigDecimal getSubWorkerSalaryAmt() {
        return subWorkerSalaryAmt;
    }

    public void setSubWorkerSalaryAmt(BigDecimal subWorkerSalaryAmt) {
        this.subWorkerSalaryAmt = subWorkerSalaryAmt;
    }

    public BigDecimal getSubBossSalaryAmt() {
        return subBossSalaryAmt;
    }

    public void setSubBossSalaryAmt(BigDecimal subBossSalaryAmt) {
        this.subBossSalaryAmt = subBossSalaryAmt;
    }

    public BigDecimal getSubProgressRatio() {
        return subProgressRatio;
    }

    public void setSubProgressRatio(BigDecimal subProgressRatio) {
        this.subProgressRatio = subProgressRatio;
    }

    public BigDecimal getSubProgressRatioTotal() {
        return subProgressRatioTotal;
    }

    public void setSubProgressRatioTotal(BigDecimal subProgressRatioTotal) {
        this.subProgressRatioTotal = subProgressRatioTotal;
    }

    public BigDecimal getSubApprovedAmount() {
        return subApprovedAmount;
    }

    public void setSubApprovedAmount(BigDecimal subApprovedAmount) {
        this.subApprovedAmount = subApprovedAmount;
    }

    public BigDecimal getSubApprovedAmountAdjust() {
        return subApprovedAmountAdjust;
    }

    public void setSubApprovedAmountAdjust(BigDecimal subApprovedAmountAdjust) {
        this.subApprovedAmountAdjust = subApprovedAmountAdjust;
    }

    public BigDecimal getSubHoldAmount() {
        return subHoldAmount;
    }

    public void setSubHoldAmount(BigDecimal subHoldAmount) {
        this.subHoldAmount = subHoldAmount;
    }

    public String getSubHoldReason() {
        return subHoldReason;
    }

    public void setSubHoldReason(String subHoldReason) {
        this.subHoldReason = subHoldReason;
    }

    public String getSubUseSalaryAccount() {
        return subUseSalaryAccount;
    }

    public void setSubUseSalaryAccount(String subUseSalaryAccount) {
        this.subUseSalaryAccount = subUseSalaryAccount;
    }

    public String getSubWageAccount() {
        return subWageAccount;
    }

    public void setSubWageAccount(String subWageAccount) {
        this.subWageAccount = subWageAccount;
    }

    public BigDecimal getSubWageAccountAmount() {
        return subWageAccountAmount;
    }

    public void setSubWageAccountAmount(BigDecimal subWageAccountAmount) {
        this.subWageAccountAmount = subWageAccountAmount;
    }

    public Date getSubWagePayTime() {
        return subWagePayTime;
    }

    public void setSubWagePayTime(Date subWagePayTime) {
        this.subWagePayTime = subWagePayTime;
    }

    public BigDecimal getSubJointAcctAmount() {
        return subJointAcctAmount;
    }

    public void setSubJointAcctAmount(BigDecimal subJointAcctAmount) {
        this.subJointAcctAmount = subJointAcctAmount;
    }

    public String getSubPayWay() {
        return subPayWay;
    }

    public void setSubPayWay(String subPayWay) {
        this.subPayWay = subPayWay;
    }

    public BigDecimal getSubBasicAcctAmount() {
        return subBasicAcctAmount;
    }

    public void setSubBasicAcctAmount(BigDecimal subBasicAcctAmount) {
        this.subBasicAcctAmount = subBasicAcctAmount;
    }

    public String getSubBasicAcctPayWay() {
        return subBasicAcctPayWay;
    }

    public void setSubBasicAcctPayWay(String subBasicAcctPayWay) {
        this.subBasicAcctPayWay = subBasicAcctPayWay;
    }

    public Integer getSubWagePersonCount() {
        return subWagePersonCount;
    }

    public void setSubWagePersonCount(Integer subWagePersonCount) {
        this.subWagePersonCount = subWagePersonCount;
    }

    public BigDecimal getSubPayBwhrAmount() {
        return subPayBwhrAmount;
    }

    public void setSubPayBwhrAmount(BigDecimal subPayBwhrAmount) {
        this.subPayBwhrAmount = subPayBwhrAmount;
    }

    public Date getSubBasicAcctPayTime() {
        return subBasicAcctPayTime;
    }

    public void setSubBasicAcctPayTime(Date subBasicAcctPayTime) {
        this.subBasicAcctPayTime = subBasicAcctPayTime;
    }

    public String getSubAccountName() {
        return subAccountName;
    }

    public void setSubAccountName(String subAccountName) {
        this.subAccountName = subAccountName;
    }

    public String getSubAccountNum() {
        return subAccountNum;
    }

    public void setSubAccountNum(String subAccountNum) {
        this.subAccountNum = subAccountNum;
    }

    public String getSubAccountBank() {
        return subAccountBank;
    }

    public void setSubAccountBank(String subAccountBank) {
        this.subAccountBank = subAccountBank;
    }

    public String getSubIdCard() {
        return subIdCard;
    }

    public void setSubIdCard(String subIdCard) {
        this.subIdCard = subIdCard;
    }

    public String getSubPhone() {
        return subPhone;
    }

    public void setSubPhone(String subPhone) {
        this.subPhone = subPhone;
    }

    public String getSubApplyDateSpan() {
        return subApplyDateSpan;
    }

    public void setSubApplyDateSpan(String subApplyDateSpan) {
        this.subApplyDateSpan = subApplyDateSpan;
    }

    public String getSubWageDateSpan() {
        return subWageDateSpan;
    }

    public void setSubWageDateSpan(String subWageDateSpan) {
        this.subWageDateSpan = subWageDateSpan;
    }

    public String getJointAccountName() {
        return jointAccountName;
    }

    public void setJointAccountName(String jointAccountName) {
        this.jointAccountName = jointAccountName;
    }

    public String getJointAccountNum() {
        return jointAccountNum;
    }

    public void setJointAccountNum(String jointAccountNum) {
        this.jointAccountNum = jointAccountNum;
    }

    public String getJointAccountBank() {
        return jointAccountBank;
    }

    public void setJointAccountBank(String jointAccountBank) {
        this.jointAccountBank = jointAccountBank;
    }

    public String getBasicAccountName() {
        return basicAccountName;
    }

    public void setBasicAccountName(String basicAccountName) {
        this.basicAccountName = basicAccountName;
    }

    public String getBasicAccountNum() {
        return basicAccountNum;
    }

    public void setBasicAccountNum(String basicAccountNum) {
        this.basicAccountNum = basicAccountNum;
    }

    public String getBasicAccountBank() {
        return basicAccountBank;
    }

    public void setBasicAccountBank(String basicAccountBank) {
        this.basicAccountBank = basicAccountBank;
    }

    public BigDecimal getSubPayBwhrWageAmount() {
        return subPayBwhrWageAmount;
    }

    public void setSubPayBwhrWageAmount(BigDecimal subPayBwhrWageAmount) {
        this.subPayBwhrWageAmount = subPayBwhrWageAmount;
    }

    public BigDecimal getSubPayBwhrBossAmount() {
        return subPayBwhrBossAmount;
    }

    public void setSubPayBwhrBossAmount(BigDecimal subPayBwhrBossAmount) {
        this.subPayBwhrBossAmount = subPayBwhrBossAmount;
    }

    public Date getSubPayBossPayTime() {
        return subPayBossPayTime;
    }

    public void setSubPayBossPayTime(Date subPayBossPayTime) {
        this.subPayBossPayTime = subPayBossPayTime;
    }

    public BigDecimal getTotalApprovedAmount() {
        return totalApprovedAmount;
    }

    public void setTotalApprovedAmount(BigDecimal totalApprovedAmount) {
        this.totalApprovedAmount = totalApprovedAmount;
    }

    public Long getProjectManagerId() {
        return projectManagerId;
    }

    public void setProjectManagerId(Long projectManagerId) {
        this.projectManagerId = projectManagerId;
    }

    public String getProjectManagerName() {
        return projectManagerName;
    }

    public void setProjectManagerName(String projectManagerName) {
        this.projectManagerName = projectManagerName;
    }

    public Long getLaborSupervisorId() {
        return laborSupervisorId;
    }

    public void setLaborSupervisorId(Long laborSupervisorId) {
        this.laborSupervisorId = laborSupervisorId;
    }

    public String getLaborSupervisorName() {
        return laborSupervisorName;
    }

    public void setLaborSupervisorName(String laborSupervisorName) {
        this.laborSupervisorName = laborSupervisorName;
    }

    public String getIsAdjusted() {
        return isAdjusted;
    }

    public void setIsAdjusted(String isAdjusted) {
        this.isAdjusted = isAdjusted;
    }

    public BigDecimal getPaidAmount() {
        return paidAmount;
    }

    public void setPaidAmount(BigDecimal paidAmount) {
        this.paidAmount = paidAmount;
    }

    public BigDecimal getSubWorkerSalaryAmtSum() {
        return subWorkerSalaryAmtSum;
    }

    public void setSubWorkerSalaryAmtSum(BigDecimal subWorkerSalaryAmtSum) {
        this.subWorkerSalaryAmtSum = subWorkerSalaryAmtSum;
    }

    public BigDecimal getSubBossSalaryAmtSum() {
        return subBossSalaryAmtSum;
    }

    public void setSubBossSalaryAmtSum(BigDecimal subBossSalaryAmtSum) {
        this.subBossSalaryAmtSum = subBossSalaryAmtSum;
    }

    public BigDecimal getSubRemainAmount() {
        return subRemainAmount;
    }

    public void setSubRemainAmount(BigDecimal subRemainAmount) {
        this.subRemainAmount = subRemainAmount;
    }

    public String getSubReceiveUnitName() {
        return subReceiveUnitName;
    }

    public void setSubReceiveUnitName(String subReceiveUnitName) {
        this.subReceiveUnitName = subReceiveUnitName;
    }

    public BigDecimal getTotalCount() {
        return totalCount;
    }

    public void setTotalCount(BigDecimal totalCount) {
        this.totalCount = totalCount;
    }

    public BigDecimal getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    public BigDecimal getSubActualAmount() {
        return subActualAmount;
    }

    public void setSubActualAmount(BigDecimal subActualAmount) {
        this.subActualAmount = subActualAmount;
    }

    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    public String getSafetyLaborPlatform() {
        return safetyLaborPlatform;
    }

    public void setSafetyLaborPlatform(String safetyLaborPlatform) {
        this.safetyLaborPlatform = safetyLaborPlatform;
    }

    public String getUseGeneralPay() {
        return useGeneralPay;
    }

    public void setUseGeneralPay(String useGeneralPay) {
        this.useGeneralPay = useGeneralPay;
    }

    public BigDecimal getGeneralPayAmount() {
        return generalPayAmount;
    }

    public void setGeneralPayAmount(BigDecimal generalPayAmount) {
        this.generalPayAmount = generalPayAmount;
    }

    public String getUseNewDisbursement() {
        return useNewDisbursement;
    }

    public void setUseNewDisbursement(String useNewDisbursement) {
        this.useNewDisbursement = useNewDisbursement;
    }
}
