/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.finance.bean.ProjectCapitalSetCostEntity;
import com.ejianc.business.finance.bean.ProjectCapitalSetEntity;
import com.ejianc.business.finance.service.IProjectCapitalSetCostService;
import com.ejianc.business.finance.service.IProjectCapitalSetService;
import com.ejianc.business.finance.vo.ProjectCapitalSetCostVO;
import com.ejianc.business.finance.vo.ProjectCapitalSetVO;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.refer.util.ReferObjectUtil;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/projectCapitalSet/"})
public class ProjectCapitalSetController {
    private static Logger logger = LoggerFactory.getLogger(ProjectCapitalSetController.class);
    @Autowired
    IProjectCapitalSetService projectCapitalSetService;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IProjectApi iProjectApi;
    @Autowired
    private IProjectCapitalSetCostService iProjectCapitalSetCostService;

    @RequestMapping(value={"saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ProjectCapitalSetVO> saveOrUpdate(@RequestBody ProjectCapitalSetVO vo) {
        this.checkProject(vo);
        ProjectCapitalSetEntity entity = (ProjectCapitalSetEntity)((Object)BeanMapper.map((Object)vo, ProjectCapitalSetEntity.class));
        this.projectCapitalSetService.saveOrUpdate((Object)entity, false);
        ProjectCapitalSetVO backVo = (ProjectCapitalSetVO)BeanMapper.map((Object)((Object)entity), ProjectCapitalSetVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)backVo);
    }

    public void checkProject(ProjectCapitalSetVO vo) {
        List list;
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("projectDepartmentId", new Parameter("eq", (Object)vo.getProjectDepartmentId()));
        if (vo.getId() != null) {
            queryParam.getParams().put("id", new Parameter("ne", (Object)vo.getId()));
        }
        if ((list = this.projectCapitalSetService.queryList(queryParam, false)) != null && list.size() > 0) {
            throw new BusinessException("\u9879\u76ee\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u9879\u76ee");
        }
    }

    @RequestMapping(value={"queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ProjectCapitalSetVO> queryDetail(Long id, HttpServletRequest request) {
        ProjectCapitalSetEntity entity = (ProjectCapitalSetEntity)((Object)this.projectCapitalSetService.selectById(id));
        ProjectCapitalSetVO vo = (ProjectCapitalSetVO)BeanMapper.map((Object)((Object)entity), ProjectCapitalSetVO.class);
        CommonResponse<JSONObject> inAndOut = this.projectCapitalSetService.queryIncoemAndExpendByProjectId(vo.getProjectId(), request);
        if (inAndOut.isSuccess()) {
            JSONObject dataresultIncoemAndExpend = (JSONObject)inAndOut.getData();
            if (dataresultIncoemAndExpend.get((Object)"incomeTaxRate") != null) {
                dataresultIncoemAndExpend.put("incomeTaxRate", (Object)dataresultIncoemAndExpend.getBigDecimal("incomeTaxRate").divide(new BigDecimal(100.0)));
            }
            if (vo.getProjectCapitalSetList() != null && vo.getProjectCapitalSetList().size() > 0) {
                List list = vo.getProjectCapitalSetList();
                BigDecimal otherMoney = new BigDecimal(0);
                for (ProjectCapitalSetCostVO cost : list) {
                    if ("value".equals(cost.getDataType())) {
                        BigDecimal valueOrFormula;
                        if ("add".equals(cost.getAddOrDelete())) {
                            if (cost.getValueOrFormula() != null) {
                                valueOrFormula = new BigDecimal(cost.getValueOrFormula());
                                otherMoney = otherMoney.add(valueOrFormula);
                                cost.setAmount(valueOrFormula);
                                continue;
                            }
                            cost.setAmount(new BigDecimal(0));
                            continue;
                        }
                        if (!"delete".equals(cost.getAddOrDelete())) continue;
                        if (cost.getValueOrFormula() != null) {
                            valueOrFormula = new BigDecimal(cost.getValueOrFormula());
                            otherMoney = otherMoney.subtract(valueOrFormula);
                            cost.setAmount(new BigDecimal(0).subtract(valueOrFormula));
                            continue;
                        }
                        cost.setAmount(new BigDecimal(0));
                        continue;
                    }
                    if (cost.getFormula() != null) {
                        String evalq = cost.getFormula();
                        for (String key : dataresultIncoemAndExpend.keySet()) {
                            String value = "0";
                            value = dataresultIncoemAndExpend.getString(key) != null ? dataresultIncoemAndExpend.getString(key) : "0";
                            evalq = evalq.replaceAll(key, value);
                        }
                        ScriptEngineManager manager = new ScriptEngineManager();
                        ScriptEngine se = manager.getEngineByName("js");
                        BigDecimal money = new BigDecimal(0);
                        try {
                            money = new BigDecimal((Double)se.eval(evalq));
                        }
                        catch (ScriptException e) {
                            e.printStackTrace();
                        }
                        if ("delete".equals(cost.getAddOrDelete())) {
                            money = new BigDecimal(0).subtract(money);
                        }
                        cost.setAmount(money);
                        otherMoney = otherMoney.add(money);
                        continue;
                    }
                    cost.setAmount(new BigDecimal(0));
                }
                BigDecimal receiveMoney = dataresultIncoemAndExpend.getBigDecimal("receiveMoney") != null ? dataresultIncoemAndExpend.getBigDecimal("receiveMoney") : new BigDecimal(0);
                BigDecimal payMoney = dataresultIncoemAndExpend.getBigDecimal("payMoney") != null ? dataresultIncoemAndExpend.getBigDecimal("payMoney") : new BigDecimal(0);
                vo.setProjectIncome(receiveMoney == null ? BigDecimal.ZERO.setScale(2, 4) : receiveMoney);
                vo.setProjectExpenditure(payMoney == null ? BigDecimal.ZERO.setScale(2, 4) : payMoney);
                BigDecimal availableBalance = receiveMoney.subtract(payMoney).add(otherMoney);
                vo.setOther(otherMoney);
                vo.setAvailableBalance(availableBalance);
            }
        } else {
            vo.setProjectIncome(BigDecimal.ZERO.setScale(2, 4));
            vo.setProjectExpenditure(BigDecimal.ZERO.setScale(2, 4));
            vo.setOther(BigDecimal.ZERO.setScale(2, 4));
            vo.setAvailableBalance(BigDecimal.ZERO.setScale(2, 4));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ProjectCapitalSetVO>> queryList(@RequestBody QueryParam param, HttpServletRequest request) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        List orgIds = ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        param.getParams().put("projectDepartmentId", new Parameter("in", orgIds));
        IPage<ProjectCapitalSetVO> page = this.projectCapitalSetService.queryForList(param, false);
        if (page.getRecords() != null && page.getRecords().size() > 0) {
            ArrayList<Long> projectIds = new ArrayList<Long>();
            for (ProjectCapitalSetVO vo : page.getRecords()) {
                projectIds.add(vo.getProjectId());
            }
            Map<Long, JSONObject> projectCapital = this.projectCapitalSetService.queryIncoemAndExpendByProjectIds(projectIds, request);
            for (ProjectCapitalSetVO vo : page.getRecords()) {
                JSONObject dataresultIncoemAndExpend = projectCapital.get(vo.getProjectId());
                if (dataresultIncoemAndExpend.get((Object)"incomeTaxRate") != null) {
                    dataresultIncoemAndExpend.put("incomeTaxRate", (Object)dataresultIncoemAndExpend.getBigDecimal("incomeTaxRate").divide(new BigDecimal(100.0)));
                }
                BigDecimal receiveMoney = dataresultIncoemAndExpend.getBigDecimal("receiveMoney") != null ? dataresultIncoemAndExpend.getBigDecimal("receiveMoney") : new BigDecimal(0);
                BigDecimal payMoney = dataresultIncoemAndExpend.getBigDecimal("payMoney") != null ? dataresultIncoemAndExpend.getBigDecimal("payMoney") : new BigDecimal(0);
                vo.setProjectIncome(receiveMoney == null ? BigDecimal.ZERO.setScale(2, 4) : receiveMoney);
                vo.setProjectExpenditure(payMoney == null ? BigDecimal.ZERO.setScale(2, 4) : payMoney);
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.eq((Object)"project_capital_set_id", (Object)vo.getId());
                queryWrapper.eq((Object)"dr", (Object)0);
                List projectCapitalSetList = this.iProjectCapitalSetCostService.list((Wrapper)queryWrapper);
                if (projectCapitalSetList != null && projectCapitalSetList.size() > 0) {
                    BigDecimal otherMoney = new BigDecimal(0);
                    for (ProjectCapitalSetCostEntity cost : projectCapitalSetList) {
                        if ("value".equals(cost.getDataType())) {
                            BigDecimal valueOrFormula;
                            if ("add".equals(cost.getAddOrDelete())) {
                                if (cost.getValueOrFormula() != null) {
                                    valueOrFormula = new BigDecimal(cost.getValueOrFormula());
                                    otherMoney = otherMoney.add(valueOrFormula);
                                    cost.setAmount(valueOrFormula);
                                    continue;
                                }
                                cost.setAmount(new BigDecimal(0));
                                continue;
                            }
                            if (!"delete".equals(cost.getAddOrDelete())) continue;
                            if (cost.getValueOrFormula() != null) {
                                valueOrFormula = new BigDecimal(cost.getValueOrFormula());
                                otherMoney = otherMoney.subtract(valueOrFormula);
                                cost.setAmount(new BigDecimal(0).subtract(valueOrFormula));
                                continue;
                            }
                            cost.setAmount(new BigDecimal(0));
                            continue;
                        }
                        if (cost.getFormula() != null) {
                            String evalq = cost.getFormula();
                            for (String key : dataresultIncoemAndExpend.keySet()) {
                                String value = "0";
                                value = dataresultIncoemAndExpend.getString(key) != null ? dataresultIncoemAndExpend.getString(key) : "0";
                                evalq = evalq.replaceAll(key, value);
                            }
                            ScriptEngineManager manager = new ScriptEngineManager();
                            ScriptEngine se = manager.getEngineByName("js");
                            BigDecimal money = new BigDecimal(0);
                            try {
                                money = new BigDecimal((Double)se.eval(evalq));
                            }
                            catch (ScriptException e) {
                                e.printStackTrace();
                            }
                            if ("delete".equals(cost.getAddOrDelete())) {
                                money = new BigDecimal(0).subtract(money);
                            }
                            cost.setAmount(money);
                            otherMoney = otherMoney.add(money);
                            continue;
                        }
                        cost.setAmount(new BigDecimal(0));
                    }
                    BigDecimal availableBalance = receiveMoney.subtract(payMoney).add(otherMoney);
                    vo.setOther(otherMoney);
                    vo.setAvailableBalance(availableBalance);
                    continue;
                }
                BigDecimal availableBalance = receiveMoney.subtract(payMoney);
                vo.setOther(new BigDecimal(0));
                vo.setAvailableBalance(availableBalance);
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", page);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response, HttpServletRequest request) {
        List fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("projectName");
        List orgIds = ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        queryParam.getParams().put("projectDepartmentId", new Parameter("in", orgIds));
        List list = this.projectCapitalSetService.queryList(queryParam, false);
        if (list != null && list.size() > 0) {
            ArrayList<Long> projectIds = new ArrayList<Long>();
            for (ProjectCapitalSetEntity entity : list) {
                projectIds.add(entity.getProjectId());
            }
            Map<Long, JSONObject> projectCapital = this.projectCapitalSetService.queryIncoemAndExpendByProjectIds(projectIds, request);
            for (ProjectCapitalSetEntity entity : list) {
                JSONObject dataresultIncoemAndExpend = projectCapital.get(entity.getProjectId());
                if (dataresultIncoemAndExpend.get((Object)"incomeTaxRate") != null) {
                    dataresultIncoemAndExpend.put("incomeTaxRate", (Object)dataresultIncoemAndExpend.getBigDecimal("incomeTaxRate").divide(new BigDecimal(100.0)));
                }
                BigDecimal receiveMoney = dataresultIncoemAndExpend.getBigDecimal("receiveMoney") != null ? dataresultIncoemAndExpend.getBigDecimal("receiveMoney") : new BigDecimal(0);
                BigDecimal payMoney = dataresultIncoemAndExpend.getBigDecimal("payMoney") != null ? dataresultIncoemAndExpend.getBigDecimal("payMoney") : new BigDecimal(0);
                entity.setProjectIncome(receiveMoney == null ? BigDecimal.ZERO.setScale(2, 4) : receiveMoney);
                entity.setProjectExpenditure(payMoney == null ? BigDecimal.ZERO.setScale(2, 4) : payMoney);
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.eq((Object)"project_capital_set_id", (Object)entity.getId());
                queryWrapper.eq((Object)"dr", (Object)0);
                List projectCapitalSetList = this.iProjectCapitalSetCostService.list((Wrapper)queryWrapper);
                if (projectCapitalSetList != null && projectCapitalSetList.size() > 0) {
                    BigDecimal otherMoney = new BigDecimal(0);
                    for (ProjectCapitalSetCostEntity cost : projectCapitalSetList) {
                        if ("value".equals(cost.getDataType())) {
                            BigDecimal valueOrFormula;
                            if ("add".equals(cost.getAddOrDelete())) {
                                if (cost.getValueOrFormula() != null) {
                                    valueOrFormula = new BigDecimal(cost.getValueOrFormula());
                                    otherMoney = otherMoney.add(valueOrFormula);
                                    cost.setAmount(valueOrFormula);
                                    continue;
                                }
                                cost.setAmount(new BigDecimal(0));
                                continue;
                            }
                            if (!"delete".equals(cost.getAddOrDelete())) continue;
                            if (cost.getValueOrFormula() != null) {
                                valueOrFormula = new BigDecimal(cost.getValueOrFormula());
                                otherMoney = otherMoney.subtract(valueOrFormula);
                                cost.setAmount(new BigDecimal(0).subtract(valueOrFormula));
                                continue;
                            }
                            cost.setAmount(new BigDecimal(0));
                            continue;
                        }
                        if (cost.getFormula() != null) {
                            String evalq = cost.getFormula();
                            for (String key : dataresultIncoemAndExpend.keySet()) {
                                String value = "0";
                                value = dataresultIncoemAndExpend.getString(key) != null ? dataresultIncoemAndExpend.getString(key) : "0";
                                evalq = evalq.replaceAll(key, value);
                            }
                            ScriptEngineManager manager = new ScriptEngineManager();
                            ScriptEngine se = manager.getEngineByName("js");
                            BigDecimal money = new BigDecimal(0);
                            try {
                                money = new BigDecimal((Double)se.eval(evalq));
                            }
                            catch (ScriptException e) {
                                e.printStackTrace();
                            }
                            if ("delete".equals(cost.getAddOrDelete())) {
                                money = new BigDecimal(0).subtract(money);
                            }
                            cost.setAmount(money);
                            otherMoney = otherMoney.add(money);
                            continue;
                        }
                        cost.setAmount(new BigDecimal(0));
                    }
                    BigDecimal availableBalance = receiveMoney.subtract(payMoney).add(otherMoney);
                    entity.setOther(otherMoney);
                    entity.setAvailableBalance(availableBalance);
                    continue;
                }
                BigDecimal availableBalance = receiveMoney.subtract(payMoney);
                entity.setOther(new BigDecimal(0));
                entity.setAvailableBalance(availableBalance);
            }
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("projectCapitalSetExport.xlsx", beans, response);
    }

    @RequestMapping(value={"delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ProjectCapitalSetVO> vos) {
        this.projectCapitalSetService.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryPrint"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryPrint(Long id, HttpServletRequest request) {
        JSONObject json = new JSONObject();
        JSONArray ProjectCapitalSetCost = new JSONArray();
        ProjectCapitalSetEntity entity = (ProjectCapitalSetEntity)((Object)this.projectCapitalSetService.selectById(id));
        ProjectCapitalSetVO vo = (ProjectCapitalSetVO)BeanMapper.map((Object)((Object)entity), ProjectCapitalSetVO.class);
        CommonResponse<JSONObject> inAndOut = this.projectCapitalSetService.queryIncoemAndExpendByProjectId(vo.getProjectId(), request);
        if (inAndOut.isSuccess()) {
            JSONObject dataresultIncoemAndExpend = (JSONObject)inAndOut.getData();
            if (dataresultIncoemAndExpend.get((Object)"incomeTaxRate") != null) {
                dataresultIncoemAndExpend.put("incomeTaxRate", (Object)dataresultIncoemAndExpend.getBigDecimal("incomeTaxRate").divide(new BigDecimal(100.0)));
            }
            if (vo.getProjectCapitalSetList() != null && vo.getProjectCapitalSetList().size() > 0) {
                List list = vo.getProjectCapitalSetList();
                BigDecimal otherMoney = new BigDecimal(0);
                for (ProjectCapitalSetCostVO cost : list) {
                    if ("value".equals(cost.getDataType())) {
                        BigDecimal valueOrFormula;
                        if ("add".equals(cost.getAddOrDelete())) {
                            if (cost.getValueOrFormula() != null) {
                                valueOrFormula = new BigDecimal(cost.getValueOrFormula());
                                otherMoney = otherMoney.add(valueOrFormula);
                                cost.setAmount(valueOrFormula);
                            } else {
                                cost.setAmount(new BigDecimal(0));
                            }
                        } else if ("delete".equals(cost.getAddOrDelete())) {
                            if (cost.getValueOrFormula() != null) {
                                valueOrFormula = new BigDecimal(cost.getValueOrFormula());
                                otherMoney = otherMoney.subtract(valueOrFormula);
                                cost.setAmount(new BigDecimal(0).subtract(valueOrFormula));
                            } else {
                                cost.setAmount(new BigDecimal(0));
                            }
                        }
                    } else if (cost.getFormula() != null) {
                        String evalq = cost.getFormula();
                        for (String key : dataresultIncoemAndExpend.keySet()) {
                            String value = "0";
                            value = dataresultIncoemAndExpend.getString(key) != null ? dataresultIncoemAndExpend.getString(key) : "0";
                            evalq = evalq.replaceAll(key, value);
                        }
                        ScriptEngineManager manager = new ScriptEngineManager();
                        ScriptEngine se = manager.getEngineByName("js");
                        BigDecimal money = new BigDecimal(0);
                        try {
                            money = new BigDecimal((Double)se.eval(evalq));
                        }
                        catch (ScriptException e) {
                            e.printStackTrace();
                        }
                        if ("delete".equals(cost.getAddOrDelete())) {
                            money = new BigDecimal(0).subtract(money);
                        }
                        cost.setAmount(money);
                        otherMoney = otherMoney.add(money);
                    } else {
                        cost.setAmount(new BigDecimal(0));
                    }
                    if ("add".equals(cost.getAddOrDelete())) {
                        cost.setAddOrDelete("\u589e\u52a0");
                    } else if ("delete".equals(cost.getAddOrDelete())) {
                        cost.setAddOrDelete("\u6263\u9664");
                    }
                    if ("value".equals(cost.getDataType())) {
                        cost.setDataType("\u6570\u503c");
                    } else if ("formula".equals(cost.getDataType())) {
                        cost.setDataType("\u516c\u5f0f");
                    }
                    JSONObject costJson = new JSONObject();
                    costJson.put("id", (Object)cost.getId());
                    costJson.put("costName", (Object)cost.getCostName());
                    costJson.put("addOrDelete", (Object)cost.getAddOrDelete());
                    costJson.put("dataType", (Object)cost.getDataType());
                    costJson.put("valueOrFormula", (Object)cost.getValueOrFormula());
                    if (cost.getRegistrationTime() != null) {
                        String pattern = "yyyy-MM-dd";
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
                        costJson.put("registrationTime", (Object)simpleDateFormat.format(cost.getRegistrationTime()));
                    }
                    costJson.put("amount", (Object)cost.getAmount());
                    if (cost.getDealUser() != null) {
                        try {
                            JSONArray jArray = ReferObjectUtil.getReferEntityValue((String)cost.getDealUser().toString(), (String)"idm-user");
                            if (jArray != null && jArray.size() > 0) {
                                costJson.put("dealUser", (Object)((JSONObject)jArray.get(0)).get((Object)"name").toString());
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    costJson.put("remarks", (Object)cost.getRemarks());
                    ProjectCapitalSetCost.add((Object)costJson);
                }
                BigDecimal receiveMoney = dataresultIncoemAndExpend.getBigDecimal("receiveMoney") != null ? dataresultIncoemAndExpend.getBigDecimal("receiveMoney") : new BigDecimal(0);
                BigDecimal payMoney = dataresultIncoemAndExpend.getBigDecimal("payMoney") != null ? dataresultIncoemAndExpend.getBigDecimal("payMoney") : new BigDecimal(0);
                vo.setProjectIncome(receiveMoney == null ? BigDecimal.ZERO.setScale(2, 4) : receiveMoney);
                vo.setProjectExpenditure(payMoney == null ? BigDecimal.ZERO.setScale(2, 4) : payMoney);
                BigDecimal availableBalance = receiveMoney.subtract(payMoney).add(otherMoney);
                vo.setOther(otherMoney);
                vo.setAvailableBalance(availableBalance);
            }
        } else {
            vo.setProjectIncome(BigDecimal.ZERO.setScale(2, 4));
            vo.setProjectExpenditure(BigDecimal.ZERO.setScale(2, 4));
            vo.setOther(BigDecimal.ZERO.setScale(2, 4));
            vo.setAvailableBalance(BigDecimal.ZERO.setScale(2, 4));
        }
        JSONObject ProjectCapitalSet = new JSONObject();
        ProjectCapitalSet.put("id", (Object)vo.getId());
        ProjectCapitalSet.put("projectName", (Object)vo.getProjectName());
        ProjectCapitalSet.put("projectIncome", (Object)vo.getProjectIncome());
        ProjectCapitalSet.put("projectExpenditure", (Object)vo.getProjectExpenditure());
        ProjectCapitalSet.put("other", (Object)vo.getOther());
        ProjectCapitalSet.put("availableBalance", (Object)vo.getAvailableBalance());
        ProjectCapitalSet.put("ProjectCapitalSetCost", (Object)ProjectCapitalSetCost);
        json.put("ProjectCapitalSet", (Object)ProjectCapitalSet);
        return CommonResponse.success((String)"\u67e5\u8be2\u6253\u5370\u6570\u636e\u6210\u529f\uff01", (Object)json);
    }

    @RequestMapping(value={"queryAllList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ProjectCapitalSetVO>> queryAllList(@RequestBody QueryParam param, HttpServletRequest request) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        long projectstartTime = System.currentTimeMillis();
        CommonResponse response = this.iProjectApi.queryProjectPage(param);
        long projectendTime = System.currentTimeMillis();
        logger.info("---------------------");
        logger.info("\u83b7\u53d6\u9879\u76ee ---- \u8fd0\u884c\u65f6\u95f4\uff1a" + (projectstartTime - projectendTime) + "ms");
        Page page = new Page();
        if (response.isSuccess()) {
            IPage projectRegisterVOIPage = (IPage)response.getData();
            page = new Page(projectRegisterVOIPage.getCurrent(), projectRegisterVOIPage.getSize(), projectRegisterVOIPage.getTotal());
            if (projectRegisterVOIPage.getTotal() > 0L) {
                ArrayList<Object> setVOS = new ArrayList<Object>();
                ArrayList<Long> projectIds = new ArrayList<Long>();
                for (ProjectRegisterVO p : projectRegisterVOIPage.getRecords()) {
                    projectIds.add(p.getId());
                }
                Map<Long, JSONObject> projectCapital = this.projectCapitalSetService.queryIncoemAndExpendByProjectIds(projectIds, request);
                long operatestartTime = System.currentTimeMillis();
                QueryParam queryParam = new QueryParam();
                queryParam.getParams().put("projectId", new Parameter("in", projectIds));
                List allExitlist = this.projectCapitalSetService.queryList(queryParam, false);
                HashMap<Long, ProjectCapitalSetEntity> exitProjectMap = new HashMap<Long, ProjectCapitalSetEntity>();
                for (ProjectCapitalSetEntity entity : allExitlist) {
                    exitProjectMap.put(entity.getProjectId(), entity);
                }
                for (ProjectRegisterVO p : projectRegisterVOIPage.getRecords()) {
                    BigDecimal payMoney;
                    BigDecimal receiveMoney;
                    JSONObject dataresultIncoemAndExpend;
                    if (exitProjectMap.get(p.getId()) != null) {
                        ProjectCapitalSetEntity vo = (ProjectCapitalSetEntity)((Object)exitProjectMap.get(p.getId()));
                        dataresultIncoemAndExpend = projectCapital.get(p.getId());
                        if (dataresultIncoemAndExpend.get((Object)"incomeTaxRate") != null) {
                            dataresultIncoemAndExpend.put("incomeTaxRate", (Object)dataresultIncoemAndExpend.getBigDecimal("incomeTaxRate").divide(new BigDecimal(100.0)));
                        }
                        receiveMoney = dataresultIncoemAndExpend.getBigDecimal("receiveMoney") != null ? dataresultIncoemAndExpend.getBigDecimal("receiveMoney") : new BigDecimal(0);
                        payMoney = dataresultIncoemAndExpend.getBigDecimal("payMoney") != null ? dataresultIncoemAndExpend.getBigDecimal("payMoney") : new BigDecimal(0);
                        vo.setProjectIncome(receiveMoney == null ? BigDecimal.ZERO.setScale(2, 4) : receiveMoney);
                        vo.setProjectExpenditure(payMoney == null ? BigDecimal.ZERO.setScale(2, 4) : payMoney);
                        QueryWrapper queryWrapper = new QueryWrapper();
                        queryWrapper.eq((Object)"project_capital_set_id", (Object)vo.getId());
                        queryWrapper.eq((Object)"dr", (Object)0);
                        List projectCapitalSetList = this.iProjectCapitalSetCostService.list((Wrapper)queryWrapper);
                        if (projectCapitalSetList != null && projectCapitalSetList.size() > 0) {
                            BigDecimal otherMoney = new BigDecimal(0);
                            for (ProjectCapitalSetCostEntity cost : projectCapitalSetList) {
                                if ("value".equals(cost.getDataType())) {
                                    BigDecimal valueOrFormula;
                                    if ("add".equals(cost.getAddOrDelete())) {
                                        if (cost.getValueOrFormula() != null) {
                                            valueOrFormula = new BigDecimal(cost.getValueOrFormula());
                                            otherMoney = otherMoney.add(valueOrFormula);
                                            cost.setAmount(valueOrFormula);
                                            continue;
                                        }
                                        cost.setAmount(new BigDecimal(0));
                                        continue;
                                    }
                                    if (!"delete".equals(cost.getAddOrDelete())) continue;
                                    if (cost.getValueOrFormula() != null) {
                                        valueOrFormula = new BigDecimal(cost.getValueOrFormula());
                                        otherMoney = otherMoney.subtract(valueOrFormula);
                                        cost.setAmount(new BigDecimal(0).subtract(valueOrFormula));
                                        continue;
                                    }
                                    cost.setAmount(new BigDecimal(0));
                                    continue;
                                }
                                if (cost.getFormula() != null) {
                                    String evalq = cost.getFormula();
                                    for (String key : dataresultIncoemAndExpend.keySet()) {
                                        String value = "0";
                                        value = dataresultIncoemAndExpend.getString(key) != null ? dataresultIncoemAndExpend.getString(key) : "0";
                                        evalq = evalq.replaceAll(key, value);
                                    }
                                    ScriptEngineManager manager = new ScriptEngineManager();
                                    ScriptEngine se = manager.getEngineByName("js");
                                    BigDecimal money = new BigDecimal(0);
                                    try {
                                        money = new BigDecimal((Double)se.eval(evalq));
                                    }
                                    catch (ScriptException e) {
                                        e.printStackTrace();
                                    }
                                    if ("delete".equals(cost.getAddOrDelete())) {
                                        money = new BigDecimal(0).subtract(money);
                                    }
                                    cost.setAmount(money);
                                    otherMoney = otherMoney.add(money);
                                    continue;
                                }
                                cost.setAmount(new BigDecimal(0));
                            }
                            BigDecimal availableBalance = receiveMoney.subtract(payMoney).add(otherMoney);
                            vo.setOther(otherMoney);
                            vo.setAvailableBalance(availableBalance);
                        } else {
                            BigDecimal availableBalance = receiveMoney.subtract(payMoney);
                            vo.setOther(new BigDecimal(0));
                            vo.setAvailableBalance(availableBalance);
                        }
                        setVOS.add(BeanMapper.map((Object)((Object)vo), ProjectCapitalSetVO.class));
                        continue;
                    }
                    ProjectCapitalSetVO capitalSetVO = new ProjectCapitalSetVO();
                    capitalSetVO.setId(p.getId());
                    capitalSetVO.setProjectId(p.getId());
                    capitalSetVO.setProjectDepartmentId(p.getProjectDepartmentId());
                    capitalSetVO.setProjectName(p.getName());
                    dataresultIncoemAndExpend = projectCapital.get(p.getId());
                    receiveMoney = dataresultIncoemAndExpend.getBigDecimal("receiveMoney");
                    payMoney = dataresultIncoemAndExpend.getBigDecimal("payMoney");
                    capitalSetVO.setProjectIncome(receiveMoney == null ? BigDecimal.ZERO.setScale(2, 4) : receiveMoney);
                    capitalSetVO.setProjectExpenditure(payMoney == null ? BigDecimal.ZERO.setScale(2, 4) : payMoney);
                    capitalSetVO.setOther(BigDecimal.ZERO.setScale(2, 4));
                    BigDecimal availableBalance = BigDecimal.ZERO.setScale(2, 4);
                    if (receiveMoney != null && payMoney != null) {
                        availableBalance = receiveMoney.subtract(payMoney);
                    } else if (receiveMoney == null && payMoney != null) {
                        availableBalance = availableBalance.subtract(payMoney);
                    } else if (receiveMoney != null) {
                        availableBalance = receiveMoney;
                    }
                    capitalSetVO.setAvailableBalance(availableBalance);
                    setVOS.add(capitalSetVO);
                }
                page.setRecords(setVOS);
                long operateendTime = System.currentTimeMillis();
                logger.info("===============================");
                logger.info("\u8ba1\u7b97 ---- \u8fd0\u884c\u65f6\u95f4\uff1a" + (operatestartTime - operateendTime) + "ms");
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/excelSisExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelSisExport(@RequestBody QueryParam param, HttpServletResponse response, HttpServletRequest request) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("name");
        CommonResponse resultData = this.iProjectApi.queryProjectPage(param);
        ArrayList<Object> setVOS = new ArrayList<Object>();
        if (resultData.isSuccess()) {
            IPage projectRegisterVOIPage = (IPage)resultData.getData();
            if (projectRegisterVOIPage.getTotal() > 100000L) {
                param.setPageSize((int)projectRegisterVOIPage.getTotal());
                resultData = this.iProjectApi.queryProjectPage(param);
            }
            ArrayList<Long> projectIds = new ArrayList<Long>();
            for (ProjectRegisterVO p : projectRegisterVOIPage.getRecords()) {
                projectIds.add(p.getId());
            }
            Map<Long, JSONObject> projectCapital = this.projectCapitalSetService.queryIncoemAndExpendByProjectIds(projectIds, request);
            QueryParam queryselfParam = new QueryParam();
            queryselfParam.getParams().put("projectId", new Parameter("in", projectIds));
            List allExitlist = this.projectCapitalSetService.queryList(queryselfParam, false);
            HashMap<Long, ProjectCapitalSetEntity> exitProjectMap = new HashMap<Long, ProjectCapitalSetEntity>();
            for (ProjectCapitalSetEntity entity : allExitlist) {
                exitProjectMap.put(entity.getProjectId(), entity);
            }
            if (projectRegisterVOIPage.getTotal() > 0L) {
                for (ProjectRegisterVO p : projectRegisterVOIPage.getRecords()) {
                    BigDecimal payMoney;
                    BigDecimal receiveMoney;
                    if (exitProjectMap.get(p.getId()) != null) {
                        ProjectCapitalSetEntity vo = (ProjectCapitalSetEntity)((Object)exitProjectMap.get(p.getId()));
                        JSONObject dataresultIncoemAndExpend = projectCapital.get(p.getId());
                        if (dataresultIncoemAndExpend.get((Object)"incomeTaxRate") != null) {
                            dataresultIncoemAndExpend.put("incomeTaxRate", (Object)dataresultIncoemAndExpend.getBigDecimal("incomeTaxRate").divide(new BigDecimal(100.0)));
                        }
                        receiveMoney = dataresultIncoemAndExpend.getBigDecimal("receiveMoney") != null ? dataresultIncoemAndExpend.getBigDecimal("receiveMoney") : new BigDecimal(0);
                        payMoney = dataresultIncoemAndExpend.getBigDecimal("payMoney") != null ? dataresultIncoemAndExpend.getBigDecimal("payMoney") : new BigDecimal(0);
                        vo.setProjectIncome(receiveMoney == null ? BigDecimal.ZERO.setScale(2, 4) : receiveMoney);
                        vo.setProjectExpenditure(payMoney == null ? BigDecimal.ZERO.setScale(2, 4) : payMoney);
                        QueryWrapper queryWrapper = new QueryWrapper();
                        queryWrapper.eq((Object)"project_capital_set_id", (Object)vo.getId());
                        queryWrapper.eq((Object)"dr", (Object)0);
                        List projectCapitalSetList = this.iProjectCapitalSetCostService.list((Wrapper)queryWrapper);
                        if (projectCapitalSetList != null && projectCapitalSetList.size() > 0) {
                            BigDecimal otherMoney = new BigDecimal(0);
                            for (ProjectCapitalSetCostEntity cost : projectCapitalSetList) {
                                if ("value".equals(cost.getDataType())) {
                                    BigDecimal valueOrFormula;
                                    if ("add".equals(cost.getAddOrDelete())) {
                                        if (cost.getValueOrFormula() != null) {
                                            valueOrFormula = new BigDecimal(cost.getValueOrFormula());
                                            otherMoney = otherMoney.add(valueOrFormula);
                                            cost.setAmount(valueOrFormula);
                                            continue;
                                        }
                                        cost.setAmount(new BigDecimal(0));
                                        continue;
                                    }
                                    if (!"delete".equals(cost.getAddOrDelete())) continue;
                                    if (cost.getValueOrFormula() != null) {
                                        valueOrFormula = new BigDecimal(cost.getValueOrFormula());
                                        otherMoney = otherMoney.subtract(valueOrFormula);
                                        cost.setAmount(new BigDecimal(0).subtract(valueOrFormula));
                                        continue;
                                    }
                                    cost.setAmount(new BigDecimal(0));
                                    continue;
                                }
                                if (cost.getFormula() != null) {
                                    String evalq = cost.getFormula();
                                    for (String key : dataresultIncoemAndExpend.keySet()) {
                                        String value = "0";
                                        value = dataresultIncoemAndExpend.getString(key) != null ? dataresultIncoemAndExpend.getString(key) : "0";
                                        evalq = evalq.replaceAll(key, value);
                                    }
                                    ScriptEngineManager manager = new ScriptEngineManager();
                                    ScriptEngine se = manager.getEngineByName("js");
                                    BigDecimal money = new BigDecimal(0);
                                    try {
                                        money = new BigDecimal((Double)se.eval(evalq));
                                    }
                                    catch (ScriptException e) {
                                        e.printStackTrace();
                                    }
                                    if ("delete".equals(cost.getAddOrDelete())) {
                                        money = new BigDecimal(0).subtract(money);
                                    }
                                    cost.setAmount(money);
                                    otherMoney = otherMoney.add(money);
                                    continue;
                                }
                                cost.setAmount(new BigDecimal(0));
                            }
                            BigDecimal availableBalance = receiveMoney.subtract(payMoney).add(otherMoney);
                            vo.setOther(otherMoney);
                            vo.setAvailableBalance(availableBalance);
                        } else {
                            BigDecimal availableBalance = receiveMoney.subtract(payMoney);
                            vo.setOther(new BigDecimal(0));
                            vo.setAvailableBalance(availableBalance);
                        }
                        setVOS.add(BeanMapper.map((Object)((Object)vo), ProjectCapitalSetVO.class));
                        continue;
                    }
                    ProjectCapitalSetVO capitalSetVO = new ProjectCapitalSetVO();
                    capitalSetVO.setId(p.getId());
                    capitalSetVO.setProjectId(p.getId());
                    capitalSetVO.setProjectDepartmentId(p.getProjectDepartmentId());
                    capitalSetVO.setProjectName(p.getName());
                    JSONObject object = projectCapital.get(p.getId());
                    receiveMoney = object.getBigDecimal("receiveMoney");
                    payMoney = object.getBigDecimal("payMoney");
                    capitalSetVO.setProjectIncome(receiveMoney == null ? BigDecimal.ZERO.setScale(2, 4) : receiveMoney);
                    capitalSetVO.setProjectExpenditure(payMoney == null ? BigDecimal.ZERO.setScale(2, 4) : payMoney);
                    capitalSetVO.setOther(BigDecimal.ZERO.setScale(2, 4));
                    BigDecimal availableBalance = BigDecimal.ZERO.setScale(2, 4);
                    if (receiveMoney != null && payMoney != null) {
                        availableBalance = receiveMoney.subtract(payMoney);
                    } else if (receiveMoney == null && payMoney != null) {
                        availableBalance = availableBalance.subtract(payMoney);
                    } else if (receiveMoney != null) {
                        availableBalance = receiveMoney;
                    }
                    capitalSetVO.setAvailableBalance(availableBalance);
                    setVOS.add(capitalSetVO);
                }
            }
        }
        HashMap<String, ArrayList<Object>> beans = new HashMap<String, ArrayList<Object>>();
        beans.put("records", setVOS);
        ExcelExport.getInstance().export("projectCapitalSetSisExport.xlsx", beans, response);
    }

    @RequestMapping(value={"querySisDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ProjectCapitalSetVO> querySisDetail(Long id, HttpServletRequest request) {
        ProjectCapitalSetEntity entity = (ProjectCapitalSetEntity)((Object)this.projectCapitalSetService.selectById(id));
        if (entity == null) {
            ProjectCapitalSetVO capitalSetVO = new ProjectCapitalSetVO();
            capitalSetVO.setId(id);
            capitalSetVO.setProjectId(id);
            CommonResponse response = this.iProjectApi.queryProjectByIds(Collections.singletonList(id));
            if (response.isSuccess()) {
                ProjectRegisterVO p = (ProjectRegisterVO)((List)response.getData()).get(0);
                capitalSetVO.setProjectName(p.getName());
                capitalSetVO.setProjectDepartmentId(p.getProjectDepartmentId());
                CommonResponse<JSONObject> inAndOut = this.projectCapitalSetService.queryIncoemAndExpendByProjectId(p.getId(), request);
                if (inAndOut.isSuccess()) {
                    JSONObject object = (JSONObject)inAndOut.getData();
                    BigDecimal receiveMoney = object.getBigDecimal("receiveMoney");
                    BigDecimal payMoney = object.getBigDecimal("payMoney");
                    capitalSetVO.setProjectIncome(receiveMoney == null ? BigDecimal.ZERO.setScale(2, 4) : receiveMoney);
                    capitalSetVO.setProjectExpenditure(payMoney == null ? BigDecimal.ZERO.setScale(2, 4) : payMoney);
                    capitalSetVO.setOther(BigDecimal.ZERO.setScale(2, 4));
                    BigDecimal availableBalance = BigDecimal.ZERO.setScale(2, 4);
                    if (receiveMoney != null && payMoney != null) {
                        availableBalance = receiveMoney.subtract(payMoney);
                    } else if (receiveMoney == null && payMoney != null) {
                        availableBalance = availableBalance.subtract(payMoney);
                    } else if (receiveMoney != null) {
                        availableBalance = receiveMoney;
                    }
                    capitalSetVO.setAvailableBalance(availableBalance);
                } else {
                    capitalSetVO.setProjectExpenditure(BigDecimal.ZERO.setScale(2, 4));
                    capitalSetVO.setProjectIncome(BigDecimal.ZERO.setScale(2, 4));
                    capitalSetVO.setOther(BigDecimal.ZERO.setScale(2, 4));
                    capitalSetVO.setAvailableBalance(BigDecimal.ZERO.setScale(2, 4));
                }
                return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)capitalSetVO);
            }
            return CommonResponse.error((String)"\u975e\u6cd5\u67e5\u8be2\uff01");
        }
        ProjectCapitalSetVO vo = (ProjectCapitalSetVO)BeanMapper.map((Object)((Object)entity), ProjectCapitalSetVO.class);
        CommonResponse<JSONObject> inAndOut = this.projectCapitalSetService.queryIncoemAndExpendByProjectId(vo.getProjectId(), request);
        if (inAndOut.isSuccess()) {
            JSONObject dataresultIncoemAndExpend = (JSONObject)inAndOut.getData();
            if (dataresultIncoemAndExpend.get((Object)"incomeTaxRate") != null) {
                dataresultIncoemAndExpend.put("incomeTaxRate", (Object)dataresultIncoemAndExpend.getBigDecimal("incomeTaxRate").divide(new BigDecimal(100.0)));
            }
            if (vo.getProjectCapitalSetList() != null && vo.getProjectCapitalSetList().size() > 0) {
                List list = vo.getProjectCapitalSetList();
                BigDecimal otherMoney = new BigDecimal(0);
                for (ProjectCapitalSetCostVO cost : list) {
                    if ("value".equals(cost.getDataType())) {
                        BigDecimal valueOrFormula;
                        if ("add".equals(cost.getAddOrDelete())) {
                            if (cost.getValueOrFormula() != null) {
                                valueOrFormula = new BigDecimal(cost.getValueOrFormula());
                                otherMoney = otherMoney.add(valueOrFormula);
                                cost.setAmount(valueOrFormula);
                                continue;
                            }
                            cost.setAmount(new BigDecimal(0));
                            continue;
                        }
                        if (!"delete".equals(cost.getAddOrDelete())) continue;
                        if (cost.getValueOrFormula() != null) {
                            valueOrFormula = new BigDecimal(cost.getValueOrFormula());
                            otherMoney = otherMoney.subtract(valueOrFormula);
                            cost.setAmount(new BigDecimal(0).subtract(valueOrFormula));
                            continue;
                        }
                        cost.setAmount(new BigDecimal(0));
                        continue;
                    }
                    if (cost.getFormula() != null) {
                        String evalq = cost.getFormula();
                        for (String key : dataresultIncoemAndExpend.keySet()) {
                            String value = "0";
                            value = dataresultIncoemAndExpend.getString(key) != null ? dataresultIncoemAndExpend.getString(key) : "0";
                            evalq = evalq.replaceAll(key, value);
                        }
                        ScriptEngineManager manager = new ScriptEngineManager();
                        ScriptEngine se = manager.getEngineByName("js");
                        BigDecimal money = new BigDecimal(0);
                        try {
                            money = new BigDecimal((Double)se.eval(evalq));
                        }
                        catch (ScriptException e) {
                            e.printStackTrace();
                        }
                        if ("delete".equals(cost.getAddOrDelete())) {
                            money = new BigDecimal(0).subtract(money);
                        }
                        cost.setAmount(money);
                        otherMoney = otherMoney.add(money);
                        continue;
                    }
                    cost.setAmount(new BigDecimal(0));
                }
                BigDecimal receiveMoney = dataresultIncoemAndExpend.getBigDecimal("receiveMoney") != null ? dataresultIncoemAndExpend.getBigDecimal("receiveMoney") : new BigDecimal(0);
                BigDecimal payMoney = dataresultIncoemAndExpend.getBigDecimal("payMoney") != null ? dataresultIncoemAndExpend.getBigDecimal("payMoney") : new BigDecimal(0);
                vo.setProjectIncome((BigDecimal)(receiveMoney == null ? BigDecimal.ZERO.setScale(2, 4) : receiveMoney));
                vo.setProjectExpenditure(payMoney == null ? BigDecimal.ZERO.setScale(2, 4) : payMoney);
                BigDecimal availableBalance = receiveMoney.subtract(payMoney).add(otherMoney);
                vo.setOther(otherMoney);
                vo.setAvailableBalance(availableBalance);
            }
        } else {
            vo.setProjectIncome(BigDecimal.ZERO.setScale(2, 4));
            vo.setProjectExpenditure(BigDecimal.ZERO.setScale(2, 4));
            vo.setOther(BigDecimal.ZERO.setScale(2, 4));
            vo.setAvailableBalance(BigDecimal.ZERO.setScale(2, 4));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/querySisPrint"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> querySisPrint(Long id, HttpServletRequest request) {
        JSONObject json = new JSONObject();
        JSONArray ProjectCapitalSetCost = new JSONArray();
        ProjectCapitalSetEntity entity = (ProjectCapitalSetEntity)((Object)this.projectCapitalSetService.selectById(id));
        if (entity == null) {
            ProjectCapitalSetVO capitalSetVO = new ProjectCapitalSetVO();
            capitalSetVO.setId(id);
            capitalSetVO.setProjectId(id);
            CommonResponse response = this.iProjectApi.queryProjectByIds(Collections.singletonList(id));
            if (response.isSuccess()) {
                ProjectRegisterVO p = (ProjectRegisterVO)((List)response.getData()).get(0);
                capitalSetVO.setProjectName(p.getName());
                capitalSetVO.setProjectDepartmentId(p.getProjectDepartmentId());
                CommonResponse<JSONObject> inAndOut = this.projectCapitalSetService.queryIncoemAndExpendByProjectId(p.getId(), request);
                if (inAndOut.isSuccess()) {
                    JSONObject object = (JSONObject)inAndOut.getData();
                    BigDecimal receiveMoney = object.getBigDecimal("receiveMoney");
                    BigDecimal payMoney = object.getBigDecimal("payMoney");
                    capitalSetVO.setProjectIncome(receiveMoney == null ? BigDecimal.ZERO.setScale(2, 4) : receiveMoney);
                    capitalSetVO.setProjectExpenditure(payMoney == null ? BigDecimal.ZERO.setScale(2, 4) : payMoney);
                    capitalSetVO.setOther(BigDecimal.ZERO.setScale(2, 4));
                    BigDecimal availableBalance = BigDecimal.ZERO.setScale(2, 4);
                    if (receiveMoney != null && payMoney != null) {
                        availableBalance = receiveMoney.subtract(payMoney);
                    } else if (receiveMoney == null && payMoney != null) {
                        availableBalance = availableBalance.subtract(payMoney);
                    } else if (receiveMoney != null) {
                        availableBalance = receiveMoney;
                    }
                    capitalSetVO.setAvailableBalance(availableBalance);
                } else {
                    capitalSetVO.setProjectExpenditure(BigDecimal.ZERO.setScale(2, 4));
                    capitalSetVO.setProjectIncome(BigDecimal.ZERO.setScale(2, 4));
                    capitalSetVO.setOther(BigDecimal.ZERO.setScale(2, 4));
                    capitalSetVO.setAvailableBalance(BigDecimal.ZERO.setScale(2, 4));
                }
                json.put("ProjectCapitalSet", (Object)capitalSetVO);
                return CommonResponse.success((String)"\u67e5\u8be2\u6253\u5370\u6570\u636e\u6210\u529f\uff01", (Object)json);
            }
            return CommonResponse.error((String)"\u975e\u6cd5\u67e5\u8be2\uff01");
        }
        ProjectCapitalSetVO vo = (ProjectCapitalSetVO)BeanMapper.map((Object)((Object)entity), ProjectCapitalSetVO.class);
        CommonResponse<JSONObject> inAndOut = this.projectCapitalSetService.queryIncoemAndExpendByProjectId(vo.getProjectId(), request);
        if (inAndOut.isSuccess()) {
            JSONObject dataresultIncoemAndExpend = (JSONObject)inAndOut.getData();
            if (dataresultIncoemAndExpend.get((Object)"incomeTaxRate") != null) {
                dataresultIncoemAndExpend.put("incomeTaxRate", (Object)dataresultIncoemAndExpend.getBigDecimal("incomeTaxRate").divide(new BigDecimal(100.0)));
            }
            if (vo.getProjectCapitalSetList() != null && vo.getProjectCapitalSetList().size() > 0) {
                List list = vo.getProjectCapitalSetList();
                BigDecimal otherMoney = new BigDecimal(0);
                for (ProjectCapitalSetCostVO cost : list) {
                    if ("value".equals(cost.getDataType())) {
                        BigDecimal valueOrFormula;
                        if ("add".equals(cost.getAddOrDelete())) {
                            if (cost.getValueOrFormula() != null) {
                                valueOrFormula = new BigDecimal(cost.getValueOrFormula());
                                otherMoney = otherMoney.add(valueOrFormula);
                                cost.setAmount(valueOrFormula);
                            } else {
                                cost.setAmount(new BigDecimal(0));
                            }
                        } else if ("delete".equals(cost.getAddOrDelete())) {
                            if (cost.getValueOrFormula() != null) {
                                valueOrFormula = new BigDecimal(cost.getValueOrFormula());
                                otherMoney = otherMoney.subtract(valueOrFormula);
                                cost.setAmount(new BigDecimal(0).subtract(valueOrFormula));
                            } else {
                                cost.setAmount(new BigDecimal(0));
                            }
                        }
                    } else if (cost.getFormula() != null) {
                        String evalq = cost.getFormula();
                        for (String key : dataresultIncoemAndExpend.keySet()) {
                            String value = "0";
                            value = dataresultIncoemAndExpend.getString(key) != null ? dataresultIncoemAndExpend.getString(key) : "0";
                            evalq = evalq.replaceAll(key, value);
                        }
                        ScriptEngineManager manager = new ScriptEngineManager();
                        ScriptEngine se = manager.getEngineByName("js");
                        BigDecimal money = new BigDecimal(0);
                        try {
                            money = new BigDecimal((Double)se.eval(evalq));
                        }
                        catch (ScriptException e) {
                            e.printStackTrace();
                        }
                        if ("delete".equals(cost.getAddOrDelete())) {
                            money = new BigDecimal(0).subtract(money);
                        }
                        cost.setAmount(money);
                        otherMoney = otherMoney.add(money);
                    } else {
                        cost.setAmount(new BigDecimal(0));
                    }
                    if ("add".equals(cost.getAddOrDelete())) {
                        cost.setAddOrDelete("\u589e\u52a0");
                    } else if ("delete".equals(cost.getAddOrDelete())) {
                        cost.setAddOrDelete("\u6263\u9664");
                    }
                    if ("value".equals(cost.getDataType())) {
                        cost.setDataType("\u6570\u503c");
                    } else if ("formula".equals(cost.getDataType())) {
                        cost.setDataType("\u516c\u5f0f");
                    }
                    JSONObject costJson = new JSONObject();
                    costJson.put("id", (Object)cost.getId());
                    costJson.put("costName", (Object)cost.getCostName());
                    costJson.put("addOrDelete", (Object)cost.getAddOrDelete());
                    costJson.put("dataType", (Object)cost.getDataType());
                    costJson.put("valueOrFormula", (Object)cost.getValueOrFormula());
                    if (cost.getRegistrationTime() != null) {
                        String pattern = "yyyy-MM-dd";
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
                        costJson.put("registrationTime", (Object)simpleDateFormat.format(cost.getRegistrationTime()));
                    }
                    costJson.put("amount", (Object)cost.getAmount());
                    if (cost.getDealUser() != null) {
                        try {
                            JSONArray jArray = ReferObjectUtil.getReferEntityValue((String)cost.getDealUser().toString(), (String)"idm-user");
                            if (jArray != null && jArray.size() > 0) {
                                costJson.put("dealUser", (Object)((JSONObject)jArray.get(0)).get((Object)"name").toString());
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    costJson.put("remarks", (Object)cost.getRemarks());
                    ProjectCapitalSetCost.add((Object)costJson);
                }
                BigDecimal receiveMoney = dataresultIncoemAndExpend.getBigDecimal("receiveMoney") != null ? dataresultIncoemAndExpend.getBigDecimal("receiveMoney") : new BigDecimal(0);
                BigDecimal payMoney = dataresultIncoemAndExpend.getBigDecimal("payMoney") != null ? dataresultIncoemAndExpend.getBigDecimal("payMoney") : new BigDecimal(0);
                vo.setProjectIncome((BigDecimal)(receiveMoney == null ? BigDecimal.ZERO.setScale(2, 4) : receiveMoney));
                vo.setProjectExpenditure(payMoney == null ? BigDecimal.ZERO.setScale(2, 4) : payMoney);
                BigDecimal availableBalance = receiveMoney.subtract(payMoney).add(otherMoney);
                vo.setOther(otherMoney);
                vo.setAvailableBalance(availableBalance);
            }
        } else {
            vo.setProjectIncome(BigDecimal.ZERO.setScale(2, 4));
            vo.setProjectExpenditure(BigDecimal.ZERO.setScale(2, 4));
            vo.setOther(BigDecimal.ZERO.setScale(2, 4));
            vo.setAvailableBalance(BigDecimal.ZERO.setScale(2, 4));
        }
        JSONObject ProjectCapitalSet = new JSONObject();
        ProjectCapitalSet.put("id", (Object)vo.getId());
        ProjectCapitalSet.put("projectName", (Object)vo.getProjectName());
        ProjectCapitalSet.put("projectIncome", (Object)vo.getProjectIncome());
        ProjectCapitalSet.put("projectExpenditure", (Object)vo.getProjectExpenditure());
        ProjectCapitalSet.put("other", (Object)vo.getOther());
        ProjectCapitalSet.put("availableBalance", (Object)vo.getAvailableBalance());
        ProjectCapitalSet.put("ProjectCapitalSetCost", (Object)ProjectCapitalSetCost);
        json.put("ProjectCapitalSet", (Object)ProjectCapitalSet);
        return CommonResponse.success((String)"\u67e5\u8be2\u6253\u5370\u6570\u636e\u6210\u529f\uff01", (Object)json);
    }
}

