/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.budget.api.IBudgetProjectProApi;
import com.ejianc.business.budget.vo.BudgetProjectProParamControlVO;
import com.ejianc.business.budget.vo.BudgetProjectProQuantityAndMnyVO;
import com.ejianc.business.cost.api.ICostDetailApi;
import com.ejianc.business.equipment.api.IEquipmentContractApi;
import com.ejianc.business.equipment.vo.EquipmentReportVo;
import com.ejianc.business.finance.bean.DeductionEntity;
import com.ejianc.business.finance.bean.LoadApplyEntity;
import com.ejianc.business.finance.bean.LoadReimburseEntity;
import com.ejianc.business.finance.bean.PayContractDeductionEntity;
import com.ejianc.business.finance.bean.PayContractEntity;
import com.ejianc.business.finance.bean.PayContractSalaryEntity;
import com.ejianc.business.finance.bean.PayContractSettleEntity;
import com.ejianc.business.finance.bean.PayContractSummaryEntity;
import com.ejianc.business.finance.bean.PayForegiftEntity;
import com.ejianc.business.finance.bean.PayForegiftPlanEntity;
import com.ejianc.business.finance.bean.PayForegiftRecordEntity;
import com.ejianc.business.finance.bean.PayInvoiceEntity;
import com.ejianc.business.finance.bean.PayReimburseEntity;
import com.ejianc.business.finance.bean.PaySporadicEntity;
import com.ejianc.business.finance.bean.ReceiveEntity;
import com.ejianc.business.finance.controller.SqlParam;
import com.ejianc.business.finance.enums.ConstantTypeEnum;
import com.ejianc.business.finance.enums.ContractTypeConst;
import com.ejianc.business.finance.enums.ReceiveInvoiceFlagConst;
import com.ejianc.business.finance.mapper.PayContractMapper;
import com.ejianc.business.finance.pub.consts.FinancePubConsts;
import com.ejianc.business.finance.pub.vo.PubContractSettleVO;
import com.ejianc.business.finance.pub.vo.PubContractSubQueryVO;
import com.ejianc.business.finance.pub.vo.PubWarnQueryVO;
import com.ejianc.business.finance.service.IDeductionService;
import com.ejianc.business.finance.service.ILoadApplyService;
import com.ejianc.business.finance.service.ILoadReimburseService;
import com.ejianc.business.finance.service.IPayContractDeductionService;
import com.ejianc.business.finance.service.IPayContractSalaryService;
import com.ejianc.business.finance.service.IPayContractService;
import com.ejianc.business.finance.service.IPayContractSettleService;
import com.ejianc.business.finance.service.IPayContractSummaryService;
import com.ejianc.business.finance.service.IPayForegiftPlanService;
import com.ejianc.business.finance.service.IPayForegiftRecordService;
import com.ejianc.business.finance.service.IPayForegiftService;
import com.ejianc.business.finance.service.IPayInvoiceService;
import com.ejianc.business.finance.service.IPayRecordService;
import com.ejianc.business.finance.service.IPayReimburseService;
import com.ejianc.business.finance.service.IPaySporadicService;
import com.ejianc.business.finance.service.IReceiveService;
import com.ejianc.business.finance.service.PayRecordMessageService;
import com.ejianc.business.finance.util.BillTypeCodeEnum;
import com.ejianc.business.finance.util.MathUtil;
import com.ejianc.business.finance.util.ValidateUtil;
import com.ejianc.business.finance.utils.BigDecimalUtil;
import com.ejianc.business.finance.utils.DateUtil;
import com.ejianc.business.finance.utils.FeignUtil;
import com.ejianc.business.finance.utils.MonthUtil;
import com.ejianc.business.finance.utils.NumberToCN;
import com.ejianc.business.finance.vo.FinanceCostVO;
import com.ejianc.business.finance.vo.FinanceMonthVO;
import com.ejianc.business.finance.vo.FinanceWarnV0;
import com.ejianc.business.finance.vo.LoadApplyVO;
import com.ejianc.business.finance.vo.ManageDetailVO;
import com.ejianc.business.finance.vo.ParamsCheckDsVO;
import com.ejianc.business.finance.vo.ParamsCheckVO;
import com.ejianc.business.finance.vo.PayAndReceiveMnyWarnVO;
import com.ejianc.business.finance.vo.PayApplyPubVO;
import com.ejianc.business.finance.vo.PayContractDeductionVO;
import com.ejianc.business.finance.vo.PayContractSalaryVO;
import com.ejianc.business.finance.vo.PayContractSettleVO;
import com.ejianc.business.finance.vo.PayContractSummaryVO;
import com.ejianc.business.finance.vo.PayContractVO;
import com.ejianc.business.finance.vo.PayInvoiceVO;
import com.ejianc.business.finance.vo.PayMnyWarnVO;
import com.ejianc.business.finance.vo.PayRecordVO;
import com.ejianc.business.finance.vo.ProjectAppVo;
import com.ejianc.business.finance.vo.ProjectFinancePayVO;
import com.ejianc.business.finance.vo.ProjectFinanceVO;
import com.ejianc.business.finance.vo.ProjectReimburseVO;
import com.ejianc.business.finance.vo.ReportAppVo;
import com.ejianc.business.finance.vo.RmatAndOtherInfo;
import com.ejianc.business.finance.vo.SumMnyStatisticVO;
import com.ejianc.business.finance.vo.SumPayMnyVO;
import com.ejianc.business.finance.vo.TotalColumnVO;
import com.ejianc.business.income.api.IContractReportApi;
import com.ejianc.business.income.api.IIncomeContractApi;
import com.ejianc.business.income.vo.ContractVo;
import com.ejianc.business.income.vo.report.IncomeReportMnyVo;
import com.ejianc.business.income.vo.report.ProjectReportVo;
import com.ejianc.business.labor.api.IProjectTeamApi;
import com.ejianc.business.material.api.IMaterialContractApi;
import com.ejianc.business.material.api.IMaterialSettlementApi;
import com.ejianc.business.material.vo.InstoreMaterialVO;
import com.ejianc.business.material.vo.MaterialReportVo;
import com.ejianc.business.other.api.IOtherContractApi;
import com.ejianc.business.other.vo.OtherProjectReportVo;
import com.ejianc.business.prjfinance.api.IPrjRiskMarginApi;
import com.ejianc.business.prjfinance.api.IProjectDutyLetterApi;
import com.ejianc.business.rmat.api.IRmatContractApi;
import com.ejianc.business.rmat.vo.RmatProjectReportVo;
import com.ejianc.business.sub.api.ISubContractForPayApi;
import com.ejianc.business.sub.api.ISubReportApi;
import com.ejianc.business.sub.vo.SubProjectReportVo;
import com.ejianc.business.tax.api.IInvoiceApi;
import com.ejianc.business.tax.vo.InvoiceReceiveVO;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.foundation.metadata.vo.CustomBusinessDataVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.permission.api.IRoleApi;
import com.ejianc.foundation.permission.vo.RoleVO;
import com.ejianc.foundation.share.util.PSRMResponse;
import com.ejianc.foundation.share.util.PSRMRestUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.extdata.service.ICustomBusinessDataService;
import com.ejianc.framework.skeleton.refer.util.ReferObjectUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PayContractServiceImpl
extends BaseServiceImpl<PayContractMapper, PayContractEntity>
implements IPayContractService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String PAY_CONTRACT_BILL_CODE = "PAY_CONTRACT";
    private static final String CHECK_PARAM_CODE = "P-v1U24318";
    private static final String CAN_USE_MNY_CHECK_CODE = "P-M478G960";
    private static final String CHECK_LABOR_APPLY = "P-Tr7VP379";
    private static final String PAY_CONTRACT_ONE_LIMIT_CODE = "P-N2kwc258";
    private static final String PREPAY_PARAM = "P-zu6b9071";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IDefdocApi defdocApi;
    @Autowired
    private IPayInvoiceService invoiceService;
    @Autowired
    private IPayContractSettleService settleService;
    @Autowired
    private IPayContractDeductionService contractDeductionService;
    @Autowired
    private IPayRecordService payRecordService;
    @Autowired
    private IPaySporadicService sporadicService;
    @Autowired
    private IPayReimburseService reimburseService;
    @Autowired
    private IPayForegiftService foregiftService;
    @Autowired
    private IPayForegiftRecordService recordService;
    @Autowired
    private IPayForegiftPlanService planService;
    @Autowired
    private IReceiveService receiveService;
    @Autowired
    private ISubContractForPayApi subApi;
    @Autowired
    private IEquipmentContractApi equipmentApi;
    @Autowired
    private IMaterialSettlementApi materialApi;
    @Autowired
    private IRmatContractApi rmatContractApi;
    @Autowired
    private IOtherContractApi otherContractApi;
    @Autowired
    private IIncomeContractApi incomeApi;
    @Autowired
    private ILoadReimburseService loadReimburseService;
    @Autowired
    private IContractReportApi contractReportApi;
    @Autowired
    private ISubReportApi subReportApi;
    @Autowired
    private IMaterialContractApi materialContractApi;
    @Autowired
    private IInvoiceApi invoiceApi;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private FeignUtil feignUtil;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ILoadApplyService loadApplyService;
    @Autowired
    private IPrjRiskMarginApi prjRiskMarginApi;
    @Autowired
    private IProjectDutyLetterApi projectDutyLetterApi;
    @Autowired
    private IProjectTeamApi projectTeamApi;
    @Autowired
    private IDeductionService deductionService;
    @Autowired
    private PayRecordMessageService payRecordMessageService;
    @Autowired
    private IPayContractSalaryService payContractSalaryService;
    @Autowired
    private IBudgetProjectProApi budgetProjectProApi;
    @Autowired
    private IPayContractSummaryService payContractSummaryService;
    @Autowired
    private PSRMRestUtil psrmRestUtil;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private ICustomBusinessDataService customBusinessDataService;
    @Value(value="${extend.field.mode:false}")
    private Boolean extFieldsMode;
    @Autowired
    private IRoleApi iRoleApi;

    public ManageDetailVO getManageDetailPlus(Long projectId) {
        QueryParam param = new QueryParam();
        param.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        param.getComplexParams().add(ComplexParam.getApprovedComplexParam((String)"and"));
        List receiveList = this.receiveService.queryList(param, false);
        BigDecimal sumReceiveMny = null;
        BigDecimal sumContractReceiveMny = BigDecimal.ZERO;
        for (ReceiveEntity receive : receiveList) {
            if (receive.getReceiveType() != null && String.valueOf(receive.getReceiveType()).equals("1275321308270993409")) {
                sumContractReceiveMny = MathUtil.safeAdd((BigDecimal)sumContractReceiveMny, (BigDecimal)receive.getReceiveMny());
            }
            sumReceiveMny = MathUtil.safeAdd(sumReceiveMny, (BigDecimal)receive.getReceiveMny());
        }
        List contractList = super.queryList(param, false);
        BigDecimal sumPayMny = null;
        for (PayContractEntity contract : contractList) {
            sumPayMny = MathUtil.safeAdd(sumPayMny, (BigDecimal)contract.getPayMny());
        }
        ManageDetailVO vo = new ManageDetailVO();
        vo.setProjectId(projectId);
        vo.setSumReceiveMny(sumReceiveMny);
        vo.setSumContractReceiveMny(sumContractReceiveMny);
        vo.setSumPayMny(sumPayMny);
        return vo;
    }

    @Override
    public ProjectFinanceVO getProFinance(Long projectId) {
        ProjectFinanceVO vo = new ProjectFinanceVO(projectId);
        CommonResponse resProject = this.incomeApi.projectProgress(projectId);
        if (resProject.isSuccess()) {
            JSONObject data = (JSONObject)resProject.getData();
            vo.setProjectType(data.getString("type"));
            vo.setProContractMny(BigDecimalUtil.nullToZero(data.getBigDecimal("contractMoney")));
            vo.setProOutputMny(BigDecimalUtil.nullToZero(data.getBigDecimal("outputMoney")));
            String dateProgressStr = data.getString("dateProgress");
            vo.setProDateProgress(BigDecimalUtil.nullToZero(BigDecimalUtil.toBigDecimal(dateProgressStr)));
            String outputProgress = data.getString("outputProgress");
            vo.setProOutputProgress(BigDecimalUtil.nullToZero(BigDecimalUtil.toBigDecimal(outputProgress)));
            ManageDetailVO manageDetailPlus = this.getManageDetailPlus(projectId);
            vo.setProReceiveMny(BigDecimalUtil.nullToZero(manageDetailPlus.getSumReceiveMny()));
            vo.setProContractReceiveMny(BigDecimalUtil.nullToZero(manageDetailPlus.getSumContractReceiveMny()));
            Long projectDepartmentId = data.getLong("projectDepartmentId");
            if (projectDepartmentId != null) {
                Page page = new Page(1L, -1L);
                QueryParam param = new QueryParam();
                param.getParams().put("orgId", new Parameter("eq", (Object)projectDepartmentId));
                QueryWrapper wrapper = PayContractServiceImpl.changeToQueryWrapper((QueryParam)param);
                List<LoadApplyVO> list = this.loadApplyService.queryAllReport(page, wrapper);
                BigDecimal surplusMny = BigDecimal.ZERO;
                if (CollectionUtils.isNotEmpty(list)) {
                    for (LoadApplyVO ap : list) {
                        surplusMny = BigDecimalUtil.safeAdd(surplusMny, ap.getSurplusMny());
                    }
                }
                vo.setProPettyCash(BigDecimalUtil.nullToZero(surplusMny));
            }
        } else {
            this.logger.error("\u67e5\u8be2\u9879\u76ee\u8d44\u91d1\u8d39\u7528\u6e05\u5355\u7ed3\u4f59\u5931\u8d25(from income)\uff1a" + resProject.getMsg());
        }
        CommonResponse costMoneyByProjectId = this.projectDutyLetterApi.getCostMoneyByProjectId(projectId);
        if (costMoneyByProjectId.isSuccess()) {
            vo.setProCostListSurplus((BigDecimal)costMoneyByProjectId.getData());
        } else {
            this.logger.error("\u67e5\u8be2\u9879\u76ee\u8d44\u91d1\u8d39\u7528\u6e05\u5355\u7ed3\u4f59\u5931\u8d25(from prjfinance)\uff1a" + costMoneyByProjectId.getMsg());
        }
        CommonResponse resPrjFinanceData = this.prjRiskMarginApi.getPrjFinanceData(projectId);
        if (resPrjFinanceData.isSuccess()) {
            Map dataMap = (Map)resPrjFinanceData.getData();
            vo.setProRiskMarginSurplus(BigDecimalUtil.nullToZero(BigDecimalUtil.toBigDecimal(dataMap.get("riskMarginBalance"))));
            vo.setProOtherFeeBack(BigDecimalUtil.nullToZero(BigDecimalUtil.toBigDecimal(dataMap.get("otherReturns"))));
            vo.setProOtherFeeDeduct(BigDecimalUtil.nullToZero(BigDecimalUtil.toBigDecimal(dataMap.get("otherDeductions"))));
            BigDecimal managementExpense = BigDecimalUtil.toBigDecimal(dataMap.get("managementExpense"));
            vo.setProManageScale(BigDecimalUtil.nullToZero(managementExpense));
            vo.setProManageFee(BigDecimalUtil.nullToZero(BigDecimalUtil.safeMultiply(vo.getProContractReceiveMny(), managementExpense)));
            vo.setProAmerce(BigDecimalUtil.nullToZero(BigDecimalUtil.toBigDecimal(dataMap.get("amerce"))));
            vo.setProTransferSurplus(BigDecimalUtil.nullToZero(BigDecimalUtil.toBigDecimal(dataMap.get("prjAdvancePaymentBalance"))));
            vo.setProLoanBalance(BigDecimalUtil.nullToZero(BigDecimalUtil.toBigDecimal(dataMap.get("loanBalance"))));
            vo.setProLoanInterest(BigDecimalUtil.nullToZero(BigDecimalUtil.toBigDecimal(dataMap.get("loadInterests"))));
        } else {
            this.logger.error("\u67e5\u8be2\u9879\u76ee\u98ce\u9669\u4fdd\u8bc1\u91d1\u7ed3\u4f59\u3001\u5176\u4ed6\u8d39\u7528\u8fd4\u8fd8\u7b49\u91d1\u989d\u5931\u8d25(from prjfinance)\uff1a" + resPrjFinanceData.getMsg());
        }
        ProjectFinancePayVO projectApplyPayInfo = ((PayContractMapper)this.baseMapper).getProjectApplyPayInfo(projectId);
        if (null != projectApplyPayInfo) {
            vo.setProApplyUnpayMny(BigDecimalUtil.nullToZero(BigDecimalUtil.safeSub(projectApplyPayInfo.getSumApplyMny(), projectApplyPayInfo.getSumPayMny())));
            vo.setProPayMny(projectApplyPayInfo.getSumPayMny());
        }
        Map<String, Object> resMap = this.loadReimburseService.countAmt(InvocationInfoProxy.getTenantid(), Collections.singletonList(projectId));
        BigDecimal amt = BigDecimalUtil.toBigDecimal(resMap.get("amt"));
        vo.setProPayMny(BigDecimalUtil.nullToZero(BigDecimalUtil.safeAdd(vo.getProPayMny(), amt)));
        BigDecimal subMny = BigDecimalUtil.safeSub(vo.getProReceiveMny(), vo.getProPayMny(), vo.getProCostListSurplus(), vo.getProManageFee(), vo.getProAmerce(), vo.getProRiskMarginSurplus(), vo.getProLoanInterest(), vo.getProPettyCash(), vo.getProOtherFeeDeduct());
        BigDecimal proSurPlusMny = BigDecimalUtil.safeAdd(subMny, vo.getProTransferSurplus(), vo.getProOtherFeeBack(), vo.getProLoanBalance());
        vo.setProSurplusMny(BigDecimalUtil.nullToZero(proSurPlusMny));
        vo.setProSurplusApplyMny(BigDecimalUtil.scaleTwo(BigDecimalUtil.nullToZero(BigDecimalUtil.safeSub(vo.getProSurplusMny(), vo.getProApplyUnpayMny()))));
        return vo;
    }

    @Override
    public List<ProjectReimburseVO> getProjectReimburse(List<Long> projectIds) {
        return ((PayContractMapper)this.baseMapper).getProjectReimburse(projectIds);
    }

    @Override
    public List<FinanceWarnV0> getProjectPayMny() {
        return ((PayContractMapper)this.baseMapper).getProjectPayMny();
    }

    @Override
    public JSONObject queryLaborSalaryApplyPageJson(QueryParam param, boolean b) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("applyUserName");
        fuzzyFields.add("receiveUnitName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContext = this.sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)authOrgIds)) {
            CommonResponse authResponse = this.orgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList()));
            param.getParams().put("orgId", new Parameter("in", ((List)authResponse.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        Parameter parameterFlag = (Parameter)param.getParams().get("contractFlag");
        param.getParams().remove("contractFlag");
        String flag = parameterFlag == null ? null : parameterFlag.getValue().toString();
        Page pages = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = PayContractServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<Map<String, Object>> list = ((PayContractMapper)this.baseMapper).queryLaborSalaryApplyPageList(pages, wrapper, flag);
        SimpleDateFormat applyTimeFmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        list.forEach(item -> {
            Object applyTime = item.get("applyTime");
            if (applyTime != null) {
                if (applyTime instanceof Timestamp) {
                    String applyTimeStr = applyTimeFmt.format(applyTime);
                    item.put("applyTime", applyTimeStr);
                } else {
                    try {
                        Date date = applyTimeFmt.parse(applyTime.toString());
                        item.put("applyTime", date);
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        JSONObject page = new JSONObject();
        page.put("records", list);
        page.put("total", (Object)pages.getTotal());
        page.put("current", (Object)pages.getCurrent());
        page.put("size", (Object)pages.getSize());
        page.put("pages", (Object)pages.getPages());
        return page;
    }

    @Override
    public List<PayContractVO> queryLaborSalaryApplyExportList(QueryParam param) {
        param.setPageIndex(0);
        param.setPageSize(-1);
        List resVos = (List)this.queryLaborSalaryApplyPageJson(param, false).get((Object)"records");
        JSONObject jsonObject = this.queryLaborSalaryApplyPageJson(param, false);
        if (!resVos.isEmpty()) {
            List recods = (List)jsonObject.get((Object)"records");
            List ds = BeanMapper.mapList((Iterable)recods, PayContractVO.class);
            for (int i = 0; i < ds.size(); ++i) {
                PayContractVO vo = (PayContractVO)ds.get(i);
                vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
            }
            resVos = ds;
        }
        return resVos;
    }

    @Override
    public PayContractVO insertOrUpdate(PayContractVO vo) {
        CommonResponse<String> usedMnyRes;
        ParamRegisterSetVO paramRegisterSetVO;
        String valueData;
        PayContractEntity entity = (PayContractEntity)((Object)BeanMapper.map((Object)vo, PayContractEntity.class));
        CommonResponse byCode = this.paramConfigApi.getByCode(PAY_CONTRACT_ONE_LIMIT_CODE);
        if (byCode.isSuccess() && null != byCode.getData() && "\u5426".equals((valueData = (paramRegisterSetVO = (ParamRegisterSetVO)byCode.getData()).getValueData()).trim()) && !BillStateEnum.COMMITED_STATE.getBillStateCode().equals(vo.getBillState()) && !BillStateEnum.PASSED_STATE.getBillStateCode().equals(vo.getBillState())) {
            this.validateBeforeSave(entity);
        }
        String billTypeCode = BillTypeCodeEnum.getContractBillTypeCode((Long)vo.getContractType());
        if (!ValidateUtil.validateUpstreamVersion((String)String.valueOf(vo.getContractId()), (String)billTypeCode, (Integer)vo.getContractVersion()).booleanValue()) {
            throw new BusinessException("\u8be5\u5408\u540c\u5df2\u88ab\u66f4\u65b0\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u505a\uff01");
        }
        List voList = vo.getInvoiceVOList();
        if (CollectionUtils.isNotEmpty((Collection)voList)) {
            for (PayInvoiceVO invoiceVO : voList) {
                if (ValidateUtil.validateUpstreamVersion((String)String.valueOf(invoiceVO.getInvoiceId()), (String)BillTypeCodeEnum.\u7a0e\u52a1\u6536\u7968.getBillTypeCode(), (Integer)invoiceVO.getInvoiceVersion()).booleanValue()) continue;
                throw new BusinessException("\u53d1\u7968\u5df2\u88ab\u66f4\u65b0\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u505a\uff01");
            }
        }
        if (!(usedMnyRes = this.invoiceService.updateInvoiceUsedMnyBySave(voList, entity.getId())).isSuccess()) {
            throw new BusinessException(usedMnyRes.getMsg());
        }
        this.autoSetBillCode(entity);
        entity.setReceiveInvoiceFlag(ReceiveInvoiceFlagConst.NO);
        super.saveOrUpdateNoES((Object)entity);
        Long id = entity.getId();
        List invoiceVOList = this.updateInvoiceVOS(vo, id);
        List<PayContractSettleVO> settleVOList = this.updateSettleVOS(vo, id);
        List<PayContractDeductionVO> payContractDeductionVOS = this.updateDeductionVOS(vo, id);
        List<PayContractSalaryVO> payContractSalaryVOS = this.updateSalary(vo, id);
        List<PayContractSummaryVO> payContractSummaryVOS = this.updateSummary(vo, id);
        if (entity.getId() != null) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"payapply_id", (Object)entity.getId());
            invoiceVOList = this.invoiceService.list((Wrapper)wrapper);
        }
        PayContractEntity payContractEntity = (PayContractEntity)((Object)super.getById((Serializable)id));
        PayContractVO backVO = (PayContractVO)BeanMapper.map((Object)((Object)payContractEntity), PayContractVO.class);
        backVO.setInvoiceVOList(BeanMapper.mapList(invoiceVOList, PayInvoiceVO.class));
        backVO.setSettleVOList(settleVOList);
        backVO.setDeductionVOList(payContractDeductionVOS);
        backVO.setContractSalaryList(payContractSalaryVOS);
        backVO.setContractSummaryList(payContractSummaryVOS);
        ProjectFinanceVO v = (ProjectFinanceVO)BeanMapper.map((Object)((Object)payContractEntity), ProjectFinanceVO.class);
        backVO.setProjectFinanceVO(v);
        return backVO;
    }

    @Override
    public PayContractVO queryDetail(Long id) {
        PayContractEntity entity = (PayContractEntity)((Object)this.selectById(id));
        PayContractVO vo = (PayContractVO)BeanMapper.map((Object)((Object)entity), PayContractVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("payapplyId", new Parameter("eq", (Object)vo.getId()));
        queryParam.getOrderMap().put("createTime", "desc");
        List invoiceEntityList = this.invoiceService.queryList(queryParam, false);
        vo.setInvoiceVOList(BeanMapper.mapList((Iterable)invoiceEntityList, PayInvoiceVO.class));
        List settleEntityList = this.settleService.queryList(queryParam, false);
        vo.setSettleVOList(BeanMapper.mapList((Iterable)settleEntityList, PayContractSettleVO.class));
        List payContractDeductionEntities = this.contractDeductionService.queryList(queryParam, false);
        vo.setDeductionVOList(BeanMapper.mapList((Iterable)payContractDeductionEntities, PayContractDeductionVO.class));
        List salaryEntityList = this.payContractSalaryService.queryList(queryParam, false);
        vo.setContractSalaryList(BeanMapper.mapList((Iterable)salaryEntityList, PayContractSalaryVO.class));
        List summaryEntityList = this.payContractSummaryService.queryList(queryParam, false);
        vo.setContractSummaryList(BeanMapper.mapList((Iterable)summaryEntityList, PayContractSummaryVO.class));
        List recordList = this.payRecordService.queryList(queryParam);
        vo.setRecordList(BeanMapper.mapList((Iterable)recordList, PayRecordVO.class));
        vo.setProjectFinanceVO((ProjectFinanceVO)BeanMapper.map((Object)vo, ProjectFinanceVO.class));
        if (null != vo.getPayMny()) {
            vo.setPayMnyCn(NumberToCN.number2CN(vo.getPayMny()));
        }
        vo.setEndthisSumApplyMny(MathUtil.safeAdd((BigDecimal)vo.getApplyMny(), (BigDecimal)vo.getSumApplyMny()));
        return vo;
    }

    @Override
    public List<PayContractVO> queryExportList(QueryParam param) {
        param.setPageIndex(0);
        param.setPageSize(-1);
        List resVos = (List)this.queryPageJson(param, false).get((Object)"records");
        if (!resVos.isEmpty()) {
            for (int i = 0; i < resVos.size(); ++i) {
                PayContractVO vo = (PayContractVO)resVos.get(i);
                if (vo.getSalaryFlag() != null && vo.getSalaryFlag() == 1) {
                    vo.setFeeTypeName("\u5de5\u4eba\u5de5\u8d44-" + vo.getApplyTypeName());
                } else {
                    ConstantTypeEnum enumByCode = ConstantTypeEnum.getEnumByCode(vo.getFeeType());
                    vo.setFeeTypeName(enumByCode != null ? enumByCode.getName() : null);
                }
                vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
            }
        }
        return resVos;
    }

    @Override
    public String delete(List<Long> ids) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("id", new Parameter("in", ids));
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List entityList = super.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)entityList)) {
            List<Long> dedIds;
            LambdaQueryWrapper removeWrapper = new LambdaQueryWrapper();
            removeWrapper.in(PayContractSalaryEntity::getPayapplyId, ids);
            List removeSalaryList = this.payContractSalaryService.list((Wrapper)removeWrapper);
            super.removeByIds(ids, false);
            this.invoiceService.updateInvoiceUsedMnyByDel(ids);
            this.invoiceService.remove((Wrapper)new QueryWrapper().in((Object)"payapply_id", ids), false);
            this.settleService.remove((Wrapper)new QueryWrapper().in((Object)"payapply_id", ids), false);
            this.payContractSalaryService.remove((Wrapper)new QueryWrapper().in((Object)"payapply_id", ids), false);
            this.payContractSummaryService.remove((Wrapper)new QueryWrapper().in((Object)"payapply_id", ids), false);
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.in((Object)"payapply_id", ids);
            List list = this.contractDeductionService.list((Wrapper)wrapper);
            if (CollectionUtils.isNotEmpty((Collection)list) && this.updateDeductionUseFlag(dedIds = list.stream().map(PayContractDeductionEntity::getDeductionId).collect(Collectors.toList()), 0)) {
                this.contractDeductionService.remove((Wrapper)new QueryWrapper().in((Object)"payapply_id", ids), false);
            }
            this.writeBackAlreadyApplyMny(BeanMapper.mapList((Iterable)removeSalaryList, PayContractSalaryVO.class));
        }
        return "\u5220\u9664\u6210\u529f\uff01";
    }

    private boolean updateDeductionUseFlag(List<Long> dedIds, int flag) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(BaseEntity::getId, dedIds);
        updateWrapper.set(DeductionEntity::getIsUse, (Object)flag);
        return this.deductionService.update((Wrapper)updateWrapper);
    }

    @Override
    public JSONObject queryPageJson(QueryParam param, boolean isEs) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("receiveUnitName");
        fuzzyFields.add("applyUserName");
        fuzzyFields.add("accountName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("payUnitName");
        fuzzyFields.add("payReason");
        fuzzyFields.add("applyMny");
        fuzzyFields.add("contractCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContext = this.sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        this.logger.info(">>>>>>>>>>>>>>>>>>>>>>1authOrgIds:{}", (Object)authOrgIds);
        if (StringUtils.isNotEmpty((String)authOrgIds)) {
            CommonResponse authResponse = this.orgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList()));
            this.logger.info(">>>>>>>>>>>>>>>>>>>>>>2authOrgIds:{}, authResponse.getData():{}", (Object)authOrgIds, authResponse.getData() == null ? null : Integer.valueOf(((List)authResponse.getData()).size()));
            param.getParams().put("orgId", new Parameter("in", ((List)authResponse.getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        } else {
            param.getParams().put("orgId", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        }
        if (StringUtils.isNotEmpty((String)param.getBillTypeId()) && this.viewSelf(param.getBillTypeId()).booleanValue() && param.getParams().get("createUserCode") == null && param.getParams().get("create_user_code") == null) {
            param.getParams().put("createUserCode", new Parameter("eq", (Object)InvocationInfoProxy.getUsercode()));
        }
        CommonResponse roleList = this.iRoleApi.queryRoleByUserId(userContext.getUserId());
        List roleCodeList = ((List)roleList.getData()).stream().map(RoleVO::getCode).collect(Collectors.toList());
        String deptName = userContext.getDeptName();
        if (roleCodeList.contains("FKSQ3")) {
            param.getParams().put("contractType", new Parameter("in", Arrays.asList(1, 4)));
        } else if (roleCodeList.contains("FKSQ1") || roleCodeList.contains("FKSQ2") || "\u5546\u52a1\u90e8".equals(deptName)) {
            param.getParams().put("contractType", new Parameter("eq", (Object)1));
        } else if ("\u91c7\u8d2d\u90e8".equals(deptName)) {
            param.getParams().put("contractType", new Parameter("eq", (Object)4));
        } else {
            param.getParams().put("contractType", new Parameter("eq", (Object)99));
        }
        Parameter parameterFlag = (Parameter)param.getParams().get("relationInvoiceFlag");
        param.getParams().remove("relationInvoiceFlag");
        String flag = parameterFlag == null ? null : parameterFlag.getValue().toString();
        Page pages = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = PayContractServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<PayContractVO> list = ((PayContractMapper)this.baseMapper).queryPageList(pages, wrapper, flag);
        list.forEach(vo -> {
            if (null != vo.getApplyMny()) {
                vo.setUnpaidMny(vo.getApplyMny().subtract(vo.getPayMny() == null ? BigDecimal.ZERO : vo.getPayMny()));
            }
            vo.setApplyHasPenaltyMny(ComputeUtil.safeAdd((BigDecimal)vo.getApplyMny(), (BigDecimal)vo.getCurPenaltyMoney()));
        });
        JSONObject page = new JSONObject();
        page.put("records", list);
        page.put("total", (Object)pages.getTotal());
        page.put("current", (Object)pages.getCurrent());
        page.put("size", (Object)pages.getSize());
        page.put("pages", (Object)pages.getPages());
        return page;
    }

    @Override
    public JSONObject querySettleRefer(QueryParam param, Integer contractType) {
        CommonResponse apiContract = null;
        if (contractType != null) {
            switch (contractType) {
                case 1: {
                    break;
                }
                case 2: {
                    apiContract = this.equipmentApi.getContractSettle(param);
                    break;
                }
                case 3: {
                    apiContract = this.equipmentApi.getRentSettle(param);
                    break;
                }
                case 4: {
                    break;
                }
            }
        }
        JSONObject page = new JSONObject();
        if (apiContract.isSuccess()) {
            page = (JSONObject)apiContract.getData();
            ((JSONObject)apiContract.getData()).get((Object)"records");
            ObjectMapper mapper = new ObjectMapper();
            List settleVOList = (List)mapper.convertValue(((JSONObject)apiContract.getData()).get((Object)"records"), (TypeReference)new TypeReference<List<PubContractSettleVO>>(){});
            if (!settleVOList.isEmpty()) {
                PubContractSettleVO vo;
                Map settleMap = settleVOList.stream().collect(Collectors.toMap(BaseVO::getId, Function.identity()));
                List ids = settleVOList.stream().map(BaseVO::getId).collect(Collectors.toList());
                QueryWrapper wrapper = (QueryWrapper)new QueryWrapper().in((Object)"settle_id", ids);
                wrapper.last("and payapply_id in (select id from ejc_finance_pay_contract where dr = 0 and bill_state in (1,3))");
                List entityList = this.settleService.list((Wrapper)wrapper);
                for (PayContractSettleEntity entity : entityList) {
                    if (!settleMap.containsKey(entity.getSettleId())) continue;
                    vo = (PubContractSettleVO)settleMap.get(entity.getSettleId());
                    vo.setSumApplyMny(MathUtil.safeAdd((BigDecimal)vo.getSumApplyMny(), (BigDecimal)entity.getBodyApplyMny()));
                }
                for (Long id : settleMap.keySet()) {
                    vo = (PubContractSettleVO)settleMap.get(id);
                    vo.setSurplusApplyMny(MathUtil.safeSub((BigDecimal)vo.getSettleMny(), (BigDecimal)vo.getSumApplyMny()));
                    if (vo.getSurplusApplyMny().compareTo(new BigDecimal(0)) != 0) continue;
                    settleMap.remove(id);
                }
                page.put("records", new ArrayList(settleMap.values()));
            }
        } else {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        return page;
    }

    @Override
    public SumPayMnyVO getSumPayMny(Long contractId, Long orgId, Boolean applyMnyContainFree) {
        boolean isPrePayPassed = true;
        CommonResponse byCode = this.paramConfigApi.getByCode(PREPAY_PARAM);
        if (byCode.isSuccess() && null != byCode.getData() && "2".equals(((ParamRegisterSetVO)byCode.getData()).getValueData())) {
            isPrePayPassed = false;
        }
        QueryParam param = new QueryParam();
        param.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        QueryWrapper queryWrapper = new QueryWrapper();
        StringBuffer selectSql = new StringBuffer();
        selectSql.append(" SUM( IF ( pay_status = 2 AND bill_state IN ( 1, 3 ) and org_id = '" + orgId + "', pay_mny, 0 ) ) AS sumPayMny, ");
        if (isPrePayPassed) {
            selectSql.append(" SUM( IF ( pay_status = 2 AND fee_type = 1 AND bill_state IN ( 1, 3 ), pay_mny, 0 ) ) AS sumPrePayMny,");
        } else {
            selectSql.append(" SUM( IF ( fee_type = 1 , apply_mny, 0 ) ) AS sumPrePayMny,");
        }
        if (applyMnyContainFree != null && applyMnyContainFree.booleanValue()) {
            selectSql.append(" SUM( IF(org_id = '" + orgId + "',IFNULL( apply_mny, 0 ),0) + IFNULL( cur_penalty_money, 0 ) ) AS sumApplyMny ");
        } else {
            selectSql.append(" SUM( IF ( bill_state IN ( 1, 3 ) and org_id = '" + orgId + "' , IFNULL( apply_mny, 0 ) + IFNULL( cur_penalty_money, 0 ), 0 ) ) AS sumApplyMny ");
        }
        queryWrapper.select(new String[]{selectSql.toString()});
        queryWrapper.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        queryWrapper.eq((Object)"contract_id", (Object)contractId);
        Map map = this.getMap((Wrapper)queryWrapper);
        SumPayMnyVO vo = new SumPayMnyVO();
        vo.setContractId(contractId);
        vo.setOrgId(orgId);
        if (MapUtils.isEmpty((Map)map)) {
            vo.setSumApplyMny(BigDecimal.ZERO);
            vo.setSumPrePayMny(BigDecimal.ZERO);
            vo.setSumPayMny(BigDecimal.ZERO);
        } else {
            vo.setSumApplyMny(ComputeUtil.toBigDecimal(map.get("sumApplyMny")));
            vo.setSumPrePayMny(ComputeUtil.toBigDecimal(map.get("sumPrePayMny")));
            vo.setSumPayMny(ComputeUtil.toBigDecimal(map.get("sumPayMny")));
        }
        return vo;
    }

    @Override
    public SumPayMnyVO getSumPayMnyVOList(Long contractId, Long orgId) {
        QueryParam param = new QueryParam();
        param.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        if (orgId == null) {
            orgId = InvocationInfoProxy.getOrgId();
        }
        param.getParams().put("orgId", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(orgId).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        param.getOrderMap().put("createTime", "desc");
        List entityList = super.queryList(param, false);
        BigDecimal sumPayMny = null;
        BigDecimal sumApplyMny = null;
        BigDecimal sumDeductionMny = null;
        for (PayContractEntity entity : entityList) {
            if (!Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()).contains(entity.getBillState())) continue;
            sumPayMny = MathUtil.safeAdd(sumPayMny, (BigDecimal)entity.getPayMny());
            sumApplyMny = MathUtil.safeAdd(sumApplyMny, (BigDecimal)entity.getApplyMny());
            sumDeductionMny = MathUtil.safeAdd(sumDeductionMny, (BigDecimal)entity.getCurPenaltyMoney());
        }
        SumPayMnyVO vo = new SumPayMnyVO();
        vo.setContractId(contractId);
        vo.setOrgId(orgId);
        vo.setSumPayMny(sumPayMny);
        vo.setSumApplyMny(sumApplyMny);
        vo.setSumDeductionMny(sumDeductionMny);
        vo.setContractVOList(BeanMapper.mapList((Iterable)entityList, PayContractVO.class));
        return vo;
    }

    @Override
    public JSONObject queryPendingPageJson(QueryParam param, boolean isEs) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("receiveUnitName");
        fuzzyFields.add("applyUserName");
        fuzzyFields.add("accountName");
        fuzzyFields.add("payUnitName");
        fuzzyFields.add("payReason");
        fuzzyFields.add("applyMny");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        param.getComplexParams().add(ComplexParam.getApprovedComplexParam((String)"and"));
        param.getParams().put("dr", new Parameter("eq", (Object)0));
        this.transformReimburse(param);
        Page pages = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = PayContractServiceImpl.changeToQueryWrapper((QueryParam)param);
        wrapper.and(x -> (QueryWrapper)x.last("(pay_status = 1 or IFNULL(pay_mny,0) < apply_mny) AND IFNULL(close_flag,0) = 0"));
        List<PayApplyPubVO> list = ((PayContractMapper)this.baseMapper).queryPendingList(pages, wrapper);
        Map<Long, String> defdocMap = this.feignUtil.getDefdocMap(FinancePubConsts.COST_TYPE);
        ArrayList<Long> businessIdList = new ArrayList<Long>();
        if (!list.isEmpty()) {
            for (PayApplyPubVO vo2 : list) {
                if ("\u62a5\u9500".equals(vo2.getApplyType()) && defdocMap.containsKey(vo2.getFeeTypeId())) {
                    vo2.setFeeType("\u62a5\u9500-" + defdocMap.get(vo2.getFeeTypeId()));
                }
                businessIdList.add(vo2.getId());
            }
        }
        CommonResponse customBusinessDataResponse = null;
        if (this.extFieldsMode.booleanValue() && ListUtil.isNotEmpty(businessIdList) && (customBusinessDataResponse = this.customBusinessDataService.queryCustomBusinessData(businessIdList)).isSuccess()) {
            Map customBusinessDataMap = (Map)customBusinessDataResponse.getData();
            for (PayApplyPubVO payApplyPubVO : list) {
                CustomBusinessDataVO subCustomBusinessDataVo = (CustomBusinessDataVO)customBusinessDataMap.get(payApplyPubVO.getId());
                if (subCustomBusinessDataVo == null) continue;
                JSONObject subCustomField = JSONObject.parseObject((String)subCustomBusinessDataVo.getBusinessData());
                payApplyPubVO.setCustomField((Map)subCustomField);
            }
        }
        list.forEach(vo -> {
            if (null != vo.getApplyMny()) {
                vo.setUnpaidMny(vo.getApplyMny().subtract(vo.getPayMny() == null ? BigDecimal.ZERO : vo.getPayMny()));
            }
        });
        JSONObject page = new JSONObject();
        page.put("records", list);
        page.put("total", (Object)pages.getTotal());
        page.put("current", (Object)pages.getCurrent());
        page.put("size", (Object)pages.getSize());
        page.put("pages", (Object)pages.getPages());
        return page;
    }

    @Override
    public JSONObject queryAllList(QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("receiveUnitName");
        fuzzyFields.add("applyUserName");
        fuzzyFields.add("accountName");
        fuzzyFields.add("payUnitName");
        fuzzyFields.add("payReason");
        fuzzyFields.add("applyMny");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        param.getComplexParams().add(ComplexParam.getApprovedComplexParam((String)"and"));
        param.getParams().put("dr", new Parameter("eq", (Object)0));
        this.transformReimburse(param);
        Page pages = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = PayContractServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<PayApplyPubVO> list = ((PayContractMapper)this.baseMapper).queryPendingList(pages, wrapper);
        Map<Long, String> defdocMap = this.feignUtil.getDefdocMap(FinancePubConsts.COST_TYPE);
        if (!list.isEmpty()) {
            for (PayApplyPubVO vo2 : list) {
                if (!"\u62a5\u9500".equals(vo2.getApplyType()) || !defdocMap.containsKey(vo2.getFeeTypeId())) continue;
                vo2.setFeeType("\u62a5\u9500-" + defdocMap.get(vo2.getFeeTypeId()));
            }
        }
        list.forEach(vo -> {
            if (null != vo.getApplyMny()) {
                vo.setUnpaidMny(vo.getApplyMny().subtract(vo.getPayMny() == null ? BigDecimal.ZERO : vo.getPayMny()));
            }
        });
        JSONObject page = new JSONObject();
        page.put("records", list);
        page.put("total", (Object)pages.getTotal());
        page.put("current", (Object)pages.getCurrent());
        page.put("size", (Object)pages.getSize());
        page.put("pages", (Object)pages.getPages());
        return page;
    }

    @Override
    public List<PayApplyPubVO> queryExportPendingList(QueryParam param) {
        param.setPageIndex(0);
        param.setPageSize(-1);
        List records = (List)this.queryPendingPageJson(param, false).get((Object)"records");
        return records;
    }

    @Override
    public String batchConfirm(List<PayApplyPubVO> vos) {
        for (PayApplyPubVO vo : vos) {
            BigDecimal surplusPayMny;
            Object data;
            PayRecordVO record = new PayRecordVO();
            if ("\u5408\u540c\u4ed8\u6b3e".equals(vo.getApplyType())) {
                data = this.queryDetail(vo.getId());
                record.setBillCode(data.getBillCode());
                record.setPayapplyId(data.getId());
                record.setContractId(data.getContractId());
                record.setContractName(data.getContractName());
                record.setContractType(data.getContractType());
                record.setProjectId(data.getProjectId());
                record.setProjectName(data.getProjectName());
                record.setOrgId(data.getOrgId());
                record.setOrgName(data.getOrgName());
                record.setApplyUserId(data.getApplyUserId());
                record.setApplyUserName(data.getApplyUserName());
                record.setApplyTime(data.getApplyTime());
                record.setApplyMny(data.getApplyMny());
                surplusPayMny = MathUtil.safeSub((BigDecimal)data.getApplyMny(), (BigDecimal)data.getPayMny());
                record.setThisPayMny(surplusPayMny);
                record.setReceiveUnitId(data.getReceiveUnitId());
                record.setReceiveUnitName(data.getReceiveUnitName());
                record.setApplyType("\u5408\u540c\u4ed8\u6b3e");
                record.setFeeType(data.getFeeType());
                record.setEmployeeId(vo.getEmployeeId());
                record.setEmployeeName(vo.getEmployeeName());
                record.setConfirmTime(vo.getConfirmTime());
                record.setAccountId(vo.getAccountId());
                record.setAccountName(vo.getAccountName());
                record.setAccountNum(vo.getAccountNum());
                record.setAccountBank(vo.getAccountBank());
                record.setPayWay(vo.getPayWay());
                record.setPayWayName(vo.getPayWayName());
                record.setMemo(vo.getMemo());
                this.payRecordService.insertOrUpdate(record, true);
            }
            if ("\u5de5\u4eba\u5de5\u8d44-\u6709\u5408\u540c".equals(vo.getApplyType())) {
                data = this.queryDetail(vo.getId());
                record.setBillCode(data.getBillCode());
                record.setPayapplyId(data.getId());
                record.setContractId(data.getContractId());
                record.setContractName(data.getContractName());
                record.setContractType(data.getContractType());
                record.setProjectId(data.getProjectId());
                record.setProjectName(data.getProjectName());
                record.setOrgId(data.getOrgId());
                record.setOrgName(data.getOrgName());
                record.setApplyUserId(data.getApplyUserId());
                record.setApplyUserName(data.getApplyUserName());
                record.setApplyTime(data.getApplyTime());
                record.setApplyMny(data.getApplyMny());
                surplusPayMny = MathUtil.safeSub((BigDecimal)data.getApplyMny(), (BigDecimal)data.getPayMny());
                record.setThisPayMny(surplusPayMny);
                record.setReceiveUnitId(data.getReceiveUnitId());
                record.setReceiveUnitName(data.getReceiveUnitName());
                record.setApplyType(vo.getApplyType());
                record.setFeeType(data.getFeeType());
                record.setEmployeeId(vo.getEmployeeId());
                record.setEmployeeName(vo.getEmployeeName());
                record.setConfirmTime(vo.getConfirmTime());
                record.setAccountId(vo.getAccountId());
                record.setAccountName(vo.getAccountName());
                record.setAccountNum(vo.getAccountNum());
                record.setAccountBank(vo.getAccountBank());
                record.setPayWay(vo.getPayWay());
                record.setPayWayName(vo.getPayWayName());
                record.setMemo(vo.getMemo());
                this.payRecordService.insertOrUpdate(record, true);
            }
            if ("\u5de5\u4eba\u5de5\u8d44-\u65e0\u5408\u540c".equals(vo.getApplyType())) {
                data = this.sporadicService.queryDetail(vo.getId());
                record.setBillCode(data.getBillCode());
                record.setPayapplyId(data.getId());
                record.setProjectId(data.getProjectId());
                record.setProjectName(data.getProjectName());
                record.setOrgId(data.getOrgId());
                record.setOrgName(data.getOrgName());
                record.setApplyUserId(data.getApplyUserId());
                record.setApplyUserName(data.getApplyUserName());
                record.setApplyTime(data.getApplyTime());
                record.setApplyMny(data.getApplyMny());
                surplusPayMny = MathUtil.safeSub((BigDecimal)data.getApplyMny(), (BigDecimal)data.getPayMny());
                record.setThisPayMny(surplusPayMny);
                record.setApplyType(vo.getApplyType());
                record.setEmployeeId(vo.getEmployeeId());
                record.setEmployeeName(vo.getEmployeeName());
                record.setConfirmTime(vo.getConfirmTime());
                record.setAccountId(vo.getAccountId());
                record.setAccountName(vo.getAccountName());
                record.setAccountNum(vo.getAccountNum());
                record.setAccountBank(vo.getAccountBank());
                record.setPayWay(vo.getPayWay());
                record.setPayWayName(vo.getPayWayName());
                record.setMemo(vo.getMemo());
                this.payRecordService.insertOrUpdate(record, true);
            }
            if ("\u96f6\u661f\u91c7\u8d2d".equals(vo.getApplyType())) {
                data = this.sporadicService.queryDetail(vo.getId());
                record.setBillCode(data.getBillCode());
                record.setPayapplyId(data.getId());
                record.setProjectId(data.getProjectId());
                record.setProjectName(data.getProjectName());
                record.setOrgId(data.getOrgId());
                record.setOrgName(data.getOrgName());
                record.setApplyUserId(data.getApplyUserId());
                record.setApplyUserName(data.getApplyUserName());
                record.setApplyTime(data.getApplyTime());
                record.setApplyMny(data.getApplyMny());
                surplusPayMny = MathUtil.safeSub((BigDecimal)data.getApplyMny(), (BigDecimal)data.getPayMny());
                record.setThisPayMny(surplusPayMny);
                record.setApplyType("\u96f6\u661f\u91c7\u8d2d");
                record.setEmployeeId(vo.getEmployeeId());
                record.setEmployeeName(vo.getEmployeeName());
                record.setConfirmTime(vo.getConfirmTime());
                record.setAccountId(vo.getAccountId());
                record.setAccountName(vo.getAccountName());
                record.setAccountNum(vo.getAccountNum());
                record.setAccountBank(vo.getAccountBank());
                record.setPayWay(vo.getPayWay());
                record.setPayWayName(vo.getPayWayName());
                record.setMemo(vo.getMemo());
                this.payRecordService.insertOrUpdate(record, true);
            }
            if ("\u62a5\u9500".equals(vo.getApplyType())) {
                data = this.reimburseService.queryDetail(vo.getId());
                record.setBillCode(data.getBillCode());
                record.setPayapplyId(data.getId());
                record.setProjectId(data.getProjectId());
                record.setProjectName(data.getProjectName());
                record.setOrgId(data.getOrgId());
                record.setOrgName(data.getOrgName());
                record.setApplyUserId(data.getApplyUserId());
                record.setApplyUserName(data.getApplyUserName());
                record.setApplyTime(data.getApplyTime());
                record.setApplyMny(data.getApplyMny());
                surplusPayMny = MathUtil.safeSub((BigDecimal)data.getApplyMny(), (BigDecimal)data.getPayMny());
                record.setThisPayMny(surplusPayMny);
                record.setApplyType("\u62a5\u9500");
                record.setFeeType(data.getFeeType());
                record.setEmployeeId(vo.getEmployeeId());
                record.setEmployeeName(vo.getEmployeeName());
                record.setConfirmTime(vo.getConfirmTime());
                record.setAccountId(vo.getAccountId());
                record.setAccountName(vo.getAccountName());
                record.setAccountNum(vo.getAccountNum());
                record.setAccountBank(vo.getAccountBank());
                record.setPayWay(vo.getPayWay());
                record.setPayWayName(vo.getPayWayName());
                record.setMemo(vo.getMemo());
                this.payRecordService.insertOrUpdate(record, true);
            }
            if ("\u62bc\u91d1".equals(vo.getApplyType())) {
                data = this.foregiftService.queryDetail(vo.getId());
                record.setBillCode(data.getBillCode());
                record.setPayapplyId(data.getId());
                record.setContractId(data.getContractId());
                record.setContractName(data.getContractName());
                record.setContractType(data.getContractType());
                record.setProjectId(data.getProjectId());
                record.setProjectName(data.getProjectName());
                record.setOrgId(data.getOrgId());
                record.setOrgName(data.getOrgName());
                record.setApplyUserId(data.getApplyUserId());
                record.setApplyUserName(data.getApplyUserName());
                record.setApplyTime(data.getApplyTime());
                record.setApplyMny(data.getApplyMny());
                surplusPayMny = MathUtil.safeSub((BigDecimal)data.getApplyMny(), (BigDecimal)data.getPayMny());
                record.setThisPayMny(surplusPayMny);
                record.setReceiveUnitId(data.getReceiveUnitId());
                record.setReceiveUnitName(data.getReceiveUnitName());
                record.setApplyType("\u62bc\u91d1");
                record.setEmployeeId(vo.getEmployeeId());
                record.setEmployeeName(vo.getEmployeeName());
                record.setConfirmTime(vo.getConfirmTime());
                record.setAccountId(vo.getAccountId());
                record.setAccountName(vo.getAccountName());
                record.setAccountNum(vo.getAccountNum());
                record.setAccountBank(vo.getAccountBank());
                record.setPayWay(vo.getPayWay());
                record.setPayWayName(vo.getPayWayName());
                record.setMemo(vo.getMemo());
                this.payRecordService.insertOrUpdate(record, true);
            }
            if (!"\u5907\u7528\u91d1".equals(vo.getApplyType())) continue;
            data = (LoadApplyEntity)((Object)this.loadApplyService.selectById(vo.getId()));
            record.setBillCode(((LoadApplyEntity)((Object)data)).getBillCode());
            record.setPayapplyId(data.getId());
            record.setProjectId(((LoadApplyEntity)((Object)data)).getProjectId());
            record.setProjectName(((LoadApplyEntity)((Object)data)).getProjectName());
            record.setOrgId(((LoadApplyEntity)((Object)data)).getOrgId());
            record.setOrgName(((LoadApplyEntity)((Object)data)).getOrgName());
            record.setApplyUserId(((LoadApplyEntity)((Object)data)).getApplyEmployeeId());
            record.setApplyUserName(((LoadApplyEntity)((Object)data)).getApplyEmployeeName());
            record.setApplyTime(((LoadApplyEntity)((Object)data)).getApplyTime());
            record.setApplyMny(((LoadApplyEntity)((Object)data)).getApplyMny());
            surplusPayMny = MathUtil.safeSub((BigDecimal)((LoadApplyEntity)((Object)data)).getApplyMny(), (BigDecimal)((LoadApplyEntity)((Object)data)).getPayMny());
            record.setThisPayMny(surplusPayMny);
            record.setApplyType("\u5907\u7528\u91d1");
            record.setEmployeeId(vo.getEmployeeId());
            record.setEmployeeName(vo.getEmployeeName());
            record.setConfirmTime(vo.getConfirmTime());
            record.setAccountId(vo.getAccountId());
            record.setAccountName(vo.getAccountName());
            record.setAccountNum(vo.getAccountNum());
            record.setAccountBank(vo.getAccountBank());
            record.setPayWay(vo.getPayWay());
            record.setPayWayName(vo.getPayWayName());
            record.setMemo(vo.getMemo());
            this.payRecordService.insertOrUpdate(record, true);
        }
        return "\u6279\u91cf\u652f\u4ed8\u6210\u529f\uff01";
    }

    @Override
    public ManageDetailVO getManageDetail(Long projectId) {
        QueryParam param = new QueryParam();
        param.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        param.getComplexParams().add(ComplexParam.getApprovedComplexParam((String)"and"));
        List receiveList = this.receiveService.queryList(param, false);
        BigDecimal sumReceiveMny = null;
        for (ReceiveEntity receive : receiveList) {
            sumReceiveMny = MathUtil.safeAdd(sumReceiveMny, (BigDecimal)receive.getReceiveMny());
        }
        List contractList = super.queryList(param, false);
        BigDecimal sumPayMny = null;
        for (PayContractEntity contract : contractList) {
            sumPayMny = MathUtil.safeAdd(sumPayMny, (BigDecimal)contract.getPayMny());
        }
        BigDecimal manageFeeRate = null;
        BigDecimal manageFee = null;
        CommonResponse incomeContract = this.incomeApi.searchContract(projectId);
        if (incomeContract.isSuccess() && incomeContract.getData() != null) {
            manageFeeRate = ((ContractVo)incomeContract.getData()).getManageChargeRate();
            manageFee = MathUtil.safeMultiply((BigDecimal)sumReceiveMny, (BigDecimal)MathUtil.safeDiv((BigDecimal)manageFeeRate, (BigDecimal)new BigDecimal(100)));
        }
        BigDecimal surplusPayMny = MathUtil.safeSub((BigDecimal)MathUtil.safeSub((BigDecimal)sumReceiveMny, manageFee), (BigDecimal)sumPayMny);
        ManageDetailVO vo = new ManageDetailVO();
        vo.setProjectId(projectId);
        vo.setSumReceiveMny(sumReceiveMny);
        vo.setManageFeeRate(manageFeeRate);
        vo.setManageFee(manageFee);
        vo.setSumPayMny(sumPayMny);
        vo.setSurplusPayMny(surplusPayMny);
        return vo;
    }

    @Override
    public SumMnyStatisticVO getStatisticsMny() {
        QueryParam param = new QueryParam();
        List orgIds = ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        param.getParams().put("orgId", new Parameter("in", orgIds));
        param.getComplexParams().add(ComplexParam.getApprovedComplexParam((String)"and"));
        List contractList = super.queryList(param, false);
        List sporadicList = this.sporadicService.queryList(param, false);
        List reimburseList = this.reimburseService.queryList(param, false);
        List foregiftList = this.foregiftService.queryList(param, false);
        BigDecimal sumApplyMny = null;
        BigDecimal sumPayMny = null;
        BigDecimal sumContractPayMny = null;
        BigDecimal sumSporadicPayMny = null;
        BigDecimal sumReimbursePayMny = null;
        BigDecimal sumForegiftPayMny = null;
        for (PayContractEntity contract : contractList) {
            sumApplyMny = MathUtil.safeAdd(sumApplyMny, (BigDecimal)contract.getApplyMny());
            sumPayMny = MathUtil.safeAdd(sumPayMny, (BigDecimal)contract.getPayMny());
            sumContractPayMny = MathUtil.safeAdd(sumContractPayMny, (BigDecimal)contract.getPayMny());
        }
        for (PaySporadicEntity sporadic : sporadicList) {
            sumApplyMny = MathUtil.safeAdd((BigDecimal)sumApplyMny, (BigDecimal)sporadic.getApplyMny());
            sumPayMny = MathUtil.safeAdd((BigDecimal)sumPayMny, (BigDecimal)sporadic.getPayMny());
            sumSporadicPayMny = MathUtil.safeAdd(sumSporadicPayMny, (BigDecimal)sporadic.getPayMny());
        }
        for (PayReimburseEntity reimburse : reimburseList) {
            sumApplyMny = MathUtil.safeAdd((BigDecimal)sumApplyMny, (BigDecimal)reimburse.getApplyMny());
            sumPayMny = MathUtil.safeAdd((BigDecimal)sumPayMny, (BigDecimal)reimburse.getPayMny());
            sumReimbursePayMny = MathUtil.safeAdd(sumReimbursePayMny, (BigDecimal)reimburse.getPayMny());
        }
        for (PayForegiftEntity foregift : foregiftList) {
            sumApplyMny = MathUtil.safeAdd((BigDecimal)sumApplyMny, (BigDecimal)foregift.getApplyMny());
            sumPayMny = MathUtil.safeAdd((BigDecimal)sumPayMny, (BigDecimal)foregift.getPayMny());
            sumForegiftPayMny = MathUtil.safeAdd(sumForegiftPayMny, (BigDecimal)foregift.getPayMny());
        }
        List payapplyIds = foregiftList.stream().map(BaseEntity::getId).collect(Collectors.toList());
        BigDecimal sumReturnMny = null;
        BigDecimal sumPlanMny = null;
        if (!payapplyIds.isEmpty()) {
            List recordList = this.recordService.list((Wrapper)new QueryWrapper().in((Object)"payapply_id", payapplyIds));
            for (PayForegiftRecordEntity record : recordList) {
                sumReturnMny = MathUtil.safeAdd(sumReturnMny, (BigDecimal)record.getReturnMny());
            }
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.in((Object)"payapply_id", payapplyIds);
            wrapper.between((Object)"plan_time", (Object)PayContractServiceImpl.getTime("min"), (Object)PayContractServiceImpl.getTime("max"));
            List planList = this.planService.list((Wrapper)wrapper);
            for (PayForegiftPlanEntity plan : planList) {
                sumPlanMny = MathUtil.safeAdd(sumPlanMny, (BigDecimal)plan.getPlanMny());
            }
        }
        BigDecimal sumUnPayMny = MathUtil.safeSub((BigDecimal)sumApplyMny, (BigDecimal)sumPayMny);
        SumMnyStatisticVO vo = new SumMnyStatisticVO();
        vo.setOrgIds(orgIds);
        vo.setSumApplyMny(sumApplyMny);
        vo.setSumPayMny(sumPayMny);
        vo.setSumUnPayMny(sumUnPayMny);
        vo.setSumContractPayMny(sumContractPayMny);
        vo.setSumSporadicPayMny(sumSporadicPayMny);
        vo.setSumReimbursePayMny(sumReimbursePayMny);
        vo.setSumForegiftPayMny(sumForegiftPayMny);
        vo.setSumReturnMny(sumReturnMny);
        vo.setSumPlanMny(sumPlanMny);
        return vo;
    }

    @Override
    public Map<String, Object> countAmt(Long tenantId, List<Long> projectIds) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select(new String[]{"ifnull(sum(pay_mny),0) as amt"});
        queryWrapper.eq((Object)"tenant_id", (Object)tenantId);
        queryWrapper.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        queryWrapper.eq((Object)"pay_type", (Object)2);
        queryWrapper.eq((Object)"pay_status", (Object)2);
        if (CollectionUtils.isNotEmpty(projectIds)) {
            queryWrapper.in((Object)"project_id", projectIds);
        }
        queryWrapper.in((Object)"bill_state", Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        List<Object> orgIds = new ArrayList();
        UserContext userContext = this.sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (StringUtils.isNotEmpty((String)authOrgIds)) {
            CommonResponse authResponse = this.orgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList()));
            orgIds = ((List)authResponse.getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        } else {
            orgIds = ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        }
        if (ListUtil.isNotEmpty(orgIds)) {
            queryWrapper.in((Object)"org_id", orgIds);
        }
        return super.getMap((Wrapper)queryWrapper);
    }

    @Override
    public List<FinanceMonthVO> getMonthInfo(Long projectId, String timeRange) {
        Date startDate = MonthUtil.monthFAdd(new Date(), -999);
        Date endDate = new Date();
        if ("3month".equals(timeRange)) {
            startDate = MonthUtil.monthFAdd(new Date(), -2);
        } else if ("6month".equals(timeRange)) {
            startDate = MonthUtil.monthFAdd(new Date(), -5);
        } else if ("thisYear".equals(timeRange)) {
            startDate = MonthUtil.monthFAdd(new Date(), -new Date().getMonth());
        } else if ("lastYear".equals(timeRange)) {
            startDate = MonthUtil.monthFAdd(new Date(), -new Date().getMonth() - 12);
            endDate = MonthUtil.monthFAdd(new Date(), -new Date().getMonth());
        }
        String startStr = DateUtil.format(startDate, "yyyy-MM-dd");
        String endStr = DateUtil.format(endDate, "yyyy-MM-dd HH:mm:ss");
        this.logger.info("startDate:" + startStr);
        this.logger.info("endDate:" + endStr);
        List<FinanceMonthVO> listReceive = ((PayContractMapper)this.baseMapper).getMonthReceiveMny(projectId, startStr, endStr);
        List<FinanceMonthVO> listOut = ((PayContractMapper)this.baseMapper).getMonthOutMny(projectId, startStr, endStr);
        Map map = listReceive.stream().collect(Collectors.toMap(FinanceMonthVO::getTerm, Function.identity()));
        if (ListUtil.isNotEmpty(listOut)) {
            listOut.forEach(financeMonthVO -> {
                if (map.containsKey(financeMonthVO.getTerm())) {
                    ((FinanceMonthVO)map.get(financeMonthVO.getTerm())).setSumOutMny(financeMonthVO.getSumOutMny());
                } else {
                    map.put(financeMonthVO.getTerm(), financeMonthVO);
                }
            });
        }
        List financeMonthVOList = map.entrySet().stream().map(et -> (FinanceMonthVO)et.getValue()).collect(Collectors.toList());
        for (FinanceMonthVO financeMonthVO2 : financeMonthVOList) {
            financeMonthVO2.setProfit(financeMonthVO2.getSumReceiveMny().subtract(financeMonthVO2.getSumOutMny()));
        }
        List bodys = financeMonthVOList.stream().filter(s -> !s.getSumOutMny().equals(BigDecimal.ZERO) || !s.getSumReceiveMny().equals(BigDecimal.ZERO)).collect(Collectors.toList());
        List collect = bodys.stream().sorted(Comparator.comparing(FinanceMonthVO::getTerm)).collect(Collectors.toList());
        HashMap<String, FinanceMonthVO> collectMap = new HashMap<String, FinanceMonthVO>();
        for (FinanceMonthVO vo : collect) {
            collectMap.put(vo.getTerm(), vo);
        }
        if ("lastYear".equals(timeRange)) {
            endDate = MonthUtil.monthFAdd(endDate, -1);
            endStr = DateUtil.format(endDate, "yyyy-MM-dd");
        }
        List<String> monthList = MonthUtil.getMonthList(startStr, endStr);
        ArrayList<FinanceMonthVO> newCollect = new ArrayList<FinanceMonthVO>();
        for (int i = 0; i < monthList.size(); ++i) {
            FinanceMonthVO financeMonthVO3 = (FinanceMonthVO)collectMap.get(monthList.get(i));
            if (null == financeMonthVO3) {
                FinanceMonthVO vo = new FinanceMonthVO();
                vo.setSumReceiveMny(BigDecimal.ZERO);
                vo.setProfit(BigDecimal.ZERO);
                vo.setSumOutMny(BigDecimal.ZERO);
                vo.setTerm(monthList.get(i));
                vo.setMonthTerm(monthList.get(i).substring(2, 7));
                newCollect.add(vo);
                continue;
            }
            newCollect.add(financeMonthVO3);
        }
        return newCollect;
    }

    @Override
    public List<FinanceCostVO> getCostInfo(Long projectId, String year) {
        List<FinanceCostVO> listReceive = ((PayContractMapper)this.baseMapper).getCostInfo(projectId, year);
        return listReceive;
    }

    @Override
    public Map<String, BigDecimal> getSubSettlePay(PubContractSubQueryVO pubContractSubQueryVO) {
        BigDecimal thisMny = ((PayContractMapper)this.baseMapper).selectSubThisPay(pubContractSubQueryVO.getContractId(), pubContractSubQueryVO.getProjectId(), pubContractSubQueryVO.getSettleId());
        BigDecimal sumMny = ((PayContractMapper)this.baseMapper).selectSubSumPay(pubContractSubQueryVO.getContractId(), pubContractSubQueryVO.getProjectId(), pubContractSubQueryVO.getSettleDate(), pubContractSubQueryVO.getSettleIdList());
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        map.put("thisMny", thisMny != null ? thisMny : BigDecimal.ZERO);
        map.put("sumMny", sumMny != null ? sumMny : BigDecimal.ZERO);
        return map;
    }

    @Override
    public Map<String, PayMnyWarnVO> getPayMnyByTenantIds(PubWarnQueryVO pubWarnQueryVO) {
        if (null == pubWarnQueryVO.getContractType()) {
            throw new BusinessException("\u5408\u540c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        HashMap<String, PayMnyWarnVO> map = new HashMap<String, PayMnyWarnVO>();
        List<PayMnyWarnVO> list = ((PayContractMapper)this.baseMapper).getPayMnyByTenantIds(pubWarnQueryVO);
        for (PayMnyWarnVO payMnyWarnVO : list) {
            map.put(payMnyWarnVO.getTenantId() + "@" + payMnyWarnVO.getOrgId() + "@" + payMnyWarnVO.getContractId(), payMnyWarnVO);
        }
        return map;
    }

    @Override
    public Map<Long, PayAndReceiveMnyWarnVO> getSumPayMnyMap(List<Long> tenantIds) {
        HashMap<Long, PayAndReceiveMnyWarnVO> map = new HashMap<Long, PayAndReceiveMnyWarnVO>();
        this.transPayContractToMap(map, tenantIds);
        this.transPaySporadicToMap(map, tenantIds);
        this.transPayReimburseToMap(map, tenantIds);
        this.transLoadReimburseToMap(map, tenantIds);
        return map;
    }

    private void transPayContractToMap(Map<Long, PayAndReceiveMnyWarnVO> map, List<Long> tenantIds) {
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(PayContractEntity::getPayStatus, (Object)2);
        lambda.in(PayContractEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        lambda.in(BaseEntity::getTenantId, tenantIds);
        List list = super.list((Wrapper)lambda);
        for (PayContractEntity entity : list) {
            Long projectId = entity.getProjectId();
            if (projectId == null) continue;
            PayAndReceiveMnyWarnVO vo = new PayAndReceiveMnyWarnVO();
            if (!map.containsKey(projectId)) {
                vo.setProjectId(projectId);
                vo.setProjectName(entity.getProjectName());
                vo.setOrgId(entity.getOrgId());
                vo.setOrgName(entity.getOrgName());
                vo.setTenantId(entity.getTenantId());
                vo.setSumPayMny(entity.getPayMny());
                map.put(projectId, vo);
                continue;
            }
            vo = map.get(projectId);
            vo.setSumPayMny(MathUtil.safeAdd((BigDecimal)vo.getSumPayMny(), (BigDecimal)entity.getPayMny()));
        }
    }

    private void transPaySporadicToMap(Map<Long, PayAndReceiveMnyWarnVO> map, List<Long> tenantIds) {
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(PaySporadicEntity::getPayStatus, (Object)2);
        lambda.in(PaySporadicEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        lambda.in(BaseEntity::getTenantId, tenantIds);
        List list = this.sporadicService.list((Wrapper)lambda);
        for (PaySporadicEntity entity : list) {
            Long projectId = entity.getProjectId();
            if (projectId == null) continue;
            PayAndReceiveMnyWarnVO vo = new PayAndReceiveMnyWarnVO();
            if (!map.containsKey(projectId)) {
                vo.setProjectId(projectId);
                vo.setProjectName(entity.getProjectName());
                vo.setOrgId(entity.getOrgId());
                vo.setOrgName(entity.getOrgName());
                vo.setTenantId(entity.getTenantId());
                vo.setSumPayMny(entity.getPayMny());
                map.put(projectId, vo);
                continue;
            }
            vo = map.get(projectId);
            vo.setSumPayMny(MathUtil.safeAdd((BigDecimal)vo.getSumPayMny(), (BigDecimal)entity.getPayMny()));
        }
    }

    private void transPayReimburseToMap(Map<Long, PayAndReceiveMnyWarnVO> map, List<Long> tenantIds) {
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(PayReimburseEntity::getPayStatus, (Object)2);
        lambda.in(PayReimburseEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        lambda.in(BaseEntity::getTenantId, tenantIds);
        List list = this.reimburseService.list((Wrapper)lambda);
        for (PayReimburseEntity entity : list) {
            Long projectId = entity.getProjectId();
            if (projectId == null) continue;
            PayAndReceiveMnyWarnVO vo = new PayAndReceiveMnyWarnVO();
            if (!map.containsKey(projectId)) {
                vo.setProjectId(projectId);
                vo.setProjectName(entity.getProjectName());
                vo.setOrgId(entity.getOrgId());
                vo.setOrgName(entity.getOrgName());
                vo.setTenantId(entity.getTenantId());
                vo.setSumPayMny(entity.getPayMny());
                map.put(projectId, vo);
                continue;
            }
            vo = map.get(projectId);
            vo.setSumPayMny(MathUtil.safeAdd((BigDecimal)vo.getSumPayMny(), (BigDecimal)entity.getPayMny()));
        }
    }

    private void transLoadReimburseToMap(Map<Long, PayAndReceiveMnyWarnVO> map, List<Long> tenantIds) {
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.in(LoadReimburseEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        lambda.in(BaseEntity::getTenantId, tenantIds);
        List list = this.loadReimburseService.list((Wrapper)lambda);
        for (LoadReimburseEntity entity : list) {
            Long projectId = entity.getProjectId();
            if (projectId == null) continue;
            PayAndReceiveMnyWarnVO vo = new PayAndReceiveMnyWarnVO();
            if (!map.containsKey(projectId)) {
                vo.setProjectId(projectId);
                vo.setProjectName(entity.getProjectName());
                vo.setOrgId(entity.getOrgId());
                vo.setOrgName(entity.getOrgName());
                vo.setTenantId(entity.getTenantId());
                vo.setSumPayMny(entity.getReimburseMny());
                map.put(projectId, vo);
                continue;
            }
            vo = map.get(projectId);
            vo.setSumPayMny(MathUtil.safeAdd((BigDecimal)vo.getSumPayMny(), (BigDecimal)entity.getReimburseMny()));
        }
    }

    @Override
    public Map<Long, PayAndReceiveMnyWarnVO> getSumReceiveMnyMap(List<Long> tenantIds) {
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.in(ReceiveEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        lambda.in(BaseEntity::getTenantId, tenantIds);
        List list = this.receiveService.list((Wrapper)lambda);
        HashMap<Long, PayAndReceiveMnyWarnVO> map = new HashMap<Long, PayAndReceiveMnyWarnVO>();
        for (ReceiveEntity entity : list) {
            Long projectId = entity.getProjectId();
            if (projectId == null) continue;
            PayAndReceiveMnyWarnVO vo = new PayAndReceiveMnyWarnVO();
            if (!map.containsKey(projectId)) {
                vo.setProjectId(projectId);
                vo.setProjectName(entity.getProjectName());
                vo.setOrgId(entity.getOrgId());
                vo.setOrgName(entity.getOrgName());
                vo.setTenantId(entity.getTenantId());
                vo.setSumReceiveMny(entity.getReceiveMny());
                map.put(projectId, vo);
                continue;
            }
            vo = (PayAndReceiveMnyWarnVO)map.get(projectId);
            vo.setSumReceiveMny(MathUtil.safeAdd((BigDecimal)vo.getSumReceiveMny(), (BigDecimal)entity.getReceiveMny()));
        }
        return map;
    }

    @Override
    public Map<Long, PayAndReceiveMnyWarnVO> getSumReimburseMnyMap(List<Long> tenantIds) {
        HashMap<Long, PayAndReceiveMnyWarnVO> map = new HashMap<Long, PayAndReceiveMnyWarnVO>();
        this.transPayReimburseToMap(map, tenantIds);
        this.transLoadReimburseToMap(map, tenantIds);
        return map;
    }

    @Override
    public List<Map<String, Object>> queryBondExpireWarn(List<SqlParam> sqlParamList) {
        List<Map<String, Object>> upList = ((PayContractMapper)this.baseMapper).queryBondUpExpireWarn(sqlParamList);
        List<Map<String, Object>> downList = ((PayContractMapper)this.baseMapper).queryBondDownExpireWarn(sqlParamList);
        upList.addAll(downList);
        return upList;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public JSONObject projectProgress(Long projectId, Date startDate, Date endDate) {
        Integer lastDay = 29;
        ArrayList<String> label = new ArrayList<String>();
        ArrayList<BigDecimal> baseValue = new ArrayList<BigDecimal>();
        ArrayList<BigDecimal> outputValue = new ArrayList<BigDecimal>();
        ArrayList<BigDecimal> payment = new ArrayList<BigDecimal>();
        ArrayList<BigDecimal> cost = new ArrayList<BigDecimal>();
        JSONObject jsonObject = new JSONObject();
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM");
        String now = sf.format(new Date());
        String start = null;
        String end = null;
        ProjectReportVo sumVo = new ProjectReportVo();
        CommonResponse res = this.contractReportApi.projectMonth(projectId, lastDay);
        if (!res.isSuccess()) {
            this.logger.error("\u8d77\u59cb\u7ed3\u675f\u65e5\u671f\u67e5\u8be2\u5931\u8d25");
            throw new BusinessException("\u57fa\u51c6\u503c\u67e5\u8be2\u5931\u8d25");
        }
        sumVo = (ProjectReportVo)res.getData();
        if (sumVo.getContractCount() <= 0) {
            this.logger.debug("\u5408\u540c\u4e3a\u7a7a\u6216\u8d77\u59cb\u7ed3\u675f\u65e5\u671f\u67e5\u8be2\u4e3a\u7a7a");
            jsonObject.put("speedLineData", (Object)new ReportAppVo());
            return jsonObject;
        }
        if (StringUtils.isEmpty((String)sumVo.getStartDate())) {
            this.logger.debug("\u5408\u540c\u8d77\u59cb\u65e5\u671f\u4e3a\u7a7a");
            jsonObject.put("speedLineData", (Object)new ReportAppVo());
            return jsonObject;
        }
        if (MonthUtil.compareTime(sumVo.getStartDate(), now) > 0) {
            this.logger.debug("\u5408\u540c\u8d77\u59cb\u65e5\u671f\u5927\u4e8e\u5f53\u524d\u65e5\u671f");
            jsonObject.put("speedLineData", (Object)new ReportAppVo());
            return jsonObject;
        }
        start = sumVo.getStartDate();
        if (StringUtils.isEmpty((String)sumVo.getEndDate())) {
            this.logger.debug("\u5408\u540c\u7ed3\u675f\u65e5\u671f\u4e3a\u7a7a");
            jsonObject.put("speedLineData", (Object)new ReportAppVo());
            return jsonObject;
        }
        end = sumVo.getEndDate();
        String lastMon = null;
        String maxmon = MonthUtil.monthAdd(sf, end, 6);
        lastMon = MonthUtil.compareTime(maxmon, now) >= 1 ? now : maxmon;
        BigDecimal contractTaxMny = BigDecimal.ZERO;
        CommonResponse res1 = this.contractReportApi.sumContractMny(projectId);
        if (!res1.isSuccess()) {
            this.logger.error("\u5408\u540c\u91d1\u989d\u67e5\u8be2\u5931\u8d25");
            throw new BusinessException("\u5408\u540c\u91d1\u989d\u67e5\u8be2\u5931\u8d25");
        }
        contractTaxMny = (BigDecimal)res1.getData();
        List productionList = new ArrayList();
        CommonResponse res2 = this.contractReportApi.getMonthProductionMny(projectId, lastDay);
        if (!res2.isSuccess()) {
            this.logger.error("\u4ea7\u503c\u91d1\u989d\u67e5\u8be2\u5931\u8d25");
            throw new BusinessException("\u4ea7\u503c\u91d1\u989d\u67e5\u8be2\u5931\u8d25");
        }
        productionList = (List)res2.getData();
        HashMap<String, Object> czMap1 = new HashMap<String, Object>();
        for (ProjectReportVo rv : productionList) {
            Object a;
            Object object = a = rv.getMny() == null ? BigDecimal.ZERO : rv.getMny();
            if (czMap1.containsKey(rv.getFinishMonth())) {
                BigDecimal mny = (BigDecimal)czMap1.get(rv.getFinishMonth());
                czMap1.put(rv.getFinishMonth(), mny.add((BigDecimal)a));
                continue;
            }
            czMap1.put(rv.getFinishMonth(), a);
        }
        List<ProjectAppVo> receiveList = ((PayContractMapper)this.baseMapper).getReceiveMny(projectId, lastDay);
        HashMap<String, BigDecimal> skMap1 = new HashMap<String, BigDecimal>();
        for (ProjectAppVo rv : receiveList) {
            BigDecimal a;
            BigDecimal bigDecimal = a = rv.getMny() == null ? BigDecimal.ZERO : rv.getMny();
            if (skMap1.containsKey(rv.getFinishMonth())) {
                BigDecimal mny = (BigDecimal)skMap1.get(rv.getFinishMonth());
                skMap1.put(rv.getFinishMonth(), mny.add(a));
                continue;
            }
            skMap1.put(rv.getFinishMonth(), a);
        }
        Map cbMap1 = new HashMap();
        CommonResponse costMonth = this.costDetailApi.getCostMonth(projectId);
        if (!costMonth.isSuccess()) {
            this.logger.error("\u6210\u672c\u4fe1\u606f\u67e5\u8be2\u5931\u8d25");
            throw new BusinessException("\u6210\u672c\u4fe1\u606f\u67e5\u8be2\u5931\u8d25");
        }
        cbMap1 = (Map)costMonth.getData();
        ArrayList list1 = new ArrayList(czMap1.keySet());
        ArrayList list2 = new ArrayList(skMap1.keySet());
        ArrayList list3 = new ArrayList(cbMap1.keySet());
        ArrayList<String> bigmonthList = new ArrayList<String>();
        for (String s : list1) {
            bigmonthList.add(s);
        }
        for (String s : list2) {
            bigmonthList.add(s);
        }
        for (String s : list3) {
            bigmonthList.add(s);
        }
        String bigMonth = MonthUtil.mostDate(bigmonthList, 0);
        List<Object> monthList = new ArrayList();
        monthList = MonthUtil.compareTime(bigMonth, lastMon) >= 0 ? MonthUtil.getMonthList(start, bigMonth) : MonthUtil.getMonthList(start, lastMon);
        HashMap<Object, BigDecimal> czMap = new HashMap<Object, BigDecimal>();
        for (Object month : monthList) {
            BigDecimal a = BigDecimal.ZERO;
            for (Object m : czMap1.keySet()) {
                if (MonthUtil.compareTime((String)m, (String)month) > 0) continue;
                a = a.add((BigDecimal)czMap1.get(m));
            }
            czMap.put(month, a);
        }
        HashMap<Object, void> skMap = new HashMap<Object, void>();
        for (Object month : monthList) {
            void var38_41;
            BigDecimal bigDecimal = BigDecimal.ZERO;
            for (Object m : skMap1.keySet()) {
                if (MonthUtil.compareTime((String)m, (String)month) > 0) continue;
                BigDecimal bigDecimal2 = var38_41.add((BigDecimal)skMap1.get(m));
            }
            skMap.put(month, var38_41);
        }
        HashMap<String, Object> cbMap = new HashMap<String, Object>();
        for (String string : monthList) {
            Object a = BigDecimal.ZERO;
            for (String m : cbMap1.keySet()) {
                if (MonthUtil.compareTime(m, string) > 0) continue;
                a = ((BigDecimal)a).add((BigDecimal)cbMap1.get(m));
            }
            cbMap.put(string, a);
        }
        List<String> monthList1 = MonthUtil.getMonthList(start, lastMon);
        Integer n = MonthUtil.getSubMonth(start, end);
        for (String mon : monthList1) {
            BigDecimal cz = (BigDecimal)czMap.get(mon);
            BigDecimal sk = (BigDecimal)skMap.get(mon);
            BigDecimal cb = (BigDecimal)cbMap.get(mon);
            BigDecimal output = BigDecimal.ZERO;
            BigDecimal pay = BigDecimal.ZERO;
            BigDecimal costmny = BigDecimal.ZERO;
            if (contractTaxMny.compareTo(BigDecimal.ZERO) != 0) {
                output = cz == null ? BigDecimal.ZERO : cz.divide(contractTaxMny, 8, 4).multiply(new BigDecimal(100));
                pay = sk == null ? BigDecimal.ZERO : sk.divide(contractTaxMny, 8, 4).multiply(new BigDecimal(100));
                BigDecimal bigDecimal = costmny = cb == null ? BigDecimal.ZERO : cb.divide(contractTaxMny, 8, 4).multiply(new BigDecimal(100));
            }
            if (n == 0) {
                baseValue.add(new BigDecimal("100.00"));
            } else {
                Integer subMonth = MonthUtil.getSubMonth(start, mon);
                if ((double)subMonth.intValue() / ((double)n.intValue() * 1.0) >= 1.0) {
                    baseValue.add(new BigDecimal("100.00"));
                } else {
                    Double f = (double)subMonth.intValue() / ((double)n.intValue() * 1.0) * 100.0;
                    BigDecimal b = new BigDecimal(f);
                    BigDecimal bigDecimal = b.setScale(2, 4);
                    baseValue.add(bigDecimal);
                }
            }
            label.add(mon);
            outputValue.add(output.setScale(2, 4));
            payment.add(pay.setScale(2, 4));
            cost.add(costmny.setScale(2, 4));
        }
        ReportAppVo rvo = new ReportAppVo();
        rvo.setLabel(label);
        rvo.setBaseValue(baseValue);
        rvo.setOutputValue(outputValue);
        rvo.setPayment(payment);
        rvo.setCost(cost);
        jsonObject.put("speedLineData", (Object)rvo);
        return jsonObject;
    }

    @Override
    public JSONObject projectIncome(Long projectId) {
        IncomeReportMnyVo inVo = new IncomeReportMnyVo();
        CommonResponse res1 = this.contractReportApi.getIncomeMny(projectId);
        if (!res1.isSuccess()) {
            this.logger.error("\u6536\u5165\u6570\u636e\u67e5\u8be2\u5931\u8d25");
            throw new BusinessException("\u6536\u5165\u6570\u636e\u67e5\u8be2\u5931\u8d25");
        }
        inVo = (IncomeReportMnyVo)res1.getData();
        List pList = new ArrayList();
        CommonResponse res2 = this.contractReportApi.getMonthProduction(projectId);
        if (!res2.isSuccess()) {
            this.logger.error("\u6708\u5ea6\u4ea7\u503c\u67e5\u8be2\u5931\u8d25");
            throw new BusinessException("\u6708\u5ea6\u4ea7\u503c\u67e5\u8be2\u5931\u8d25");
        }
        pList = (List)res2.getData();
        BigDecimal billingContract = BigDecimal.ZERO;
        CommonResponse res3 = this.invoiceApi.sumContractMny(projectId);
        if (!res3.isSuccess()) {
            this.logger.error("\u5408\u540c\u5f00\u7968\u67e5\u8be2\u5931\u8d25");
            throw new BusinessException("\u5408\u540c\u5f00\u7968\u67e5\u8be2\u5931\u8d25");
        }
        billingContract = (BigDecimal)res3.getData();
        BigDecimal contractReceived = BigDecimal.ZERO;
        ArrayList<Integer> billStatus = new ArrayList<Integer>();
        billStatus.add(1);
        billStatus.add(3);
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(ReceiveEntity::getProjectId, (Object)projectId);
        lambda.eq(BaseEntity::getDr, (Object)0);
        lambda.in(ReceiveEntity::getBillState, billStatus);
        List quoteEntities = this.receiveService.list((Wrapper)lambda);
        for (ReceiveEntity ce : quoteEntities) {
            contractReceived = contractReceived.add(ce.getReceiveMny());
        }
        BigDecimal totalAmount = PayContractServiceImpl.roundTwoPre(inVo.getContractAmount()).add(PayContractServiceImpl.roundTwoPre(inVo.getVisaAmount()));
        HashMap<String, Number> inMap = new HashMap<String, Number>();
        inMap.put("contractQuantity", PayContractServiceImpl.roundTwoPre(inVo.getContractQuantity()));
        inMap.put("visasNumber", PayContractServiceImpl.roundTwoPre(inVo.getVisasNumber()));
        inMap.put("contractAmount", PayContractServiceImpl.roundTwoPre(inVo.getContractAmount()));
        inMap.put("visaAmount", PayContractServiceImpl.roundTwoPre(inVo.getVisaAmount()));
        inMap.put("totalAmount", PayContractServiceImpl.roundTwoPre(totalAmount));
        HashMap<String, Number> payMap = new HashMap<String, Number>();
        if (totalAmount.compareTo(BigDecimal.ZERO) == 0) {
            payMap.put("paymentProgress", 0.0);
        } else {
            payMap.put("paymentProgress", contractReceived.divide(totalAmount, 8, 4).multiply(new BigDecimal(100)));
        }
        payMap.put("contractReceived", PayContractServiceImpl.roundTwoPre(contractReceived));
        payMap.put("uncollectedContractVisa", totalAmount.subtract(contractReceived));
        payMap.put("outputAmount", PayContractServiceImpl.roundTwoPre(inVo.getOutputAmount()));
        payMap.put("batchAmount", PayContractServiceImpl.roundTwoPre(inVo.getBatchAmount()));
        payMap.put("billingContract", PayContractServiceImpl.roundTwoPre(billingContract));
        payMap.put("contractCollection", PayContractServiceImpl.roundTwoPre(contractReceived));
        HashMap monthValue = new HashMap();
        ArrayList<String> label = new ArrayList<String>();
        ArrayList<BigDecimal> value = new ArrayList<BigDecimal>();
        for (ProjectReportVo pr : pList) {
            label.add(pr.getFinishMonth());
            value.add(PayContractServiceImpl.roundTwoPre(pr.getMny()));
        }
        monthValue.put("label", label);
        monthValue.put("value", value);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("revenueManagement", inMap);
        jsonObject.put("paymentProgress", payMap);
        jsonObject.put("monthlyOutputValue", monthValue);
        return jsonObject;
    }

    @Override
    public JSONObject projectOut(Long projectId) {
        SubProjectReportVo sub = new SubProjectReportVo();
        CommonResponse res1 = this.subReportApi.getSubContract(projectId);
        if (!res1.isSuccess()) {
            this.logger.error("\u5206\u5305\u5408\u540c\u67e5\u8be2\u5931\u8d25");
            throw new BusinessException("\u5206\u5305\u5408\u540c\u67e5\u8be2\u5931\u8d25");
        }
        sub = (SubProjectReportVo)res1.getData();
        MaterialReportVo material = new MaterialReportVo();
        CommonResponse res2 = this.materialContractApi.getMaterialContract(projectId);
        if (!res2.isSuccess()) {
            this.logger.error("\u7269\u8d44\u91c7\u8d2d\u5408\u540c\u67e5\u8be2\u5931\u8d25");
            throw new BusinessException("\u7269\u8d44\u91c7\u8d2d\u5408\u540c\u67e5\u8be2\u5931\u8d25");
        }
        material = (MaterialReportVo)res2.getData();
        List equipment = new ArrayList();
        CommonResponse res3 = this.equipmentApi.getEquipment(projectId);
        if (!res3.isSuccess()) {
            this.logger.error("\u8bbe\u5907\u79df\u8d41/\u91c7\u8d2d\u5408\u540c\u67e5\u8be2\u5931\u8d25");
            throw new BusinessException("\u8bbe\u5907\u79df\u8d41/\u91c7\u8d2d\u5408\u540c\u67e5\u8be2\u5931\u8d25");
        }
        equipment = (List)res3.getData();
        EquipmentReportVo cg = (EquipmentReportVo)equipment.get(0);
        EquipmentReportVo zl = (EquipmentReportVo)equipment.get(1);
        RmatAndOtherInfo rmatInfo = new RmatAndOtherInfo();
        RmatAndOtherInfo otherInfo = new RmatAndOtherInfo();
        CommonResponse otherCommonResponse = this.otherContractApi.getOtherContract(projectId);
        if (!otherCommonResponse.isSuccess()) {
            this.logger.error("\u5176\u4ed6\u5408\u540c\u67e5\u8be2\u5931\u8d25");
            throw new BusinessException("\u5176\u4ed6\u5408\u540c\u67e5\u8be2\u5931\u8d25");
        }
        OtherProjectReportVo data = (OtherProjectReportVo)otherCommonResponse.getData();
        otherInfo.setContractType(Integer.valueOf(6));
        otherInfo.setContractTaxMny(data.getMny());
        otherInfo.setSumSettleTaxMny(data.getSettleMny());
        otherInfo.setNum(data.getNum());
        CommonResponse rmatCommonResponse = this.rmatContractApi.getRmatContract(projectId);
        if (!rmatCommonResponse.isSuccess()) {
            this.logger.error("\u5468\u8f6c\u6750\u5408\u540c\u67e5\u8be2\u5931\u8d25");
            throw new BusinessException("\u5468\u8f6c\u6750\u5408\u540c\u67e5\u8be2\u5931\u8d25");
        }
        RmatProjectReportVo data2 = (RmatProjectReportVo)rmatCommonResponse.getData();
        rmatInfo.setContractType(Integer.valueOf(5));
        rmatInfo.setContractTaxMny(data2.getMny());
        rmatInfo.setSumSettleTaxMny(data2.getSettleMny());
        rmatInfo.setNum(data2.getNum());
        List taxInvoice = new ArrayList();
        CommonResponse res4 = this.invoiceApi.getTaxReceive(projectId);
        if (!res4.isSuccess()) {
            this.logger.error("\u5408\u540c\u6536\u7968\u67e5\u8be2\u5931\u8d25");
            throw new BusinessException("\u5408\u540c\u6536\u7968\u67e5\u8be2\u5931\u8d25");
        }
        taxInvoice = (List)res4.getData();
        HashMap<String, BigDecimal> withMap = new HashMap<String, BigDecimal>();
        BigDecimal without = BigDecimal.ZERO;
        for (InvoiceReceiveVO pc : taxInvoice) {
            if (pc.getType() != null && pc.getType() == 1) {
                if (withMap.containsKey(pc.getContractType())) {
                    BigDecimal a = withMap.get(pc.getContractType()) == null ? BigDecimal.ZERO : (BigDecimal)withMap.get(pc.getContractType());
                    BigDecimal b = pc.getInvoiceTaxMny() == null ? BigDecimal.ZERO : pc.getInvoiceTaxMny();
                    BigDecimal payMny = a.add(b);
                    withMap.put(pc.getContractType(), payMny);
                } else {
                    withMap.put(pc.getContractType(), pc.getInvoiceTaxMny());
                }
            }
            if (pc.getType() == null || pc.getType() != 2) continue;
            BigDecimal b = pc.getInvoiceTaxMny() == null ? BigDecimal.ZERO : pc.getInvoiceTaxMny();
            without = without.add(b);
        }
        ArrayList<Integer> billStatus = new ArrayList<Integer>();
        billStatus.add(1);
        billStatus.add(3);
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(PayContractEntity::getProjectId, (Object)projectId);
        lambda.eq(BaseEntity::getDr, (Object)0);
        lambda.eq(PayContractEntity::getPayStatus, (Object)2);
        lambda.in(PayContractEntity::getBillState, billStatus);
        List payContractEntities = super.list((Wrapper)lambda);
        HashMap<Long, BigDecimal> payMap = new HashMap<Long, BigDecimal>();
        BigDecimal cumulativePayment = BigDecimal.ZERO;
        for (PayContractEntity pc : payContractEntities) {
            if (payMap.containsKey(pc.getContractType())) {
                BigDecimal a = payMap.get(pc.getContractType()) == null ? BigDecimal.ZERO : (BigDecimal)payMap.get(pc.getContractType());
                BigDecimal b = pc.getPayMny() == null ? BigDecimal.ZERO : pc.getPayMny();
                BigDecimal payMny = a.add(b);
                payMap.put(pc.getContractType(), payMny);
            } else {
                payMap.put(pc.getContractType(), pc.getPayMny() == null ? BigDecimal.ZERO : pc.getPayMny());
            }
            BigDecimal b = pc.getPayMny() == null ? BigDecimal.ZERO : pc.getPayMny();
            cumulativePayment = cumulativePayment.add(b);
        }
        BigDecimal projectCollection = ((PayContractMapper)this.baseMapper).projectCollection(projectId);
        HashMap<String, BigDecimal> target = new HashMap<String, BigDecimal>();
        BigDecimal c = sub.getMny() == null ? BigDecimal.ZERO : sub.getMny();
        BigDecimal d = material.getMny() == null ? BigDecimal.ZERO : material.getMny();
        BigDecimal e = cg.getMny() == null ? BigDecimal.ZERO : cg.getMny();
        BigDecimal f = zl.getMny() == null ? BigDecimal.ZERO : zl.getMny();
        BigDecimal g = sub.getSettleMny() == null ? BigDecimal.ZERO : sub.getSettleMny();
        BigDecimal h = material.getSettleMny() == null ? BigDecimal.ZERO : material.getSettleMny();
        BigDecimal k = cg.getSettleMny() == null ? BigDecimal.ZERO : cg.getSettleMny();
        BigDecimal l = zl.getSettleMny() == null ? BigDecimal.ZERO : zl.getSettleMny();
        BigDecimal m = projectCollection == null ? BigDecimal.ZERO : projectCollection;
        BigDecimal rmatContractTaxMny = rmatInfo == null ? BigDecimal.ZERO : rmatInfo.getContractTaxMny();
        BigDecimal otherContractTaxMny = otherInfo == null ? BigDecimal.ZERO : otherInfo.getContractTaxMny();
        BigDecimal rmatSettleTaxMny = rmatInfo == null ? BigDecimal.ZERO : rmatInfo.getSumSettleTaxMny();
        BigDecimal otherSettleTaxMny = otherInfo == null ? BigDecimal.ZERO : otherInfo.getSumSettleTaxMny();
        target.put("expenditureContractAmount", c.add(d).add(e).add(f).add(rmatContractTaxMny).add(otherContractTaxMny));
        target.put("contractSettlementAmount", g.add(h).add(k).add(l).add(rmatSettleTaxMny).add(otherSettleTaxMny));
        target.put("otherPayments", PayContractServiceImpl.roundTwoPre(projectCollection));
        target.put("cumulativePayment", cumulativePayment.add(m));
        HashMap<String, Number> subcontract = new HashMap<String, Number>();
        subcontract.put("number", PayContractServiceImpl.roundTwoPre(sub.getNum()));
        subcontract.put("contractAmount", PayContractServiceImpl.roundTwoPre(sub.getMny()));
        subcontract.put("settlementAmount", PayContractServiceImpl.roundTwoPre(sub.getSettleMny()));
        subcontract.put("amountPaid", PayContractServiceImpl.roundTwoPre((BigDecimal)payMap.get(ContractTypeConst.SUB)));
        subcontract.put("inputInvoice", PayContractServiceImpl.roundTwoPre((BigDecimal)withMap.get("1")));
        HashMap<String, Number> materialPurchaseContract = new HashMap<String, Number>();
        materialPurchaseContract.put("number", PayContractServiceImpl.roundTwoPre(material.getNum()));
        materialPurchaseContract.put("contractAmount", PayContractServiceImpl.roundTwoPre(material.getMny()));
        materialPurchaseContract.put("settlementAmount", PayContractServiceImpl.roundTwoPre(material.getSettleMny()));
        materialPurchaseContract.put("amountPaid", PayContractServiceImpl.roundTwoPre((BigDecimal)payMap.get(ContractTypeConst.MATERIAL)));
        materialPurchaseContract.put("inputInvoice", PayContractServiceImpl.roundTwoPre((BigDecimal)withMap.get("4")));
        HashMap<String, Number> equipmentProcurementContract = new HashMap<String, Number>();
        equipmentProcurementContract.put("number", PayContractServiceImpl.roundTwoPre(cg.getNum()));
        equipmentProcurementContract.put("contractAmount", PayContractServiceImpl.roundTwoPre(cg.getMny()));
        equipmentProcurementContract.put("settlementAmount", PayContractServiceImpl.roundTwoPre(cg.getSettleMny()));
        equipmentProcurementContract.put("amountPaid", PayContractServiceImpl.roundTwoPre((BigDecimal)payMap.get(ContractTypeConst.EQUIPMENT_PURCHASE)));
        equipmentProcurementContract.put("inputInvoice", PayContractServiceImpl.roundTwoPre((BigDecimal)withMap.get("2")));
        HashMap<String, Number> equipmentLeasingContract = new HashMap<String, Number>();
        equipmentLeasingContract.put("number", PayContractServiceImpl.roundTwoPre(zl.getNum()));
        equipmentLeasingContract.put("contractAmount", PayContractServiceImpl.roundTwoPre(zl.getMny()));
        equipmentLeasingContract.put("settlementAmount", PayContractServiceImpl.roundTwoPre(zl.getSettleMny()));
        equipmentLeasingContract.put("amountPaid", PayContractServiceImpl.roundTwoPre((BigDecimal)payMap.get(ContractTypeConst.EQUIPMENT_RENT)));
        equipmentLeasingContract.put("inputInvoice", PayContractServiceImpl.roundTwoPre((BigDecimal)withMap.get("3")));
        HashMap<String, Number> rmatContract = new HashMap<String, Number>();
        rmatContract.put("number", PayContractServiceImpl.roundTwoPre(rmatInfo.getNum()));
        rmatContract.put("contractAmount", PayContractServiceImpl.roundTwoPre(rmatInfo.getContractTaxMny()));
        rmatContract.put("settlementAmount", PayContractServiceImpl.roundTwoPre(rmatInfo.getSumSettleTaxMny()));
        rmatContract.put("amountPaid", PayContractServiceImpl.roundTwoPre((BigDecimal)payMap.get(ContractTypeConst.RMAT)));
        rmatContract.put("inputInvoice", PayContractServiceImpl.roundTwoPre((BigDecimal)withMap.get("5")));
        HashMap<String, Number> otherContract = new HashMap<String, Number>();
        otherContract.put("number", PayContractServiceImpl.roundTwoPre(otherInfo.getNum()));
        otherContract.put("contractAmount", PayContractServiceImpl.roundTwoPre(otherInfo.getContractTaxMny()));
        otherContract.put("settlementAmount", PayContractServiceImpl.roundTwoPre(otherInfo.getSumSettleTaxMny()));
        otherContract.put("amountPaid", PayContractServiceImpl.roundTwoPre((BigDecimal)payMap.get(ContractTypeConst.OTHER)));
        otherContract.put("inputInvoice", PayContractServiceImpl.roundTwoPre((BigDecimal)withMap.get("6")));
        HashMap<String, BigDecimal> otherExpenses = new HashMap<String, BigDecimal>();
        otherExpenses.put("projectCollection", PayContractServiceImpl.roundTwoPre(projectCollection));
        otherExpenses.put("salesInvoice", PayContractServiceImpl.roundTwoPre(without));
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("target", target);
        jsonObject.put("subcontract", subcontract);
        jsonObject.put("materialPurchaseContract", materialPurchaseContract);
        jsonObject.put("equipmentLeasingContract", equipmentLeasingContract);
        jsonObject.put("equipmentProcurementContract", equipmentProcurementContract);
        jsonObject.put("rmatContract", rmatContract);
        jsonObject.put("otherContract", otherContract);
        jsonObject.put("otherExpenses", otherExpenses);
        return jsonObject;
    }

    @Override
    public Map<String, PayMnyWarnVO> warnPayMny(PubWarnQueryVO pubWarnQueryVO) {
        if (null == pubWarnQueryVO.getContractType()) {
            throw new BusinessException("\u5408\u540c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        HashMap<String, PayMnyWarnVO> map = new HashMap<String, PayMnyWarnVO>();
        List<PayMnyWarnVO> list = ((PayContractMapper)this.baseMapper).warnPayMny(pubWarnQueryVO);
        for (PayMnyWarnVO payMnyWarnVO : list) {
            map.put(payMnyWarnVO.getTenantId() + "@" + payMnyWarnVO.getOrgId() + "@" + payMnyWarnVO.getContractId(), payMnyWarnVO);
        }
        return map;
    }

    @Override
    public Map<String, PayMnyWarnVO> warnMaterialPayMny(PubWarnQueryVO pubWarnQueryVO) {
        if (null == pubWarnQueryVO.getContractType()) {
            throw new BusinessException("\u5408\u540c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        HashMap<String, PayMnyWarnVO> map = new HashMap<String, PayMnyWarnVO>();
        List<PayMnyWarnVO> list = ((PayContractMapper)this.baseMapper).warnMaterialPayMny(pubWarnQueryVO);
        for (PayMnyWarnVO payMnyWarnVO : list) {
            map.put(payMnyWarnVO.getTenantId() + "@" + payMnyWarnVO.getContractId(), payMnyWarnVO);
        }
        return map;
    }

    @Override
    public Map<String, PayMnyWarnVO> warnMaterialPrePayMny(PubWarnQueryVO pubWarnQueryVO) {
        if (null == pubWarnQueryVO.getContractType()) {
            throw new BusinessException("\u5408\u540c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        HashMap<String, PayMnyWarnVO> map = new HashMap<String, PayMnyWarnVO>();
        List<PayMnyWarnVO> list = ((PayContractMapper)this.baseMapper).warnMaterialPrePayMny(pubWarnQueryVO);
        for (PayMnyWarnVO payMnyWarnVO : list) {
            map.put(payMnyWarnVO.getTenantId() + "@" + payMnyWarnVO.getContractId(), payMnyWarnVO);
        }
        return map;
    }

    @Override
    public TotalColumnVO getTotalColumnInfo(QueryParam param, boolean isEs) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("receiveUnitName");
        fuzzyFields.add("applyUserName");
        fuzzyFields.add("accountName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("payUnitName");
        fuzzyFields.add("payReason");
        fuzzyFields.add("applyMny");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        if (StringUtils.isNotEmpty((String)param.getBillTypeId()) && this.viewSelf(param.getBillTypeId()).booleanValue() && param.getParams().get("createUserCode") == null && param.getParams().get("create_user_code") == null) {
            param.getParams().put("createUserCode", new Parameter("eq", (Object)InvocationInfoProxy.getUsercode()));
        }
        Parameter parameterFlag = (Parameter)param.getParams().get("relationInvoiceFlag");
        param.getParams().remove("relationInvoiceFlag");
        String flag = parameterFlag == null ? null : parameterFlag.getValue().toString();
        QueryWrapper wrapper = PayContractServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<PayContractVO> list = ((PayContractMapper)this.baseMapper).queryPageList(null, wrapper, flag);
        BigDecimal sumApplyMny = list.stream().filter(entity -> entity.getApplyMny() != null).map(PayContractVO::getApplyMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal sumPayMny = list.stream().filter(entity -> entity.getPayMny() != null).map(PayContractVO::getPayMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        TotalColumnVO vo = new TotalColumnVO();
        vo.setSumApplyMny(sumApplyMny);
        vo.setSumPayMny(sumPayMny);
        return vo;
    }

    @Override
    public TotalColumnVO getApproveTotalColumnInfo(QueryParam param, boolean isEs) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("receiveUnitName");
        fuzzyFields.add("applyUserName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        Parameter parameterFlag = (Parameter)param.getParams().get("relationInvoiceFlag");
        param.getParams().remove("relationInvoiceFlag");
        String flag = parameterFlag == null ? null : parameterFlag.getValue().toString();
        QueryWrapper wrapper = PayContractServiceImpl.changeToQueryWrapper((QueryParam)param);
        List<PayContractVO> list = ((PayContractMapper)this.baseMapper).queryPageList(null, wrapper, flag);
        BigDecimal sumApplyMny = list.stream().filter(entity -> entity.getApplyMny() != null).map(PayContractVO::getApplyMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal sumPayMny = list.stream().filter(entity -> entity.getPayMny() != null).map(PayContractVO::getPayMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        TotalColumnVO vo = new TotalColumnVO();
        vo.setSumApplyMny(sumApplyMny);
        vo.setSumPayMny(sumPayMny);
        return vo;
    }

    @Override
    public TotalColumnVO getPendingTotalColumnInfo(QueryParam param, boolean isEs, String type) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("orgName");
        fuzzyFields.add("receiveUnitName");
        fuzzyFields.add("applyUserName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        param.getComplexParams().add(ComplexParam.getApprovedComplexParam((String)"and"));
        param.getParams().put("dr", new Parameter("eq", (Object)0));
        param.getOrderMap().put("approveTime", "desc");
        this.transformReimburse(param);
        QueryWrapper wrapper = PayContractServiceImpl.changeToQueryWrapper((QueryParam)param);
        if ("pending".equals(type)) {
            wrapper.and(x -> (QueryWrapper)x.last("pay_status = 1 or pay_mny < apply_mny"));
        }
        List<PayApplyPubVO> list = ((PayContractMapper)this.baseMapper).queryPendingList(null, wrapper);
        BigDecimal sumApplyMny = list.stream().filter(entity -> entity.getApplyMny() != null).map(PayApplyPubVO::getApplyMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal sumPayMny = list.stream().filter(entity -> entity.getPayMny() != null).map(PayApplyPubVO::getPayMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        TotalColumnVO vo = new TotalColumnVO();
        vo.setSumApplyMny(sumApplyMny);
        vo.setSumPayMny(sumPayMny);
        return vo;
    }

    @Override
    public ParamsCheckVO checkParams(Integer purchaseType, BigDecimal sumPayMny, BigDecimal payMny, BigDecimal contractMny, BigDecimal proSurplusApplyMny, Long orgId) {
        CommonResponse response1;
        Long curOrgId = Optional.ofNullable(orgId).orElse(InvocationInfoProxy.getOrgId());
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        HashMap<String, List<ParamsCheckDsVO>> paramsCheckVOMap = new HashMap<String, List<ParamsCheckDsVO>>();
        paramsCheckVOMap.put("alert", new ArrayList());
        paramsCheckVOMap.put("warn", new ArrayList());
        CommonResponse response = this.paramConfigApi.getBillParamByCodeAndOrgId(CHECK_PARAM_CODE, curOrgId);
        if (!response.isSuccess()) {
            this.logger.info(response.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        List billParamVOS = (List)response.getData();
        if (CollectionUtils.isNotEmpty((Collection)billParamVOS)) {
            for (BillParamVO billParamVO : billParamVOS) {
                BigDecimal comMny;
                BigDecimal roleValue = billParamVO.getRoleValue();
                BigDecimal sumPayWithThisMny = sumPayMny.add(payMny);
                if (sumPayWithThisMny.compareTo(comMny = contractMny.multiply(roleValue.divide(BigDecimal.valueOf(100L)))) <= 0) continue;
                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                paramsCheckDsVO.setWarnItem("\u5408\u540c\u8d85\u4ed8");
                paramsCheckDsVO.setWarnName("\u4ed8\u6b3e\u91d1\u989d\u5927\u4e8e\u5408\u540c\u91d1\u989d");
                paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("\u672c\u6b21\u7533\u8bf7\u91d1\u989d\uff1a").append(payMny.toString()).append("\u5143\uff0c\u5408\u540c\u91d1\u989d*").append(roleValue).append("%:").append(comMny).append("\u5143\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(sumPayWithThisMny.subtract(comMny)).append("\u5143");
                paramsCheckDsVO.setContent(stringBuffer.toString());
                PayContractServiceImpl.updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
            }
        }
        if (!(response1 = this.paramConfigApi.getBillParamByCodeAndOrgId(CAN_USE_MNY_CHECK_CODE, curOrgId)).isSuccess()) {
            this.logger.info(response1.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        List billParamVOS1 = (List)response1.getData();
        if (CollectionUtils.isNotEmpty((Collection)billParamVOS1)) {
            for (BillParamVO billParamVO : billParamVOS1) {
                BigDecimal roleValue = billParamVO.getRoleValue();
                BigDecimal surplusApplyMny = ComputeUtil.safeMultiply((BigDecimal)roleValue.divide(BigDecimal.valueOf(100L)), (BigDecimal)proSurplusApplyMny);
                if (!ComputeUtil.isGreaterThan((BigDecimal)payMny, (BigDecimal)surplusApplyMny)) continue;
                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                paramsCheckDsVO.setWarnItem("\u4ed8\u6b3e\u7533\u8bf7\u989d\u8d85\u9879\u76ee\u53ef\u7528\u8d44\u91d1");
                paramsCheckDsVO.setWarnName("\u672c\u671f\u7533\u8bf7\u91d1\u989d\u5927\u4e8e\u5269\u4f59\u53ef\u7533\u8bf7\u91d1\u989d");
                paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("\u672c\u6b21\u7533\u8bf7\u91d1\u989d\uff1a").append(payMny.setScale(2, 4)).append("\u5143\uff0c\u5269\u4f59\u53ef\u7533\u8bf7\u91d1\u989d*").append(roleValue.setScale(2, 4)).append("%:").append(surplusApplyMny.setScale(2, 4)).append("\u5143\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(payMny.subtract(surplusApplyMny).setScale(2, 4)).append("\u5143");
                paramsCheckDsVO.setContent(stringBuffer.toString());
                PayContractServiceImpl.updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
            }
        }
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        if (CollectionUtils.isNotEmpty((Collection)((Collection)paramsCheckVOMap.get("alert")))) {
            paramsCheckVO.setWarnType("alert");
            paramsCheckVO.setDataSource((List)paramsCheckVOMap.get("alert"));
        } else if (CollectionUtils.isNotEmpty((Collection)((Collection)paramsCheckVOMap.get("warn")))) {
            paramsCheckVO.setWarnType("warn");
            paramsCheckVO.setDataSource((List)paramsCheckVOMap.get("warn"));
        } else {
            paramsCheckVO.setWarnType("none");
            paramsCheckVO.setDataSource(null);
        }
        return paramsCheckVO;
    }

    public static void updateParamsCheckVOMap(String[] paramsArray, Map<String, List<ParamsCheckDsVO>> paramsCheckVOMap, BillParamVO billParamVO, ParamsCheckDsVO paramsCheckDsVO) {
        if ("alert".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> alert = paramsCheckVOMap.get("alert");
            alert.add(paramsCheckDsVO);
        }
        if ("warn".equals(paramsArray[billParamVO.getControlType()])) {
            List<ParamsCheckDsVO> warn = paramsCheckVOMap.get("warn");
            warn.add(paramsCheckDsVO);
        }
    }

    private Map<String, BigDecimal> getCostMonth(Long projectId, Integer lastDay) {
        BigDecimal mny;
        BigDecimal a;
        List subList = new ArrayList();
        CommonResponse res3 = this.subReportApi.getMonthSubMny(projectId, lastDay);
        if (!res3.isSuccess()) {
            this.logger.error("\u5206\u5305\u7ed3\u7b97\u67e5\u8be2\u5931\u8d25");
            throw new BusinessException("\u5206\u5305\u7ed3\u7b97\u67e5\u8be2\u5931\u8d25");
        }
        subList = (List)res3.getData();
        List materialList = new ArrayList();
        CommonResponse res4 = this.materialContractApi.getMonthMaterialMny(projectId, lastDay);
        if (!res4.isSuccess()) {
            this.logger.error("\u7269\u8d44\u7ed3\u7b97\u67e5\u8be2\u5931\u8d25");
            throw new BusinessException("\u7269\u8d44\u7ed3\u7b97\u67e5\u8be2\u5931\u8d25");
        }
        materialList = (List)res4.getData();
        List equipmentList = new ArrayList();
        CommonResponse res5 = this.equipmentApi.getMonthEquipmentMny(projectId, lastDay);
        if (!res5.isSuccess()) {
            this.logger.error("\u8bbe\u5907\u91c7\u8d2d\u79df\u8d41\u67e5\u8be2\u5931\u8d25");
            throw new BusinessException("\u5b9e\u9645\u6210\u672c\u67e5\u8be2\u5931\u8d25");
        }
        equipmentList = (List)res5.getData();
        List<ProjectAppVo> costList = ((PayContractMapper)this.baseMapper).getMonthCostMny(projectId, lastDay);
        HashMap<String, BigDecimal> cbMap = new HashMap<String, BigDecimal>();
        for (SubProjectReportVo subProjectReportVo : subList) {
            BigDecimal bigDecimal = a = subProjectReportVo.getMny() == null ? BigDecimal.ZERO : subProjectReportVo.getMny();
            if (cbMap.containsKey(subProjectReportVo.getFinishMonth())) {
                mny = (BigDecimal)cbMap.get(subProjectReportVo.getFinishMonth());
                cbMap.put(subProjectReportVo.getFinishMonth(), mny.add(a));
                continue;
            }
            cbMap.put(subProjectReportVo.getFinishMonth(), a);
        }
        for (MaterialReportVo materialReportVo : materialList) {
            BigDecimal bigDecimal = a = materialReportVo.getMny() == null ? BigDecimal.ZERO : materialReportVo.getMny();
            if (cbMap.containsKey(materialReportVo.getFinishMonth())) {
                mny = (BigDecimal)cbMap.get(materialReportVo.getFinishMonth());
                cbMap.put(materialReportVo.getFinishMonth(), mny.add(a));
                continue;
            }
            cbMap.put(materialReportVo.getFinishMonth(), a);
        }
        for (EquipmentReportVo equipmentReportVo : equipmentList) {
            BigDecimal bigDecimal = a = equipmentReportVo.getMny() == null ? BigDecimal.ZERO : equipmentReportVo.getMny();
            if (cbMap.containsKey(equipmentReportVo.getFinishMonth())) {
                mny = (BigDecimal)cbMap.get(equipmentReportVo.getFinishMonth());
                cbMap.put(equipmentReportVo.getFinishMonth(), mny.add(a));
                continue;
            }
            cbMap.put(equipmentReportVo.getFinishMonth(), a);
        }
        for (ProjectAppVo projectAppVo : costList) {
            BigDecimal bigDecimal = a = projectAppVo.getMny() == null ? BigDecimal.ZERO : projectAppVo.getMny();
            if (cbMap.containsKey(projectAppVo.getFinishMonth())) {
                mny = (BigDecimal)cbMap.get(projectAppVo.getFinishMonth());
                cbMap.put(projectAppVo.getFinishMonth(), mny.add(a));
                continue;
            }
            cbMap.put(projectAppVo.getFinishMonth(), a);
        }
        return cbMap;
    }

    public static BigDecimal roundTwoPre(BigDecimal src) {
        return src == null ? new BigDecimal("0.00") : src.setScale(2, 6);
    }

    public static Integer roundTwoPre(Integer src) {
        return src == null ? 0 : src;
    }

    private void validateBeforeSave(PayContractEntity entity) {
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(PayContractEntity::getContractId, (Object)entity.getContractId());
        lambda.eq(PayContractEntity::getOrgId, (Object)entity.getOrgId());
        lambda.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
        lambda.ne(entity.getId() != null && entity.getId() > 0L, BaseEntity::getId, (Object)entity.getId());
        lambda.orderByDesc(PayContractEntity::getApplyTime);
        List entityList = super.list((Wrapper)lambda);
        if (CollectionUtils.isNotEmpty((Collection)entityList)) {
            for (PayContractEntity p : entityList) {
                List<Integer> effectState = Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode());
                if (effectState.contains(p.getBillState())) continue;
                throw new BusinessException("\u8be5\u5408\u540c\u5728\u540c\u4e00\u7ec4\u7ec7\u4e0b\u5b58\u5728\u672a\u751f\u6548\u5355\u636e,\u4e0d\u5141\u8bb8\u65b0\u589e!");
            }
            PayContractEntity late = (PayContractEntity)((Object)entityList.get(0));
            Date applyTime = late.getApplyTime();
            Date _applyTime = entity.getApplyTime();
            if (_applyTime != null && applyTime != null && _applyTime.getTime() <= applyTime.getTime()) {
                String applyTimeStr = MonthUtil.dateFormatStrTMDHMS(applyTime);
                String _applyTimeStr = MonthUtil.dateFormatStrTMDHMS(_applyTime);
                throw new BusinessException("\u5f53\u524d\u7533\u8bf7\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u6700\u65b0\u7684\u7533\u8bf7\u65f6\u95f4\uff0c\u6700\u65b0\u65f6\u95f4\uff1a" + applyTimeStr + "\uff0c\u5f53\u524d\u7533\u8bf7\u65f6\u95f4\uff1a" + _applyTimeStr + " !");
            }
        }
    }

    private boolean getWriteFlag(PayContractVO vo) {
        PayContractEntity data;
        Integer payStatus;
        boolean writeFlag = false;
        if (vo.getId() != null && (payStatus = (data = (PayContractEntity)((Object)super.selectById((Serializable)vo.getId()))).getPayStatus()) != vo.getPayStatus() && vo.getPayStatus() == 2) {
            writeFlag = true;
        }
        return writeFlag;
    }

    public Boolean writeBackAlreadyApplyMny(List<PayContractSalaryVO> list) {
        if (CollectionUtils.isNotEmpty(list)) {
            List<Long> salaryIds = list.stream().distinct().map(PayContractSalaryVO::getSalaryId).collect(Collectors.toList());
            List<PayContractSalaryVO> salarylist = this.payContractSalaryService.querySalaryAlreadyApplyMny(salaryIds);
            Map<Long, BigDecimal> map = salarylist.stream().collect(Collectors.toMap(PayContractSalaryVO::getSalaryId, a -> a.getApplyMny()));
            for (Long salaryId : salaryIds) {
                if (map.containsKey(salaryId)) continue;
                map.put(salaryId, BigDecimal.ZERO);
            }
            this.projectTeamApi.updateAlreadyApplyMny(map);
        }
        return true;
    }

    private List<PayContractSalaryVO> updateSalary(PayContractVO vo, Long id) {
        List delSalList;
        List voList = vo.getContractSalaryList();
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"payapply_id", (Object)id);
        ArrayList<PayContractSalaryVO> updSalarys = new ArrayList<PayContractSalaryVO>();
        if (voList != null && !voList.isEmpty()) {
            for (PayContractSalaryVO salaryVO : voList) {
                salaryVO.setPayapplyId(id);
            }
            List entityList = BeanMapper.mapList((Iterable)voList, PayContractSalaryEntity.class);
            this.payContractSalaryService.saveOrUpdateBatch(entityList, entityList.size(), false);
            voList = BeanMapper.mapList((Iterable)entityList, PayContractSalaryVO.class);
            List ids = voList.stream().map(BaseVO::getId).collect(Collectors.toList());
            wrapper.notIn(!ids.isEmpty(), (Object)"id", ids);
            updSalarys.addAll(voList);
        }
        if (CollectionUtils.isNotEmpty((Collection)(delSalList = this.payContractSalaryService.list((Wrapper)wrapper)))) {
            List delSalVOList = BeanMapper.mapList((Iterable)delSalList, PayContractSalaryVO.class);
            updSalarys.addAll(delSalVOList);
        }
        this.payContractSalaryService.remove((Wrapper)wrapper);
        this.writeBackAlreadyApplyMny(updSalarys);
        return voList;
    }

    private List<PayContractSummaryVO> updateSummary(PayContractVO vo, Long id) {
        List voList = vo.getContractSummaryList();
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"payapply_id", (Object)id);
        if (voList != null && !voList.isEmpty()) {
            for (PayContractSummaryVO summaryVO : voList) {
                summaryVO.setPayapplyId(id);
            }
            List entityList = BeanMapper.mapList((Iterable)voList, PayContractSummaryEntity.class);
            this.payContractSummaryService.saveOrUpdateBatch(entityList, entityList.size(), false);
            voList = BeanMapper.mapList((Iterable)entityList, PayContractSummaryVO.class);
            List ids = voList.stream().map(BaseVO::getId).collect(Collectors.toList());
            wrapper.notIn(!ids.isEmpty(), (Object)"id", ids);
        }
        this.payContractSummaryService.remove((Wrapper)wrapper, false);
        return voList;
    }

    private List<PayInvoiceVO> updateInvoiceVOS(PayContractVO vo, Long id) {
        List voList = vo.getInvoiceVOList();
        if (voList != null && !voList.isEmpty()) {
            for (PayInvoiceVO invoiceVO : voList) {
                invoiceVO.setPayapplyId(id);
            }
            List entityList = BeanMapper.mapList((Iterable)voList, PayInvoiceEntity.class);
            this.invoiceService.saveOrUpdateBatch(entityList, entityList.size(), false);
            voList = BeanMapper.mapList((Iterable)entityList, PayInvoiceVO.class);
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"payapply_id", (Object)id);
        if (CollectionUtils.isNotEmpty((Collection)voList)) {
            List ids = voList.stream().map(BaseVO::getId).collect(Collectors.toList());
            wrapper.notIn(!ids.isEmpty(), (Object)"id", ids);
        }
        this.invoiceService.remove((Wrapper)wrapper, false);
        return voList;
    }

    private List<PayContractDeductionVO> updateDeductionVOS(PayContractVO vo, Long id) {
        List vos = vo.getDeductionVOList();
        if (CollectionUtils.isNotEmpty((Collection)vos)) {
            for (PayContractDeductionVO deductionVO : vos) {
                deductionVO.setPayapplyId(id);
            }
            List entityList = BeanMapper.mapList((Iterable)vos, PayContractDeductionEntity.class);
            boolean updateBatch = this.contractDeductionService.saveOrUpdateBatch(entityList);
            vos = BeanMapper.mapList((Iterable)entityList, PayContractDeductionVO.class);
            if (updateBatch) {
                List<Long> dedIds = vos.stream().map(PayContractDeductionVO::getDeductionId).collect(Collectors.toList());
                this.updateDeductionUseFlag(dedIds, 1);
            }
            List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"payapply_id", (Object)id);
            wrapper.notIn(!ids.isEmpty(), (Object)"id", ids);
            List oldList = this.contractDeductionService.list((Wrapper)wrapper);
            if (CollectionUtils.isNotEmpty((Collection)oldList)) {
                List<Long> oldDedIds = oldList.stream().map(PayContractDeductionEntity::getDeductionId).collect(Collectors.toList());
                this.updateDeductionUseFlag(oldDedIds, 0);
                this.contractDeductionService.remove((Wrapper)wrapper, false);
            }
        } else {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"payapply_id", (Object)id);
            List oldList = this.contractDeductionService.list((Wrapper)wrapper);
            if (CollectionUtils.isNotEmpty((Collection)oldList)) {
                List<Long> oldDedIds = oldList.stream().map(PayContractDeductionEntity::getDeductionId).collect(Collectors.toList());
                this.updateDeductionUseFlag(oldDedIds, 0);
                this.contractDeductionService.remove((Wrapper)wrapper, false);
            }
        }
        return vos;
    }

    private List<PayContractSettleVO> updateSettleVOS(PayContractVO vo, Long id) {
        List vos = vo.getSettleVOList();
        if (vos != null && !vos.isEmpty()) {
            String billTypeCode = BillTypeCodeEnum.getSettleBillTypeCode((Long)vo.getContractType());
            for (PayContractSettleVO settleVO : vos) {
                if (!ValidateUtil.validateUpstreamVersion((String)String.valueOf(settleVO.getSettleId()), (String)billTypeCode, (Integer)settleVO.getSettleVersion()).booleanValue()) {
                    throw new BusinessException("\u7ed3\u7b97\u5355\u5df2\u88ab\u66f4\u65b0\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u505a\uff01");
                }
                settleVO.setPayapplyId(id);
            }
            List entityList = BeanMapper.mapList((Iterable)vos, PayContractSettleEntity.class);
            this.settleService.saveOrUpdateBatch(entityList, entityList.size(), false);
            vos = BeanMapper.mapList((Iterable)entityList, PayContractSettleVO.class);
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"payapply_id", (Object)id);
        if (CollectionUtils.isNotEmpty((Collection)vos)) {
            List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
            wrapper.notIn(!ids.isEmpty(), (Object)"id", ids);
        }
        this.settleService.remove((Wrapper)wrapper, false);
        return vos;
    }

    @Override
    public boolean writeBackSumPayMny(Long billId, PayContractEntity entity, boolean flag) {
        BigDecimal payMny = flag ? entity.getPayMny() : MathUtil.safeSub((BigDecimal)new BigDecimal(0), (BigDecimal)entity.getPayMny());
        BigDecimal prepayMny = entity.getFeeType() == 1L ? payMny : BigDecimal.ZERO;
        List settleEntityList = this.settleService.list((Wrapper)new QueryWrapper().eq((Object)"payapply_id", (Object)billId));
        HashMap<Long, BigDecimal> settlePayMnyMap = new HashMap<Long, BigDecimal>();
        for (PayContractSettleEntity settleEntity : settleEntityList) {
            BigDecimal settlePayMny = flag ? settleEntity.getSumPayMny() : MathUtil.safeSub((BigDecimal)new BigDecimal(0), (BigDecimal)settleEntity.getSumPayMny());
            settlePayMnyMap.put(settleEntity.getSettleId(), ComputeUtil.nullToZero((BigDecimal)settlePayMny));
        }
        if (entity.getContractType() == 1L) {
            this.subApi.updateSubContractSumPayMny(entity.getContractId(), payMny, prepayMny);
            for (PayContractSettleEntity settleEntity : settleEntityList) {
                this.subApi.updateSubSettleSumPayMny(settleEntity.getSettleId(), (BigDecimal)settlePayMnyMap.get(settleEntity.getSettleId()));
            }
        }
        if (entity.getContractType() == 2L) {
            this.equipmentApi.updatePurchaseContractSumPayMny(entity.getContractId(), payMny, prepayMny);
            for (PayContractSettleEntity settleEntity : settleEntityList) {
                this.equipmentApi.updatePurchaseSettleSumPayMny(settleEntity.getSettleId(), (BigDecimal)settlePayMnyMap.get(settleEntity.getSettleId()));
            }
        }
        if (entity.getContractType() == 3L) {
            this.equipmentApi.updateRentContractSumPayMny(entity.getContractId(), payMny, prepayMny);
            for (PayContractSettleEntity settleEntity : settleEntityList) {
                this.equipmentApi.updateRentSettleSumPayMny(settleEntity.getSettleId(), (BigDecimal)settlePayMnyMap.get(settleEntity.getSettleId()));
            }
        }
        if (entity.getContractType() == 4L) {
            for (PayContractSettleEntity settleEntity : settleEntityList) {
                this.materialApi.updateSettlementBillAlreadyPaidAmount(settleEntity.getSettleId(), (BigDecimal)settlePayMnyMap.get(settleEntity.getSettleId()));
            }
        }
        if (entity.getContractType() == 5L) {
            this.rmatContractApi.updateRentContractSumPayMny(entity.getContractId(), payMny, prepayMny);
            for (PayContractSettleEntity settleEntity : settleEntityList) {
                this.rmatContractApi.updateRentSettleSumPayMny(settleEntity.getSettleId(), (BigDecimal)settlePayMnyMap.get(settleEntity.getSettleId()));
            }
        }
        if (entity.getContractType() == 6L) {
            this.otherContractApi.updateOtherContractSumPayMny(entity.getContractId(), payMny, prepayMny);
            for (PayContractSettleEntity settleEntity : settleEntityList) {
                this.otherContractApi.updateOtherSettleSumPayMny(settleEntity.getSettleId(), (BigDecimal)settlePayMnyMap.get(settleEntity.getSettleId()));
            }
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void autoSetBillCode(PayContractEntity entity) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (StringUtils.isEmpty((String)entity.getBillCode()) && entity.getContractType() == 1L) {
            CommonResponse commonResponse = this.billCodeApi.getCodeBatchByRuleCode(PAY_CONTRACT_BILL_CODE, tenantId);
            if (!commonResponse.isSuccess()) throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            entity.setBillCode((String)commonResponse.getData());
        } else if (StringUtils.isEmpty((String)entity.getBillCode()) && entity.getContractType() == 4L) {
            String string = this.generateCode();
            entity.setBillCode(string);
        }
        LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery();
        lambdaQueryWrapper.eq(PayContractEntity::getBillCode, (Object)entity.getBillCode());
        lambdaQueryWrapper.eq(BaseEntity::getTenantId, (Object)tenantId);
        lambdaQueryWrapper.ne(entity.getId() != null && entity.getId() > 0L, BaseEntity::getId, (Object)entity.getId());
        List entityList = super.list((Wrapper)lambdaQueryWrapper);
        if (entityList == null || entityList.size() <= 0) return;
        throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
    }

    private static Date getTime(String limit) {
        Calendar cal = Calendar.getInstance();
        cal.add(2, 0);
        if ("min".equals(limit)) {
            cal.set(cal.get(1), cal.get(2), cal.getActualMinimum(5), 0, 0, 0);
        } else if ("max".equals(limit)) {
            cal.set(cal.get(1), cal.get(2), cal.getActualMaximum(5), 23, 59, 59);
        }
        return cal.getTime();
    }

    private void transformReimburse(QueryParam param) {
        String value;
        Parameter feeType = (Parameter)param.getParams().get("feeType");
        if (!Objects.equals(feeType, null) && StringUtils.contains((String)(value = feeType.getValue().toString()), (String)"\u62a5\u9500-")) {
            CommonResponse listCommonResponse = this.defdocApi.getDefDocByDefId(FinancePubConsts.COST_TYPE);
            List data = (List)listCommonResponse.getData();
            Object[] split = value.split(",");
            for (int i = 0; i < split.length; ++i) {
                String feeTypeName = split[i];
                if (!StringUtils.contains((String)feeTypeName, (String)"\u62a5\u9500-")) continue;
                List list = data.stream().filter(vo -> vo.getName().equals(feeTypeName.substring(3))).collect(Collectors.toList());
                split[i] = ((DefdocDetailVO)list.get(0)).getId().toString();
            }
            value = StringUtils.join((Object[])split, (String)",");
            feeType.setValue((Object)value);
        }
    }

    @Override
    public void closePayment(Long id) {
        Assert.notNull((Object)id, (String)"\u4ed8\u6b3e\u7533\u8bf7id\u4e0d\u80fd\u4e3a\u7a7a");
        PayContractEntity entity = (PayContractEntity)((Object)super.selectById((Serializable)id));
        if (entity == null) {
            throw new BusinessException("\u4ed8\u6b3e\u7533\u8bf7\u4e0d\u5b58\u5728");
        }
        entity.setApplyMnyBeforeClose(entity.getApplyMny());
        entity.setApplyMny(entity.getPayMny());
        entity.setApplyMnyCn(NumberToCN.number2CN(entity.getApplyMny()));
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(PayContractSettleEntity::getPayapplyId, (Object)id);
        List list = this.settleService.list((Wrapper)wrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            list.forEach(settle -> {
                settle.setBodyApplyMnyBeforeClose(settle.getBodyApplyMny());
                settle.setBodyApplyMny(settle.getSumPayMny());
            });
            this.settleService.updateBatchById(list);
        }
        entity.setCloseFlag(Boolean.TRUE);
        entity.setCloseState("\u5df2\u5173\u95ed");
        entity.setCloseTime(new Date());
        entity.setCloseUser(this.sessionManager.getUserContext().getUserName());
        super.updateById((Object)entity);
        this.writeBackSumApplyMny(id, entity, false);
    }

    @Override
    public ProjectFinancePayVO getProjectApplyPayInfo(Long projectId) {
        return ((PayContractMapper)this.baseMapper).getProjectApplyPayInfo(projectId);
    }

    @Override
    public Map<Long, BigDecimal> getApplyMnyHasFree(List<Long> settleIds, Long id) {
        List<PayContractSettleVO> settleVOList = ((PayContractMapper)this.baseMapper).getApplyMnyHasFree(settleIds, id);
        Map<Long, BigDecimal> map = new HashMap<Long, BigDecimal>();
        if (CollectionUtils.isNotEmpty(settleVOList)) {
            map = settleVOList.stream().collect(Collectors.toMap(PayContractSettleVO::getSettleId, PayContractSettleVO::getSumApplyMny));
        }
        return map;
    }

    @Override
    public ParamsCheckVO checkParamsToLabor(PayContractVO vo) {
        Long curOrgId = Optional.ofNullable(vo.getOrgId()).orElse(InvocationInfoProxy.getOrgId());
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        HashMap<String, List<ParamsCheckDsVO>> paramsCheckVOMap = new HashMap<String, List<ParamsCheckDsVO>>();
        paramsCheckVOMap.put("alert", new ArrayList());
        paramsCheckVOMap.put("warn", new ArrayList());
        CommonResponse response = this.paramConfigApi.getBillParamByCodeAndOrgId(CHECK_LABOR_APPLY, curOrgId);
        if (!response.isSuccess()) {
            this.logger.info(response.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        List billParamVOS = (List)response.getData();
        BudgetProjectProParamControlVO proParamControlVO = new BudgetProjectProParamControlVO();
        proParamControlVO.setProjectId(vo.getProjectId());
        proParamControlVO.setCostType(Integer.valueOf(2));
        CommonResponse responseBudge = this.budgetProjectProApi.fetchQuantityAndMny(proParamControlVO);
        if (CollectionUtils.isNotEmpty((Collection)billParamVOS) && responseBudge.getData() != null) {
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("projectId", new Parameter("eq", (Object)vo.getProjectId()));
            queryParam.getParams().put("salaryFlag", new Parameter("eq", (Object)1));
            queryParam.getParams().put("dr", new Parameter("eq", (Object)0));
            if (null != vo.getId()) {
                queryParam.getParams().put("id", new Parameter("ne", (Object)vo.getId()));
            }
            List payContractEntities = super.queryList(queryParam);
            List paySporadicEntities = this.sporadicService.queryList(queryParam);
            BigDecimal sumApplyMny = BigDecimal.ZERO;
            if (CollectionUtils.isNotEmpty((Collection)payContractEntities)) {
                sumApplyMny = payContractEntities.stream().filter(v -> null != v.getApplyMny()).map(PayContractEntity::getApplyMny).reduce(sumApplyMny, BigDecimal::add);
            }
            if (CollectionUtils.isNotEmpty((Collection)paySporadicEntities)) {
                sumApplyMny = paySporadicEntities.stream().filter(v -> null != v.getApplyMny()).map(PaySporadicEntity::getApplyMny).reduce(sumApplyMny, BigDecimal::add);
            }
            for (BillParamVO billParamVO : billParamVOS) {
                BigDecimal laborTaxMny;
                BigDecimal _laborTaxMny;
                BigDecimal roleValue = billParamVO.getRoleValue();
                BigDecimal sumApplyMnyhavThis = ComputeUtil.safeAdd((BigDecimal)sumApplyMny, (BigDecimal)vo.getApplyMny());
                if (sumApplyMnyhavThis.compareTo(_laborTaxMny = (laborTaxMny = ((BudgetProjectProQuantityAndMnyVO)responseBudge.getData()).getLaborTaxMny()).multiply(roleValue.divide(BigDecimal.valueOf(100L)))) <= 0) continue;
                ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                paramsCheckDsVO.setWarnItem("\u52b3\u52a1\u5de5\u8d44\u7533\u8bf7\u603b\u91d1\u989d\u8d85\u989d");
                paramsCheckDsVO.setWarnName("\u9884\u7b97\u4eba\u5de5\u8d39\u603b\u91d1\u989d\u63a7\u52b3\u52a1\u5de5\u8d44\u7533\u8bf7\u603b\u91d1\u989d");
                paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("\u672c\u6b21\u7533\u8bf7\u91d1\u989d\uff1a").append(ComputeUtil.nullToZero((BigDecimal)vo.getApplyMny()).setScale(2, 4)).append("\u5143\uff0c\u7d2f\u8ba1\u7533\u8bf7\u91d1\u989d\uff1a").append(sumApplyMnyhavThis.setScale(2, 4)).append("\u5143\uff0c\u9879\u76ee\u9884\u7b97\u4eba\u5de5\u8d39\u603b\u91d1\u989d*").append(roleValue.setScale(2, 4)).append("%\uff1a").append(_laborTaxMny.setScale(2, 4)).append("\u5143\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(ComputeUtil.safeSub((BigDecimal)sumApplyMnyhavThis, (BigDecimal)_laborTaxMny).setScale(2, 4)).append("\u5143");
                paramsCheckDsVO.setContent(stringBuffer.toString());
                PayContractServiceImpl.updateParamsCheckVOMap(paramsArray, paramsCheckVOMap, billParamVO, paramsCheckDsVO);
            }
        }
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        if (CollectionUtils.isNotEmpty((Collection)((Collection)paramsCheckVOMap.get("alert")))) {
            paramsCheckVO.setWarnType("alert");
            paramsCheckVO.setDataSource((List)paramsCheckVOMap.get("alert"));
        } else if (CollectionUtils.isNotEmpty((Collection)((Collection)paramsCheckVOMap.get("warn")))) {
            paramsCheckVO.setWarnType("warn");
            paramsCheckVO.setDataSource((List)paramsCheckVOMap.get("warn"));
        } else {
            paramsCheckVO.setWarnType("none");
            paramsCheckVO.setDataSource(null);
        }
        return paramsCheckVO;
    }

    public boolean writeBackSumApplyMny(Long billId, PayContractEntity entity, boolean flag) {
        List settleEntityList = this.settleService.list((Wrapper)new QueryWrapper().eq((Object)"payapply_id", (Object)billId));
        HashMap<Long, BigDecimal> settleApplyMnyMap = new HashMap<Long, BigDecimal>();
        for (PayContractSettleEntity settleEntity : settleEntityList) {
            BigDecimal applyMny = flag ? settleEntity.getBodyApplyMny() : MathUtil.safeSub((BigDecimal)settleEntity.getBodyApplyMny(), (BigDecimal)settleEntity.getBodyApplyMnyBeforeClose());
            settleApplyMnyMap.put(settleEntity.getSettleId(), applyMny);
        }
        if (entity.getContractType() == 1L) {
            for (PayContractSettleEntity settleEntity : settleEntityList) {
                this.subApi.updateSubSettleSumApplyMny(settleEntity.getSettleId(), (BigDecimal)settleApplyMnyMap.get(settleEntity.getSettleId()));
            }
        }
        if (entity.getContractType() == 2L) {
            for (PayContractSettleEntity settleEntity : settleEntityList) {
                this.equipmentApi.updatePurchaseSettleSumApplyMny(settleEntity.getSettleId(), (BigDecimal)settleApplyMnyMap.get(settleEntity.getSettleId()));
            }
        }
        if (entity.getContractType() == 3L) {
            for (PayContractSettleEntity settleEntity : settleEntityList) {
                this.equipmentApi.updateRentSettleSumApplyMny(settleEntity.getSettleId(), (BigDecimal)settleApplyMnyMap.get(settleEntity.getSettleId()));
            }
        }
        if (entity.getContractType() == 4L) {
            for (PayContractSettleEntity settleEntity : settleEntityList) {
                this.materialApi.updateSettlementBillAlreadyApplyAmount(settleEntity.getSettleId(), (BigDecimal)settleApplyMnyMap.get(settleEntity.getSettleId()));
            }
        }
        if (entity.getContractType() == 5L) {
            for (PayContractSettleEntity settleEntity : settleEntityList) {
                this.rmatContractApi.updateRentSettleSumApplyMny(settleEntity.getSettleId(), (BigDecimal)settleApplyMnyMap.get(settleEntity.getSettleId()));
            }
        }
        if (entity.getContractType() == 6L) {
            for (PayContractSettleEntity settleEntity : settleEntityList) {
                this.otherContractApi.updateOtherSettleSumApplyMny(settleEntity.getSettleId(), (BigDecimal)settleApplyMnyMap.get(settleEntity.getSettleId()));
            }
        }
        return true;
    }

    public PSRMResponse saveOrUpdatePsrmObj(PayContractVO vo) {
        String signDate = DateUtil.format(Optional.ofNullable(vo.getApproveTime()).orElse(new Date()), "yyyy-MM-dd");
        JSONObject obj = new JSONObject();
        obj.put("f_synccode", (Object)vo.getBillCode());
        obj.put("f_status", (Object)"Y");
        obj.put("f_date", (Object)signDate);
        obj.put("f_engineeringcode", (Object)vo.getProjectCode());
        obj.put("f_accountingtype", (Object)"Supplier");
        try {
            JSONArray jArray;
            if (vo.getReceiveUnitId() != null && (jArray = ReferObjectUtil.getReferEntityValue((String)String.valueOf(vo.getReceiveUnitId()), (String)"support-supplier")) != null && jArray.size() > 0) {
                JSONObject json = (JSONObject)jArray.get(0);
                obj.put("f_accountingcode", (Object)json.getString("code"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        obj.put("f_bank", (Object)vo.getAccountBank());
        obj.put("f_bankcode", (Object)vo.getAccountNum());
        obj.put("f_bankname", (Object)vo.getAccountName());
        obj.put("f_amount", (Object)vo.getApplyMny());
        obj.put("f_paymenttypetext", (Object)vo.getContent());
        obj.put("f_explanation", (Object)vo.getFeeKindName());
        obj.put("f_contractbillno", (Object)vo.getContractCode());
        obj.put("f_empname", (Object)vo.getApplyUserName());
        obj.put("f_synccreator", (Object)vo.getCreateUserName());
        UserContext userContext = this.sessionManager.getUserContext();
        obj.put("f_syncauditor", (Object)userContext.getUserName());
        return this.psrmRestUtil.postReq((Object)obj, this.getSaveMethodName());
    }

    public String getSaveMethodName() {
        return "dmp.paymentrequest.add";
    }

    public String getUpdateMethodName() {
        return null;
    }

    @Override
    public List<InstoreMaterialVO> queryInstoreMaterialById(Long contractId) {
        return ((PayContractMapper)this.baseMapper).queryInstoreMaterialById(contractId);
    }

    @Override
    public BigDecimal queryWeeklyProgressByProjectId(Long projectId) {
        return ((PayContractMapper)this.baseMapper).queryWeeklyProgressByProjectId(projectId);
    }

    @Override
    public BigDecimal queryTotalAmountByContractIds(List<Long> contractIds) {
        if (contractIds == null || contractIds.isEmpty()) {
            return BigDecimal.ZERO;
        }
        return ((PayContractMapper)this.baseMapper).queryTotalAmountByContractIds(contractIds);
    }

    @Override
    public BigDecimal queryCertificateSupplierId(Long supplierId, Long projectId) {
        return ((PayContractMapper)this.baseMapper).queryCertificateSupplierId(supplierId, projectId);
    }

    public String generateCode() {
        String validPrefix = "x";
        Calendar calendar = Calendar.getInstance();
        int currentYear = calendar.get(1);
        int yearOffset = currentYear - 2019;
        if (yearOffset < 0 || yearOffset >= 26) {
            throw new RuntimeException("\u5e74\u4efd\u8d85\u51fa\u5b57\u6bcd\u8868\u793a\u8303\u56f4\uff08\u652f\u63012019-2044\uff09");
        }
        char yearLetter = (char)(97 + yearOffset);
        int month = calendar.get(2) + 1;
        String monthStr = String.format("%02d", month);
        String codePrefix = validPrefix + yearLetter + monthStr;
        return this.generateUniqueCode(codePrefix);
    }

    private String generateUniqueCode(String codePrefix) {
        int serialNumber = this.getMaxSerialNumber(codePrefix) + 1;
        String candidateCode;
        while (this.isCodeExists(candidateCode = codePrefix + "-" + serialNumber)) {
            ++serialNumber;
        }
        return candidateCode;
    }

    private int getMaxSerialNumber(String code) {
        Integer maxSerial = ((PayContractMapper)this.baseMapper).queryMaxSerialNumber(code);
        return maxSerial == null ? 0 : maxSerial;
    }

    private boolean isCodeExists(String code) {
        Integer count = ((PayContractMapper)this.baseMapper).isCodeExists(code);
        return count != null && count > 0;
    }
}

