/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.bank.bean.BankAcctEntity;
import com.ejianc.business.bank.consts.BankFlowSourceType;
import com.ejianc.business.bank.service.IBankAcctService;
import com.ejianc.business.bank.service.IBankFlowService;
import com.ejianc.business.bank.vo.BankFlowVO;
import com.ejianc.business.finance.bean.BidBondDealEntity;
import com.ejianc.business.finance.bean.BidBondEntity;
import com.ejianc.business.finance.mapper.BidBondDealMapper;
import com.ejianc.business.finance.service.IBidBondDealService;
import com.ejianc.business.finance.service.IBidBondService;
import com.ejianc.business.finance.vo.BidBondDealVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="bidBondDealService")
public class BidBondDealServiceImpl
extends BaseServiceImpl<BidBondDealMapper, BidBondDealEntity>
implements IBidBondDealService {
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "BIDBOND_DEL";
    @Autowired
    private IBidBondDealService service;
    @Autowired
    private IBidBondService bidBondService;
    @Autowired
    private IBankFlowService bankFlowService;
    @Autowired
    private IBankAcctService bankAcctService;

    @Override
    public BidBondDealVO insertOrUpdate(BidBondDealVO saveOrUpdateVO) {
        LambdaQueryWrapper lambda;
        BidBondDealEntity entity = (BidBondDealEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, BidBondDealEntity.class));
        if (StringUtils.isEmpty((CharSequence)saveOrUpdateVO.getBillCode())) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        List entities = null;
        if (null != saveOrUpdateVO.getId() && saveOrUpdateVO.getId() > 0L) {
            lambda = new LambdaQueryWrapper();
            lambda.eq(BidBondDealEntity::getBillCode, (Object)saveOrUpdateVO.getBillCode());
            lambda.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
            lambda.ne(BaseEntity::getId, (Object)saveOrUpdateVO.getId());
            entities = super.list((Wrapper)lambda);
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)entity.getId());
            updateWrapper.set(BidBondDealEntity::getDealStatus, (Object)"2");
            super.update((Wrapper)updateWrapper);
            this.bankFlowService.delFlowBySource(entity.getId(), entity.getBondId());
            entity.setId(null);
        } else {
            lambda = new LambdaQueryWrapper();
            lambda.eq(BaseEntity::getTenantId, (Object)InvocationInfoProxy.getTenantid());
            lambda.eq(BidBondDealEntity::getBillCode, (Object)saveOrUpdateVO.getBillCode());
            entities = super.list((Wrapper)lambda);
        }
        if (entities != null && entities.size() > 0) {
            throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        entity.setDealStatus("1");
        entity.setDealTime(new Date());
        this.service.saveOrUpdate((Object)entity, false);
        BidBondEntity bidBondEntity = (BidBondEntity)((Object)this.bidBondService.selectById(entity.getBondId()));
        BankAcctEntity bankAcctEntity = (BankAcctEntity)((Object)this.bankAcctService.selectById(entity.getPayAccountId()));
        BankFlowVO flowVO = BankFlowVO.instanceVOBySourceType((BankFlowSourceType)BankFlowSourceType.\u6295\u6807\u4fdd\u8bc1\u91d1\u652f\u4ed8);
        flowVO.setBillDate(new Date());
        flowVO.setSourceId(entity.getId());
        flowVO.setBillId(entity.getBondId());
        flowVO.setPayMoney(entity.getBondMny());
        flowVO.setBillCode(entity.getBillCode());
        flowVO.setOrgId(bidBondEntity.getOrgId());
        flowVO.setOrgName(bidBondEntity.getOrgName());
        if (null != bankAcctEntity) {
            flowVO.setAccountOrgId(bankAcctEntity.getOrgId());
            flowVO.setAccountOrgName(bankAcctEntity.getOrgName());
        }
        flowVO.setAccountId(entity.getPayAccountId());
        flowVO.setAccountName(entity.getPayAccountName());
        flowVO.setAccountBank(entity.getPayAccountBank());
        flowVO.setAccountNum(entity.getPayAccountNum());
        flowVO.setTradeOrgId(bidBondEntity.getCustomerId());
        flowVO.setTradeOrgName(bidBondEntity.getCustomerName());
        flowVO.setTradeAccountName(bidBondEntity.getAccountName());
        flowVO.setTradeAccountBank(bidBondEntity.getBankName());
        flowVO.setTradeAccountNum(bidBondEntity.getBankAccount());
        flowVO.setMemo(entity.getMemo());
        this.bankFlowService.saveFlowVO(flowVO);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)entity.getBondId());
        updateWrapper.set(BidBondEntity::getBondStatus, (Object)"1");
        updateWrapper.set(BidBondEntity::getBeginDate, (Object)entity.getBeginDate());
        updateWrapper.set(BidBondEntity::getEndDate, (Object)entity.getEndDate());
        updateWrapper.set(BidBondEntity::getEmployeeId, (Object)entity.getEmployeeId());
        updateWrapper.set(BidBondEntity::getEmployeeName, (Object)entity.getEmployeeName());
        updateWrapper.set(BidBondEntity::getPayMny, (Object)entity.getBondMny());
        updateWrapper.set(BidBondEntity::getDealTime, (Object)entity.getDealTime());
        updateWrapper.set(BidBondEntity::getPayState, (Object)1);
        updateWrapper.set(BidBondEntity::getInvoiceState, (Object)(ComputeUtil.isGreaterThan((BigDecimal)ComputeUtil.nullToZero((BigDecimal)entity.getInvoiceMny()), (BigDecimal)BigDecimal.ZERO) ? 1 : 0));
        updateWrapper.set(BidBondEntity::getInvoiceMny, (Object)ComputeUtil.nullToZero((BigDecimal)entity.getInvoiceMny()));
        this.bidBondService.update((Wrapper)updateWrapper);
        return (BidBondDealVO)BeanMapper.map((Object)((Object)entity), BidBondDealVO.class);
    }
}

