package com.ejianc.business.finance.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.labor.api.IProjectTeamApi;
import com.ejianc.business.labor.vo.SalarySlipVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.finance.bean.PayRecordSalaryGrantEntity;
import com.ejianc.business.finance.service.IPayRecordSalaryGrantService;
import com.ejianc.business.finance.vo.PayRecordSalaryGrantVO;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 工人工资发放记录子表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("payRecordSalaryGrant")
public class PayRecordSalaryGrantController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IPayRecordSalaryGrantService service;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IEmployeeApi employeeApi;
    @Autowired
    private IProjectTeamApi projectTeamApi;
    @Value("${oms.fileServerPath}")
    private String baseImgUrl;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PayRecordSalaryGrantVO> saveOrUpdate(@RequestBody PayRecordSalaryGrantVO saveOrUpdateVO) {
    	PayRecordSalaryGrantEntity entity = BeanMapper.map(saveOrUpdateVO, PayRecordSalaryGrantEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	PayRecordSalaryGrantVO vo = BeanMapper.map(entity, PayRecordSalaryGrantVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PayRecordSalaryGrantVO> queryDetail(Long id) {
    	PayRecordSalaryGrantEntity entity = service.selectById(id);
    	PayRecordSalaryGrantVO vo = BeanMapper.map(entity, PayRecordSalaryGrantVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PayRecordSalaryGrantVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (PayRecordSalaryGrantVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(PayRecordSalaryGrantVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PayRecordSalaryGrantVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("workerName");
        fuzzyFields.add("idCard");
        fuzzyFields.add("teamName");
        /** 租户隔离 */
        String salaryMonth=null;
        Map<String, Parameter> params = param.getParams();
        if (params.containsKey("salaryMonth")){
            salaryMonth = (String)params.get("salaryMonth").getValue();
            String[] split = salaryMonth.split("-");
            salaryMonth=split[0]+"-"+split[1];
            param.getParams().remove("salaryMonth");
        }
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        QueryWrapper wrapper = changeToQueryWrapper(param);
        Page<PayRecordSalaryGrantVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        List<PayRecordSalaryGrantVO> list = service.querySalaryGrantVOPage(wrapper,salaryMonth,page);
        if (CollectionUtils.isNotEmpty(list)){
            for (PayRecordSalaryGrantVO payRecordSalaryGrantVO : list) {
                payRecordSalaryGrantVO.setBaseImgUrl(baseImgUrl);
            }
        }
        page.setTotal(page.getTotal());
        page.setRecords(list);
        return CommonResponse.success("查询列表数据成功！",page);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("workerName");
        fuzzyFields.add("idCard");
        fuzzyFields.add("teamName");
        /** 租户隔离 */
        String salaryMonth=null;
        Map<String, Parameter> params = param.getParams();
        if (params.containsKey("salaryMonth")){
            salaryMonth = (String)params.get("salaryMonth").getValue();
            String[] split = salaryMonth.split("-");
            salaryMonth=split[0]+"-"+split[1];
            param.getParams().remove("salaryMonth");
        }
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<PayRecordSalaryGrantVO> list = service.querySalaryGrantVOPage(wrapper,salaryMonth,null);
        if (CollectionUtils.isNotEmpty(list)){
            for (PayRecordSalaryGrantVO payRecordSalaryGrantVO : list) {
                payRecordSalaryGrantVO.setBaseImgUrl(baseImgUrl);
                if (payRecordSalaryGrantVO.getAckFlag()==1){
                    payRecordSalaryGrantVO.setAckFlagName("已确认");
                }else {
                    payRecordSalaryGrantVO.setAckFlagName("未确认");
                }
            }
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("PayRecordSalaryGrant-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refPayRecordSalaryGrantData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<PayRecordSalaryGrantVO>> refPayRecordSalaryGrantData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<PayRecordSalaryGrantEntity> page = service.queryPage(param,false);
        IPage<PayRecordSalaryGrantVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PayRecordSalaryGrantVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }




    /**
     * @Description querySalarySlipList 查询工资发放移- 内部人员的 动端列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryProjectSalaryGrantList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PayRecordSalaryGrantVO>> queryProjectSalaryGranList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("workerName");
        fuzzyFields.add("idCard");
        fuzzyFields.add("teamName");
        /** 租户隔离 */
        String salaryMonth=null;
        Map<String, Parameter> params = param.getParams();
        if (params.containsKey("salaryMonth")){
            salaryMonth = (String)params.get("salaryMonth").getValue();
            String[] split = salaryMonth.split("-");
            salaryMonth=split[0]+"-"+split[1];
            param.getParams().remove("salaryMonth");
        }
        Long projectId=null;
        if (params.containsKey("projectId")){
            projectId = Long.parseLong((String)params.get("projectId").getValue());
            param.getParams().remove("projectId");
        }else {
            return CommonResponse.error("项目id不能为空！");
        }
        Page<PayRecordSalaryGrantVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        param.getParams().put("project_id",new Parameter(QueryParam.EQ,projectId));
        QueryWrapper wrapper = changeToQueryWrapper(param);
        wrapper.isNotNull("worker_id");
        List<PayRecordSalaryGrantVO> list = service.querySalaryGrantVOPage(wrapper,salaryMonth,page);
        page.setTotal(page.getTotal());
        page.setRecords(list);
        return CommonResponse.success("查询列表数据成功！",page);
    }

    /**
     * @Description querySalarySlipList 查询工资条移- 班组长 动端列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryTeamSalarySlipList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PayRecordSalaryGrantVO>> queryTeamSalarySlipList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("workerName");
        fuzzyFields.add("idCard");
        fuzzyFields.add("teamName");

        String phone=null;
        Long userId = sessionManager.getUserContext().getUserId();
        CommonResponse<EmployeeVO> commonResponse = employeeApi.getById(userId);
        if (commonResponse.isSuccess() && commonResponse.getData()!=null){
            EmployeeVO employeeVO = commonResponse.getData();
            phone = employeeVO.getMobilePhone();
        }
        /** 租户隔离 */
        Map<String, Parameter> params = param.getParams();
        Long projectId=null;
        if (params.containsKey("projectId")){
            projectId = Long.parseLong(params.get("projectId").getValue().toString());
            param.getParams().remove("projectId");
        }
        String salaryMonth=null;
        if (params.containsKey("salaryMonth")){
            salaryMonth = (String)params.get("salaryMonth").getValue();
            String[] split = salaryMonth.split("-");
            salaryMonth=split[0]+"-"+split[1];
            param.getParams().remove("salaryMonth");
        }
        Page<PayRecordSalaryGrantVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        //先根据项目花名册查询班组长的人员id
        CommonResponse<List<Long>> listCommonResponse = projectTeamApi.queryTeamWorkerIdByPhone(phone,projectId);
        if (listCommonResponse.isSuccess() && listCommonResponse.getData()!=null){
           List<Long> workerIds= listCommonResponse.getData();
            if (CollectionUtils.isNotEmpty(workerIds)){
                QueryWrapper wrapper = changeToQueryWrapper(param);
                List<PayRecordSalaryGrantVO> list = service.queryTeamSalaryGrantList(wrapper,salaryMonth,page,workerIds);
                page.setTotal(page.getTotal());
                page.setRecords(list);
            }
        }
        return CommonResponse.success("查询列表数据成功！",page);
    }

    /**
     * @Description querySalarySlipList 查询工资发放- 工人人 动端列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryWorkerSalaryGranList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PayRecordSalaryGrantVO>> queryWorkerSalaryGranList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("workerName");
        fuzzyFields.add("idCard");
        fuzzyFields.add("teamName");
        fuzzyFields.add("shouldSalaryMny");
        /** 租户隔离 */
        Map<String, Parameter> params = param.getParams();
        String phone=null;
        if (params.containsKey("phone")){
            phone = params.get("phone").getValue().toString();
            param.getParams().remove("phone");
        }
        String salaryMonth=null;
        if (params.containsKey("salaryMonth")){
            salaryMonth = (String)params.get("salaryMonth").getValue();
            String[] split = salaryMonth.split("-");
            salaryMonth=split[0]+"-"+split[1];
            param.getParams().remove("salaryMonth");
        }
        Page<PayRecordSalaryGrantVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        //先根据项目花名册查询人员id
        CommonResponse<List<Long>> listCommonResponse = projectTeamApi.queryWorkerIdByPhone(phone);
        if (listCommonResponse.isSuccess() && listCommonResponse.getData()!=null){
            List<Long> workerIds = listCommonResponse.getData();
            if (CollectionUtils.isNotEmpty(workerIds)){
                param.getParams().put("worker_id",new Parameter(QueryParam.IN,workerIds));
                QueryWrapper wrapper = changeToQueryWrapper(param);
                List<PayRecordSalaryGrantVO> list = service.querySalaryGrantVOPage(wrapper,salaryMonth,page);
                page.setTotal(page.getTotal());
                page.setRecords(list);
            }
        }
        return CommonResponse.success("查询列表数据成功！",page);
    }

    /**
     * @Description ackSalary 工资发放确认
     */
    @RequestMapping(value = "/ackSalary", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PayRecordSalaryGrantVO> ackSalary(@RequestBody PayRecordSalaryGrantVO vo) {
        PayRecordSalaryGrantEntity payRecordSalaryGrantEntity = service.selectById(vo.getId());
        LambdaUpdateWrapper<PayRecordSalaryGrantEntity> salarySlipAckWrapper = new LambdaUpdateWrapper<>();
        salarySlipAckWrapper.eq(PayRecordSalaryGrantEntity::getId,vo.getId());
        salarySlipAckWrapper.set(PayRecordSalaryGrantEntity::getAckFlag,1);
        salarySlipAckWrapper.set(PayRecordSalaryGrantEntity::getAckTime,new Date());
        salarySlipAckWrapper.set(PayRecordSalaryGrantEntity::getLogonPeopleId,payRecordSalaryGrantEntity.getWorkerId());
        salarySlipAckWrapper.set(PayRecordSalaryGrantEntity::getLogonPeople,payRecordSalaryGrantEntity.getWorkerName());
        salarySlipAckWrapper.set(PayRecordSalaryGrantEntity::getFacePhotoId,vo.getFacePhotoId());
        salarySlipAckWrapper.set(PayRecordSalaryGrantEntity::getFacePhoto,vo.getFacePhoto());
        salarySlipAckWrapper.set(PayRecordSalaryGrantEntity::getSignPhotoId,vo.getSignPhotoId());
        salarySlipAckWrapper.set(PayRecordSalaryGrantEntity::getSignPhoto,vo.getSignPhoto());
        service.update(salarySlipAckWrapper);
        PayRecordSalaryGrantEntity entity = service.selectById(vo.getId());
        PayRecordSalaryGrantVO payRecordSalaryGrantVO = BeanMapper.map(entity, PayRecordSalaryGrantVO.class);
        return CommonResponse.success("工资发放确认成功！",payRecordSalaryGrantVO);
    }
    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/download")
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "payRecordSalaryGrant-import.xlsx", "工资发放导入模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/excelImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        CommonResponse<JSONObject> commonResponse=  service.excelImport(request,response);
        return commonResponse;
    }

}
