package com.ejianc.business.finance.service;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.finance.bean.BondUpEntity;
import com.ejianc.business.finance.vo.BondReportVO;
import com.ejianc.business.finance.vo.BondUpVO;
import com.ejianc.business.finance.vo.BondVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;

/**
 * <p>
 * 保证金对上申请表 服务类
 * </p>
 *
 * @author sunyj
 * @since 2020-06-16
 */
public interface IBondUpService extends IBaseService<BondUpEntity> {

    CommonResponse<BondUpVO> insertOrUpdate(BondUpVO bondUpEntityVO);

    BondUpVO queryDetail(Long id);

    List<BondVO> queryUnDealList(Page pages, QueryWrapper queryWrapper);

    BondReportVO queryBondReport(QueryWrapper queryWrapper);

    IPage<BondUpEntity> selectPage(Page pages, QueryWrapper queryWrapper);
}
