package com.ejianc.business.finance.service.impl;

import com.ejianc.business.cost.api.ICostDetailApi;
import com.ejianc.business.finance.bean.LoadReimburseEntity;
import com.ejianc.business.finance.service.ILoadReimburseService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service("loadReimburse")
public class LoadReimburseBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private ILoadReimburseService loadReimburseService;
	@Autowired
	private IBillTypeApi billTypeApi;
	@Autowired
	private ICostDetailApi costDetailApi;
	private Logger logger = LoggerFactory.getLogger(this.getClass());
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		//成本改造
		logger.info("借款报销审批后事件触发");
		logger.info("billId"+billId);
		LoadReimburseEntity loadReimburseEntity = loadReimburseService.selectById(billId);
		loadReimburseService.costPush(loadReimburseEntity);
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TO DO 结算单是否被其他引用
		CommonResponse<String>  res = billTypeApi.checkQuote(billTypeCode,billId);
		if(res.isSuccess()) {//单据未被下游单据引用
		}else{
			return CommonResponse.error(res.getMsg());
		}
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//成本改造
//        弃审前校验该结算单是否已经分摊，已分摊不允许撤回
		CommonResponse<String> commonResponse = costDetailApi.checkShareFlag(billId);
		if(!commonResponse.isSuccess()){
			return CommonResponse.error(commonResponse.getMsg());
		}


		//删除成本中心数据, 更新关联状态为未关联
		loadReimburseService.pullCost(billId);
		//TODO
		return CommonResponse.success();
	}

}
