package com.ejianc.business.bank.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 银行账户
 *
 * @author generator
 *
 */
@TableName("ejc_bank_acct")
public class BankAcctEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value = "org_id")
    private Long orgId; // 所属公司
    @TableField(value = "org_name")
    private String orgName; // 所属公司
    @TableField(value = "account_name")
    private String accountName; // 账户名称
    @TableField(value = "account_num")
    private String accountNum; // 银行账号
    @TableField(value = "account_bank")
    private String accountBank; // 开户行
    @TableField(value = "init_surplus_mny")
    private BigDecimal initSurplusMny; // 初始余额
    @TableField(value = "init_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date initDate; // 初始日期
    @TableField(value = "bill_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date billDate; // 创建日期
    @TableField(value = "state")
    private Boolean state; // 状态
    @TableField(value = "memo")
    private String memo; // 备注

    /**
     * 创建人
     */
    @TableField("employee_id")
    private Long employeeId;

    /**
     * 创建人
     */
    @TableField("employee_name")
    private String employeeName;


    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public Date getBillDate() {
        return billDate;
    }

    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public String getAccountNum() {
        return accountNum;
    }

    public void setAccountNum(String accountNum) {
        this.accountNum = accountNum;
    }

    public String getAccountBank() {
        return accountBank;
    }

    public void setAccountBank(String accountBank) {
        this.accountBank = accountBank;
    }

    public BigDecimal getInitSurplusMny() {
        return initSurplusMny;
    }

    public void setInitSurplusMny(BigDecimal initSurplusMny) {
        this.initSurplusMny = initSurplusMny;
    }

    public Date getInitDate() {
        return initDate;
    }

    public void setInitDate(Date initDate) {
        this.initDate = initDate;
    }

    public Boolean getState() {
        return state;
    }

    public void setState(Boolean state) {
        this.state = state;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

}
