/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.utils;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.CamelAndUnderLineConverter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;

public class ParamUtil {
    public static <T> String paramToString(Map<String, Parameter> params) {
        StringBuilder builder = new StringBuilder();
        builder.append("dr = 0");
        for (Map.Entry<String, Parameter> entry : params.entrySet()) {
            Parameter param = entry.getValue();
            String type = param.getType();
            String key = CamelAndUnderLineConverter.humpToLine((String)entry.getKey());
            switch (type) {
                case "eq": {
                    if (null == param.getValue()) {
                        builder.append(" and " + key + " is null");
                        break;
                    }
                    builder.append(" and " + key + " = '" + param.getValue() + "'");
                    break;
                }
                case "ne": {
                    if (null == param.getValue()) {
                        builder.append(" and " + key + " is not null");
                        break;
                    }
                    builder.append(" and " + key + " <> '" + param.getValue() + "'");
                    break;
                }
                case "sql": {
                    if (param.getValue() == null) break;
                    builder.append(param.getValue().toString());
                    break;
                }
                case "in": {
                    if (param.getValue() instanceof List) {
                        builder.append(" and " + key + " in ('" + StringUtils.join((Iterable)((List)param.getValue()), (String)"', '") + "')");
                        break;
                    }
                    if (!(param.getValue() instanceof String)) break;
                    Object[] paramArr = param.getValue().toString().split(",");
                    builder.append(" and " + key + " in ('" + StringUtils.join((Object[])paramArr, (String)"', '") + "')");
                    break;
                }
                case "not_in": {
                    if (param.getValue() instanceof List) {
                        builder.append(" and " + key + " not in ('" + StringUtils.join((Iterable)((List)param.getValue()), (String)"', '") + "')");
                        break;
                    }
                    if (!(param.getValue() instanceof String)) break;
                    Object[] paramArr = param.getValue().toString().split(",");
                    builder.append(" and " + key + " not in ('" + StringUtils.join((Object[])paramArr, (String)"', '") + "')");
                    break;
                }
                case "like": {
                    if (param.getValue() == null || !StringUtils.isNotBlank((CharSequence)param.getValue().toString())) break;
                    builder.append(" and " + key + " like '%" + param.getValue() + "%'");
                    break;
                }
                case "not_like": {
                    if (param.getValue() == null || !StringUtils.isNotBlank((CharSequence)param.getValue().toString())) break;
                    builder.append(" and " + key + " not like '%" + param.getValue() + "%'");
                    break;
                }
                case "like_left": {
                    if (param.getValue() == null || !StringUtils.isNotBlank((CharSequence)param.getValue().toString())) break;
                    builder.append(" and " + key + " like '%" + param.getValue() + "'");
                    break;
                }
                case "like_right": {
                    if (param.getValue() == null || !StringUtils.isNotBlank((CharSequence)param.getValue().toString())) break;
                    builder.append(" and " + key + " like '" + param.getValue() + "%'");
                    break;
                }
                case "between": {
                    if (param.getValue() == null || !StringUtils.isNotBlank((CharSequence)param.getValue().toString())) break;
                    Object[] paramArr = param.getValue().toString().split(",");
                    if ("dateInSelect".equals(param.getInputType()) && paramArr[0].length() == 7) {
                        if (((String)paramArr[0]).equals(paramArr[1])) {
                            builder.append(" and " + key + " = '" + (String)paramArr[0] + "'");
                            break;
                        }
                        builder.append(" and " + key + " in ('" + StringUtils.join(ParamUtil.getMonthRange((String)paramArr[0], (String)paramArr[1]), (String)"', '") + "')");
                        break;
                    }
                    builder.append(" and " + key + " between '" + (String)paramArr[0] + "' and '" + (String)paramArr[1] + "'");
                    break;
                }
                case "lt": {
                    if (param.getValue() == null || !StringUtils.isNotBlank((CharSequence)param.getValue().toString())) break;
                    builder.append(" and " + key + " < '" + param.getValue() + "'");
                    break;
                }
                case "le": {
                    if (param.getValue() == null || !StringUtils.isNotBlank((CharSequence)param.getValue().toString())) break;
                    builder.append(" and " + key + " <= '" + param.getValue() + "'");
                    break;
                }
                case "gt": {
                    if (param.getValue() == null || !StringUtils.isNotBlank((CharSequence)param.getValue().toString())) break;
                    builder.append(" and " + key + " > '" + param.getValue() + "'");
                    break;
                }
                case "ge": {
                    if (param.getValue() == null || !StringUtils.isNotBlank((CharSequence)param.getValue().toString())) break;
                    builder.append(" and " + key + " >= '" + param.getValue() + "'");
                }
            }
        }
        return builder.toString();
    }

    public static List<String> getMonthRange(String startDateStr, String endDateStr) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        Date startDate = null;
        Date endDate = null;
        try {
            startDate = sdf.parse(startDateStr);
            endDate = sdf.parse(endDateStr);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        ArrayList<String> monthList = new ArrayList<String>();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startDate);
        while (!calendar.getTime().after(endDate)) {
            int year = calendar.get(1);
            int month = calendar.get(2) + 1;
            String monthStr = String.format("%04d-%02d", year, month);
            monthList.add(monthStr);
            calendar.add(2, 1);
        }
        return monthList;
    }

    public static String getSql(QueryParam param, String tableAlias) {
        String field;
        StringBuffer sql = new StringBuffer(" AND ");
        Function<String, String> addAlias = fieldName -> {
            if (StringUtils.isNotBlank((CharSequence)tableAlias)) {
                return tableAlias + "." + fieldName;
            }
            return fieldName;
        };
        boolean hasData = false;
        if (StringUtils.isNotBlank((CharSequence)param.getSearchText()) && !ListUtil.isEmpty((List)param.getFuzzyFields())) {
            hasData = true;
            String searchText = param.getSearchText();
            List fuzzyFields = param.getFuzzyFields();
            if (fuzzyFields.size() == 1) {
                String field2 = CamelAndUnderLineConverter.humpToLine((String)((String)fuzzyFields.get(0)));
                sql.append(addAlias.apply(field2)).append(" LIKE '%").append(StringEscapeUtils.escapeSql((String)searchText)).append("%' ");
            } else {
                sql.append(" ( ");
                int size = fuzzyFields.size();
                for (int i = 0; i < size; ++i) {
                    String key = (String)fuzzyFields.get(i);
                    field = CamelAndUnderLineConverter.humpToLine((String)key);
                    sql.append(addAlias.apply(field)).append(" LIKE '%").append(StringEscapeUtils.escapeSql((String)searchText)).append("%' ");
                    if (i == size - 1) continue;
                    sql.append(" OR ");
                }
                sql.append(" ) ");
            }
        }
        if (param.getParams() != null && param.getParams().size() > 0) {
            if (hasData) {
                sql.append(" AND ( ");
            }
            int i = 1;
            for (Object key : param.getParams().keySet()) {
                Parameter parameter = (Parameter)param.getParams().get(key);
                String type = parameter.getType();
                field = CamelAndUnderLineConverter.humpToLine((String)key);
                field = addAlias.apply(field);
                switch (type) {
                    case "eq": {
                        if (null == parameter.getValue()) {
                            sql.append(field).append(" IS NULL ");
                            break;
                        }
                        sql.append(field).append(" = '").append(StringEscapeUtils.escapeSql((String)parameter.getValue().toString())).append("' ");
                        break;
                    }
                    case "ne": {
                        if (null == parameter.getValue()) {
                            sql.append(field).append(" IS NOT NULL ");
                            break;
                        }
                        sql.append(field).append(" != '").append(StringEscapeUtils.escapeSql((String)parameter.getValue().toString())).append("' ");
                        break;
                    }
                    case "in": {
                        if (parameter.getValue() instanceof List) {
                            String inValues = ((List)parameter.getValue()).stream().map(obj -> "'" + StringEscapeUtils.escapeSql((String)obj.toString()) + "'").collect(Collectors.joining(","));
                            sql.append(field).append(" IN (").append(inValues).append(") ");
                            break;
                        }
                        if (!(parameter.getValue() instanceof String)) break;
                        String[] paramArr = parameter.getValue().toString().split(",");
                        String inValues = Arrays.stream(paramArr).map(val -> "'" + StringEscapeUtils.escapeSql((String)val.trim()) + "'").collect(Collectors.joining(","));
                        sql.append(field).append(" IN (").append(inValues).append(") ");
                        break;
                    }
                    case "not_in": {
                        if (parameter.getValue() instanceof List) {
                            String notInValues = ((List)parameter.getValue()).stream().map(obj -> "'" + StringEscapeUtils.escapeSql((String)obj.toString()) + "'").collect(Collectors.joining(","));
                            sql.append(field).append(" NOT IN (").append(notInValues).append(") ");
                            break;
                        }
                        if (!(parameter.getValue() instanceof String)) break;
                        String[] paramArr = parameter.getValue().toString().split(",");
                        String notInValues = Arrays.stream(paramArr).map(val -> "'" + StringEscapeUtils.escapeSql((String)val.trim()) + "'").collect(Collectors.joining(","));
                        sql.append(field).append(" NOT IN (").append(notInValues).append(") ");
                        break;
                    }
                    case "like": {
                        if (parameter.getValue() == null || !StringUtils.isNotBlank((CharSequence)parameter.getValue().toString())) break;
                        sql.append(field).append(" LIKE '%").append(StringEscapeUtils.escapeSql((String)parameter.getValue().toString())).append("%' ");
                        break;
                    }
                    case "not_like": {
                        if (parameter.getValue() == null || !StringUtils.isNotBlank((CharSequence)parameter.getValue().toString())) break;
                        sql.append(field).append(" NOT LIKE '%").append(StringEscapeUtils.escapeSql((String)parameter.getValue().toString())).append("%' ");
                        break;
                    }
                    case "like_left": {
                        if (parameter.getValue() == null || !StringUtils.isNotBlank((CharSequence)parameter.getValue().toString())) break;
                        sql.append(field).append(" LIKE '").append(StringEscapeUtils.escapeSql((String)parameter.getValue().toString())).append("%' ");
                        break;
                    }
                    case "like_right": {
                        if (parameter.getValue() == null || !StringUtils.isNotBlank((CharSequence)parameter.getValue().toString())) break;
                        sql.append(field).append(" LIKE '%").append(StringEscapeUtils.escapeSql((String)parameter.getValue().toString())).append("' ");
                        break;
                    }
                    case "between": {
                        String[] paramArr;
                        if (parameter.getValue() == null || !StringUtils.isNotBlank((CharSequence)parameter.getValue().toString()) || (paramArr = parameter.getValue().toString().split(",")).length != 2) break;
                        sql.append(field).append(" BETWEEN '").append(StringEscapeUtils.escapeSql((String)paramArr[0].trim())).append("' AND '").append(StringEscapeUtils.escapeSql((String)paramArr[1].trim())).append("' ");
                        break;
                    }
                    case "lt": {
                        if (parameter.getValue() == null || !StringUtils.isNotBlank((CharSequence)parameter.getValue().toString())) break;
                        sql.append(field).append(" < '").append(StringEscapeUtils.escapeSql((String)parameter.getValue().toString())).append("' ");
                        break;
                    }
                    case "le": {
                        if (parameter.getValue() == null || !StringUtils.isNotBlank((CharSequence)parameter.getValue().toString())) break;
                        sql.append(field).append(" <= '").append(StringEscapeUtils.escapeSql((String)parameter.getValue().toString())).append("' ");
                        break;
                    }
                    case "gt": {
                        if (parameter.getValue() == null || !StringUtils.isNotBlank((CharSequence)parameter.getValue().toString())) break;
                        sql.append(field).append(" > '").append(StringEscapeUtils.escapeSql((String)parameter.getValue().toString())).append("' ");
                        break;
                    }
                    case "ge": {
                        if (parameter.getValue() == null || !StringUtils.isNotBlank((CharSequence)parameter.getValue().toString())) break;
                        sql.append(field).append(" >= '").append(StringEscapeUtils.escapeSql((String)parameter.getValue().toString())).append("' ");
                    }
                }
                if (i != param.getParams().size()) {
                    sql.append(" AND ");
                }
                ++i;
            }
            if (hasData) {
                sql.append(" ) ");
            }
            hasData = true;
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getSearchObject())) {
            JSONObject searchObject = JSONObject.parseObject((String)param.getSearchObject());
            if (hasData) {
                sql.append(" AND ");
            }
            int i = 1;
            for (String key : searchObject.keySet()) {
                String field3 = CamelAndUnderLineConverter.humpToLine((String)key);
                field3 = addAlias.apply(field3);
                sql.append(field3).append(" = '").append(StringEscapeUtils.escapeSql((String)searchObject.getString(key))).append("' ");
                if (i != searchObject.size()) {
                    sql.append(" AND ");
                }
                ++i;
            }
        }
        String whereClause = sql.length() == 5 ? null : sql.toString();
        LinkedHashMap orderMap = param.getOrderMap();
        StringBuffer orderByClause = new StringBuffer();
        if (orderMap != null && !orderMap.isEmpty()) {
            orderByClause.append(" ORDER BY ");
            int index = 0;
            int total = orderMap.size();
            for (Map.Entry entry : orderMap.entrySet()) {
                String dir;
                String field4 = (String)entry.getKey();
                String direction = (String)entry.getValue();
                String dbField = CamelAndUnderLineConverter.humpToLine((String)field4);
                dbField = addAlias.apply(dbField);
                String string = dir = StringUtils.isNotBlank((CharSequence)direction) ? direction.trim().toUpperCase() : "ASC";
                if (!"ASC".equals(dir) && !"DESC".equals(dir)) {
                    dir = "ASC";
                }
                orderByClause.append(dbField).append(" ").append(dir);
                if (index != total - 1) {
                    orderByClause.append(", ");
                }
                ++index;
            }
        }
        if (orderByClause.length() > 0) {
            if (whereClause != null) {
                return whereClause + orderByClause.toString();
            }
            return orderByClause.toString();
        }
        return whereClause;
    }

    public static String getSqlBuild(QueryParam param, String tableAlias) {
        String whereClause;
        String field;
        StringBuffer sql = new StringBuffer(" AND ");
        Function<String, String> addAlias = fieldName -> {
            if (StringUtils.isNotBlank((CharSequence)tableAlias)) {
                return tableAlias + "." + fieldName;
            }
            return fieldName;
        };
        boolean hasData = false;
        if (StringUtils.isNotBlank((CharSequence)param.getSearchText()) && !ListUtil.isEmpty((List)param.getFuzzyFields())) {
            hasData = true;
            String searchText = param.getSearchText();
            List fuzzyFields = param.getFuzzyFields();
            if (fuzzyFields.size() == 1) {
                sql.append(addAlias.apply((String)fuzzyFields.get(0))).append(" LIKE '%").append(StringEscapeUtils.escapeSql((String)searchText)).append("%' ");
            } else {
                sql.append(" ( ");
                for (int i = 0; i < fuzzyFields.size(); ++i) {
                    sql.append(addAlias.apply((String)fuzzyFields.get(i))).append(" LIKE '%").append(StringEscapeUtils.escapeSql((String)searchText)).append("%' ");
                    if (i == fuzzyFields.size() - 1) continue;
                    sql.append(" OR ");
                }
                sql.append(" ) ");
            }
        }
        if (param.getParams() != null && !param.getParams().isEmpty()) {
            if (hasData) {
                sql.append(" AND ( ");
            }
            int i = 1;
            for (String key : param.getParams().keySet()) {
                Parameter parameter = (Parameter)param.getParams().get(key);
                String type = parameter.getType();
                field = addAlias.apply(key);
                switch (type) {
                    case "eq": {
                        if (null == parameter.getValue()) {
                            sql.append(field).append(" IS NULL ");
                            break;
                        }
                        sql.append(field).append(" = '").append(StringEscapeUtils.escapeSql((String)parameter.getValue().toString())).append("' ");
                        break;
                    }
                    case "ne": {
                        if (null == parameter.getValue()) {
                            sql.append(field).append(" IS NOT NULL ");
                            break;
                        }
                        sql.append(field).append(" != '").append(StringEscapeUtils.escapeSql((String)parameter.getValue().toString())).append("' ");
                        break;
                    }
                    case "in": {
                        if (parameter.getValue() instanceof List) {
                            String inValues = ((List)parameter.getValue()).stream().map(obj -> "'" + StringEscapeUtils.escapeSql((String)obj.toString()) + "'").collect(Collectors.joining(","));
                            sql.append(field).append(" IN (").append(inValues).append(") ");
                            break;
                        }
                        if (!(parameter.getValue() instanceof String)) break;
                        String[] paramArr = parameter.getValue().toString().split(",");
                        String inValues = Arrays.stream(paramArr).map(val -> "'" + StringEscapeUtils.escapeSql((String)val.trim()) + "'").collect(Collectors.joining(","));
                        sql.append(field).append(" IN (").append(inValues).append(") ");
                    }
                }
                if (i != param.getParams().size()) {
                    sql.append(" AND ");
                }
                ++i;
            }
            if (hasData) {
                sql.append(" ) ");
            }
            hasData = true;
        }
        if (StringUtils.isNotEmpty((CharSequence)param.getSearchObject())) {
            JSONObject searchObject = JSONObject.parseObject((String)param.getSearchObject());
            if (hasData) {
                sql.append(" AND ");
            }
            int i = 1;
            for (String key : searchObject.keySet()) {
                String field2 = addAlias.apply(key);
                sql.append(field2).append(" = '").append(StringEscapeUtils.escapeSql((String)searchObject.getString(key))).append("' ");
                if (i != searchObject.size()) {
                    sql.append(" AND ");
                }
                ++i;
            }
        }
        LinkedHashMap orderMap = param.getOrderMap();
        StringBuffer orderByClause = new StringBuffer();
        if (orderMap != null && !orderMap.isEmpty()) {
            orderByClause.append(" ORDER BY ");
            int index = 0;
            for (Map.Entry entry : orderMap.entrySet()) {
                String dir;
                field = (String)entry.getKey();
                String direction = (String)entry.getValue();
                String dbField = addAlias.apply(field);
                String string = dir = StringUtils.isNotBlank((CharSequence)direction) ? direction.trim().toUpperCase() : "ASC";
                if (!"ASC".equals(dir) && !"DESC".equals(dir)) {
                    dir = "ASC";
                }
                orderByClause.append(dbField).append(" ").append(dir);
                if (index != orderMap.size() - 1) {
                    orderByClause.append(", ");
                }
                ++index;
            }
        }
        String string = whereClause = sql.length() == 5 ? null : sql.toString();
        if (orderByClause.length() > 0) {
            return whereClause != null ? whereClause + orderByClause.toString() : orderByClause.toString();
        }
        return whereClause;
    }
}

