package com.ejianc.business.finance.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.finance.vo.BidBondReportVO;
import com.ejianc.business.finance.vo.BondUpVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.*;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import com.ejianc.business.finance.bean.BidBondEntity;
import com.ejianc.business.finance.service.IBidBondService;
import com.ejianc.business.finance.vo.BidBondVO;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 投标保证金申请
 *
 * @author generator
 */
@Controller
@RequestMapping("bidBond")
public class BidBondController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "FINANCE_BID_BOND";//此处需要根据实际修改

    @Autowired
    private IBidBondService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BidBondVO> saveOrUpdate(@RequestBody BidBondVO saveOrUpdateVO) {
        if (StringUtils.isNotBlank(saveOrUpdateVO.getBillCode())) {
            //编码重复校验
            BidBondVO voByCode = service.queryByCode(saveOrUpdateVO.getBillCode());
            if (null != voByCode && (null == saveOrUpdateVO.getId() || !voByCode.getId().equals(saveOrUpdateVO.getId()))) {
                return CommonResponse.error("保存失败，编码重复！");
            }
        } else {
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(), saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                saveOrUpdateVO.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        BidBondEntity entity = BeanMapper.map(saveOrUpdateVO, BidBondEntity.class);
        entity.setInvoiceMny(BigDecimal.ZERO);
        entity.setBondStatus("0");
        entity.setPayState(0);
        entity.setBackedState(0);
        service.saveOrUpdate(entity, false);
        BidBondVO vo = BeanMapper.map(entity, BidBondVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BidBondVO> queryDetail(Long id) {
        BidBondEntity entity = service.selectById(id);
        BidBondVO vo = BeanMapper.map(entity, BidBondVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * 查询收款账户信息
     *
     * @param queryParam
     * @return
     */
    @RequestMapping(value = "/queryReceiveInfo", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BidBondVO> queryReceiveInfo(QueryParam queryParam) {
        queryParam.getParams().put("applyEmployeeId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getEmployeeId()));
        //已生效状态的单据
        queryParam.getComplexParams().add(ComplexParam.getApprovedComplexParam(ComplexParam.AND));
        queryParam.getOrderMap().put("createTime", QueryParam.DESC);
        List<BidBondEntity> entityList = service.queryList(queryParam, false);
        BidBondVO backVO = !entityList.isEmpty() ? BeanMapper.map(entityList.get(0), BidBondVO.class) : new BidBondVO();
        return CommonResponse.success("查询数据成功！", backVO);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BidBondVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (BidBondVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(BidBondVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("opportunityName");
        fuzzyFields.add("applyEmployeeName");
        param.getParams().put("tenantId", new Parameter("eq", InvocationInfoProxy.getTenantid()));
        List<Long> commonOrgIds = new ArrayList<>();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> orgListResp = iOrgApi.findChildrenByParentId(orgId);
        if (!orgListResp.isSuccess()) {
            return CommonResponse.success("列表查询失败, 查询组织信息失败！");
        }
        commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        }
        Page<BidBondEntity> page = new Page<>((long) param.getPageIndex(), (long) param.getPageSize());
        Parameter aa = param.getParams().get("backType");
        param.getParams().remove("backType");
        QueryWrapper wrapper = changeToQueryWrapper(param);
        if (null != aa) {
            String backType = String.valueOf(aa.getValue());
            switch (backType) {
                case "1":
                    wrapper.apply("IFNULL(back_mny,0) > 0 and IFNULL(back_mny,0) = IFNULL(apply_mny,0)");
                    break;
                case "3":
                    wrapper.apply("IFNULL(back_mny,0) = 0");
                    break;
                case "2":
                    wrapper.apply("IFNULL(back_mny,0) > 0 and IFNULL(back_mny,0) < IFNULL(apply_mny,0)");
                    break;
                default:
                    break;
            }
        }

        IPage<BidBondEntity> pageData = service.selectPage(page, wrapper);
        com.alibaba.fastjson.JSONObject res = new com.alibaba.fastjson.JSONObject();
        List<BidBondVO> bidBondVOS = BeanMapper.mapList(pageData.getRecords(), BidBondVO.class);
        for (BidBondVO bidBondVO : bidBondVOS) {
            if (ComputeUtil.equals(ComputeUtil.nullToZero(bidBondVO.getBackMny()), BigDecimal.ZERO)) {
                bidBondVO.setBackType("3");
            }else if(ComputeUtil.equals(bidBondVO.getBackMny(), bidBondVO.getApplyMny())){
                bidBondVO.setBackType("1");
            }else if(ComputeUtil.isLessThan(bidBondVO.getBackMny(), bidBondVO.getApplyMny())){
                bidBondVO.setBackType("2");
            }
        }
        res.put("records", bidBondVOS);
        res.put("total", pageData.getTotal());
        res.put("current", pageData.getCurrent());
        res.put("size", pageData.getSize());
        res.put("pages", pageData.getPages());
        return CommonResponse.success("查询列表数据成功！", res);
    }

    /**
     * @Description 查询列表
     */
    @RequestMapping(value = "/queryListManage", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryListManage(@RequestBody QueryParam param) {
        List<BidBondVO> list = new ArrayList<>();
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("opportunityName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", InvocationInfoProxy.getTenantid()));
        param.getParams().put("bondStatus", new Parameter("eq", "1"));
        List<Long> commonOrgIds = new ArrayList<>();
        List<Integer> billstate = new ArrayList<>();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> orgListResp = iOrgApi.findChildrenByParentId(orgId);
        if (!orgListResp.isSuccess()) {
            return CommonResponse.success("列表查询失败, 查询组织信息失败！");
        }
        commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        }
        billstate.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billstate.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        param.getParams().put("bill_state", new Parameter(QueryParam.IN, billstate));
        Page<BidBondEntity> page = new Page<>((long) param.getPageIndex(), (long) param.getPageSize());
        Parameter backType = param.getParams().get("backType");
        Parameter bondState = param.getParams().get("bondState");
        param.getParams().remove("backType");
        param.getParams().remove("bondState");
        QueryWrapper wrapper = changeToQueryWrapper(param);
        if (null != backType && "1".equals(backType.getValue())) {
            wrapper.apply("IFNULL(back_mny,0) = IFNULL(apply_mny,0)");
        } else if (null != backType && "2".equals(backType.getValue())) {
            wrapper.apply("IFNULL(back_mny,0) < IFNULL(apply_mny,0)");
        }

        if (null != bondState && "1".equals(bondState.getValue())) {
            wrapper.apply("CURRENT_DATE() <= end_date");
        } else if (null != bondState && "2".equals(bondState.getValue())) {
            wrapper.apply("CURRENT_DATE() > end_date");
        }
        IPage<BidBondEntity> pageData = service.selectPage(page, wrapper);
        if (CollectionUtils.isNotEmpty(pageData.getRecords())) {
            list = BeanMapper.mapList(pageData.getRecords(), BidBondVO.class);
            list.forEach(vo -> {
                if (null != vo.getEndDate() && new Date().after(vo.getEndDate())) {
                    vo.setDealStatus("已到期");
                } else {
                    vo.setDealStatus("有效");
                }
            });
        }
        com.alibaba.fastjson.JSONObject res = new com.alibaba.fastjson.JSONObject();
        res.put("records", list);
        res.put("total", pageData.getTotal());
        res.put("current", pageData.getCurrent());
        res.put("size", pageData.getSize());
        res.put("pages", pageData.getPages());
        return CommonResponse.success("查询列表数据成功！", res);
    }

    /**
     * @param param
     * @Description saveOrUpdate 查询待处理列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryDealList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> queryDealList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("customerName");
        fuzzyFields.add("opportunityName");
        fuzzyFields.add("applyEmployeeName");
        param.getParams().put("tenantId", new Parameter("eq", InvocationInfoProxy.getTenantid()));
        List<Long> commonOrgIds = new ArrayList<>();
        List<Integer> billstate = new ArrayList<>();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> orgListResp = iOrgApi.findChildrenByParentId(orgId);
        if (!orgListResp.isSuccess()) {
            return CommonResponse.success("列表查询失败, 查询组织信息失败！");
        }
        commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        }
        billstate.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billstate.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        param.getParams().put("bill_state", new Parameter(QueryParam.IN, billstate));
        Page<BidBondVO> page = new Page<>((long) param.getPageIndex(), (long) param.getPageSize());
        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<BidBondVO> list = service.queryDealList(page, wrapper);
        com.alibaba.fastjson.JSONObject res = new com.alibaba.fastjson.JSONObject();
        res.put("records", list);
        res.put("total", page.getTotal());
        res.put("current", page.getCurrent());
        res.put("size", page.getSize());
        res.put("pages", page.getPages());
        return CommonResponse.success("查询列表数据成功！", res);
    }

    /**
     * @param param
     * @Description saveOrUpdate 查询待处理列表
     */
    @RequestMapping(value = "/queryBondMny", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BidBondReportVO> queryBondMny(@RequestBody QueryParam param) {
        param.getParams().put("tenantId", new Parameter("eq", InvocationInfoProxy.getTenantid()));
        List<Long> commonOrgIds = new ArrayList<>();
        List<Integer> billstate = new ArrayList<>();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> orgListResp = iOrgApi.findChildrenByParentId(orgId);
        if (!orgListResp.isSuccess()) {
            return CommonResponse.success("列表查询失败, 查询组织信息失败！");
        }
        commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        }
        billstate.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billstate.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        param.getParams().put("bill_state", new Parameter(QueryParam.IN, billstate));
        QueryWrapper wrapper = changeToQueryWrapper(param);
        BidBondReportVO reportVO = service.queryBondReport(wrapper);
        return CommonResponse.success("查询列表数据成功！", reportVO);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List<BidBondVO> list = new ArrayList<>();
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("customerName");
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("tenantId", new Parameter("eq", InvocationInfoProxy.getTenantid()));
        List<Long> commonOrgIds = new ArrayList<>();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> orgListResp = iOrgApi.findChildrenByParentId(orgId);
        if (!orgListResp.isSuccess()) {
            throw new BusinessException("列表查询失败, 查询组织信息失败！");
        }
        commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        }
        Page<BidBondEntity> page = new Page<>((long) param.getPageIndex(), (long) param.getPageSize());
        Parameter aa = param.getParams().get("backType");
        param.getParams().remove("backType");
        QueryWrapper wrapper = changeToQueryWrapper(param);
        if (null != aa && "1".equals(aa.getValue())) {
            wrapper.apply("IFNULL(back_mny,0) = IFNULL(apply_mny,0)");
        } else if (null != aa && "2".equals(aa.getValue())) {
            wrapper.apply("IFNULL(back_mny,0) < IFNULL(apply_mny,0)");
        }

        IPage<BidBondEntity> pageData = service.selectPage(page, wrapper);
        if (CollectionUtils.isNotEmpty(pageData.getRecords())) {
            list = BeanMapper.mapList(pageData.getRecords(), BidBondVO.class);
        }
        list.forEach(vo -> {
            vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            if (new Date().after(vo.getEndDate())) {
                vo.setDealStatus("已到期");
            } else {
                vo.setDealStatus("有效");
            }
        });
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("bidBondExport.xlsx", beans, response);
    }

    @RequestMapping(value = "/excelExports", method = RequestMethod.POST)
    @ResponseBody
    public void excelExports(@RequestBody QueryParam param, HttpServletResponse response) {
        List<BondUpVO> list = new ArrayList<>();
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("customerName");
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("tenantId", new Parameter("eq", InvocationInfoProxy.getTenantid()));
        param.getParams().put("bondStatus", new Parameter("eq", "1"));
        List<Long> commonOrgIds = new ArrayList<>();
        List<Integer> billstate = new ArrayList<>();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> orgListResp = iOrgApi.findChildrenByParentId(orgId);
        if (!orgListResp.isSuccess()) {
            throw new BusinessException("列表查询失败, 查询组织信息失败！");
        }
        commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        }
        billstate.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billstate.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        param.getParams().put("bill_state", new Parameter(QueryParam.IN, billstate));
        Page<BidBondEntity> page = new Page<>((long) param.getPageIndex(), (long) param.getPageSize());
        Parameter backType = param.getParams().get("backType");
        Parameter bondState = param.getParams().get("bondState");
        param.getParams().remove("backType");
        param.getParams().remove("bondState");
        QueryWrapper wrapper = changeToQueryWrapper(param);
        if (null != backType && "1".equals(backType.getValue())) {
            wrapper.apply("IFNULL(back_mny,0) = IFNULL(apply_mny,0)");
        } else if (null != backType && "2".equals(backType.getValue())) {
            wrapper.apply("IFNULL(back_mny,0) < IFNULL(apply_mny,0)");
        }

        if (null != bondState && "1".equals(bondState.getValue())) {
            wrapper.apply("CURRENT_DATE() <= end_date");
        } else if (null != bondState && "2".equals(bondState.getValue())) {
            wrapper.apply("CURRENT_DATE() > end_date");
        }
        IPage<BidBondEntity> pageData = service.selectPage(page, wrapper);
        if (CollectionUtils.isNotEmpty(pageData.getRecords())) {
            list = BeanMapper.mapList(pageData.getRecords(), BondUpVO.class);
        }
        list.forEach(vo -> {
            if (new Date().after(vo.getEndDate())) {
                vo.setDealStatus("已到期");
            } else {
                vo.setDealStatus("有效");
            }
        });
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("bidBondManageExport.xlsx", beans, response);
    }

    @RequestMapping(value = "/excelExportUn", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportsUn(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("customerName");
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("tenantId", new Parameter("eq", InvocationInfoProxy.getTenantid()));
        List<Long> commonOrgIds = new ArrayList<>();
        List<Integer> billstate = new ArrayList<>();
        Long orgId = InvocationInfoProxy.getOrgId();
        CommonResponse<List<OrgVO>> orgListResp = iOrgApi.findChildrenByParentId(orgId);
        if (!orgListResp.isSuccess()) {
            throw new BusinessException("列表查询失败, 查询组织信息失败！");
        }
        commonOrgIds.addAll(orgListResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        }
        billstate.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
        billstate.add(BillStateEnum.PASSED_STATE.getBillStateCode());
        param.getParams().put("bill_state", new Parameter(QueryParam.IN, billstate));
        Page<BidBondVO> page = new Page<>((long) param.getPageIndex(), (long) param.getPageSize());
        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<BidBondVO> list = service.queryDealList(page, wrapper);
        List<BidBondVO> listExport = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(list)) {
            list.forEach(vo -> {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            });
            listExport = BeanMapper.mapList(list, BidBondVO.class);
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", listExport);
        ExcelExport.getInstance().export("bidBondUnManageExport.xlsx", beans, response);
    }
}
