/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.equipment.api.IEquipmentContractApi;
import com.ejianc.business.finance.bean.PayContractEntity;
import com.ejianc.business.finance.service.IPayContractService;
import com.ejianc.business.finance.service.IPayReportedService;
import com.ejianc.business.finance.util.MathUtil;
import com.ejianc.business.finance.utils.BigDecimalUtil;
import com.ejianc.business.finance.utils.NumberToCN;
import com.ejianc.business.finance.utils.ParamSearchUtil;
import com.ejianc.business.finance.vo.FinanceCostVO;
import com.ejianc.business.finance.vo.FinanceMonthVO;
import com.ejianc.business.finance.vo.ManageDetailVO;
import com.ejianc.business.finance.vo.ParamsCheckVO;
import com.ejianc.business.finance.vo.PayApplyPubVO;
import com.ejianc.business.finance.vo.PayContractSettleVO;
import com.ejianc.business.finance.vo.PayContractVO;
import com.ejianc.business.finance.vo.PayReportedVO;
import com.ejianc.business.finance.vo.ProjectFinanceVO;
import com.ejianc.business.finance.vo.RequestPaymentReportVO;
import com.ejianc.business.finance.vo.SumMnyStatisticVO;
import com.ejianc.business.finance.vo.SumPayMnyVO;
import com.ejianc.business.finance.vo.TotalColumnVO;
import com.ejianc.business.income.api.IContractReportApi;
import com.ejianc.business.material.vo.InstoreMaterialVO;
import com.ejianc.business.utils.ComputeUtil;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.permission.api.IRoleApi;
import com.ejianc.foundation.permission.vo.RoleVO;
import com.ejianc.foundation.share.util.PSRMResponse;
import com.ejianc.foundation.share.util.PSRMRestUtil;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.ISupplierApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/payContract"})
public class PayContractController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPayContractService contractService;
    @Autowired
    private IEquipmentContractApi equipmentContractApi;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private ICommonBusinessService payContract;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ISupplierApi supplierApi;
    @Autowired
    private IRoleApi iRoleApi;
    @Autowired
    private IContractReportApi contractReportApi;
    @Autowired
    private IPayContractService payContractService;
    @Autowired
    private PSRMRestUtil psrmRestUtil;
    @Autowired
    private IPayReportedService payReportedService;

    @RequestMapping(value={"/queryAllList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryAllList(@RequestBody QueryParam param) {
        ParamSearchUtil.handleQueryParam(param);
        JSONObject page = this.contractService.queryAllList(param);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/excelAllList"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelAllList(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        ParamSearchUtil.handleQueryParam(queryParam);
        queryParam.setPageIndex(0);
        queryParam.setPageSize(-1);
        List records = new ArrayList();
        JSONObject jsonObject = this.contractService.queryAllList(queryParam);
        if (jsonObject != null && jsonObject.get((Object)"records") != null) {
            records = (List)jsonObject.get((Object)"records");
        }
        records.forEach(vo -> {
            if (null != vo.getApplyMny()) {
                vo.setUnpaidMny(vo.getApplyMny().subtract(vo.getPayMny() == null ? BigDecimal.ZERO : vo.getPayMny()));
            }
        });
        HashMap beans = new HashMap();
        beans.put("records", records);
        ExcelExport.getInstance().export("all-payapply-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/handleData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PayContractVO> handleData() {
        long start = System.currentTimeMillis();
        QueryParam param = new QueryParam();
        List payContractEntities = this.contractService.queryList(param);
        for (PayContractEntity payContractEntity : payContractEntities) {
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("contractId", new Parameter("eq", (Object)payContractEntity.getContractId()));
            queryParam.getParams().put("orgId", new Parameter("eq", (Object)payContractEntity.getOrgId()));
            queryParam.getParams().put("applyTime", new Parameter("lt", (Object)payContractEntity.getApplyTime()));
            List entities = this.contractService.queryList(queryParam);
            BigDecimal sumApplyMny = BigDecimal.ZERO;
            if (CollectionUtils.isNotEmpty((Collection)entities)) {
                for (PayContractEntity pce : entities) {
                    sumApplyMny = BigDecimalUtil.safeAdd(sumApplyMny, pce.getApplyMny());
                }
                payContractEntity.setSumApplyMny(sumApplyMny);
            }
            payContractEntity.setApplyMnyCn(NumberToCN.number2CN(payContractEntity.getApplyMny()));
            BigDecimal sumApplyMnyWithThis = BigDecimalUtil.safeAdd(sumApplyMny, payContractEntity.getApplyMny());
            BigDecimal _endthisPayScaleByContract = BigDecimalUtil.safeDiv(sumApplyMnyWithThis, payContractEntity.getContractMny());
            BigDecimal endthisPayScaleByContract = BigDecimalUtil.safeMultiply(_endthisPayScaleByContract, BigDecimalUtil.ONE_HUNDRED);
            payContractEntity.setEndthisPayScaleByContract(endthisPayScaleByContract);
        }
        this.contractService.saveOrUpdateBatch(payContractEntities);
        long end = System.currentTimeMillis();
        String msg = "\u7a0b\u5e8f\u8fd0\u884c\u65f6\u95f4\uff1a" + (end - start) + "ms\uff0c\u5904\u7406\u6570\u636e\uff1a" + payContractEntities.size() + "\u6761\u3002";
        return CommonResponse.success((String)msg);
    }

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PayContractVO> saveOrUpdate(@RequestBody PayContractVO payContractVO) {
        List<Long> settleIds;
        List settleVOS = payContractVO.getSettleVOList();
        if (CollectionUtils.isNotEmpty((Collection)settleVOS) && CollectionUtils.isNotEmpty(settleIds = settleVOS.stream().filter(t -> !"del".equals(t.getRowState())).map(e -> e.getSettleId()).collect(Collectors.toList()))) {
            Map<Long, BigDecimal> settleApplyData = this.contractService.getApplyMnyHasFree(settleIds, payContractVO.getId());
            for (PayContractSettleVO settleVO : settleVOS) {
                BigDecimal settleTaxMny = settleVO.getSettleMny();
                BigDecimal sumApplyMny = settleApplyData.get(settleVO.getSettleId());
                BigDecimal sumApplyMnyHasThis = ComputeUtil.safeAdd((BigDecimal)sumApplyMny, (BigDecimal)settleVO.getBodyApplyMny());
                if (!ComputeUtil.isGreaterThan((BigDecimal)ComputeUtil.scaleTwo((BigDecimal)sumApplyMnyHasThis), (BigDecimal)ComputeUtil.scaleTwo((BigDecimal)settleTaxMny))) continue;
                throw new BusinessException("\u7ed3\u7b97\u5355\u3010\u5355\u636e\u7f16\u53f7\uff1a" + settleVO.getSettleCode() + "\u3011\u7d2f\u8ba1\u7533\u8bf7\u91d1\u989d(\u542b\u672c\u671f)\uff1a" + ComputeUtil.scaleTwo((BigDecimal)sumApplyMnyHasThis) + " \u5927\u4e8e\u7ed3\u7b97\u91d1\u989d\uff1a" + ComputeUtil.scaleTwo((BigDecimal)settleTaxMny) + " \uff0c\u4e0d\u80fd\u4fdd\u5b58\uff01");
            }
        }
        if (payContractVO.getJointAccountName() != null && payContractVO.getJointAccountNum() != null && payContractVO.getJointAccountBank() != null) {
            payContractVO.setAccountName(payContractVO.getJointAccountName());
            payContractVO.setAccountNum(payContractVO.getJointAccountNum());
            payContractVO.setAccountBank(payContractVO.getJointAccountBank());
        } else if (payContractVO.getBasicAccountName() != null && payContractVO.getBasicAccountNum() != null && payContractVO.getBasicAccountBank() != null) {
            payContractVO.setAccountName(payContractVO.getBasicAccountName());
            payContractVO.setAccountNum(payContractVO.getBasicAccountNum());
            payContractVO.setAccountBank(payContractVO.getBasicAccountBank());
        } else if (payContractVO.getSubAccountName() != null && payContractVO.getSubAccountNum() != null && payContractVO.getSubAccountBank() != null) {
            payContractVO.setAccountName(payContractVO.getSubAccountName());
            payContractVO.setAccountNum(payContractVO.getSubAccountNum());
            payContractVO.setAccountBank(payContractVO.getSubAccountBank());
        } else if (payContractVO.getAccountName() == null || payContractVO.getAccountNum() == null || payContractVO.getAccountBank() == null) {
            throw new BusinessException("\u6536\u6b3e\u8d26\u6237\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        PayContractVO backVO = this.contractService.insertOrUpdate(payContractVO);
        backVO.setEndthisSumApplyMny(MathUtil.safeAdd((BigDecimal)backVO.getApplyMny(), (BigDecimal)backVO.getSumApplyMny()));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)backVO);
    }

    @RequestMapping(value={"/updateInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PayContractVO> updateInfo(@RequestBody PayContractVO vo) {
        PayContractEntity entity = (PayContractEntity)((Object)BeanMapper.map((Object)vo, PayContractEntity.class));
        if (vo.getId() != null && vo.getInvoiceFlag() != null) {
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)entity.getId());
            updateWrapper.set(PayContractEntity::getInvoiceFlag, (Object)entity.getInvoiceFlag());
            this.contractService.update((Wrapper)updateWrapper);
        }
        return CommonResponse.success((String)"\u4fee\u6539\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PayContractVO> queryDetail(Long id) {
        PayContractVO backVO = this.contractService.queryDetail(id);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)backVO);
    }

    @RequestMapping(value={"/queryPrint"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryPrint(Long id) {
        JSONObject json = new JSONObject();
        json.put("PayContract", (Object)this.contractService.queryDetail(id));
        return CommonResponse.success((String)"\u67e5\u8be2\u6253\u5370\u6570\u636e\u6210\u529f\uff01", (Object)json);
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam param) {
        param.getOrderMap().put("createTime", "desc");
        JSONObject page = this.contractService.queryPageJson(param, false);
        try {
            List contractIds;
            List records = (List)page.get((Object)"records");
            if (records != null && !records.isEmpty() && !(contractIds = records.stream().map(PayContractVO::getContractId).filter(Objects::nonNull).distinct().collect(Collectors.toList())).isEmpty()) {
                HashMap<Long, BigDecimal> totalAmountMap = new HashMap<Long, BigDecimal>();
                for (Long contractId : contractIds) {
                    try {
                        BigDecimal totalAmount = this.contractService.queryTotalAmountByContractIds(Collections.singletonList(contractId));
                        if (totalAmount == null) continue;
                        totalAmountMap.put(contractId, totalAmount);
                    }
                    catch (Exception e) {
                        this.logger.error("\u83b7\u53d6\u5408\u540cID\u4e3a {} \u7684\u5165\u5e93\u6750\u6599\u603b\u91d1\u989d\u5931\u8d25", (Object)contractId, (Object)e);
                    }
                }
                records.forEach(record -> {
                    Long contractId = record.getContractId();
                    if (contractId != null && totalAmountMap.containsKey(contractId)) {
                        record.setTotalAmount((BigDecimal)totalAmountMap.get(contractId));
                    }
                });
            }
        }
        catch (Exception e) {
            this.logger.error("\u6279\u91cf\u83b7\u53d6\u5165\u5e93\u6750\u6599\u603b\u91d1\u989d\u5931\u8d25", (Throwable)e);
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/queryApproveList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryApproveList(@RequestBody QueryParam param) {
        ParamSearchUtil.handleQueryParam(param);
        param.getComplexParams().add(ComplexParam.getApprovedComplexParam((String)"and"));
        param.getOrderMap().put("approveTime", "desc");
        JSONObject page = this.contractService.queryPageJson(param, false);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PayContractVO> vos) {
        List<Long> ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        String msg = this.contractService.delete(ids);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        ParamSearchUtil.handleQueryParam(queryParam);
        if (StringUtils.isNotEmpty((CharSequence)queryParam.getBillTypeId()) && this.contractService.viewSelf(queryParam.getBillTypeId()).booleanValue() && queryParam.getParams().get("createUserCode") == null && queryParam.getParams().get("create_user_code") == null) {
            queryParam.getParams().put("createUserCode", new Parameter("eq", (Object)InvocationInfoProxy.getUsercode()));
        }
        List<PayContractVO> supplierVos = this.contractService.queryExportList(queryParam);
        supplierVos.forEach(vo -> {
            if (null != vo.getApplyMny()) {
                vo.setUnpaidMny(vo.getApplyMny().subtract(vo.getPayMny() == null ? BigDecimal.ZERO : vo.getPayMny()));
            }
            switch (vo.getContractType().intValue()) {
                case 1: {
                    vo.setContractTypeName("\u5206\u5305");
                    break;
                }
                case 2: {
                    vo.setContractTypeName("\u8bbe\u5907\u91c7\u8d2d\u5408\u540c");
                    break;
                }
                case 3: {
                    vo.setContractTypeName("\u8bbe\u5907\u79df\u8d41\u5408\u540c");
                    break;
                }
                case 4: {
                    vo.setContractTypeName("\u7269\u8d44\u91c7\u8d2d\u5408\u540c");
                    break;
                }
                case 5: {
                    vo.setContractTypeName("\u5468\u8f6c\u6750\u79df\u8d41\u5408\u540c");
                    break;
                }
                case 6: {
                    vo.setContractTypeName("\u5176\u4ed6\u652f\u51fa\u5408\u540c");
                }
            }
        });
        HashMap<String, List<PayContractVO>> beans = new HashMap<String, List<PayContractVO>>();
        beans.put("records", supplierVos);
        UserContext userContext = this.sessionManager.getUserContext();
        CommonResponse roleList = this.iRoleApi.queryRoleByUserId(userContext.getUserId());
        List roleCodeList = ((List)roleList.getData()).stream().map(RoleVO::getCode).collect(Collectors.toList());
        String deptName = userContext.getDeptName();
        if (roleCodeList.contains("FKSQ1") || roleCodeList.contains("FKSQ2") || "\u5546\u52a1\u90e8".equals(deptName)) {
            ExcelExport.getInstance().export("contractSub-payapply-export.xlsx", beans, response);
        } else {
            ExcelExport.getInstance().export("contract-payapply-export.xlsx", beans, response);
        }
    }

    @RequestMapping(value={"/queryContractRefer"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryContractRefer(@RequestParam(defaultValue="1") int pageNumber, @RequestParam(defaultValue="10") int pageSize, @RequestParam(required=false) String searchText, @RequestParam(required=false) String condition) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageSize(pageSize);
        queryParam.setPageIndex(pageNumber);
        queryParam.setSearchText(searchText);
        if (StringUtils.isNotBlank((CharSequence)condition)) {
            JSONObject obj = JSONObject.parseObject((String)condition);
            if (condition.contains("projectId")) {
                queryParam.getParams().put("projectId", new Parameter("eq", (Object)obj.getLong("projectId")));
            }
        }
        queryParam.getParams().put("org_id", new Parameter("in", ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        CommonResponse apiContract = this.equipmentContractApi.getContract(queryParam);
        JSONObject page = new JSONObject();
        if (!apiContract.isSuccess()) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        page = (JSONObject)apiContract.getData();
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/querySettleRefer"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> querySettleRefer(@RequestParam(defaultValue="1") int pageNumber, @RequestParam(defaultValue="10") int pageSize, @RequestParam(required=false) String searchText, @RequestParam(required=false) String condition) {
        QueryParam queryParam = new QueryParam();
        queryParam.setPageSize(pageSize);
        queryParam.setPageIndex(pageNumber);
        queryParam.setSearchText(searchText);
        Integer contractType = null;
        if (StringUtils.isNotBlank((CharSequence)condition)) {
            JSONObject obj = JSONObject.parseObject((String)condition);
            if (!condition.contains("contractId")) {
                return CommonResponse.error((String)"condition\u6761\u4ef6\u7f3a\u5c11contractId\uff01");
            }
            queryParam.getParams().put("contractId", new Parameter("eq", (Object)obj.getLong("contractId")));
            if (condition.contains("projectId")) {
                queryParam.getParams().put("projectId", new Parameter("eq", (Object)obj.getLong("projectId")));
            }
            if (!condition.contains("orgId")) {
                return CommonResponse.error((String)"condition\u6761\u4ef6\u7f3a\u5c11orgId\uff01");
            }
            queryParam.getParams().put("orgId", new Parameter("eq", (Object)obj.getLong("orgId")));
            if (condition.contains("contractType")) {
                contractType = obj.getInteger("contractType");
            } else {
                return CommonResponse.error((String)"condition\u6761\u4ef6\u7f3a\u5c11contractType\uff01");
            }
        }
        JSONObject page = this.contractService.querySettleRefer(queryParam, contractType);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/queryReceiveInfo"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PayContractVO> queryReceiveInfo(Long receiveUnitId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("receiveUnitId", new Parameter("eq", (Object)receiveUnitId));
        queryParam.getComplexParams().add(ComplexParam.getApprovedComplexParam((String)"and"));
        queryParam.getOrderMap().put("createTime", "desc");
        List entityList = this.contractService.queryList(queryParam, false);
        PayContractVO backVO = !entityList.isEmpty() ? (PayContractVO)BeanMapper.map(entityList.get(0), PayContractVO.class) : new PayContractVO();
        return CommonResponse.success((String)"\u67e5\u8be2\u6570\u636e\u6210\u529f\uff01", (Object)backVO);
    }

    @RequestMapping(value={"getSumPayMny"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SumPayMnyVO> getSumPayMny(@RequestParam(value="contractId", required=true) Long contractId, @RequestParam(value="orgId", required=true) Long orgId, @RequestParam(value="applyMnyContainFree", required=false) Boolean applyMnyContainFree) {
        SumPayMnyVO vo = this.contractService.getSumPayMny(contractId, orgId, applyMnyContainFree);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryPendingList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryPendingList(@RequestBody QueryParam param) {
        ParamSearchUtil.handleQueryParam(param);
        JSONObject page = this.contractService.queryPendingPageJson(param, false);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)page);
    }

    @RequestMapping(value={"/excelExportPending"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportPending(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        ParamSearchUtil.handleQueryParam(queryParam);
        List<PayApplyPubVO> records = this.contractService.queryExportPendingList(queryParam);
        records.forEach(vo -> {
            if (null != vo.getApplyMny()) {
                vo.setUnpaidMny(vo.getApplyMny().subtract(vo.getPayMny() == null ? BigDecimal.ZERO : vo.getPayMny()));
            }
        });
        HashMap<String, List<PayApplyPubVO>> beans = new HashMap<String, List<PayApplyPubVO>>();
        beans.put("records", records);
        ExcelExport.getInstance().export("pending-payapply-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/batchConfirm"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> batchConfirm(@RequestBody List<PayApplyPubVO> vos) {
        String msg = this.contractService.batchConfirm(vos);
        return CommonResponse.success((String)"\u6279\u91cf\u652f\u4ed8\u6210\u529f\uff01");
    }

    @RequestMapping(value={"getStatisticsMny"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SumMnyStatisticVO> getStatisticsMny() {
        SumMnyStatisticVO vo = this.contractService.getStatisticsMny();
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"getManageDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ManageDetailVO> getManageDetail(@RequestParam(value="projectId", required=true) Long projectId) {
        ManageDetailVO vo = this.contractService.getManageDetail(projectId);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"getTotalPayApplyAmountByProjectIds"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> getTotalPayApplyAmountByProjectIds(@RequestBody List<Long> projectIds) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("dependOnProject", new Parameter("eq", (Object)"1"));
        queryParam.getParams().put("payStatus", new Parameter("eq", (Object)"2"));
        if (ListUtil.isNotEmpty(projectIds)) {
            queryParam.getParams().put("projectId", new Parameter("in", projectIds));
        }
        List<Object> orgIds = new ArrayList();
        UserContext userContext = this.sessionManager.getUserContext();
        String authOrgIds = userContext.getAuthOrgIds();
        if (StringUtils.isNotEmpty((CharSequence)authOrgIds)) {
            CommonResponse authResponse = this.orgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList()));
            orgIds = ((List)authResponse.getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        } else {
            orgIds = ((List)this.orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList());
        }
        if (CollectionUtils.isNotEmpty(orgIds)) {
            queryParam.getParams().put("orgId", new Parameter("in", orgIds));
        }
        List contractEntities = this.contractService.queryList(queryParam, false);
        BigDecimal payApplyAmount = new BigDecimal("0.00");
        if (ListUtil.isNotEmpty((List)contractEntities)) {
            for (PayContractEntity p : contractEntities) {
                if (p.getPayMny() == null) continue;
                payApplyAmount = payApplyAmount.add(p.getPayMny());
            }
        }
        JSONObject back = new JSONObject();
        back.put("payApplyAmount", (Object)payApplyAmount);
        return CommonResponse.success((Object)back);
    }

    @RequestMapping(value={"getMonthInfo"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<FinanceMonthVO>> getMonthInfo(@RequestParam(value="projectId", required=true) Long projectId, @RequestParam(value="timeRange", required=false) String timeRange) {
        List<FinanceMonthVO> list = this.contractService.getMonthInfo(projectId, timeRange);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", list);
    }

    @RequestMapping(value={"getCostInfo"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<FinanceCostVO>> getCostInfo(@RequestParam(value="projectId", required=true) Long projectId, @RequestParam(value="year", required=false) String year) {
        List<FinanceCostVO> list = this.contractService.getCostInfo(projectId, year);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", list);
    }

    @RequestMapping(value={"getTotalColumnInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<TotalColumnVO> getTotalColumnInfo(@RequestBody QueryParam param) {
        param.getOrderMap().put("createTime", "desc");
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)this.contractService.getTotalColumnInfo(param, false));
    }

    @RequestMapping(value={"getApproveTotalColumnInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<TotalColumnVO> getApproveTotalColumnInfo(@RequestBody QueryParam param) {
        ParamSearchUtil.handleQueryParam(param);
        param.getComplexParams().add(ComplexParam.getApprovedComplexParam((String)"and"));
        param.getOrderMap().put("approveTime", "desc");
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)this.contractService.getApproveTotalColumnInfo(param, false));
    }

    @RequestMapping(value={"getPendingTotalColumnInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<TotalColumnVO> getPendingTotalColumnInfo(@RequestBody QueryParam param) {
        ParamSearchUtil.handleQueryParam(param);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)this.contractService.getPendingTotalColumnInfo(param, false, "pending"));
    }

    @RequestMapping(value={"getALLTotalColumnInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<TotalColumnVO> getALLTotalColumnInfo(@RequestBody QueryParam param) {
        ParamSearchUtil.handleQueryParam(param);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)this.contractService.getPendingTotalColumnInfo(param, false, "all"));
    }

    @RequestMapping(value={"checkParams"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ParamsCheckVO> checkParams(@RequestParam(value="purchaseType") Integer purchaseType, @RequestParam(value="sumPayMny") BigDecimal sumPayMny, @RequestParam(value="payMny") BigDecimal payMny, @RequestParam(value="contractMny") BigDecimal contractMny, @RequestParam(value="proSurplusApplyMny") BigDecimal proSurplusApplyMny, @RequestParam(value="orgId", required=false) Long orgId) {
        ParamsCheckVO pc = new ParamsCheckVO();
        pc.setWarnType("none");
        pc.setDataSource(null);
        return CommonResponse.success((String)"\u53c2\u6570\u6821\u9a8c\u6210\u529f\uff01", (Object)pc);
    }

    @RequestMapping(value={"getProFinance"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ProjectFinanceVO> getProFinance(@RequestParam(value="projectId", required=true) Long projectId) {
        ProjectFinanceVO vo = this.contractService.getProFinance(projectId);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/closePayment"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Void> closePayment(@RequestParam(value="id") Long id) {
        this.contractService.closePayment(id);
        return CommonResponse.success((String)"\u4ed8\u6b3e\u5173\u95ed\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/getSupplierVOById"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SupplierVO> getProjectReimburse(@RequestParam(value="supplierId", required=true) Long supplierId) {
        CommonResponse resp = this.supplierApi.queryById(supplierId);
        return resp;
    }

    @RequestMapping(value={"queryInstoreMaterialById"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<InstoreMaterialVO>> queryInstoreMaterialById(Long contractId) {
        List<InstoreMaterialVO> list = this.contractService.queryInstoreMaterialById(contractId);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", list);
    }

    @RequestMapping(value={"queryPayContractHistoryByContractId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<PayContractEntity>> queryPayContractHistoryByContractId(Long contractId) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.in((Object)"bill_state", new Object[]{1, 3});
        wrapper.eq((Object)"contract_id", (Object)contractId);
        List list = this.contractService.list((Wrapper)wrapper);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)list);
    }

    @RequestMapping(value={"queryWeeklyProgressByProjectId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BigDecimal> queryWeeklyProgressByProjectId(Long projectId) {
        BigDecimal weeklyProgress = this.contractService.queryWeeklyProgressByProjectId(projectId);
        if (weeklyProgress == null) {
            weeklyProgress = BigDecimal.ZERO;
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)weeklyProgress);
    }

    @GetMapping(value={"/pushPsrm"})
    @ResponseBody
    public CommonResponse<PayContractVO> pushPsrm(@RequestParam(value="id") Long id) {
        PayContractEntity dbEntity = (PayContractEntity)((Object)this.contractService.selectById(id));
        PayContractVO vo = (PayContractVO)BeanMapper.map((Object)((Object)dbEntity), PayContractVO.class);
        if (this.psrmRestUtil.isRunMode().booleanValue() && (vo.getContractType().intValue() == 1 || vo.getContractType().intValue() == 4)) {
            PSRMResponse resp = this.contractService.saveOrUpdatePsrmObj(vo);
            LambdaUpdateWrapper updateWrapper = Wrappers.lambdaUpdate();
            updateWrapper.eq(BaseEntity::getId, (Object)id);
            updateWrapper.set(PayContractEntity::getPsrmReturncode, (Object)resp.getReturncode());
            updateWrapper.set(resp.isSuccess(), PayContractEntity::getPsrmCode, (Object)resp.getPsrmCode());
            updateWrapper.set(PayContractEntity::getPsrmReturndata, (Object)JSONObject.toJSONString((Object)resp));
            this.contractService.update((Wrapper)updateWrapper);
            if (!resp.isSuccess()) {
                return CommonResponse.error((String)("\u6570\u636e\u4e2d\u53f0\u64cd\u4f5c\u5931\u8d25" + JSONObject.toJSONString((Object)resp)));
            }
        }
        return CommonResponse.success((String)"\u63a8\u9001\u6570\u636e\u4e2d\u53f0\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"queryCertificateSupplierId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BigDecimal> queryCertificateSupplierId(Long supplierId, Long projectId) {
        BigDecimal mny = this.contractService.queryCertificateSupplierId(supplierId, projectId);
        if (mny == null) {
            mny = BigDecimal.ZERO;
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)mny);
    }

    @RequestMapping(value={"/querySupplierType"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> querySupplierType(@RequestParam(value="supplierId", required=true) Long supplierId) {
        String fkfs = this.contractService.querySupplierType(supplierId);
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)fkfs);
    }

    @RequestMapping(value={"/requestPaymentReport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> requestPaymentReport(@RequestBody List<RequestPaymentReportVO> vo) {
        this.payReportedService.batchSaveReport(vo);
        return CommonResponse.success((String)"\u62a5\u5907\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryRequestPaymentReportList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<PayReportedVO>> queryRequestPaymentReportList(@RequestBody List<Long> paymentIds) {
        List<PayReportedVO> list = this.payReportedService.queryRequestPaymentReportList(paymentIds);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", list);
    }
}

