package com.ejianc.business.finance.service;

import com.ejianc.business.finance.bean.BondUpBackEntity;
import com.ejianc.business.finance.vo.BondUpBackVO;
import com.ejianc.business.finance.vo.BondUpDealRentVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.math.BigDecimal;
import java.util.List;

/**
 * <p>
 * 保证金退还表 服务类
 * </p>
 *
 * @author sunyj
 * @since 2020-06-16
 */
public interface IBondUpBackService extends IBaseService<BondUpBackEntity> {

    BondUpBackVO insertOrUpdate(BondUpBackVO bondUpBackVO);

    BondUpDealRentVO queryDetail(Long id);

    void deleteNew(List<BondUpBackVO> vos);


    /**
     *  统计所以单据状态的  取该保证金所有状态的单据【本次退还金额】合计值；
     * @param bondId
     * @return
     */
     CommonResponse<BigDecimal> totalAlreadyBackMny(Long bondId,Long backId);
}
